/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import driftwood.isosurface.CrystalVertexSource;
import driftwood.isosurface.OMapVertexSource;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.r3.Builder;
import driftwood.r3.PrincipleAxes;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class AnisoOxygenSearch {
    File pdbFile = null;
    File mapFile = null;

    void searchModel(PrintStream printStream, String string, Model model, ModelState modelState, CrystalVertexSource crystalVertexSource) {
        boolean bl = true;
        double d = 2.0 * crystalVertexSource.sigma;
        double d2 = 1.2 * crystalVertexSource.sigma;
        Builder builder = new Builder();
        DecimalFormat decimalFormat = new DecimalFormat("0.0000");
        if (bl) {
            printStream.println("#file:model:residue:angle:ellipse_ratio");
        } else {
            printStream.println("@kinemage 1");
            printStream.println("@group {O-rings} dominant");
        }
        for (Residue residue : model.getResidues()) {
            try {
                Object object;
                AtomState atomState = modelState.get(residue.getAtom(" O  "));
                AtomState atomState2 = modelState.get(residue.getAtom(" C  "));
                AtomState atomState3 = modelState.get(residue.getAtom(" CA "));
                AtomState atomState4 = modelState.get(residue.getNext(model).getAtom(" CA "));
                Triple triple = new Triple().likeVector(atomState3, atomState4);
                Triple triple2 = new Triple().likeVector(atomState2, atomState).unit();
                triple2.mult(triple.dot(triple2));
                triple.sub(triple2);
                double d3 = crystalVertexSource.evaluateAtPoint(atomState.getX(), atomState.getY(), atomState.getZ());
                if (Double.isNaN(d3) || d3 < d) {
                    if (!bl) continue;
                    printStream.println(string + ":" + model + ":" + residue.getCNIT() + ":bad_density:bad_density");
                    continue;
                }
                ArrayList<Triple> arrayList = new ArrayList<Triple>();
                for (double d4 = 0.0; d4 < 64.0; d4 += 1.0) {
                    object = builder.construct4(atomState3, atomState2, atomState, 1.0, 90.0, 360.0 * d4 / 64.0);
                    ((Triple)object).sub(atomState);
                    arrayList.add(this.findBelow(d2, crystalVertexSource, atomState, (Tuple3)object));
                }
                PrincipleAxes principleAxes = new PrincipleAxes(arrayList);
                Tuple3[] tuple3Array = principleAxes.getAxes();
                object = principleAxes.getLengths();
                double d5 = triple.angle(tuple3Array[0]);
                if (d5 > 90.0) {
                    d5 = 180.0 - d5;
                }
                reference var30_27 = object[0] / object[1];
                if (bl) {
                    printStream.println(string + ":" + model + ":" + residue.getCNIT() + ":" + decimalFormat.format(d5) + ":" + decimalFormat.format((double)var30_27));
                    continue;
                }
                printStream.println("@vectorlist {" + string + ":" + model + ":" + residue.getCNIT() + "} color= orange");
                for (Triple triple3 : arrayList) {
                    printStream.println("{} " + triple3.format(decimalFormat));
                }
            }
            catch (Exception exception) {
            }
        }
    }

    Triple findBelow(double d, CrystalVertexSource crystalVertexSource, Tuple3 tuple3, Tuple3 tuple32) {
        double d2;
        Triple triple = new Triple();
        double d3 = 0.0;
        do {
            triple.like(tuple32).unit().mult(d3 += 0.025);
            triple.add(tuple3);
        } while ((d2 = crystalVertexSource.evaluateAtPoint(triple.getX(), triple.getY(), triple.getZ())) > d);
        return triple;
    }

    public void Main() throws IOException {
        PdbReader pdbReader = new PdbReader();
        CoordinateFile coordinateFile = pdbReader.read(this.pdbFile);
        Model model = coordinateFile.getFirstModel();
        ModelState modelState = model.getState();
        String string = this.pdbFile.toString();
        if (coordinateFile.getIdCode() != null) {
            string = coordinateFile.getIdCode();
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.mapFile));
        OMapVertexSource oMapVertexSource = new OMapVertexSource(bufferedInputStream);
        ((InputStream)bufferedInputStream).close();
        this.searchModel(System.out, string, model, modelState, oMapVertexSource);
    }

    public static void main(String[] stringArray) {
        AnisoOxygenSearch anisoOxygenSearch = new AnisoOxygenSearch();
        try {
            anisoOxygenSearch.parseArguments(stringArray);
            if (anisoOxygenSearch.pdbFile == null || anisoOxygenSearch.mapFile == null) {
                throw new IllegalArgumentException("Must specify both a PDB file and an O map");
            }
            anisoOxygenSearch.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            anisoOxygenSearch.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("AnisoOxygenSearch.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'AnisoOxygenSearch.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.mc.AnisoOxygenSearch");
        System.err.println("Copyright (C) 2004 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        if (this.pdbFile == null) {
            this.pdbFile = new File(string);
        } else if (this.mapFile == null) {
            this.mapFile = new File(string);
        } else {
            throw new IllegalArgumentException("Unneccessary parameter '" + string + "'");
        }
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

