/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.r3.Triple;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;

public class BackrubFinder {
    DecimalFormat df = new DecimalFormat("0.0##");

    AtomState[][] getCalphas(Collection collection) {
        AtomState[][] atomStateArray = new AtomState[collection.size()][0];
        int n = 0;
        for (Model model : collection) {
            ModelState modelState = model.getState();
            ArrayList<AtomState> arrayList = new ArrayList<AtomState>();
            for (Residue residue : model.getResidues()) {
                Atom atom = residue.getAtom(" CA ");
                if (atom == null) continue;
                try {
                    arrayList.add(modelState.get(atom));
                }
                catch (AtomException atomException) {
                    atomException.printStackTrace();
                }
            }
            atomStateArray[n] = arrayList.toArray(atomStateArray[n]);
            ++n;
        }
        return atomStateArray;
    }

    void printStats(PrintStream printStream, AtomState[][] atomStateArray) {
        printStream.println("Residue,dist24,sd,theta124,sd,theta245,sd,phi1245,len,sd,phi1243,len,sd,phi3245,len,sd");
        int n = atomStateArray.length;
        if (n == 0) {
            return;
        }
        int n2 = atomStateArray[0].length;
        if (n2 == 0) {
            return;
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        double[] dArray7 = new double[n];
        double[] dArray8 = new double[n];
        double[] dArray9 = new double[n];
        double[] dArray10 = new double[n];
        double[] dArray11 = new double[n];
        for (int i = 2; i < n2 - 2; ++i) {
            for (int j = 0; j < n; ++j) {
                AtomState atomState = atomStateArray[j][i - 2];
                AtomState atomState2 = atomStateArray[j][i - 1];
                AtomState atomState3 = atomStateArray[j][i];
                AtomState atomState4 = atomStateArray[j][i + 1];
                AtomState atomState5 = atomStateArray[j][i + 2];
                dArray[j] = atomState.distance(atomState3);
                dArray2[j] = atomState2.distance(atomState4);
                dArray3[j] = atomState3.distance(atomState5);
                dArray4[j] = atomState.distance(atomState4);
                dArray5[j] = atomState2.distance(atomState5);
                dArray6[j] = atomState.distance(atomState5);
                dArray7[j] = Triple.angle(atomState, atomState2, atomState4);
                dArray8[j] = Triple.angle(atomState2, atomState4, atomState5);
                dArray9[j] = Triple.dihedral(atomState, atomState2, atomState4, atomState5);
                dArray10[j] = Triple.dihedral(atomState, atomState2, atomState4, atomState3);
                dArray11[j] = Triple.dihedral(atomState3, atomState2, atomState4, atomState5);
            }
            printStream.print("\"" + atomStateArray[0][i].getResidue());
            printStream.print("\",\"" + this.df.format(this.mean(dArray2)) + "\",\"" + this.df.format(this.stddev(dArray2)));
            printStream.print("\",\"" + this.df.format(this.mean(dArray7)) + "\",\"" + this.df.format(this.stddev(dArray7)));
            printStream.print("\",\"" + this.df.format(this.mean(dArray8)) + "\",\"" + this.df.format(this.stddev(dArray8)));
            printStream.print("\",\"" + this.df.format(this.circ_mean(dArray9)) + "\",\"" + this.df.format(this.circ_len(dArray9)) + "\",\"" + this.df.format(this.circ_stddev(dArray9)));
            printStream.print("\",\"" + this.df.format(this.circ_mean(dArray10)) + "\",\"" + this.df.format(this.circ_len(dArray10)) + "\",\"" + this.df.format(this.circ_stddev(dArray10)));
            printStream.print("\",\"" + this.df.format(this.circ_mean(dArray11)) + "\",\"" + this.df.format(this.circ_len(dArray11)) + "\",\"" + this.df.format(this.circ_stddev(dArray11)));
            printStream.println("\"");
        }
    }

    double mean(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d / (double)dArray.length;
    }

    double stddev(double[] dArray) {
        double d = this.mean(dArray);
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d3 = d - dArray[i];
            d2 += d3 * d3;
        }
        return Math.sqrt(d2 / (double)dArray.length);
    }

    double circ_mean(double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += Math.cos(Math.toRadians(dArray[i]));
            d2 += Math.sin(Math.toRadians(dArray[i]));
        }
        return Math.toDegrees(Math.atan2(d2 / (double)dArray.length, d / (double)dArray.length));
    }

    double circ_len(double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += Math.cos(Math.toRadians(dArray[i]));
            d2 += Math.sin(Math.toRadians(dArray[i]));
        }
        return Math.sqrt((d /= (double)dArray.length) * d + (d2 /= (double)dArray.length) * d2);
    }

    double circ_stddev(double[] dArray) {
        double d = this.circ_mean(dArray);
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d3 = Math.abs(d - dArray[i]) % 360.0;
            if (d3 > 180.0) {
                d3 = 360.0 - d3;
            }
            d2 += d3 * d3;
        }
        return Math.sqrt(d2 / (double)dArray.length);
    }

    public void Main() throws IOException {
        PdbReader pdbReader = new PdbReader();
        CoordinateFile coordinateFile = pdbReader.read(System.in);
        AtomState[][] atomStateArray = this.getCalphas(coordinateFile.getModels());
        this.printStats(System.out, atomStateArray);
    }

    public static void main(String[] stringArray) {
        BackrubFinder backrubFinder = new BackrubFinder();
        try {
            backrubFinder.parseArguments(stringArray);
            backrubFinder.Main();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println();
            backrubFinder.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + exception.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("BackrubFinder.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'BackrubFinder.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.mc.BackrubFinder");
        System.err.println("Copyright (C) 2005 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

