/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import chiropraxis.mc.Peptide;
import chiropraxis.mc.SheetAxes;
import driftwood.moldb2.AminoAcid;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.r3.LsqPlane;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SheetBuilder {
    void processModel(String string, Model model, ModelState modelState) {
        Collection collection = this.createPeptides(model, modelState);
        this.connectPeptides(collection);
        this.findHBonds(collection, modelState);
        this.assignSecStruct(collection);
        Map map = this.calcSheetNormals(collection, model, modelState);
        Map map2 = this.measureSheetAngles(collection, map, modelState);
        this.printCrossStrandNeighborAngles(System.out, string, collection, map2);
    }

    Collection createPeptides(Model model, ModelState modelState) {
        ArrayList<Peptide> arrayList = new ArrayList<Peptide>();
        Residue residue = null;
        for (Residue residue2 : model.getResidues()) {
            if (!AminoAcid.isAminoAcid(residue2)) continue;
            try {
                Peptide peptide = new Peptide(residue, residue2, modelState);
                if (residue == null) {
                    arrayList.add(peptide);
                } else {
                    AtomState atomState;
                    AtomState atomState2 = modelState.get(residue.getAtom(" C  "));
                    if (atomState2.sqDistance(atomState = modelState.get(residue2.getAtom(" N  "))) < 4.0) {
                        arrayList.add(peptide);
                    } else {
                        arrayList.add(new Peptide(residue, null, modelState));
                        arrayList.add(new Peptide(null, residue2, modelState));
                    }
                }
            }
            catch (AtomException atomException) {
                try {
                    arrayList.add(new Peptide(residue, null, modelState));
                }
                catch (AtomException atomException2) {
                    // empty catch block
                }
                try {
                    arrayList.add(new Peptide(null, residue2, modelState));
                }
                catch (AtomException atomException3) {
                    // empty catch block
                }
            }
            residue = residue2;
        }
        try {
            arrayList.add(new Peptide(residue, null, modelState));
        }
        catch (AtomException atomException) {
            // empty catch block
        }
        return arrayList;
    }

    void connectPeptides(Collection collection) {
        Peptide peptide = null;
        int n = 0;
        for (Peptide peptide2 : collection) {
            if (peptide != null && peptide.nRes != null && peptide2.cRes != null && peptide.nRes == peptide2.cRes) {
                peptide.next = peptide2;
                peptide2.prev = peptide;
                peptide2.chain = peptide.chain;
                peptide2.index = peptide.index + 1;
            } else {
                peptide2.chain = ++n;
                peptide2.index = 1;
            }
            peptide = peptide2;
        }
    }

    void findHBonds(Collection collection, ModelState modelState) {
        Peptide[] peptideArray = collection.toArray(new Peptide[collection.size()]);
        AtomState[] atomStateArray = new AtomState[peptideArray.length];
        AtomState[] atomStateArray2 = new AtomState[peptideArray.length];
        for (int i = 0; i < peptideArray.length; ++i) {
            if (peptideArray[i].cRes == null) continue;
            try {
                atomStateArray[i] = modelState.get(peptideArray[i].cRes.getAtom(" C  "));
                atomStateArray2[i] = modelState.get(peptideArray[i].cRes.getAtom(" O  "));
                continue;
            }
            catch (AtomException atomException) {
                // empty catch block
            }
        }
        for (int i = 0; i < peptideArray.length; ++i) {
            if (peptideArray[i].nRes == null) continue;
            try {
                AtomState atomState = modelState.get(peptideArray[i].nRes.getAtom(" N  "));
                AtomState atomState2 = modelState.get(peptideArray[i].nRes.getAtom(" H  "));
                Peptide peptide = null;
                double d = -0.5;
                for (int j = 0; j < peptideArray.length; ++j) {
                    double d2;
                    double d3;
                    double d4;
                    double d5;
                    double d6;
                    if (i == j || peptideArray[i].chain == peptideArray[j].chain && Math.abs(peptideArray[i].index - peptideArray[j].index) <= 2 || atomStateArray[j] == null || atomStateArray2[j] == null || atomState.sqDistance(atomStateArray2[j]) > 28.09 || !((d6 = 27.9 * (1.0 / (d5 = atomStateArray2[j].distance(atomState)) + 1.0 / (d4 = atomStateArray[j].distance(atomState2)) - 1.0 / (d3 = atomStateArray2[j].distance(atomState2)) - 1.0 / (d2 = atomStateArray[j].distance(atomState)))) < d) || peptideArray[j].hbondO != null) continue;
                    peptide = peptideArray[j];
                    d = d6;
                }
                if (peptide == null) continue;
                peptideArray[i].hbondN = peptide;
                peptide.hbondO = peptideArray[i];
                continue;
            }
            catch (AtomException atomException) {
                // empty catch block
            }
        }
    }

    void assignSecStruct(Collection collection) {
        for (Peptide peptide : collection) {
            Peptide peptide2 = peptide.hbondN;
            if (peptide2 == null) continue;
            if (peptide.next != null && peptide2.prev != null && peptide.next.hbondO == peptide2.prev) {
                peptide2.isBeta = true;
                peptide.isBeta = true;
                peptide2.isParallelO = false;
                peptide.isParallelN = false;
                continue;
            }
            if (peptide.prev != null && peptide2.next != null && peptide.prev.hbondO == peptide2.next) {
                peptide2.isBeta = true;
                peptide.isBeta = true;
                peptide2.isParallelO = false;
                peptide.isParallelN = false;
                continue;
            }
            if (peptide.chain == peptide2.chain && Math.abs(peptide.index - peptide2.index) <= 5) continue;
            if (peptide.next != null && peptide2.next != null && peptide.next.hbondO == peptide2.next) {
                peptide2.isBeta = true;
                peptide.isBeta = true;
                peptide2.isParallelO = true;
                peptide.isParallelN = true;
                continue;
            }
            if (peptide.prev == null || peptide2.prev == null || peptide.prev.hbondO != peptide2.prev) continue;
            peptide2.isBeta = true;
            peptide.isBeta = true;
            peptide2.isParallelO = true;
            peptide.isParallelN = true;
        }
    }

    Map calcSheetNormals(Collection collection, Model model, ModelState modelState) {
        HashMap<Residue, Object> hashMap = new HashMap<Residue, Object>();
        HashMap<Residue, Object> hashMap2 = new HashMap<Residue, Object>();
        for (Object object : collection) {
            if (((Peptide)object).cRes != null) {
                hashMap.put(((Peptide)object).cRes, object);
            }
            if (((Peptide)object).nRes == null) continue;
            hashMap2.put(((Peptide)object).nRes, object);
        }
        HashMap hashMap3 = new HashMap();
        for (Residue residue : model.getResidues()) {
            Peptide peptide = (Peptide)hashMap.get(residue);
            Peptide peptide2 = (Peptide)hashMap2.get(residue);
            if (peptide == null || peptide.hbondN == null || peptide.hbondO == null || peptide2 == null || peptide2.hbondN == null || peptide2.hbondO == null || !peptide.isBeta || !peptide.hbondN.isBeta || !peptide.hbondO.isBeta || !peptide2.isBeta || !peptide2.hbondN.isBeta || !peptide2.hbondO.isBeta) continue;
            ArrayList<Triple> arrayList = new ArrayList<Triple>();
            arrayList.add(peptide.hbondN.midpoint);
            arrayList.add(peptide.midpoint);
            arrayList.add(peptide.hbondO.midpoint);
            arrayList.add(peptide2.hbondN.midpoint);
            arrayList.add(peptide2.midpoint);
            arrayList.add(peptide2.hbondO.midpoint);
            LsqPlane lsqPlane = new LsqPlane(arrayList);
            Triple triple = new Triple(lsqPlane.getNormal());
            hashMap3.put(residue, triple);
            try {
                AtomState atomState = modelState.get(residue.getAtom(" CA "));
                AtomState atomState2 = modelState.get(residue.getAtom(" CB "));
                Triple triple2 = new Triple(atomState2).sub(atomState);
                if (!(triple2.dot(triple) < 0.0)) continue;
                triple.neg();
            }
            catch (AtomException atomException) {}
        }
        return hashMap3;
    }

    Map measureSheetAngles(Collection collection, Map map, ModelState modelState) {
        HashMap<Residue, Object> hashMap = new HashMap<Residue, Object>();
        HashMap<Residue, Object> hashMap2 = new HashMap<Residue, Object>();
        for (Object object : collection) {
            if (((Peptide)object).cRes != null) {
                hashMap.put(((Peptide)object).cRes, object);
            }
            if (((Peptide)object).nRes == null) continue;
            hashMap2.put(((Peptide)object).nRes, object);
        }
        HashMap hashMap3 = new HashMap();
        for (Residue residue : map.keySet()) {
            Triple triple = (Triple)map.get(residue);
            Peptide peptide = (Peptide)hashMap.get(residue);
            Peptide peptide2 = (Peptide)hashMap2.get(residue);
            if (peptide == null || peptide2 == null) continue;
            Triple triple2 = new Triple(peptide.midpoint).sub(peptide2.midpoint);
            try {
                AtomState atomState = modelState.get(residue.getAtom(" CA "));
                AtomState atomState2 = modelState.get(residue.getAtom(" CB "));
                Triple triple3 = new Triple(atomState2).sub(atomState);
                SheetAxes sheetAxes = new SheetAxes(triple, triple2, triple3);
                hashMap3.put(residue, sheetAxes);
            }
            catch (AtomException atomException) {}
        }
        return hashMap3;
    }

    void sketchHbonds(PrintStream printStream, Collection collection, ModelState modelState) {
        AtomState atomState;
        AtomState atomState2;
        DecimalFormat decimalFormat = new DecimalFormat("0.0###");
        printStream.println("@group {peptides & hbonds}");
        printStream.println("@balllist {peptides} radius= 0.1 color= green");
        for (Peptide peptide : collection) {
            if (peptide.isBeta) {
                printStream.println("{" + peptide + "} r=0.3 " + peptide.midpoint.format(decimalFormat));
                continue;
            }
            printStream.println("{" + peptide + "} " + peptide.midpoint.format(decimalFormat));
        }
        printStream.println("@vectorlist {N hbonds} color= sky");
        for (Peptide peptide : collection) {
            if (peptide.hbondN == null) continue;
            try {
                atomState2 = modelState.get(peptide.nRes.getAtom(" H  "));
                atomState = modelState.get(peptide.hbondN.cRes.getAtom(" O  "));
                printStream.println("{" + peptide + "}P " + atomState2.format(decimalFormat));
                printStream.println("{" + peptide.hbondN + "} " + atomState.format(decimalFormat));
            }
            catch (AtomException atomException) {}
        }
        printStream.println("@vectorlist {O hbonds} color= red");
        for (Peptide peptide : collection) {
            if (peptide.hbondO == null) continue;
            try {
                atomState2 = modelState.get(peptide.cRes.getAtom(" O  "));
                atomState = modelState.get(peptide.hbondO.nRes.getAtom(" H  "));
                printStream.println("{" + peptide + "}P " + atomState2.format(decimalFormat));
                printStream.println("{" + peptide.hbondO + "} " + atomState.format(decimalFormat));
            }
            catch (AtomException atomException) {}
        }
    }

    void sketchNormals(PrintStream printStream, Map map, ModelState modelState) {
        DecimalFormat decimalFormat = new DecimalFormat("0.0###");
        printStream.println("@group {normals & planes}");
        printStream.println("@vectorlist {peptides} color= magenta");
        for (Residue residue : map.keySet()) {
            Triple triple = (Triple)map.get(residue);
            try {
                AtomState atomState = modelState.get(residue.getAtom(" CA "));
                Triple triple2 = new Triple(triple).add(atomState);
                printStream.println("{" + residue + "}P " + atomState.format(decimalFormat));
                printStream.println("{normal: " + triple2.format(decimalFormat) + "} " + triple2.format(decimalFormat));
            }
            catch (AtomException atomException) {
                atomException.printStackTrace();
            }
        }
    }

    void sketchLocalAxes(PrintStream printStream, Map map, ModelState modelState) {
        Triple triple;
        AtomState atomState;
        SheetAxes sheetAxes;
        DecimalFormat decimalFormat = new DecimalFormat("0.0###");
        printStream.println("@group {local axes}");
        printStream.println("@vectorlist {axes} color= brown");
        for (Residue residue : map.keySet()) {
            sheetAxes = (SheetAxes)map.get(residue);
            try {
                atomState = modelState.get(residue.getAtom(" CA "));
                triple = new Triple(sheetAxes.strand).add(atomState);
                printStream.println("{" + residue + "}P " + atomState.format(decimalFormat));
                printStream.println("{strand}red " + triple.format(decimalFormat));
                triple.like(sheetAxes.cross).add(atomState);
                printStream.println("{" + residue + "}P " + atomState.format(decimalFormat));
                printStream.println("{cross}green " + triple.format(decimalFormat));
                triple.like(sheetAxes.normal).add(atomState);
                printStream.println("{" + residue + "}P " + atomState.format(decimalFormat));
                printStream.println("{normal}blue " + triple.format(decimalFormat));
            }
            catch (AtomException atomException) {
                atomException.printStackTrace();
            }
        }
        printStream.println("@labellist {angles} color= peach");
        for (Residue residue : map.keySet()) {
            sheetAxes = (SheetAxes)map.get(residue);
            try {
                atomState = modelState.get(residue.getAtom(" CA "));
                triple = new Triple(sheetAxes.strand).add(atomState);
                printStream.println("{strand: " + decimalFormat.format(sheetAxes.angleAlong) + "}red " + triple.format(decimalFormat));
                triple.like(sheetAxes.cross).add(atomState);
                printStream.println("{cross: " + decimalFormat.format(sheetAxes.angleAcross) + "}green " + triple.format(decimalFormat));
                triple.like(sheetAxes.normal).add(atomState);
                printStream.println("{normal: " + decimalFormat.format(sheetAxes.angleNormal) + "}blue " + triple.format(decimalFormat));
            }
            catch (AtomException atomException) {
                atomException.printStackTrace();
            }
        }
    }

    void sketchPlanes(PrintStream printStream, Map map, ModelState modelState) {
        DecimalFormat decimalFormat = new DecimalFormat("0.0###");
        Transform transform = new Transform();
        ArrayList arrayList = new ArrayList(map.keySet());
        Collections.sort(arrayList);
        for (Residue residue : arrayList) {
            SheetAxes sheetAxes = (SheetAxes)map.get(residue);
            printStream.println("@group {" + residue.getCNIT() + "} animate dominant");
            printStream.println("@vectorlist {axes} color= brown");
            try {
                AtomState atomState = modelState.get(residue.getAtom(" CA "));
                Triple triple = new Triple();
                for (int i = 0; i < 360; i += 5) {
                    triple.like(sheetAxes.strand).mult(5.0);
                    transform.likeRotation(sheetAxes.normal, i);
                    transform.transformVector(triple);
                    triple.add(atomState);
                    printStream.println("{" + residue + "}P " + atomState.format(decimalFormat));
                    printStream.println("{plane} " + triple.format(decimalFormat));
                }
            }
            catch (AtomException atomException) {
                atomException.printStackTrace();
            }
        }
    }

    void printAlongStrandNeighborAngles(PrintStream printStream, Collection collection, Map map) {
        HashMap<Residue, Peptide> hashMap = new HashMap<Residue, Peptide>();
        HashMap<Residue, Object> hashMap2 = new HashMap<Residue, Object>();
        for (Object object : collection) {
            if (((Peptide)object).cRes != null) {
                hashMap.put(((Peptide)object).cRes, (Peptide)object);
            }
            if (((Peptide)object).nRes == null) continue;
            hashMap2.put(((Peptide)object).nRes, object);
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.0###");
        printStream.println("residue:normal:across:along:next-neighbor?:normal:across:along");
        for (Residue residue : map.keySet()) {
            SheetAxes sheetAxes = (SheetAxes)map.get(residue);
            printStream.print(residue.getCNIT() + ":" + decimalFormat.format(sheetAxes.angleNormal) + ":" + decimalFormat.format(sheetAxes.angleAcross) + ":" + decimalFormat.format(sheetAxes.angleAlong));
            Peptide peptide = (Peptide)hashMap.get(residue);
            SheetAxes sheetAxes2 = (SheetAxes)map.get(peptide.nRes);
            if (peptide.nRes != null && sheetAxes2 != null) {
                printStream.print(":" + peptide.nRes.getCNIT() + ":" + decimalFormat.format(sheetAxes2.angleNormal) + ":" + decimalFormat.format(sheetAxes2.angleAcross) + ":" + decimalFormat.format(sheetAxes2.angleAlong));
            }
            printStream.println();
        }
    }

    void printCrossStrandNeighborAngles(PrintStream printStream, String string, Collection collection, Map map) {
        HashMap<Residue, Object> hashMap = new HashMap<Residue, Object>();
        HashMap<Residue, Object> hashMap2 = new HashMap<Residue, Object>();
        for (Object object : collection) {
            if (((Peptide)object).cRes != null) {
                hashMap.put(((Peptide)object).cRes, object);
            }
            if (((Peptide)object).nRes == null) continue;
            hashMap2.put(((Peptide)object).nRes, object);
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.0###");
        for (Residue residue : map.keySet()) {
            SheetAxes sheetAxes = (SheetAxes)map.get(residue);
            printStream.print(string + ":" + residue.getCNIT() + ":" + decimalFormat.format(sheetAxes.angleNormal) + ":" + decimalFormat.format(sheetAxes.angleAcross) + ":" + decimalFormat.format(sheetAxes.angleAlong));
            Peptide peptide = (Peptide)hashMap2.get(residue);
            if (peptide.hbondN != null) {
                Residue residue2 = peptide.isParallelN ? peptide.hbondN.nRes : peptide.hbondN.cRes;
                SheetAxes sheetAxes2 = (SheetAxes)map.get(residue2);
                if (residue2 != null && sheetAxes2 != null) {
                    printStream.print(":" + residue2.getCNIT() + ":" + decimalFormat.format(sheetAxes2.angleNormal) + ":" + decimalFormat.format(sheetAxes2.angleAcross) + ":" + decimalFormat.format(sheetAxes2.angleAlong));
                }
            }
            printStream.println();
        }
    }

    public void Main() throws IOException {
        PdbReader pdbReader = new PdbReader();
        CoordinateFile coordinateFile = pdbReader.read(System.in);
        Model model = coordinateFile.getFirstModel();
        ModelState modelState = model.getState();
        this.processModel(coordinateFile.getIdCode(), model, modelState);
    }

    public static void main(String[] stringArray) {
        SheetBuilder sheetBuilder = new SheetBuilder();
        try {
            sheetBuilder.parseArguments(stringArray);
            sheetBuilder.Main();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println();
            sheetBuilder.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + exception.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("SheetBuilder.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'SheetBuilder.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.mc.SheetBuilder");
        System.err.println("Copyright (C) 2004 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

