/*
 * Decompiled with CFR 0.152.
 */
package driftwood.moldb2;

import driftwood.moldb2.Residue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public abstract class SecondaryStructure {
    public static final Object COIL = "Unnamed structure (coil)";
    public static final Object HELIX = "Generic helix";
    public static final Object STRAND = "Generic extended strand";
    public static final Object TURN = "Generic turn";
    private Collection ranges = new ArrayList();

    protected void addRange(Range range) {
        this.ranges.add(range);
        range.rangeIndex = this.ranges.size();
    }

    public Range getRange(Residue residue) {
        Iterator iterator = this.ranges.iterator();
        while (iterator.hasNext()) {
            Range range = (Range)iterator.next();
            if (!range.contains(residue)) continue;
            return range;
        }
        return null;
    }

    public Object classify(Residue residue) {
        Range range = this.getRange(residue);
        if (range != null) {
            return range.getType();
        }
        return COIL;
    }

    public boolean isHelix(Residue residue) {
        return HELIX.equals(this.classify(residue));
    }

    public boolean isStrand(Residue residue) {
        return STRAND.equals(this.classify(residue));
    }

    public boolean isTurn(Residue residue) {
        return TURN.equals(this.classify(residue));
    }

    public boolean isCoil(Residue residue) {
        return COIL.equals(this.classify(residue));
    }

    public static class Range {
        int rangeIndex = 0;
        Object type = COIL;
        String chainId;
        int initSeqNum;
        int endSeqNum;
        String initICode = " ";
        String endICode = " ";

        public boolean contains(Residue residue) {
            if (!this.chainId.equals(residue.getChain())) {
                return false;
            }
            int n = residue.getSequenceInteger();
            if (n < this.initSeqNum || n > this.endSeqNum) {
                return false;
            }
            String string = residue.getInsertionCode();
            if (n == this.initSeqNum && string.compareTo(this.initICode) < 0) {
                return false;
            }
            return n != this.endSeqNum || string.compareTo(this.endICode) <= 0;
        }

        public Object getType() {
            return this.type;
        }

        public int getIndex() {
            return this.rangeIndex;
        }
    }

    public static class AllCoil
    extends SecondaryStructure {
        public Object classify(Residue residue) {
            return COIL;
        }
    }
}

