/*
 * Decompiled with CFR 0.152.
 */
package driftwood.r3;

import driftwood.r3.MutableTuple3;
import driftwood.r3.Quaternion;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import driftwood.util.Strings;

public class Transform {
    protected double m11 = 1.0;
    protected double m12 = 0.0;
    protected double m13 = 0.0;
    protected double m14 = 0.0;
    protected double m21 = 0.0;
    protected double m22 = 1.0;
    protected double m23 = 0.0;
    protected double m24 = 0.0;
    protected double m31 = 0.0;
    protected double m32 = 0.0;
    protected double m33 = 1.0;
    protected double m34 = 0.0;
    protected double m41 = 0.0;
    protected double m42 = 0.0;
    protected double m43 = 0.0;
    protected double m44 = 1.0;

    public Transform like(Transform transform) {
        this.m11 = transform.m11;
        this.m12 = transform.m12;
        this.m13 = transform.m13;
        this.m14 = transform.m14;
        this.m21 = transform.m21;
        this.m22 = transform.m22;
        this.m23 = transform.m23;
        this.m24 = transform.m24;
        this.m31 = transform.m31;
        this.m32 = transform.m32;
        this.m33 = transform.m33;
        this.m34 = transform.m34;
        this.m41 = transform.m41;
        this.m42 = transform.m42;
        this.m43 = transform.m43;
        this.m44 = transform.m44;
        return this;
    }

    public Transform likeIdentity() {
        return this.likeTranslation(0.0, 0.0, 0.0);
    }

    public Transform likeTranslation(double d, double d2, double d3) {
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m14 = d;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.m23 = 0.0;
        this.m24 = d2;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
        this.m34 = d3;
        this.m41 = 0.0;
        this.m42 = 0.0;
        this.m43 = 0.0;
        this.m44 = 1.0;
        return this;
    }

    public Transform likeTranslation(Tuple3 tuple3) {
        return this.likeTranslation(tuple3.getX(), tuple3.getY(), tuple3.getZ());
    }

    public Transform likeRotation(Tuple3 tuple3, double d) {
        Triple triple = new Triple().like(tuple3).unit();
        double d2 = triple.x;
        double d3 = triple.y;
        double d4 = triple.z;
        double d5 = Math.toRadians(d);
        double d6 = Math.sin(d5);
        double d7 = Math.cos(d5);
        double d8 = 1.0 - d7;
        this.m11 = d2 * d2 * d8 + d7;
        this.m12 = d2 * d3 * d8 - d4 * d6;
        this.m13 = d2 * d4 * d8 + d3 * d6;
        this.m14 = 0.0;
        this.m21 = d2 * d3 * d8 + d4 * d6;
        this.m22 = d3 * d3 * d8 + d7;
        this.m23 = d3 * d4 * d8 - d2 * d6;
        this.m24 = 0.0;
        this.m31 = d2 * d4 * d8 - d3 * d6;
        this.m32 = d3 * d4 * d8 + d2 * d6;
        this.m33 = d4 * d4 * d8 + d7;
        this.m34 = 0.0;
        this.m41 = 0.0;
        this.m42 = 0.0;
        this.m43 = 0.0;
        this.m44 = 1.0;
        return this;
    }

    public Transform likeRotation(Tuple3 tuple3, Tuple3 tuple32, double d) {
        Triple triple = new Triple().likeVector(tuple3, tuple32).unit();
        double d2 = triple.x;
        double d3 = triple.y;
        double d4 = triple.z;
        double d5 = tuple3.getX();
        double d6 = tuple3.getY();
        double d7 = tuple3.getZ();
        double d8 = Math.toRadians(d);
        double d9 = Math.sin(d8);
        double d10 = Math.cos(d8);
        double d11 = 1.0 - d10;
        this.m11 = d2 * d2 * d11 + d10;
        this.m12 = d2 * d3 * d11 - d4 * d9;
        this.m13 = d2 * d4 * d11 + d3 * d9;
        this.m14 = d5 - (this.m11 * d5 + this.m12 * d6 + this.m13 * d7);
        this.m21 = d2 * d3 * d11 + d4 * d9;
        this.m22 = d3 * d3 * d11 + d10;
        this.m23 = d3 * d4 * d11 - d2 * d9;
        this.m24 = d6 - (this.m21 * d5 + this.m22 * d6 + this.m23 * d7);
        this.m31 = d2 * d4 * d11 - d3 * d9;
        this.m32 = d3 * d4 * d11 + d2 * d9;
        this.m33 = d4 * d4 * d11 + d10;
        this.m34 = d7 - (this.m31 * d5 + this.m32 * d6 + this.m33 * d7);
        this.m41 = 0.0;
        this.m42 = 0.0;
        this.m43 = 0.0;
        this.m44 = 1.0;
        return this;
    }

    public Transform likeQuaternion(Quaternion quaternion) {
        double d = 2.0 / (quaternion.getX() * quaternion.getX() + quaternion.getY() * quaternion.getY() + quaternion.getZ() * quaternion.getZ() + quaternion.getW() * quaternion.getW());
        double d2 = quaternion.getX() * d;
        double d3 = quaternion.getY() * d;
        double d4 = quaternion.getZ() * d;
        double d5 = quaternion.getW() * d2;
        double d6 = quaternion.getW() * d3;
        double d7 = quaternion.getW() * d4;
        double d8 = quaternion.getX() * d2;
        double d9 = quaternion.getX() * d3;
        double d10 = quaternion.getX() * d4;
        double d11 = quaternion.getY() * d3;
        double d12 = quaternion.getY() * d4;
        double d13 = quaternion.getZ() * d4;
        this.m11 = 1.0 - (d11 + d13);
        this.m12 = d9 + d7;
        this.m13 = d10 - d6;
        this.m14 = 0.0;
        this.m21 = d9 - d7;
        this.m22 = 1.0 - (d8 + d13);
        this.m23 = d12 + d5;
        this.m24 = 0.0;
        this.m31 = d10 + d6;
        this.m32 = d12 - d5;
        this.m33 = 1.0 - (d8 + d11);
        this.m34 = 0.0;
        this.m41 = 0.0;
        this.m42 = 0.0;
        this.m43 = 0.0;
        this.m44 = 1.0;
        return this;
    }

    public Transform likeMatrix(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.m11 = d;
        this.m12 = d2;
        this.m13 = d3;
        this.m14 = 0.0;
        this.m21 = d4;
        this.m22 = d5;
        this.m23 = d6;
        this.m24 = 0.0;
        this.m31 = d7;
        this.m32 = d8;
        this.m33 = d9;
        this.m34 = 0.0;
        this.m41 = 0.0;
        this.m42 = 0.0;
        this.m43 = 0.0;
        this.m44 = 1.0;
        return this;
    }

    public Transform likeScale(double d) {
        this.m11 = d;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m14 = 0.0;
        this.m21 = 0.0;
        this.m22 = d;
        this.m23 = 0.0;
        this.m24 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = d;
        this.m34 = 0.0;
        this.m41 = 0.0;
        this.m42 = 0.0;
        this.m43 = 0.0;
        this.m44 = 1.0;
        return this;
    }

    public Transform likeScale(double d, double d2, double d3) {
        this.m11 = d;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m14 = 0.0;
        this.m21 = 0.0;
        this.m22 = d2;
        this.m23 = 0.0;
        this.m24 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = d3;
        this.m34 = 0.0;
        this.m41 = 0.0;
        this.m42 = 0.0;
        this.m43 = 0.0;
        this.m44 = 1.0;
        return this;
    }

    public Transform likePerspective(double d) {
        this.m11 = d;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m14 = 0.0;
        this.m21 = 0.0;
        this.m22 = d;
        this.m23 = 0.0;
        this.m24 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = d;
        this.m34 = 0.0;
        this.m41 = 0.0;
        this.m42 = 0.0;
        this.m43 = -1.0;
        this.m44 = d;
        return this;
    }

    public Transform premult(Transform transform) {
        return this.append(transform);
    }

    public Transform append(Transform transform) {
        double d = transform.m11 * this.m11 + transform.m12 * this.m21 + transform.m13 * this.m31 + transform.m14 * this.m41;
        double d2 = transform.m11 * this.m12 + transform.m12 * this.m22 + transform.m13 * this.m32 + transform.m14 * this.m42;
        double d3 = transform.m11 * this.m13 + transform.m12 * this.m23 + transform.m13 * this.m33 + transform.m14 * this.m43;
        double d4 = transform.m11 * this.m14 + transform.m12 * this.m24 + transform.m13 * this.m34 + transform.m14 * this.m44;
        double d5 = transform.m21 * this.m11 + transform.m22 * this.m21 + transform.m23 * this.m31 + transform.m24 * this.m41;
        double d6 = transform.m21 * this.m12 + transform.m22 * this.m22 + transform.m23 * this.m32 + transform.m24 * this.m42;
        double d7 = transform.m21 * this.m13 + transform.m22 * this.m23 + transform.m23 * this.m33 + transform.m24 * this.m43;
        double d8 = transform.m21 * this.m14 + transform.m22 * this.m24 + transform.m23 * this.m34 + transform.m24 * this.m44;
        double d9 = transform.m31 * this.m11 + transform.m32 * this.m21 + transform.m33 * this.m31 + transform.m34 * this.m41;
        double d10 = transform.m31 * this.m12 + transform.m32 * this.m22 + transform.m33 * this.m32 + transform.m34 * this.m42;
        double d11 = transform.m31 * this.m13 + transform.m32 * this.m23 + transform.m33 * this.m33 + transform.m34 * this.m43;
        double d12 = transform.m31 * this.m14 + transform.m32 * this.m24 + transform.m33 * this.m34 + transform.m34 * this.m44;
        double d13 = transform.m41 * this.m11 + transform.m42 * this.m21 + transform.m43 * this.m31 + transform.m44 * this.m41;
        double d14 = transform.m41 * this.m12 + transform.m42 * this.m22 + transform.m43 * this.m32 + transform.m44 * this.m42;
        double d15 = transform.m41 * this.m13 + transform.m42 * this.m23 + transform.m43 * this.m33 + transform.m44 * this.m43;
        double d16 = transform.m41 * this.m14 + transform.m42 * this.m24 + transform.m43 * this.m34 + transform.m44 * this.m44;
        this.m11 = d;
        this.m12 = d2;
        this.m13 = d3;
        this.m14 = d4;
        this.m21 = d5;
        this.m22 = d6;
        this.m23 = d7;
        this.m24 = d8;
        this.m31 = d9;
        this.m32 = d10;
        this.m33 = d11;
        this.m34 = d12;
        this.m41 = d13;
        this.m42 = d14;
        this.m43 = d15;
        this.m44 = d16;
        return this;
    }

    public Transform postmult(Transform transform) {
        return this.prepend(transform);
    }

    public Transform prepend(Transform transform) {
        double d = this.m11 * transform.m11 + this.m12 * transform.m21 + this.m13 * transform.m31 + this.m14 * transform.m41;
        double d2 = this.m11 * transform.m12 + this.m12 * transform.m22 + this.m13 * transform.m32 + this.m14 * transform.m42;
        double d3 = this.m11 * transform.m13 + this.m12 * transform.m23 + this.m13 * transform.m33 + this.m14 * transform.m43;
        double d4 = this.m11 * transform.m14 + this.m12 * transform.m24 + this.m13 * transform.m34 + this.m14 * transform.m44;
        double d5 = this.m21 * transform.m11 + this.m22 * transform.m21 + this.m23 * transform.m31 + this.m24 * transform.m41;
        double d6 = this.m21 * transform.m12 + this.m22 * transform.m22 + this.m23 * transform.m32 + this.m24 * transform.m42;
        double d7 = this.m21 * transform.m13 + this.m22 * transform.m23 + this.m23 * transform.m33 + this.m24 * transform.m43;
        double d8 = this.m21 * transform.m14 + this.m22 * transform.m24 + this.m23 * transform.m34 + this.m24 * transform.m44;
        double d9 = this.m31 * transform.m11 + this.m32 * transform.m21 + this.m33 * transform.m31 + this.m34 * transform.m41;
        double d10 = this.m31 * transform.m12 + this.m32 * transform.m22 + this.m33 * transform.m32 + this.m34 * transform.m42;
        double d11 = this.m31 * transform.m13 + this.m32 * transform.m23 + this.m33 * transform.m33 + this.m34 * transform.m43;
        double d12 = this.m31 * transform.m14 + this.m32 * transform.m24 + this.m33 * transform.m34 + this.m34 * transform.m44;
        double d13 = this.m41 * transform.m11 + this.m42 * transform.m21 + this.m43 * transform.m31 + this.m44 * transform.m41;
        double d14 = this.m41 * transform.m12 + this.m42 * transform.m22 + this.m43 * transform.m32 + this.m44 * transform.m42;
        double d15 = this.m41 * transform.m13 + this.m42 * transform.m23 + this.m43 * transform.m33 + this.m44 * transform.m43;
        double d16 = this.m41 * transform.m14 + this.m42 * transform.m24 + this.m43 * transform.m34 + this.m44 * transform.m44;
        this.m11 = d;
        this.m12 = d2;
        this.m13 = d3;
        this.m14 = d4;
        this.m21 = d5;
        this.m22 = d6;
        this.m23 = d7;
        this.m24 = d8;
        this.m31 = d9;
        this.m32 = d10;
        this.m33 = d11;
        this.m34 = d12;
        this.m41 = d13;
        this.m42 = d14;
        this.m43 = d15;
        this.m44 = d16;
        return this;
    }

    public MutableTuple3 transform(MutableTuple3 mutableTuple3) {
        return this.transform(mutableTuple3, mutableTuple3);
    }

    public MutableTuple3 transform(Tuple3 tuple3, MutableTuple3 mutableTuple3) {
        double d = tuple3.getX();
        double d2 = tuple3.getY();
        double d3 = tuple3.getZ();
        double d4 = this.m41 * d + this.m42 * d2 + this.m43 * d3 + this.m44;
        mutableTuple3.setXYZ((this.m11 * d + this.m12 * d2 + this.m13 * d3 + this.m14) / d4, (this.m21 * d + this.m22 * d2 + this.m23 * d3 + this.m24) / d4, (this.m31 * d + this.m32 * d2 + this.m33 * d3 + this.m34) / d4);
        return mutableTuple3;
    }

    public MutableTuple3 transformVector(MutableTuple3 mutableTuple3) {
        return this.transformVector(mutableTuple3, mutableTuple3);
    }

    public MutableTuple3 transformVector(Tuple3 tuple3, MutableTuple3 mutableTuple3) {
        double d = tuple3.getX();
        double d2 = tuple3.getY();
        double d3 = tuple3.getZ();
        double d4 = this.m44;
        mutableTuple3.setXYZ((this.m11 * d + this.m12 * d2 + this.m13 * d3) / d4, (this.m21 * d + this.m22 * d2 + this.m23 * d3) / d4, (this.m31 * d + this.m32 * d2 + this.m33 * d3) / d4);
        return mutableTuple3;
    }

    public Transform orthonormalize() {
        Triple triple = new Triple(this.m11, this.m12, this.m13);
        Triple triple2 = new Triple(this.m21, this.m22, this.m23);
        Triple triple3 = new Triple(this.m31, this.m32, this.m33);
        triple3.unit();
        triple.likeCross(triple2, triple3);
        triple.unit();
        triple2.likeCross(triple3, triple);
        triple2.unit();
        this.m11 = triple.x;
        this.m12 = triple.y;
        this.m13 = triple.z;
        this.m21 = triple2.x;
        this.m22 = triple2.y;
        this.m23 = triple2.z;
        this.m31 = triple3.x;
        this.m32 = triple3.y;
        this.m33 = triple3.z;
        return this;
    }

    public boolean isNaN() {
        return Double.isNaN(this.m11) || Double.isNaN(this.m12) || Double.isNaN(this.m13) || Double.isNaN(this.m14) || Double.isNaN(this.m21) || Double.isNaN(this.m22) || Double.isNaN(this.m23) || Double.isNaN(this.m24) || Double.isNaN(this.m31) || Double.isNaN(this.m32) || Double.isNaN(this.m33) || Double.isNaN(this.m34) || Double.isNaN(this.m41) || Double.isNaN(this.m42) || Double.isNaN(this.m43) || Double.isNaN(this.m44);
    }

    public double get(int n, int n2) {
        String string = "Index must be 1, 2, 3, or 4";
        switch (n) {
            case 1: {
                switch (n2) {
                    case 1: {
                        return this.m11;
                    }
                    case 2: {
                        return this.m12;
                    }
                    case 3: {
                        return this.m13;
                    }
                    case 4: {
                        return this.m14;
                    }
                }
                throw new IllegalArgumentException(string);
            }
            case 2: {
                switch (n2) {
                    case 1: {
                        return this.m21;
                    }
                    case 2: {
                        return this.m22;
                    }
                    case 3: {
                        return this.m23;
                    }
                    case 4: {
                        return this.m24;
                    }
                }
                throw new IllegalArgumentException(string);
            }
            case 3: {
                switch (n2) {
                    case 1: {
                        return this.m31;
                    }
                    case 2: {
                        return this.m32;
                    }
                    case 3: {
                        return this.m33;
                    }
                    case 4: {
                        return this.m34;
                    }
                }
                throw new IllegalArgumentException(string);
            }
            case 4: {
                switch (n2) {
                    case 1: {
                        return this.m41;
                    }
                    case 2: {
                        return this.m42;
                    }
                    case 3: {
                        return this.m43;
                    }
                    case 4: {
                        return this.m44;
                    }
                }
                throw new IllegalArgumentException(string);
            }
        }
        throw new IllegalArgumentException(string);
    }

    public void set(int n, int n2, double d) {
        String string = "Index must be 1, 2, 3, or 4";
        block0 : switch (n) {
            case 1: {
                switch (n2) {
                    case 1: {
                        this.m11 = d;
                        break block0;
                    }
                    case 2: {
                        this.m12 = d;
                        break block0;
                    }
                    case 3: {
                        this.m13 = d;
                        break block0;
                    }
                    case 4: {
                        this.m14 = d;
                        break block0;
                    }
                }
                throw new IllegalArgumentException(string);
            }
            case 2: {
                switch (n2) {
                    case 1: {
                        this.m21 = d;
                        break block0;
                    }
                    case 2: {
                        this.m22 = d;
                        break block0;
                    }
                    case 3: {
                        this.m23 = d;
                        break block0;
                    }
                    case 4: {
                        this.m24 = d;
                        break block0;
                    }
                }
                throw new IllegalArgumentException(string);
            }
            case 3: {
                switch (n2) {
                    case 1: {
                        this.m31 = d;
                        break block0;
                    }
                    case 2: {
                        this.m32 = d;
                        break block0;
                    }
                    case 3: {
                        this.m33 = d;
                        break block0;
                    }
                    case 4: {
                        this.m34 = d;
                        break block0;
                    }
                }
                throw new IllegalArgumentException(string);
            }
            case 4: {
                switch (n2) {
                    case 1: {
                        this.m41 = d;
                        break block0;
                    }
                    case 2: {
                        this.m42 = d;
                        break block0;
                    }
                    case 3: {
                        this.m43 = d;
                        break block0;
                    }
                    case 4: {
                        this.m44 = d;
                        break block0;
                    }
                }
                throw new IllegalArgumentException(string);
            }
            default: {
                throw new IllegalArgumentException(string);
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Transform)) {
            return false;
        }
        Transform transform = (Transform)object;
        return this.m11 == transform.m11 && this.m12 == transform.m12 && this.m13 == transform.m13 && this.m14 == transform.m14 && this.m21 == transform.m21 && this.m22 == transform.m22 && this.m23 == transform.m23 && this.m24 == transform.m24 && this.m31 == transform.m31 && this.m32 == transform.m32 && this.m33 == transform.m33 && this.m34 == transform.m34;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.m11) ^ Double.doubleToLongBits(this.m12) ^ Double.doubleToLongBits(this.m13) ^ Double.doubleToLongBits(this.m14) ^ Double.doubleToLongBits(this.m21) ^ Double.doubleToLongBits(this.m22) ^ Double.doubleToLongBits(this.m23) ^ Double.doubleToLongBits(this.m24) ^ Double.doubleToLongBits(this.m31) ^ Double.doubleToLongBits(this.m32) ^ Double.doubleToLongBits(this.m33) ^ Double.doubleToLongBits(this.m34);
        return (int)(l ^ l >>> 32);
    }

    public String toString() {
        return "[ " + Strings.justifyLeft(Double.toString(this.m11), 20) + "   " + Strings.justifyLeft(Double.toString(this.m12), 20) + "   " + Strings.justifyLeft(Double.toString(this.m13), 20) + "   " + Strings.justifyLeft(Double.toString(this.m14), 20) + " ]\n" + "[ " + Strings.justifyLeft(Double.toString(this.m21), 20) + "   " + Strings.justifyLeft(Double.toString(this.m22), 20) + "   " + Strings.justifyLeft(Double.toString(this.m23), 20) + "   " + Strings.justifyLeft(Double.toString(this.m24), 20) + " ]\n" + "[ " + Strings.justifyLeft(Double.toString(this.m31), 20) + "   " + Strings.justifyLeft(Double.toString(this.m32), 20) + "   " + Strings.justifyLeft(Double.toString(this.m33), 20) + "   " + Strings.justifyLeft(Double.toString(this.m34), 20) + " ]\n" + "[ " + Strings.justifyLeft(Double.toString(this.m41), 20) + "   " + Strings.justifyLeft(Double.toString(this.m42), 20) + "   " + Strings.justifyLeft(Double.toString(this.m43), 20) + "   " + Strings.justifyLeft(Double.toString(this.m44), 20) + " ]\n";
    }
}

