/*
 * Decompiled with CFR 0.152.
 */
package king.core;

import driftwood.data.UberMap;
import java.awt.BasicStroke;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import king.core.KPaint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KPalette {
    public static final float[] widthScale;
    public static final BasicStroke pen0;
    public static final BasicStroke pen1;
    public static final BasicStroke[][] pens;
    public static final int[][] lineWidths;
    public static final KPaint red;
    public static final KPaint orange;
    public static final KPaint gold;
    public static final KPaint yellow;
    public static final KPaint lime;
    public static final KPaint green;
    public static final KPaint sea;
    public static final KPaint cyan;
    public static final KPaint sky;
    public static final KPaint blue;
    public static final KPaint purple;
    public static final KPaint magenta;
    public static final KPaint hotpink;
    public static final KPaint pink;
    public static final KPaint peach;
    public static final KPaint lilac;
    public static final KPaint pinktint;
    public static final KPaint peachtint;
    public static final KPaint yellowtint;
    public static final KPaint greentint;
    public static final KPaint bluetint;
    public static final KPaint lilactint;
    public static final KPaint white;
    public static final KPaint gray;
    public static final KPaint brown;
    public static final KPaint deadwhite;
    public static final KPaint deadblack;
    public static final KPaint invisible;
    public static final KPaint defaultColor;
    private static final Map<String, KPaint> stdColorMap;
    private static final Map<String, KPaint> fullColorMap;
    private static final KPaint[] aspectTable;

    private static void addAspect(char c, KPaint kPaint) {
        char c2 = Character.toUpperCase(c);
        char c3 = Character.toLowerCase(c);
        KPalette.aspectTable[c2] = KPalette.aspectTable[c3] = kPaint;
    }

    private KPalette() {
    }

    public static KPaint forName(String string) {
        return fullColorMap.get(string);
    }

    public static KPaint forAspect(char c) {
        if (c < '\u0000' || c > '\u00ff') {
            return null;
        }
        return aspectTable[c];
    }

    public static Map<String, KPaint> getStandardMap() {
        return stdColorMap;
    }

    public static Map<String, KPaint> getFullMap() {
        return fullColorMap;
    }

    public static void setContrast(double d) {
        for (KPaint kPaint : KPalette.getFullMap().values()) {
            kPaint.setContrast(d);
        }
    }

    static {
        int n;
        widthScale = new float[16];
        pen0 = new BasicStroke(0.0f, 1, 1);
        pen1 = new BasicStroke(1.0f, 1, 1);
        pens = new BasicStroke[7][16];
        lineWidths = new int[7][16];
        for (n = 0; n < 16; ++n) {
            double d = (double)n / 15.0;
            KPalette.widthScale[n] = (float)(d * 2.0 + (1.0 - d) * 0.5);
        }
        for (n = 0; n < 16; ++n) {
            KPalette.lineWidths[0][n] = 1;
            KPalette.pens[0][n] = pen1;
        }
        for (n = 1; n < 7; ++n) {
            for (int i = 0; i < 16; ++i) {
                KPalette.lineWidths[n][i] = Math.max(1, (int)((double)((float)(n + 1) * widthScale[i]) + 0.5));
                KPalette.pens[n][i] = new BasicStroke((float)(n + 1) * widthScale[i], 1, 1);
            }
        }
        red = KPaint.createHSV("red", 0.0f, 100.0f, 100.0f, 100.0f, 80.0f);
        orange = KPaint.createHSV("orange", 20.0f, 100.0f, 100.0f, 100.0f, 90.0f);
        gold = KPaint.createHSV("gold", 40.0f, 100.0f, 100.0f, 100.0f, 90.0f);
        yellow = KPaint.createHSV("yellow", 60.0f, 100.0f, 100.0f, 100.0f, 90.0f);
        lime = KPaint.createHSV("lime", 80.0f, 100.0f, 100.0f, 100.0f, 85.0f);
        green = KPaint.createHSV("green", 120.0f, 80.0f, 90.0f, 100.0f, 75.0f);
        sea = KPaint.createHSV("sea", 150.0f, 100.0f, 100.0f, 100.0f, 85.0f);
        cyan = KPaint.createHSV("cyan", 180.0f, 100.0f, 85.0f, 85.0f, 80.0f);
        sky = KPaint.createHSV("sky", 210.0f, 75.0f, 80.0f, 95.0f, 90.0f);
        blue = KPaint.createHSV("blue", 240.0f, 70.0f, 80.0f, 100.0f, 100.0f);
        purple = KPaint.createHSV("purple", 275.0f, 75.0f, 100.0f, 100.0f, 85.0f);
        magenta = KPaint.createHSV("magenta", 300.0f, 95.0f, 100.0f, 100.0f, 90.0f);
        hotpink = KPaint.createHSV("hotpink", 335.0f, 100.0f, 100.0f, 100.0f, 90.0f);
        pink = KPaint.createHSV("pink", 350.0f, 55.0f, 75.0f, 100.0f, 90.0f);
        peach = KPaint.createHSV("peach", 25.0f, 75.0f, 75.0f, 100.0f, 90.0f);
        lilac = KPaint.createHSV("lilac", 275.0f, 55.0f, 75.0f, 100.0f, 80.0f);
        pinktint = KPaint.createHSV("pinktint", 340.0f, 30.0f, 100.0f, 100.0f, 55.0f);
        peachtint = KPaint.createHSV("peachtint", 25.0f, 50.0f, 100.0f, 100.0f, 60.0f);
        yellowtint = KPaint.createHSV("yellowtint", 60.0f, 50.0f, 100.0f, 100.0f, 75.0f);
        greentint = KPaint.createHSV("greentint", 135.0f, 40.0f, 100.0f, 100.0f, 35.0f);
        bluetint = KPaint.createHSV("bluetint", 220.0f, 40.0f, 100.0f, 100.0f, 50.0f);
        lilactint = KPaint.createHSV("lilactint", 275.0f, 35.0f, 100.0f, 100.0f, 45.0f);
        white = KPaint.createHSV("white", 0.0f, 0.0f, 0.0f, 100.0f, 0.0f);
        gray = KPaint.createHSV("gray", 0.0f, 0.0f, 0.0f, 50.0f, 40.0f);
        brown = KPaint.createHSV("brown", 20.0f, 45.0f, 45.0f, 75.0f, 55.0f);
        deadwhite = KPaint.createSolid("deadwhite", KPaint.white);
        deadblack = KPaint.createSolid("deadblack", KPaint.black);
        invisible = KPaint.createInvisible("invisible");
        defaultColor = white;
        UberMap uberMap = new UberMap();
        uberMap.put(red.toString(), red);
        uberMap.put(pink.toString(), pink);
        uberMap.put(pinktint.toString(), pinktint);
        uberMap.put(orange.toString(), orange);
        uberMap.put(peach.toString(), peach);
        uberMap.put(peachtint.toString(), peachtint);
        uberMap.put(gold.toString(), gold);
        uberMap.put(yellow.toString(), yellow);
        uberMap.put(yellowtint.toString(), yellowtint);
        uberMap.put(lime.toString(), lime);
        uberMap.put(green.toString(), green);
        uberMap.put(greentint.toString(), greentint);
        uberMap.put(sea.toString(), sea);
        uberMap.put(cyan.toString(), cyan);
        uberMap.put(sky.toString(), sky);
        uberMap.put(blue.toString(), blue);
        uberMap.put(bluetint.toString(), bluetint);
        uberMap.put(purple.toString(), purple);
        uberMap.put(lilac.toString(), lilac);
        uberMap.put(lilactint.toString(), lilactint);
        uberMap.put(magenta.toString(), magenta);
        uberMap.put(hotpink.toString(), hotpink);
        uberMap.put(white.toString(), white);
        uberMap.put(gray.toString(), gray);
        uberMap.put(brown.toString(), brown);
        uberMap.put(deadwhite.toString(), deadwhite);
        uberMap.put(deadblack.toString(), deadblack);
        uberMap.put(invisible.toString(), invisible);
        stdColorMap = Collections.unmodifiableMap(uberMap);
        uberMap = new UberMap(uberMap);
        uberMap.put("default", defaultColor);
        uberMap.put("rust", orange);
        uberMap.put("seagreen", sea);
        uberMap.put("skyblue", sky);
        uberMap.put("paleyellow", yellowtint);
        uberMap.put("grey", gray);
        uberMap.put("black", deadblack);
        fullColorMap = Collections.unmodifiableMap(uberMap);
        aspectTable = new KPaint[256];
        Arrays.fill(aspectTable, null);
        KPalette.addAspect('A', red);
        KPalette.addAspect('B', orange);
        KPalette.addAspect('C', gold);
        KPalette.addAspect('D', yellow);
        KPalette.addAspect('E', lime);
        KPalette.addAspect('F', green);
        KPalette.addAspect('G', sea);
        KPalette.addAspect('H', cyan);
        KPalette.addAspect('I', sky);
        KPalette.addAspect('J', blue);
        KPalette.addAspect('K', purple);
        KPalette.addAspect('L', magenta);
        KPalette.addAspect('M', hotpink);
        KPalette.addAspect('N', pink);
        KPalette.addAspect('O', lilac);
        KPalette.addAspect('P', peach);
        KPalette.addAspect('Q', peachtint);
        KPalette.addAspect('R', yellowtint);
        KPalette.addAspect('S', greentint);
        KPalette.addAspect('T', bluetint);
        KPalette.addAspect('U', lilactint);
        KPalette.addAspect('V', pinktint);
        KPalette.addAspect('W', white);
        KPalette.addAspect('X', gray);
        KPalette.addAspect('Y', brown);
        KPalette.addAspect('Z', invisible);
    }
}

