/*
 * Decompiled with CFR 0.152.
 */
package king.io;

import driftwood.util.Strings;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.Collection;
import king.core.AGE;
import king.core.Aspect;
import king.core.KGroup;
import king.core.KList;
import king.core.KPaint;
import king.core.KPalette;
import king.core.KPoint;
import king.core.KView;
import king.core.Kinemage;
import king.core.MasterGroup;
import king.points.BallPoint;
import king.points.MarkerPoint;
import king.points.RingPoint;
import king.points.TrianglePoint;
import king.points.VectorPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KinfileWriter {
    static final DecimalFormat df = Strings.usDecimalFormat("0.####");
    PrintWriter out = null;
    String lastPointID = null;

    public void save(Writer writer, String string, Collection<Kinemage> collection) {
        this.out = new PrintWriter(new BufferedWriter(writer));
        this.out.println("@text");
        this.out.println(string.trim());
        int n = 1;
        for (Kinemage kinemage : collection) {
            this.writeKinemage(kinemage, n++);
        }
        this.out.flush();
    }

    void writeKinemage(Kinemage kinemage, int n) {
        this.out.println("@kinemage " + n);
        if (!kinemage.getName().startsWith("Kinemage #")) {
            this.out.println("@title {" + kinemage.getName() + "}");
        }
        if (kinemage.atWhitebackground) {
            this.out.println("@whitebackground");
        }
        if (kinemage.atOnewidth) {
            this.out.println("@onewidth");
        } else if (kinemage.atThinline) {
            this.out.println("@thinline");
        }
        if (kinemage.atPerspective) {
            this.out.println("@perspective");
        }
        if (kinemage.atFlat) {
            this.out.println("@flat");
        }
        if (kinemage.atListcolordominant) {
            this.out.println("@listcolordominant");
        }
        if (kinemage.atLens > 0.0) {
            this.out.println("@lens " + df.format(kinemage.atLens));
        }
        if (kinemage.atPdbfile != null) {
            this.out.println("@pdbfile {" + kinemage.atPdbfile + "}");
        }
        if (kinemage.atCommand != null) {
            this.out.println("@command {" + kinemage.atCommand + "}");
        }
        for (KPaint object : kinemage.getNewPaintMap().values()) {
            if (object.isAlias()) {
                this.out.println("@colorset {" + object + "} " + object.getAlias());
                continue;
            }
            this.out.print("@hsvcolor {" + object + "}");
            Color color = object.getBlackExemplar();
            float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            this.out.print(" " + df.format(360.0f * fArray[0]) + " " + df.format(100.0f * fArray[1]) + " " + df.format(100.0f * fArray[2]));
            Color color2 = object.getWhiteExemplar();
            fArray = Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), null);
            this.out.print(" " + df.format(360.0f * fArray[0]) + " " + df.format(100.0f * fArray[1]) + " " + df.format(100.0f * fArray[2]));
            this.out.println();
        }
        for (Aspect aspect : kinemage.getAspects()) {
            this.out.println("@" + aspect.getIndex() + "aspect {" + aspect.getName() + "}");
        }
        int n2 = 1;
        for (KView kView : kinemage.getViewList()) {
            this.writeView(kView, n2++);
        }
        for (MasterGroup masterGroup : kinemage.masterList()) {
            this.writeMaster(masterGroup, kinemage);
        }
        if (kinemage.dimensionNames.size() > 0) {
            this.out.print("@dimensions");
            for (String string : kinemage.dimensionNames) {
                this.out.print(" {" + string + "}");
            }
            this.out.println();
        }
        if (kinemage.dimensionMinMax.size() > 0) {
            this.out.print("@dimminmax");
            for (Number number : kinemage.dimensionMinMax) {
                this.out.print(" " + df.format(number.doubleValue()));
            }
            this.out.println();
        }
        if (kinemage.dimensionScale.size() > 0) {
            this.out.print("@dimscale");
            for (Number number : kinemage.dimensionScale) {
                this.out.print(" " + df.format(number.doubleValue()));
            }
            this.out.println();
        }
        if (kinemage.dimensionOffset.size() > 0) {
            this.out.print("@dimoffset");
            for (Number number : kinemage.dimensionOffset) {
                this.out.print(" " + df.format(number.doubleValue()));
            }
            this.out.println();
        }
        for (KGroup kGroup : kinemage) {
            this.writeGroup(kGroup, kinemage);
        }
    }

    void writeGroup(KGroup kGroup, Kinemage kinemage) {
        int n = kGroup.getDepth();
        if (n == 1) {
            this.out.print("@group {" + kGroup.getName() + "}");
            if (kGroup.isAnimate()) {
                this.out.print(" animate");
            }
            if (kGroup.is2Animate()) {
                this.out.print(" 2animate");
            }
            if (kGroup.isSelect()) {
                this.out.print(" select");
            }
        } else if (n == 2) {
            this.out.print("@subgroup {" + kGroup.getName() + "}");
        }
        if (n == 1 || n == 2) {
            if (!kGroup.isOn()) {
                this.out.print(" off");
            }
            if (!kGroup.hasButton()) {
                this.out.print(" nobutton");
            }
            if (kGroup.isDominant()) {
                this.out.print(" dominant");
            }
            if (kGroup.isCollapsible()) {
                this.out.print(" collapsible");
            }
            if (kGroup.isLens()) {
                this.out.print(" lens");
            }
            for (String object : kGroup.getMasters()) {
                this.out.print(" master= {" + object + "}");
            }
            this.out.println();
        }
        for (AGE aGE : kGroup) {
            if (aGE instanceof KList) {
                this.writeList((KList)aGE, kinemage);
                continue;
            }
            if (!(aGE instanceof KGroup)) continue;
            this.writeGroup((KGroup)aGE, kinemage);
        }
    }

    void writeList(KList kList, Kinemage kinemage) {
        KPaint kPaint;
        this.out.print("@" + kList.getType() + "list {" + kList.getName() + "}");
        if (kList.getInstance() != null) {
            this.out.print(" instance= {" + kList.getInstance().getName() + "}");
        }
        if (!kList.isOn()) {
            this.out.print(" off");
        }
        if (!kList.hasButton()) {
            this.out.print(" nobutton");
        }
        if (kList.isLens()) {
            this.out.print(" lens");
        }
        if ((kPaint = kList.getColor()) == null) {
            kPaint = KPalette.defaultColor;
        }
        if (kPaint.isAlias()) {
            this.out.print(" color= {" + kPaint + "}");
        } else {
            this.out.print(" color= " + kPaint);
        }
        if (kList.getType() == "vector" || kList.getType() == "dot") {
            if (kList.getWidth() != 2) {
                this.out.print(" width= " + kList.getWidth());
            }
        } else if (kList.getType() == "ball" || kList.getType() == "sphere" || kList.getType() == "ring") {
            this.out.print(" radius= " + df.format(kList.getRadius()));
            if (kList.getNoHighlight()) {
                this.out.print(" nohighlight");
            }
        } else if (kList.getType() == "arrow") {
            this.out.print(" radius= " + df.format(kList.getRadius()));
            this.out.print(" angle= " + df.format(kList.getAngle()));
        }
        if (kList.getAlpha() != 255) {
            this.out.print(" alpha= " + df.format((double)kList.getAlpha() / 255.0));
        }
        for (String object : kList.getMasters()) {
            this.out.print(" master= {" + object + "}");
        }
        if (kList.getDimension() > 3) {
            this.out.print(" dimension= " + kList.getDimension());
        }
        if (kList.getScreen()) {
            this.out.print(" screen");
        }
        if (kList.getRear()) {
            this.out.print(" rear");
        }
        if (kList.getFore()) {
            this.out.print(" fore");
        }
        this.out.println();
        this.lastPointID = null;
        for (KPoint kPoint : kList) {
            this.writePoint(kPoint, kList, kinemage);
            this.lastPointID = kPoint.getName();
        }
    }

    void writePoint(KPoint kPoint, KList kList, Kinemage kinemage) {
        float[] fArray;
        Object object;
        String string;
        if (kPoint.getComment() != null) {
            this.out.print("<" + kPoint.getComment() + ">");
        }
        if ((string = kPoint.getName()).equals(this.lastPointID)) {
            this.out.print("{\"}");
        } else {
            this.out.print("{" + string + "}");
        }
        if (kPoint.getPmMask() != 0) {
            this.out.print("'" + kinemage.fromPmBitmask(kPoint.getPmMask()) + "' ");
        }
        if (kPoint.getAspects() != null) {
            this.out.print("(" + kPoint.getAspects() + ") ");
        }
        if (kPoint.isBreak()) {
            this.out.print("P ");
        }
        if (kPoint.isUnpickable()) {
            this.out.print("U ");
        }
        if (kPoint.isGhost()) {
            this.out.print("ghost ");
        }
        if (kPoint instanceof TrianglePoint && kPoint.isBreak()) {
            this.out.print("X ");
        } else if (kPoint instanceof VectorPoint) {
            object = (VectorPoint)kPoint;
            if (((VectorPoint)object).getWidth() > 0 && ((VectorPoint)object).getWidth() != kList.getWidth()) {
                this.out.print("width" + ((VectorPoint)object).getWidth() + " ");
            }
        } else if (kPoint instanceof BallPoint) {
            object = (BallPoint)kPoint;
            if (((RingPoint)object).getRadius() > 0.0f) {
                this.out.print("r=" + df.format(((RingPoint)object).getRadius()) + " ");
            }
        } else if (kPoint instanceof MarkerPoint && ((MarkerPoint)(object = (MarkerPoint)kPoint)).getStyle() != 0) {
            this.out.print("s=" + ((MarkerPoint)object).getStyle() + " ");
        }
        object = kPoint.getColor();
        if (object != null && object != kList.getColor()) {
            this.out.print(object + " ");
        }
        if ((fArray = kPoint.getAllCoords()) == null) {
            this.out.println(df.format(kPoint.getX()) + " " + df.format(kPoint.getY()) + " " + df.format(kPoint.getZ()));
        } else {
            for (int i = 0; i < fArray.length; ++i) {
                this.out.print(df.format(fArray[i]) + " ");
            }
            this.out.println();
        }
    }

    void writeView(KView kView, int n) {
        this.out.println("@" + n + "viewid {" + kView.getName() + "}");
        this.out.println("@" + n + "span " + kView.getSpan());
        this.out.println("@" + n + "zslab " + kView.getClip() * 200.0f);
        float[] fArray = kView.getCenter();
        this.out.println("@" + n + "center " + df.format(fArray[0]) + " " + df.format(fArray[1]) + " " + df.format(fArray[2]));
        int[] nArray = kView.getViewingAxes();
        if (nArray != null) {
            this.out.println("@" + n + "axischoice " + (nArray[0] + 1) + " " + (nArray[1] + 1) + " " + (nArray[2] + 1));
        }
        this.out.print("@" + n + "matrix");
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.out.print(" " + df.format(kView.xform[j][i]));
            }
        }
        this.out.println();
    }

    void writeMaster(MasterGroup masterGroup, Kinemage kinemage) {
        this.out.print("@master {" + masterGroup.getName() + "}");
        if (!masterGroup.hasButton()) {
            this.out.print(" nobutton");
        }
        if (masterGroup.getIndent()) {
            this.out.print(" indent");
        }
        this.out.println();
        if (masterGroup.pm_mask != 0) {
            this.out.println("@pointmaster '" + kinemage.fromPmBitmask(masterGroup.pm_mask) + "' {" + masterGroup.getName() + "}");
        }
    }
}

