/*
 * Decompiled with CFR 0.152.
 */
package king.tool.edmap;

import driftwood.isosurface.EdgePlotter;
import driftwood.isosurface.MarchingCubes;
import driftwood.util.Strings;
import java.text.DecimalFormat;
import king.core.KList;
import king.points.AbstractPoint;
import king.points.TrianglePoint;
import king.points.VectorPoint;

public class EDMapPlotter
implements EdgePlotter {
    DecimalFormat df2 = Strings.usDecimalFormat("0.##");
    KList list = null;
    VectorPoint prevV = null;
    TrianglePoint prevT = null;
    String level = null;
    Object mode;
    boolean unpickable;

    public EDMapPlotter(boolean bl, Object object) {
        boolean bl2 = this.unpickable = !bl;
        if (object != MarchingCubes.MODE_MESH && object != MarchingCubes.MODE_TRIANGLE) {
            throw new IllegalArgumentException("Illegal MarchingCubes MODE constant: " + object);
        }
        this.mode = object;
    }

    public void startIsosurface(double d) {
        this.level = this.df2.format(d);
        this.list = new KList(this.mode == MarchingCubes.MODE_MESH ? "vector" : "triangle");
        this.list.setName("ED map @ " + this.level);
        this.list.setWidth(1);
        if (this.mode == MarchingCubes.MODE_TRIANGLE) {
            this.list.setAlpha(63);
        }
    }

    public void startCell(int n, int n2, int n3) {
        this.prevV = null;
        this.prevT = null;
    }

    public void plotEdge(double d, double d2, double d3, boolean bl) {
        AbstractPoint abstractPoint;
        if (this.mode == MarchingCubes.MODE_MESH) {
            abstractPoint = bl ? new VectorPoint(this.level, this.prevV) : new VectorPoint(this.level, null);
            this.prevV = abstractPoint;
        } else {
            abstractPoint = bl ? new TrianglePoint(this.level, this.prevT) : new TrianglePoint(this.level, null);
            this.prevT = (TrianglePoint)abstractPoint;
        }
        abstractPoint.setX(d);
        abstractPoint.setY(d2);
        abstractPoint.setZ(d3);
        abstractPoint.setUnpickable(this.unpickable);
        this.list.add(abstractPoint);
    }

    public void endCell(int n, int n2, int n3) {
    }

    public void endIsosurface(double d) {
    }

    public void freeList() {
        this.list = null;
    }

    public KList getList() {
        return this.list;
    }
}

