/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept X32 keyctl syscall
 *
 * Notes:
 *  - None
 *
 * Caveats:
 *  - Keyring support
 *
 * Timeline:
 *  - Created: 13.VIII.2018
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#ifdef CONFIG_X86_X32

#ifdef P_SYSCALL_LAYOUT_4_17

#ifndef P_LKRG_EXPLOIT_DETECTION_X32_SYS_KEYCTL_H
#define P_LKRG_EXPLOIT_DETECTION_X32_SYS_KEYCTL_H

/* per-instance private data */
struct p_x32_sys_keyctl_data {
    ktime_t entry_stamp;
};


int p_x32_sys_keyctl_ret(struct kretprobe_instance *ri, struct pt_regs *p_regs);
int p_x32_sys_keyctl_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_install_x32_sys_keyctl_hook(int p_isra);
void p_uninstall_x32_sys_keyctl_hook(void);

#endif

#endif

#endif
