/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept compat_capset syscall
 *
 * Notes:
 *  - COMPAT version of this syscall is only available in the kernels
 *    with a new syscall implementation (4.17+)
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 13.VIII.2018
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#ifdef CONFIG_COMPAT

#ifdef P_SYSCALL_LAYOUT_4_17

#ifndef P_LKRG_EXPLOIT_DETECTION_COMPAT_SYS_CAPSET_H
#define P_LKRG_EXPLOIT_DETECTION_COMPAT_SYS_CAPSET_H

/* per-instance private data */
struct p_compat_sys_capset_data {
    ktime_t entry_stamp;
};


int p_compat_sys_capset_ret(struct kretprobe_instance *ri, struct pt_regs *p_regs);
int p_compat_sys_capset_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_install_compat_sys_capset_hook(int p_isra);
void p_uninstall_compat_sys_capset_hook(void);

#endif

#endif

#endif
