/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept compat_keyctl syscall
 *
 * Notes:
 *  - None
 *
 * Caveats:
 *  - Keyring support
 *
 * Timeline:
 *  - Created: 17.I.2018
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#ifdef CONFIG_COMPAT

#ifndef P_LKRG_EXPLOIT_DETECTION_COMPAT_SYS_KEYCTL_H
#define P_LKRG_EXPLOIT_DETECTION_COMPAT_SYS_KEYCTL_H

/* per-instance private data */
struct p_compat_sys_keyctl_data {
    ktime_t entry_stamp;
};


int p_compat_sys_keyctl_ret(struct kretprobe_instance *ri, struct pt_regs *p_regs);
int p_compat_sys_keyctl_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_install_compat_sys_keyctl_hook(int p_isra);
void p_uninstall_compat_sys_keyctl_hook(void);

#endif

#endif
