/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept 'override_creds' function
 *
 * Notes:
 *  - We are maintianing Red-Black tree of pid's for Exploit Detection feature.
 *    When process calls 'override_creds', we need to correctly 'propagate'
 *    this information.
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 10.X.2018
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#include "../../../../../p_lkrg_main.h"

char p_override_creds_kretprobe_state = 0;

static struct kretprobe p_override_creds_kretprobe = {
    .kp.symbol_name = "override_creds",
    .handler = p_override_creds_ret,
    .entry_handler = p_override_creds_entry,
    .data_size = sizeof(struct p_override_creds_data),
};


notrace int p_override_creds_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs) {

   struct p_ed_process *p_tmp;
   unsigned long p_flags;

   if (p_is_ed_task(current)) {
      p_tasks_write_lock(&p_flags);
      p_ed_validate_current();
      if ( (p_tmp = p_find_ed_by_pid(task_pid_nr(current))) != NULL) {
#ifdef P_LKRG_TASK_OFF_DEBUG
         p_debug_off_flag_override_off(p_tmp, 31, p_regs);
#endif
         /*
          * Set temporary 'disable' flag:
          *  - It is possible that this flag is already set. This is not a problem because in
          *    normal scenario task that ends up being here must call 'revert_creds' before
          *    switching to user-mode. This will 'normalize' this flag to the correct state.
          */
         p_set_ed_process_override_off(p_tmp);
      }
      p_tasks_write_unlock(&p_flags);
   }

   return 0;
}


notrace int p_override_creds_ret(struct kretprobe_instance *ri, struct pt_regs *p_regs) {

   struct p_ed_process *p_tmp;
   unsigned long p_flags;

   if (p_is_ed_task(current)) {
      p_tasks_read_lock(&p_flags);
      if ( (p_tmp = p_find_ed_by_pid(task_pid_nr(current))) != NULL) {
         p_ed_enforce_pcfi(current, p_tmp, p_regs);
      }
      p_tasks_read_unlock(&p_flags);
   }

   return 0;
}


GENERATE_INSTALL_FUNC(override_creds)
