/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept *call_usermodehelper_exec* function
 *
 * Notes:
 *  - We are maintianing Red-Black tree of pid's for Exploit Detection feature.
 *    When kernel calls user-mode helper, we need to verify task's integrity
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 01.IV.2019
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#ifndef P_LKRG_EXPLOIT_DETECTION_CALL_USERMODEHELPER_EXEC_H
#define P_LKRG_EXPLOIT_DETECTION_CALL_USERMODEHELPER_EXEC_H

/* per-instance private data */
struct p_call_usermodehelper_exec_data {
    ktime_t entry_stamp;
};

int p_call_usermodehelper_exec_ret(struct kretprobe_instance *ri, struct pt_regs *p_regs);
int p_call_usermodehelper_exec_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_install_call_usermodehelper_exec_hook(int p_isra);
void p_uninstall_call_usermodehelper_exec_hook(void);

#endif
