/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept SECCOMP policy update
 *
 * Notes:
 *  - Process SECCOMP Exploit Detection validation
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 18.XI.2017
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#if defined(CONFIG_SECCOMP)

#ifndef P_LKRG_EXPLOIT_DETECTION_SECCOMP_H
#define P_LKRG_EXPLOIT_DETECTION_SECCOMP_H

/* per-instance private data */
struct p_seccomp_data {
    ktime_t entry_stamp;
};


int p_seccomp_ret(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_seccomp_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_install_seccomp_hook(int p_isra);
void p_uninstall_seccomp_hook(void);

#endif

#endif
