/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept setns syscall
 *
 * Notes:
 *  - Dump namespace metadata
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 29.I.2020
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#ifndef P_LKRG_EXPLOIT_DETECTION_SYS_SETNS_H
#define P_LKRG_EXPLOIT_DETECTION_SYS_SETNS_H

/* per-instance private data */
struct p_sys_setns_data {
    ktime_t entry_stamp;
};


int p_sys_setns_ret(struct kretprobe_instance *ri, struct pt_regs *p_regs);
int p_sys_setns_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_install_sys_setns_hook(int p_isra);
void p_uninstall_sys_setns_hook(void);

#endif
