/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.UnexpectedErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.AttachmentInvalidException;
import org.asamk.signal.manager.api.GroupNotFoundException;
import org.asamk.signal.manager.api.GroupSendingNotAllowedException;
import org.asamk.signal.manager.api.InvalidStickerException;
import org.asamk.signal.manager.api.Message;
import org.asamk.signal.manager.api.NotAGroupMemberException;
import org.asamk.signal.manager.api.RecipientIdentifier;
import org.asamk.signal.manager.api.SendMessageResults;
import org.asamk.signal.manager.api.TextStyle;
import org.asamk.signal.manager.api.UnregisteredRecipientException;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.util.CommandUtil;
import org.asamk.signal.util.Hex;
import org.asamk.signal.util.IOUtils;
import org.asamk.signal.util.SendMessageResultUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendCommand
implements JsonRpcLocalCommand {
    private static final Logger logger = LoggerFactory.getLogger(SendCommand.class);

    @Override
    public String getName() {
        return "send";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Send a message to another user or group.");
        subparser.addArgument(new String[]{"recipient"}).help("Specify the recipients' phone number.").nargs("*");
        subparser.addArgument(new String[]{"-g", "--group-id", "--group"}).help("Specify the recipient group ID.").nargs("*");
        subparser.addArgument(new String[]{"-u", "--username"}).help("Specify the recipient username or username link.").nargs("*");
        subparser.addArgument(new String[]{"--note-to-self"}).help("Send the message to self without notification.").action((ArgumentAction)Arguments.storeTrue());
        subparser.addArgument(new String[]{"--notify-self"}).help("If self is part of recipients/groups send a normal message, not a sync message.").action((ArgumentAction)Arguments.storeTrue());
        MutuallyExclusiveGroup mut = subparser.addMutuallyExclusiveGroup();
        mut.addArgument(new String[]{"-m", "--message"}).help("Specify the message to be sent.");
        mut.addArgument(new String[]{"--message-from-stdin"}).action((ArgumentAction)Arguments.storeTrue()).help("Read the message from standard input.");
        subparser.addArgument(new String[]{"-a", "--attachment"}).nargs("*").help("Add an attachment. Can be either a file path or a data URI. Data URI encoded attachments must follow the RFC 2397. Additionally a file name can be added, e.g. data:<MIME-TYPE>;filename=<FILENAME>;base64,<BASE64 ENCODED DATA>.");
        subparser.addArgument(new String[]{"-e", "--end-session", "--endsession"}).help("Clear session state and send end session message.").action((ArgumentAction)Arguments.storeTrue());
        subparser.addArgument(new String[]{"--mention"}).nargs("*").help("Mention another group member (syntax: start:length:recipientNumber). Unit of start and length is UTF-16 code units, NOT Unicode code points.");
        subparser.addArgument(new String[]{"--text-style"}).nargs("*").help("Style parts of the message text (syntax: start:length:STYLE). Unit of start and length is UTF-16 code units, NOT Unicode code points.");
        subparser.addArgument(new String[]{"--quote-timestamp"}).type(Long.TYPE).help("Specify the timestamp of a previous message with the recipient or group to add a quote to the new message.");
        subparser.addArgument(new String[]{"--quote-author"}).help("Specify the number of the author of the original message.");
        subparser.addArgument(new String[]{"--quote-message"}).help("Specify the message of the original message.");
        subparser.addArgument(new String[]{"--quote-mention"}).nargs("*").help("Quote with mention of another group member (syntax: start:length:recipientNumber)");
        subparser.addArgument(new String[]{"--quote-attachment"}).nargs("*").help("Specify the attachments of the original message (syntax: contentType[:filename[:previewFile]]), e.g. 'audio/aac' or 'image/png:test.png:/tmp/preview.jpg'.");
        subparser.addArgument(new String[]{"--quote-text-style"}).nargs("*").help("Quote with style parts of the message text (syntax: start:length:STYLE)");
        subparser.addArgument(new String[]{"--sticker"}).help("Send a sticker (syntax: stickerPackId:stickerId)");
        subparser.addArgument(new String[]{"--preview-url"}).help("Specify the url for the link preview (the same url must also appear in the message body).");
        subparser.addArgument(new String[]{"--preview-title"}).help("Specify the title for the link preview (mandatory).");
        subparser.addArgument(new String[]{"--preview-description"}).help("Specify the description for the link preview (optional).");
        subparser.addArgument(new String[]{"--preview-image"}).help("Specify the image file for the link preview (optional).");
        subparser.addArgument(new String[]{"--story-timestamp"}).type(Long.TYPE).help("Specify the timestamp of a story to reply to.");
        subparser.addArgument(new String[]{"--story-author"}).help("Specify the number of the author of the story.");
        subparser.addArgument(new String[]{"--edit-timestamp"}).type(Long.TYPE).help("Specify the timestamp of a previous message with the recipient or group to send an edited message.");
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        Message.StoryReply storyReply;
        List<Object> previews;
        Message.Quote quote;
        boolean readMessageFromStdin;
        boolean notifySelf = Boolean.TRUE.equals(ns.getBoolean("notify-self"));
        boolean isNoteToSelf = Boolean.TRUE.equals(ns.getBoolean("note-to-self"));
        List recipientStrings = ns.getList("recipient");
        List groupIdStrings = ns.getList("group-id");
        List usernameStrings = ns.getList("username");
        Set<RecipientIdentifier> recipientIdentifiers = CommandUtil.getRecipientIdentifiers(m, isNoteToSelf, recipientStrings, groupIdStrings, usernameStrings);
        boolean isEndSession = Boolean.TRUE.equals(ns.getBoolean("end-session"));
        if (isEndSession) {
            Set singleRecipients = recipientIdentifiers.stream().filter(r -> r instanceof RecipientIdentifier.Single).map(RecipientIdentifier.Single.class::cast).collect(Collectors.toSet());
            if (singleRecipients.isEmpty()) {
                throw new UserErrorException("No recipients given");
            }
            try {
                SendMessageResults results = m.sendEndSessionMessage(singleRecipients);
                SendMessageResultUtils.outputResult(outputWriter, results);
                return;
            }
            catch (IOException e) {
                throw new UnexpectedErrorException("Failed to send message: " + e.getMessage() + " (" + e.getClass().getSimpleName() + ")", e);
            }
        }
        String stickerString = ns.getString("sticker");
        Message.Sticker sticker = stickerString == null ? null : this.parseSticker(stickerString);
        String messageText = ns.getString("message");
        boolean bl = readMessageFromStdin = ns.getBoolean("message-from-stdin") == Boolean.TRUE;
        if (readMessageFromStdin) {
            logger.debug("Reading message from stdin...");
            try {
                messageText = IOUtils.readAll(System.in, IOUtils.getConsoleCharset());
            }
            catch (IOException e) {
                throw new UserErrorException("Failed to read message from stdin: " + e.getMessage());
            }
        } else if (messageText == null) {
            messageText = "";
        }
        List attachments = ns.getList("attachment");
        if (attachments == null) {
            attachments = List.of();
        }
        String selfNumber = m.getSelfNumber();
        List mentionStrings = ns.getList("mention");
        List mentions = mentionStrings == null ? List.of() : this.parseMentions(selfNumber, mentionStrings);
        List textStyleStrings = ns.getList("text-style");
        List textStyles = textStyleStrings == null ? List.of() : this.parseTextStyles(textStyleStrings);
        Long quoteTimestamp = ns.getLong("quote-timestamp");
        if (quoteTimestamp != null) {
            String quoteAuthor = ns.getString("quote-author");
            String quoteMessage = ns.getString("quote-message");
            List quoteMentionStrings = ns.getList("quote-mention");
            List quoteMentions = quoteMentionStrings == null ? List.of() : this.parseMentions(selfNumber, quoteMentionStrings);
            List quoteTextStyleStrings = ns.getList("quote-text-style");
            List quoteAttachmentStrings = ns.getList("quote-attachment");
            List quoteTextStyles = quoteTextStyleStrings == null ? List.of() : this.parseTextStyles(quoteTextStyleStrings);
            List quoteAttachments = quoteAttachmentStrings == null ? List.of() : this.parseQuoteAttachments(quoteAttachmentStrings);
            quote = new Message.Quote(quoteTimestamp.longValue(), CommandUtil.getSingleRecipientIdentifier(quoteAuthor, selfNumber), quoteMessage == null ? "" : quoteMessage, quoteMentions, quoteTextStyles, quoteAttachments);
        } else {
            quote = null;
        }
        String previewUrl = ns.getString("preview-url");
        if (previewUrl != null) {
            String previewTitle = ns.getString("preview-title");
            String previewDescription = ns.getString("preview-description");
            String previewImage = ns.getString("preview-image");
            previews = List.of(new Message.Preview(previewUrl, Optional.ofNullable(previewTitle).orElse(""), Optional.ofNullable(previewDescription).orElse(""), Optional.ofNullable(previewImage)));
        } else {
            previews = List.of();
        }
        Long storyReplyTimestamp = ns.getLong("story-timestamp");
        if (storyReplyTimestamp != null) {
            String storyAuthor = ns.getString("story-author");
            storyReply = new Message.StoryReply(storyReplyTimestamp.longValue(), CommandUtil.getSingleRecipientIdentifier(storyAuthor, selfNumber));
        } else {
            storyReply = null;
        }
        if (messageText.isEmpty() && attachments.isEmpty() && sticker == null && quote == null) {
            throw new UserErrorException("Sending empty message is not allowed, either a message, attachment or sticker must be given.");
        }
        Long editTimestamp = ns.getLong("edit-timestamp");
        try {
            Message message = new Message(messageText, attachments, mentions, Optional.ofNullable(quote), Optional.ofNullable(sticker), previews, Optional.ofNullable(storyReply), textStyles);
            SendMessageResults results = editTimestamp != null ? m.sendEditMessage(message, recipientIdentifiers, editTimestamp.longValue()) : m.sendMessage(message, recipientIdentifiers, notifySelf);
            SendMessageResultUtils.outputResult(outputWriter, results);
        }
        catch (IOException | AttachmentInvalidException e) {
            throw new UnexpectedErrorException("Failed to send message: " + e.getMessage() + " (" + e.getClass().getSimpleName() + ")", e);
        }
        catch (GroupNotFoundException | GroupSendingNotAllowedException | NotAGroupMemberException e) {
            throw new UserErrorException(e.getMessage());
        }
        catch (UnregisteredRecipientException e) {
            throw new UserErrorException("The user " + e.getSender().getIdentifier() + " is not registered.");
        }
        catch (InvalidStickerException e) {
            throw new UserErrorException("Failed to send sticker: " + e.getMessage(), e);
        }
    }

    private List<Message.Mention> parseMentions(String selfNumber, List<String> mentionStrings) throws UserErrorException {
        Pattern mentionPattern = Pattern.compile("(\\d+):(\\d+):(.+)");
        ArrayList<Message.Mention> mentions = new ArrayList<Message.Mention>();
        for (String mention : mentionStrings) {
            Matcher matcher = mentionPattern.matcher(mention);
            if (!matcher.matches()) {
                throw new UserErrorException("Invalid mention syntax (" + mention + ") expected 'start:length:recipientNumber'");
            }
            mentions.add(new Message.Mention(CommandUtil.getSingleRecipientIdentifier(matcher.group(3), selfNumber), Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2))));
        }
        return mentions;
    }

    private List<TextStyle> parseTextStyles(List<String> textStylesStrings) throws UserErrorException {
        Pattern textStylePattern = Pattern.compile("(\\d+):(\\d+):(.+)");
        ArrayList<TextStyle> textStyles = new ArrayList<TextStyle>();
        for (String textStyle : textStylesStrings) {
            Matcher matcher = textStylePattern.matcher(textStyle);
            if (!matcher.matches()) {
                throw new UserErrorException("Invalid textStyle syntax (" + textStyle + ") expected 'start:length:STYLE'");
            }
            TextStyle.Style style = TextStyle.Style.from((String)matcher.group(3));
            if (style == null) {
                throw new UserErrorException("Invalid style: " + matcher.group(3));
            }
            textStyles.add(new TextStyle(style, Integer.valueOf(Integer.parseInt(matcher.group(1))), Integer.valueOf(Integer.parseInt(matcher.group(2)))));
        }
        return textStyles;
    }

    private Message.Sticker parseSticker(String stickerString) throws UserErrorException {
        Pattern stickerPattern = Pattern.compile("([\\da-f]+):(\\d+)");
        Matcher matcher = stickerPattern.matcher(stickerString);
        if (!matcher.matches() || matcher.group(1).length() % 2 != 0) {
            throw new UserErrorException("Invalid sticker syntax (" + stickerString + ") expected 'stickerPackId:stickerId'");
        }
        return new Message.Sticker(Hex.toByteArray(matcher.group(1)), Integer.parseInt(matcher.group(2)));
    }

    private List<Message.Quote.Attachment> parseQuoteAttachments(List<String> attachmentStrings) throws UserErrorException {
        Pattern attachmentPattern = Pattern.compile("([^:]+)(:([^:]+)(:(.+))?)?");
        ArrayList<Message.Quote.Attachment> attachments = new ArrayList<Message.Quote.Attachment>();
        for (String attachment : attachmentStrings) {
            Matcher matcher = attachmentPattern.matcher(attachment);
            if (!matcher.matches()) {
                throw new UserErrorException("Invalid attachment syntax (" + attachment + ") expected 'contentType[:filename[:previewFile]]'");
            }
            attachments.add(new Message.Quote.Attachment(matcher.group(1), matcher.group(3), matcher.group(5)));
        }
        return attachments;
    }
}

