/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.jul.LevelChangePropagator;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.FilterReply;
import java.io.File;
import org.asamk.signal.logging.ScrubberPatternLayout;

public class LogConfigurator
extends ContextAwareBase
implements Configurator {
    private static int verboseLevel = 0;
    private static File logFile = null;
    private static boolean scrubSensitiveInformation = false;

    public static void setVerboseLevel(int verboseLevel) {
        LogConfigurator.verboseLevel = verboseLevel;
    }

    public static void setLogFile(File logFile) {
        LogConfigurator.logFile = logFile;
    }

    public static void setScrubSensitiveInformation(boolean scrubSensitiveInformation) {
        LogConfigurator.scrubSensitiveInformation = scrubSensitiveInformation;
    }

    public Configurator.ExecutionStatus configure(final LoggerContext lc) {
        lc.addListener((LoggerContextListener)new LevelChangePropagator(this){
            {
                this.setContext((Context)lc);
            }
        });
        Logger rootLogger = lc.getLogger("ROOT");
        Level defaultLevel = verboseLevel > 2 ? Level.ALL : (verboseLevel > 0 ? Level.INFO : Level.WARN);
        rootLogger.setLevel(defaultLevel);
        PatternLayout consoleLayout = verboseLevel == 0 || logFile != null ? this.createSimpleLoggingLayout(lc) : this.createDetailedLoggingLayout(lc);
        ConsoleAppender<ILoggingEvent> consoleAppender = this.createLoggingConsoleAppender(lc, this.createLayoutWrappingEncoder((Layout<ILoggingEvent>)consoleLayout));
        rootLogger.addAppender(consoleAppender);
        lc.getLogger("org.asamk").setLevel(verboseLevel > 1 ? Level.ALL : (verboseLevel > 0 ? Level.DEBUG : Level.INFO));
        lc.getLogger("org.asamk.Signal").setLevel(verboseLevel > 2 ? Level.ALL : (verboseLevel > 1 ? Level.INFO : Level.WARN));
        lc.getLogger("com.zaxxer.hikari.pool.PoolBase").setLevel(verboseLevel > 2 ? Level.ALL : (verboseLevel > 1 ? Level.INFO : Level.WARN));
        lc.getLogger("org.sqlite.core.NativeDB").setLevel(verboseLevel > 3 ? Level.ALL : (verboseLevel > 1 ? Level.INFO : Level.WARN));
        if (logFile != null) {
            consoleAppender.addFilter((Filter)new Filter<ILoggingEvent>(this){

                public FilterReply decide(ILoggingEvent event) {
                    return !"LibSignal".equals(event.getLoggerName()) && (event.getLevel().isGreaterOrEqual(Level.WARN) || event.getLevel().isGreaterOrEqual(Level.INFO) && event.getLoggerName().startsWith("org.asamk")) ? FilterReply.NEUTRAL : FilterReply.DENY;
                }
            });
            PatternLayout fileLayout = this.createDetailedLoggingLayout(lc);
            FileAppender<ILoggingEvent> fileAppender = this.createLoggingFileAppender(lc, this.createLayoutWrappingEncoder((Layout<ILoggingEvent>)fileLayout));
            rootLogger.addAppender(fileAppender);
        }
        return Configurator.ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY;
    }

    private ConsoleAppender<ILoggingEvent> createLoggingConsoleAppender(final LoggerContext lc, final LayoutWrappingEncoder<ILoggingEvent> layoutEncoder) {
        return new ConsoleAppender<ILoggingEvent>(this){
            {
                this.setContext((Context)lc);
                this.setName("console");
                this.setTarget("System.err");
                this.setEncoder((Encoder)layoutEncoder);
                this.start();
            }
        };
    }

    private FileAppender<ILoggingEvent> createLoggingFileAppender(final LoggerContext lc, final LayoutWrappingEncoder<ILoggingEvent> layoutEncoder) {
        return new FileAppender<ILoggingEvent>(this){
            {
                this.setContext((Context)lc);
                this.setName("file");
                this.setFile(logFile.getAbsolutePath());
                this.setEncoder((Encoder)layoutEncoder);
                this.start();
            }
        };
    }

    private LayoutWrappingEncoder<ILoggingEvent> createLayoutWrappingEncoder(final Layout<ILoggingEvent> l) {
        return new LayoutWrappingEncoder<ILoggingEvent>(this){
            {
                this.setContext(l.getContext());
                this.setLayout(l);
            }
        };
    }

    private PatternLayout createSimpleLoggingLayout(LoggerContext lc) {
        PatternLayout patternLayout = this.getPatternLayout();
        patternLayout.setPattern("%-5level %logger{0} - %msg%n");
        patternLayout.setContext((Context)lc);
        patternLayout.start();
        return patternLayout;
    }

    private PatternLayout createDetailedLoggingLayout(LoggerContext lc) {
        PatternLayout patternLayout = this.getPatternLayout();
        patternLayout.setPattern("%d{yyyy-MM-dd'T'HH:mm:ss.SSSXX} [%thread] %-5level %logger{36} - %msg%n");
        patternLayout.setContext((Context)lc);
        patternLayout.start();
        return patternLayout;
    }

    private PatternLayout getPatternLayout() {
        if (scrubSensitiveInformation) {
            return new ScrubberPatternLayout();
        }
        return new PatternLayout();
    }
}

