/*
 * Decompiled with CFR 0.152.
 */
package org.signal.core.util.stream;

import java.io.FilterOutputStream;
import java.io.OutputStream;
import javax.crypto.Mac;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0010H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/signal/core/util/stream/MacOutputStream;", "Ljava/io/FilterOutputStream;", "wrapped", "Ljava/io/OutputStream;", "mac", "Ljavax/crypto/Mac;", "(Ljava/io/OutputStream;Ljavax/crypto/Mac;)V", "getMac", "()Ljavax/crypto/Mac;", "getWrapped", "()Ljava/io/OutputStream;", "write", "", "data", "", "offset", "", "length", "byte", "core-util-jvm"})
public final class MacOutputStream
extends FilterOutputStream {
    @NotNull
    private final OutputStream wrapped;
    @NotNull
    private final Mac mac;

    public MacOutputStream(@NotNull OutputStream wrapped, @NotNull Mac mac) {
        Intrinsics.checkNotNullParameter((Object)wrapped, (String)"wrapped");
        Intrinsics.checkNotNullParameter((Object)mac, (String)"mac");
        super(wrapped);
        this.wrapped = wrapped;
        this.mac = mac;
    }

    @NotNull
    public final OutputStream getWrapped() {
        return this.wrapped;
    }

    @NotNull
    public final Mac getMac() {
        return this.mac;
    }

    @Override
    public void write(int n) {
        this.wrapped.write(n);
        this.mac.update((byte)n);
    }

    @Override
    public void write(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.write(data, 0, data.length);
    }

    @Override
    public void write(@NotNull byte[] data, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.wrapped.write(data, offset, length);
        this.mac.update(data, offset, length);
    }
}

