/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.storage;

import com.squareup.wire.Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import okio.ByteString;
import org.signal.core.util.ProtoUtil;
import org.signal.libsignal.protocol.logging.Log;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.api.storage.SignalRecord;
import org.whispersystems.signalservice.api.storage.SignalStorageRecord;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.api.storage.StorageRecordProtoUtil;
import org.whispersystems.signalservice.api.util.OptionalUtil;
import org.whispersystems.signalservice.internal.storage.protos.AccountRecord;
import org.whispersystems.signalservice.internal.storage.protos.OptionalBool;
import org.whispersystems.signalservice.internal.storage.protos.Payments;

public final class SignalAccountRecord
implements SignalRecord {
    private static final String TAG = SignalAccountRecord.class.getSimpleName();
    private final StorageId id;
    private final AccountRecord proto;
    private final boolean hasUnknownFields;
    private final Optional<String> givenName;
    private final Optional<String> familyName;
    private final Optional<String> avatarUrlPath;
    private final Optional<byte[]> profileKey;
    private final List<PinnedConversation> pinnedConversations;
    private final Payments payments;
    private final List<String> defaultReactions;
    private final Subscriber subscriber;
    private final Subscriber backupsSubscriber;

    public SignalAccountRecord(StorageId id, AccountRecord proto) {
        this.id = id;
        this.proto = proto;
        this.hasUnknownFields = ProtoUtil.hasUnknownFields((Message)proto);
        this.givenName = OptionalUtil.absentIfEmpty(proto.givenName);
        this.familyName = OptionalUtil.absentIfEmpty(proto.familyName);
        this.profileKey = OptionalUtil.absentIfEmpty(proto.profileKey);
        this.avatarUrlPath = OptionalUtil.absentIfEmpty(proto.avatarUrlPath);
        this.pinnedConversations = new ArrayList<PinnedConversation>(proto.pinnedConversations.size());
        this.defaultReactions = new ArrayList<String>(proto.preferredReactionEmoji);
        this.subscriber = new Subscriber(proto.subscriberCurrencyCode, proto.subscriberId.toByteArray());
        this.backupsSubscriber = new Subscriber(proto.backupsSubscriberCurrencyCode, proto.backupsSubscriberId.toByteArray());
        this.payments = proto.payments != null ? new Payments(proto.payments.enabled, OptionalUtil.absentIfEmpty(proto.payments.entropy)) : new Payments(false, Optional.empty());
        for (AccountRecord.PinnedConversation conversation : proto.pinnedConversations) {
            this.pinnedConversations.add(PinnedConversation.fromRemote(conversation));
        }
    }

    @Override
    public StorageId getId() {
        return this.id;
    }

    @Override
    public SignalStorageRecord asStorageRecord() {
        return SignalStorageRecord.forAccount(this);
    }

    @Override
    public String describeDiff(SignalRecord other) {
        if (other instanceof SignalAccountRecord) {
            SignalAccountRecord that = (SignalAccountRecord)other;
            LinkedList<String> diff = new LinkedList<String>();
            if (!Arrays.equals(this.id.getRaw(), that.id.getRaw())) {
                diff.add("ID");
            }
            if (!Objects.equals(this.givenName, that.givenName)) {
                diff.add("GivenName");
            }
            if (!Objects.equals(this.familyName, that.familyName)) {
                diff.add("FamilyName");
            }
            if (!OptionalUtil.byteArrayEquals(this.profileKey, that.profileKey)) {
                diff.add("ProfileKey");
            }
            if (!Objects.equals(this.avatarUrlPath, that.avatarUrlPath)) {
                diff.add("AvatarUrlPath");
            }
            if (!Objects.equals(this.isNoteToSelfArchived(), that.isNoteToSelfArchived())) {
                diff.add("NoteToSelfArchived");
            }
            if (!Objects.equals(this.isNoteToSelfForcedUnread(), that.isNoteToSelfForcedUnread())) {
                diff.add("NoteToSelfForcedUnread");
            }
            if (!Objects.equals(this.isReadReceiptsEnabled(), that.isReadReceiptsEnabled())) {
                diff.add("ReadReceipts");
            }
            if (!Objects.equals(this.isTypingIndicatorsEnabled(), that.isTypingIndicatorsEnabled())) {
                diff.add("TypingIndicators");
            }
            if (!Objects.equals(this.isSealedSenderIndicatorsEnabled(), that.isSealedSenderIndicatorsEnabled())) {
                diff.add("SealedSenderIndicators");
            }
            if (!Objects.equals(this.isLinkPreviewsEnabled(), that.isLinkPreviewsEnabled())) {
                diff.add("LinkPreviews");
            }
            if (!Objects.equals((Object)this.getPhoneNumberSharingMode(), (Object)that.getPhoneNumberSharingMode())) {
                diff.add("PhoneNumberSharingMode");
            }
            if (!Objects.equals(this.isPhoneNumberUnlisted(), that.isPhoneNumberUnlisted())) {
                diff.add("PhoneNumberUnlisted");
            }
            if (!Objects.equals(this.pinnedConversations, that.pinnedConversations)) {
                diff.add("PinnedConversations");
            }
            if (!Objects.equals(this.isPreferContactAvatars(), that.isPreferContactAvatars())) {
                diff.add("PreferContactAvatars");
            }
            if (!Objects.equals(this.payments, that.payments)) {
                diff.add("Payments");
            }
            if (this.getUniversalExpireTimer() != that.getUniversalExpireTimer()) {
                diff.add("UniversalExpireTimer");
            }
            if (!Objects.equals(this.isPrimarySendsSms(), that.isPrimarySendsSms())) {
                diff.add("PrimarySendsSms");
            }
            if (!Objects.equals(this.getE164(), that.getE164())) {
                diff.add("E164");
            }
            if (!Objects.equals(this.getDefaultReactions(), that.getDefaultReactions())) {
                diff.add("DefaultReactions");
            }
            if (!Objects.equals(this.hasUnknownFields(), that.hasUnknownFields())) {
                diff.add("UnknownFields");
            }
            if (!Objects.equals(this.getSubscriber(), that.getSubscriber())) {
                diff.add("Subscriber");
            }
            if (!Objects.equals(this.isDisplayBadgesOnProfile(), that.isDisplayBadgesOnProfile())) {
                diff.add("DisplayBadgesOnProfile");
            }
            if (!Objects.equals(this.isSubscriptionManuallyCancelled(), that.isSubscriptionManuallyCancelled())) {
                diff.add("SubscriptionManuallyCancelled");
            }
            if (this.isKeepMutedChatsArchived() != that.isKeepMutedChatsArchived()) {
                diff.add("KeepMutedChatsArchived");
            }
            if (this.hasSetMyStoriesPrivacy() != that.hasSetMyStoriesPrivacy()) {
                diff.add("HasSetMyStoryPrivacy");
            }
            if (this.hasViewedOnboardingStory() != that.hasViewedOnboardingStory()) {
                diff.add("HasViewedOnboardingStory");
            }
            if (this.isStoriesDisabled() != that.isStoriesDisabled()) {
                diff.add("StoriesDisabled");
            }
            if (this.getStoryViewReceiptsState() != that.getStoryViewReceiptsState()) {
                diff.add("StoryViewedReceipts");
            }
            if (this.hasSeenGroupStoryEducationSheet() != that.hasSeenGroupStoryEducationSheet()) {
                diff.add("HasSeenGroupStoryEducationSheet");
            }
            if (!Objects.equals(this.getUsername(), that.getUsername())) {
                diff.add("Username");
            }
            if (this.hasCompletedUsernameOnboarding() != that.hasCompletedUsernameOnboarding()) {
                diff.add("HasCompletedUsernameOnboarding");
            }
            if (!Objects.equals(this.getBackupsSubscriber(), that.getBackupsSubscriber())) {
                diff.add("BackupsSubscriber");
            }
            return ((Object)diff).toString();
        }
        return "Different class. " + this.getClass().getSimpleName() + " | " + other.getClass().getSimpleName();
    }

    public boolean hasUnknownFields() {
        return this.hasUnknownFields;
    }

    public byte[] serializeUnknownFields() {
        return this.hasUnknownFields ? this.proto.encode() : null;
    }

    public Optional<String> getGivenName() {
        return this.givenName;
    }

    public Optional<String> getFamilyName() {
        return this.familyName;
    }

    public Optional<byte[]> getProfileKey() {
        return this.profileKey;
    }

    public Optional<String> getAvatarUrlPath() {
        return this.avatarUrlPath;
    }

    public boolean isNoteToSelfArchived() {
        return this.proto.noteToSelfArchived;
    }

    public boolean isNoteToSelfForcedUnread() {
        return this.proto.noteToSelfMarkedUnread;
    }

    public boolean isReadReceiptsEnabled() {
        return this.proto.readReceipts;
    }

    public boolean isTypingIndicatorsEnabled() {
        return this.proto.typingIndicators;
    }

    public boolean isSealedSenderIndicatorsEnabled() {
        return this.proto.sealedSenderIndicators;
    }

    public boolean isLinkPreviewsEnabled() {
        return this.proto.linkPreviews;
    }

    public AccountRecord.PhoneNumberSharingMode getPhoneNumberSharingMode() {
        return this.proto.phoneNumberSharingMode;
    }

    public boolean isPhoneNumberUnlisted() {
        return this.proto.unlistedPhoneNumber;
    }

    public List<PinnedConversation> getPinnedConversations() {
        return this.pinnedConversations;
    }

    public boolean isPreferContactAvatars() {
        return this.proto.preferContactAvatars;
    }

    public Payments getPayments() {
        return this.payments;
    }

    public int getUniversalExpireTimer() {
        return this.proto.universalExpireTimer;
    }

    public boolean isPrimarySendsSms() {
        return this.proto.primarySendsSms;
    }

    public String getE164() {
        return this.proto.e164;
    }

    public List<String> getDefaultReactions() {
        return this.defaultReactions;
    }

    public Subscriber getSubscriber() {
        return this.subscriber;
    }

    public Subscriber getBackupsSubscriber() {
        return this.backupsSubscriber;
    }

    public boolean isDisplayBadgesOnProfile() {
        return this.proto.displayBadgesOnProfile;
    }

    public boolean isSubscriptionManuallyCancelled() {
        return this.proto.subscriptionManuallyCancelled;
    }

    public boolean isKeepMutedChatsArchived() {
        return this.proto.keepMutedChatsArchived;
    }

    public boolean hasSetMyStoriesPrivacy() {
        return this.proto.hasSetMyStoriesPrivacy;
    }

    public boolean hasViewedOnboardingStory() {
        return this.proto.hasViewedOnboardingStory;
    }

    public boolean isStoriesDisabled() {
        return this.proto.storiesDisabled;
    }

    public OptionalBool getStoryViewReceiptsState() {
        return this.proto.storyViewReceiptsEnabled;
    }

    public boolean hasSeenGroupStoryEducationSheet() {
        return this.proto.hasSeenGroupStoryEducationSheet;
    }

    public boolean hasCompletedUsernameOnboarding() {
        return this.proto.hasCompletedUsernameOnboarding;
    }

    @Nullable
    public String getUsername() {
        return this.proto.username;
    }

    @Nullable
    public AccountRecord.UsernameLink getUsernameLink() {
        return this.proto.usernameLink;
    }

    public AccountRecord toProto() {
        return this.proto;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignalAccountRecord that = (SignalAccountRecord)o;
        return this.id.equals(that.id) && this.proto.equals((Object)that.proto);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.proto});
    }

    public static class Subscriber {
        private final Optional<String> currencyCode;
        private final Optional<byte[]> id;

        public Subscriber(String currencyCode, byte[] id) {
            if (currencyCode != null && id != null && id.length == 32) {
                this.currencyCode = Optional.of(currencyCode);
                this.id = Optional.of(id);
            } else {
                this.currencyCode = Optional.empty();
                this.id = Optional.empty();
            }
        }

        public Optional<String> getCurrencyCode() {
            return this.currencyCode;
        }

        public Optional<byte[]> getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Subscriber that = (Subscriber)o;
            return Objects.equals(this.currencyCode, that.currencyCode) && OptionalUtil.byteArrayEquals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.currencyCode, this.id);
        }
    }

    public static class Payments {
        private static final String TAG = Payments.class.getSimpleName();
        private final boolean enabled;
        private final Optional<byte[]> entropy;

        public Payments(boolean enabled, Optional<byte[]> entropy) {
            byte[] entropyBytes = entropy.orElse(null);
            if (entropyBytes != null && entropyBytes.length != 32) {
                Log.w((String)TAG, (String)("Blocked entropy of length " + entropyBytes.length));
                entropyBytes = null;
            }
            this.entropy = Optional.ofNullable(entropyBytes);
            this.enabled = enabled && this.entropy.isPresent();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Optional<byte[]> getEntropy() {
            return this.entropy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Payments payments = (Payments)o;
            return this.enabled == payments.enabled && OptionalUtil.byteArrayEquals(this.entropy, payments.entropy);
        }

        public int hashCode() {
            return Objects.hash(this.enabled, this.entropy);
        }
    }

    public static class PinnedConversation {
        private final Optional<SignalServiceAddress> contact;
        private final Optional<byte[]> groupV1Id;
        private final Optional<byte[]> groupV2MasterKey;

        private PinnedConversation(Optional<SignalServiceAddress> contact, Optional<byte[]> groupV1Id, Optional<byte[]> groupV2MasterKey) {
            this.contact = contact;
            this.groupV1Id = groupV1Id;
            this.groupV2MasterKey = groupV2MasterKey;
        }

        public static PinnedConversation forContact(SignalServiceAddress address) {
            return new PinnedConversation(Optional.of(address), Optional.empty(), Optional.empty());
        }

        public static PinnedConversation forGroupV1(byte[] groupId2) {
            return new PinnedConversation(Optional.empty(), Optional.of(groupId2), Optional.empty());
        }

        public static PinnedConversation forGroupV2(byte[] masterKey) {
            return new PinnedConversation(Optional.empty(), Optional.empty(), Optional.of(masterKey));
        }

        private static PinnedConversation forEmpty() {
            return new PinnedConversation(Optional.empty(), Optional.empty(), Optional.empty());
        }

        static PinnedConversation fromRemote(AccountRecord.PinnedConversation remote) {
            if (remote.contact != null) {
                ServiceId serviceId = ServiceId.parseOrNull(remote.contact.serviceId);
                if (serviceId != null) {
                    return PinnedConversation.forContact(new SignalServiceAddress(serviceId, remote.contact.e164));
                }
                Log.w((String)TAG, (String)("Bad serviceId on pinned contact! Length: " + remote.contact.serviceId));
                return PinnedConversation.forEmpty();
            }
            if (remote.legacyGroupId != null && remote.legacyGroupId.size() > 0) {
                return PinnedConversation.forGroupV1(remote.legacyGroupId.toByteArray());
            }
            if (remote.groupMasterKey != null && remote.groupMasterKey.size() > 0) {
                return PinnedConversation.forGroupV2(remote.groupMasterKey.toByteArray());
            }
            return PinnedConversation.forEmpty();
        }

        public Optional<SignalServiceAddress> getContact() {
            return this.contact;
        }

        public Optional<byte[]> getGroupV1Id() {
            return this.groupV1Id;
        }

        public Optional<byte[]> getGroupV2MasterKey() {
            return this.groupV2MasterKey;
        }

        public boolean isValid() {
            return this.contact.isPresent() || this.groupV1Id.isPresent() || this.groupV2MasterKey.isPresent();
        }

        private AccountRecord.PinnedConversation toRemote() {
            if (this.contact.isPresent()) {
                AccountRecord.PinnedConversation.Contact.Builder contactBuilder = new AccountRecord.PinnedConversation.Contact.Builder();
                contactBuilder.serviceId(this.contact.get().getServiceId().toString());
                if (this.contact.get().getNumber().isPresent()) {
                    contactBuilder.e164(this.contact.get().getNumber().get());
                }
                return new AccountRecord.PinnedConversation.Builder().contact(contactBuilder.build()).build();
            }
            if (this.groupV1Id.isPresent()) {
                return new AccountRecord.PinnedConversation.Builder().legacyGroupId(ByteString.of((byte[])this.groupV1Id.get())).build();
            }
            if (this.groupV2MasterKey.isPresent()) {
                return new AccountRecord.PinnedConversation.Builder().groupMasterKey(ByteString.of((byte[])this.groupV2MasterKey.get())).build();
            }
            return new AccountRecord.PinnedConversation.Builder().build();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PinnedConversation that = (PinnedConversation)o;
            return this.contact.equals(that.contact) && this.groupV1Id.equals(that.groupV1Id) && this.groupV2MasterKey.equals(that.groupV2MasterKey);
        }

        public int hashCode() {
            return Objects.hash(this.contact, this.groupV1Id, this.groupV2MasterKey);
        }
    }

    public static final class Builder {
        private StorageId id;
        private final AccountRecord.Builder builder;

        public Builder(byte[] rawId, byte[] serializedUnknowns) {
            this.id = StorageId.forAccount(rawId);
            this.builder = serializedUnknowns != null ? Builder.parseUnknowns(serializedUnknowns) : new AccountRecord.Builder();
        }

        public Builder setId(byte[] rawId) {
            this.id = StorageId.forAccount(rawId);
            return this;
        }

        public Builder setGivenName(String givenName) {
            this.builder.givenName(givenName == null ? "" : givenName);
            return this;
        }

        public Builder setFamilyName(String familyName) {
            this.builder.familyName(familyName == null ? "" : familyName);
            return this;
        }

        public Builder setProfileKey(byte[] profileKey) {
            this.builder.profileKey(profileKey == null ? ByteString.EMPTY : ByteString.of((byte[])profileKey));
            return this;
        }

        public Builder setAvatarUrlPath(String urlPath) {
            this.builder.avatarUrlPath(urlPath == null ? "" : urlPath);
            return this;
        }

        public Builder setNoteToSelfArchived(boolean archived) {
            this.builder.noteToSelfArchived(archived);
            return this;
        }

        public Builder setNoteToSelfForcedUnread(boolean forcedUnread) {
            this.builder.noteToSelfMarkedUnread(forcedUnread);
            return this;
        }

        public Builder setReadReceiptsEnabled(boolean enabled) {
            this.builder.readReceipts(enabled);
            return this;
        }

        public Builder setTypingIndicatorsEnabled(boolean enabled) {
            this.builder.typingIndicators(enabled);
            return this;
        }

        public Builder setSealedSenderIndicatorsEnabled(boolean enabled) {
            this.builder.sealedSenderIndicators(enabled);
            return this;
        }

        public Builder setLinkPreviewsEnabled(boolean enabled) {
            this.builder.linkPreviews(enabled);
            return this;
        }

        public Builder setPhoneNumberSharingMode(AccountRecord.PhoneNumberSharingMode mode) {
            this.builder.phoneNumberSharingMode(mode);
            return this;
        }

        public Builder setUnlistedPhoneNumber(boolean unlisted) {
            this.builder.unlistedPhoneNumber(unlisted);
            return this;
        }

        public Builder setPinnedConversations(List<PinnedConversation> pinnedConversations) {
            this.builder.pinnedConversations(pinnedConversations.stream().map(PinnedConversation::toRemote).collect(Collectors.toList()));
            return this;
        }

        public Builder setPreferContactAvatars(boolean preferContactAvatars) {
            this.builder.preferContactAvatars(preferContactAvatars);
            return this;
        }

        public Builder setPayments(boolean enabled, byte[] entropy) {
            Payments.Builder paymentsBuilder = new Payments.Builder();
            boolean entropyPresent = entropy != null && entropy.length == 32;
            paymentsBuilder.enabled(enabled && entropyPresent);
            if (entropyPresent) {
                paymentsBuilder.entropy(ByteString.of((byte[])entropy));
            }
            this.builder.payments(paymentsBuilder.build());
            return this;
        }

        public Builder setUniversalExpireTimer(int timer) {
            this.builder.universalExpireTimer(timer);
            return this;
        }

        public Builder setPrimarySendsSms(boolean primarySendsSms) {
            this.builder.primarySendsSms(primarySendsSms);
            return this;
        }

        public Builder setE164(String e164) {
            this.builder.e164(e164);
            return this;
        }

        public Builder setDefaultReactions(List<String> defaultReactions) {
            this.builder.preferredReactionEmoji(new ArrayList<String>(defaultReactions));
            return this;
        }

        public Builder setSubscriber(Subscriber subscriber) {
            if (subscriber.id.isPresent() && subscriber.currencyCode.isPresent()) {
                this.builder.subscriberId(ByteString.of((byte[])subscriber.id.get()));
                this.builder.subscriberCurrencyCode(subscriber.currencyCode.get());
            } else {
                this.builder.subscriberId(StorageRecordProtoUtil.getDefaultAccountRecord().subscriberId);
                this.builder.subscriberCurrencyCode(StorageRecordProtoUtil.getDefaultAccountRecord().subscriberCurrencyCode);
            }
            return this;
        }

        public Builder setBackupsSubscriber(Subscriber subscriber) {
            if (subscriber.id.isPresent() && subscriber.currencyCode.isPresent()) {
                this.builder.backupsSubscriberId(ByteString.of((byte[])subscriber.id.get()));
                this.builder.backupsSubscriberCurrencyCode(subscriber.currencyCode.get());
            } else {
                this.builder.backupsSubscriberId(StorageRecordProtoUtil.getDefaultAccountRecord().subscriberId);
                this.builder.backupsSubscriberCurrencyCode(StorageRecordProtoUtil.getDefaultAccountRecord().subscriberCurrencyCode);
            }
            return this;
        }

        public Builder setDisplayBadgesOnProfile(boolean displayBadgesOnProfile) {
            this.builder.displayBadgesOnProfile(displayBadgesOnProfile);
            return this;
        }

        public Builder setSubscriptionManuallyCancelled(boolean subscriptionManuallyCancelled) {
            this.builder.subscriptionManuallyCancelled(subscriptionManuallyCancelled);
            return this;
        }

        public Builder setKeepMutedChatsArchived(boolean keepMutedChatsArchived) {
            this.builder.keepMutedChatsArchived(keepMutedChatsArchived);
            return this;
        }

        public Builder setHasSetMyStoriesPrivacy(boolean hasSetMyStoriesPrivacy) {
            this.builder.hasSetMyStoriesPrivacy(hasSetMyStoriesPrivacy);
            return this;
        }

        public Builder setHasViewedOnboardingStory(boolean hasViewedOnboardingStory) {
            this.builder.hasViewedOnboardingStory(hasViewedOnboardingStory);
            return this;
        }

        public Builder setStoriesDisabled(boolean storiesDisabled) {
            this.builder.storiesDisabled(storiesDisabled);
            return this;
        }

        public Builder setStoryViewReceiptsState(OptionalBool storyViewedReceiptsEnabled) {
            this.builder.storyViewReceiptsEnabled(storyViewedReceiptsEnabled);
            return this;
        }

        public Builder setHasSeenGroupStoryEducationSheet(boolean hasSeenGroupStoryEducationSheet) {
            this.builder.hasSeenGroupStoryEducationSheet(hasSeenGroupStoryEducationSheet);
            return this;
        }

        public Builder setHasCompletedUsernameOnboarding(boolean hasCompletedUsernameOnboarding) {
            this.builder.hasCompletedUsernameOnboarding(hasCompletedUsernameOnboarding);
            return this;
        }

        public Builder setUsername(@Nullable String username) {
            if (username == null || username.isEmpty()) {
                this.builder.username(StorageRecordProtoUtil.getDefaultAccountRecord().username);
            } else {
                this.builder.username(username);
            }
            return this;
        }

        public Builder setUsernameLink(@Nullable AccountRecord.UsernameLink link) {
            if (link == null) {
                this.builder.usernameLink(StorageRecordProtoUtil.getDefaultAccountRecord().usernameLink);
            } else {
                this.builder.usernameLink(link);
            }
            return this;
        }

        private static AccountRecord.Builder parseUnknowns(byte[] serializedUnknowns) {
            try {
                return ((AccountRecord)((Object)AccountRecord.ADAPTER.decode(serializedUnknowns))).newBuilder();
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)"Failed to combine unknown fields!", (Throwable)e);
                return new AccountRecord.Builder();
            }
        }

        public SignalAccountRecord build() {
            return new SignalAccountRecord(this.id, this.builder.build());
        }
    }
}

