/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.subscriptions;

import java.security.SecureRandom;
import java.util.Arrays;
import org.signal.core.util.Base64;
import org.whispersystems.signalservice.api.util.Preconditions;

public final class IdempotencyKey {
    private static final int SIZE = 16;
    private final byte[] bytes;

    private IdempotencyKey(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String serialize() {
        return Base64.encodeUrlSafeWithPadding((byte[])this.bytes);
    }

    public static IdempotencyKey fromBytes(byte[] bytes) {
        Preconditions.checkArgument(bytes.length == 16);
        return new IdempotencyKey(bytes);
    }

    public static IdempotencyKey generate() {
        byte[] bytes = new byte[16];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(bytes);
        return new IdempotencyKey(bytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdempotencyKey that = (IdempotencyKey)o;
        return Arrays.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }
}

