/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.svr;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.signal.libsignal.svr2.PinHash;
import org.whispersystems.signalservice.internal.push.AuthCredentials;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/whispersystems/signalservice/api/svr/Svr2PinHasher;", "", "authCredentials", "Lorg/whispersystems/signalservice/internal/push/AuthCredentials;", "mrEnclave", "", "(Lorg/whispersystems/signalservice/internal/push/AuthCredentials;[B)V", "hash", "Lorg/signal/libsignal/svr2/PinHash;", "normalizedPin", "signal-service-java"})
public final class Svr2PinHasher {
    @NotNull
    private final AuthCredentials authCredentials;
    @NotNull
    private final byte[] mrEnclave;

    public Svr2PinHasher(@NotNull AuthCredentials authCredentials, @NotNull byte[] mrEnclave) {
        Intrinsics.checkNotNullParameter((Object)authCredentials, (String)"authCredentials");
        Intrinsics.checkNotNullParameter((Object)mrEnclave, (String)"mrEnclave");
        this.authCredentials = authCredentials;
        this.mrEnclave = mrEnclave;
    }

    @NotNull
    public final PinHash hash(@NotNull byte[] normalizedPin) {
        Intrinsics.checkNotNullParameter((Object)normalizedPin, (String)"normalizedPin");
        PinHash pinHash = PinHash.svr2((byte[])normalizedPin, (String)this.authCredentials.username(), (byte[])this.mrEnclave);
        Intrinsics.checkNotNullExpressionValue((Object)pinHash, (String)"svr2(...)");
        return pinHash;
    }
}

