/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.svr;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.ConnectionSpec;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.libsignal.attest.AttestationDataException;
import org.signal.libsignal.protocol.logging.Log;
import org.signal.libsignal.protocol.util.Pair;
import org.signal.libsignal.sgxsession.SgxCommunicationFailureException;
import org.signal.libsignal.svr2.Svr2Client;
import org.signal.svr2.proto.Request;
import org.whispersystems.signalservice.api.push.TrustStore;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;
import org.whispersystems.signalservice.api.svr.Svr2PinHasher;
import org.whispersystems.signalservice.api.util.Tls12SocketFactory;
import org.whispersystems.signalservice.api.util.TlsProxySocketFactory;
import org.whispersystems.signalservice.internal.configuration.SignalProxy;
import org.whispersystems.signalservice.internal.configuration.SignalServiceConfiguration;
import org.whispersystems.signalservice.internal.configuration.SignalSvr2Url;
import org.whispersystems.signalservice.internal.push.AuthCredentials;
import org.whispersystems.signalservice.internal.util.BlacklistingTrustManager;
import org.whispersystems.signalservice.internal.util.Hex;
import org.whispersystems.signalservice.internal.util.Util;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0004\u0011\u0012\u0013\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/whispersystems/signalservice/api/svr/Svr2Socket;", "", "configuration", "Lorg/whispersystems/signalservice/internal/configuration/SignalServiceConfiguration;", "mrEnclave", "", "(Lorg/whispersystems/signalservice/internal/configuration/SignalServiceConfiguration;Ljava/lang/String;)V", "okhttp", "Lokhttp3/OkHttpClient;", "svr2Url", "Lorg/whispersystems/signalservice/internal/configuration/SignalSvr2Url;", "makeRequest", "Lorg/signal/svr2/proto/Response;", "authorization", "Lorg/whispersystems/signalservice/internal/push/AuthCredentials;", "clientRequest", "Lorg/signal/svr2/proto/Request;", "Companion", "Response", "Stage", "SvrWebSocketListener", "signal-service-java"})
public final class Svr2Socket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String mrEnclave;
    @NotNull
    private final SignalSvr2Url svr2Url;
    @NotNull
    private final OkHttpClient okhttp;
    private static final String TAG = Svr2Socket.class.getSimpleName();

    public Svr2Socket(@NotNull SignalServiceConfiguration configuration, @NotNull String mrEnclave) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)mrEnclave, (String)"mrEnclave");
        this.mrEnclave = mrEnclave;
        this.svr2Url = Svr2Socket.Companion.chooseUrl(configuration.getSignalSvr2Urls());
        this.okhttp = Svr2Socket.Companion.buildOkHttpClient(configuration, this.svr2Url);
    }

    @NotNull
    public final org.signal.svr2.proto.Response makeRequest(@NotNull AuthCredentials authorization, @NotNull Request clientRequest) throws IOException {
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        Intrinsics.checkNotNullParameter((Object)((Object)clientRequest), (String)"clientRequest");
        Request.Builder builder = new Request.Builder().url(this.svr2Url.getUrl() + "/v1/" + this.mrEnclave);
        String string = authorization.asBasic();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asBasic(...)");
        Request.Builder openRequest = builder.addHeader("Authorization", string);
        if (this.svr2Url.getHostHeader().isPresent()) {
            String string2 = this.svr2Url.getHostHeader().get();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
            openRequest.addHeader("Host", string2);
            Log.w((String)TAG, (String)("Using alternate host: " + this.svr2Url.getHostHeader().get()));
        }
        SvrWebSocketListener listener = new SvrWebSocketListener(this.mrEnclave, clientRequest);
        this.okhttp.newWebSocket(openRequest.build(), (WebSocketListener)listener);
        return listener.blockAndWaitForResult();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001b\u0010\f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/whispersystems/signalservice/api/svr/Svr2Socket$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "buildOkHttpClient", "Lokhttp3/OkHttpClient;", "configuration", "Lorg/whispersystems/signalservice/internal/configuration/SignalServiceConfiguration;", "svr2Url", "Lorg/whispersystems/signalservice/internal/configuration/SignalSvr2Url;", "chooseUrl", "urls", "", "([Lorg/whispersystems/signalservice/internal/configuration/SignalSvr2Url;)Lorg/whispersystems/signalservice/internal/configuration/SignalSvr2Url;", "createTlsSocketFactory", "Lorg/signal/libsignal/protocol/util/Pair;", "Ljavax/net/ssl/SSLSocketFactory;", "Ljavax/net/ssl/X509TrustManager;", "trustStore", "Lorg/whispersystems/signalservice/api/push/TrustStore;", "signal-service-java"})
    public static final class Companion {
        private Companion() {
        }

        private final OkHttpClient buildOkHttpClient(SignalServiceConfiguration configuration, SignalSvr2Url svr2Url) {
            TrustStore trustStore = svr2Url.getTrustStore();
            Intrinsics.checkNotNullExpressionValue((Object)trustStore, (String)"getTrustStore(...)");
            Pair<SSLSocketFactory, X509TrustManager> socketFactory = this.createTlsSocketFactory(trustStore);
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            SSLSocketFactory sSLSocketFactory = new Tls12SocketFactory((SSLSocketFactory)socketFactory.first());
            Object object = socketFactory.second();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second(...)");
            OkHttpClient.Builder builder2 = builder.sslSocketFactory(sSLSocketFactory, (X509TrustManager)object);
            ConnectionSpec[] connectionSpecArray = new ConnectionSpec[]{ConnectionSpec.RESTRICTED_TLS};
            List<ConnectionSpec> list = svr2Url.getConnectionSpecs().orElse(Util.immutableList(connectionSpecArray));
            Intrinsics.checkNotNullExpressionValue(list, (String)"orElse(...)");
            OkHttpClient.Builder builder3 = builder2.connectionSpecs(list).retryOnConnectionFailure(false).readTimeout(30L, TimeUnit.SECONDS).connectTimeout(30L, TimeUnit.SECONDS);
            for (Interceptor interceptor : configuration.getNetworkInterceptors()) {
                builder3.addInterceptor(interceptor);
            }
            if (configuration.getSignalProxy().isPresent()) {
                SignalProxy signalProxy = configuration.getSignalProxy().get();
                Intrinsics.checkNotNullExpressionValue((Object)signalProxy, (String)"get(...)");
                SignalProxy proxy = signalProxy;
                builder3.socketFactory((SocketFactory)new TlsProxySocketFactory(proxy.getHost(), proxy.getPort(), configuration.getDns()));
            }
            return builder3.build();
        }

        private final Pair<SSLSocketFactory, X509TrustManager> createTlsSocketFactory(TrustStore trustStore) {
            Pair pair;
            try {
                SSLContext context = SSLContext.getInstance("TLS");
                TrustManager[] trustManagers = BlacklistingTrustManager.createFor(trustStore);
                context.init(null, trustManagers, null);
                SSLSocketFactory sSLSocketFactory = context.getSocketFactory();
                TrustManager trustManager = trustManagers[0];
                Intrinsics.checkNotNull((Object)trustManager, (String)"null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
                pair = new Pair((Object)sSLSocketFactory, (Object)((X509TrustManager)trustManager));
            }
            catch (NoSuchAlgorithmException e) {
                throw new AssertionError((Object)e);
            }
            catch (KeyManagementException e) {
                throw new AssertionError((Object)e);
            }
            return pair;
        }

        private final SignalSvr2Url chooseUrl(SignalSvr2Url[] urls) {
            return urls[(int)(Math.random() * (double)urls.length)];
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/whispersystems/signalservice/api/svr/Svr2Socket$Response;", "", "response", "Lorg/signal/svr2/proto/Response;", "pinHasher", "Lorg/whispersystems/signalservice/api/svr/Svr2PinHasher;", "(Lorg/signal/svr2/proto/Response;Lorg/whispersystems/signalservice/api/svr/Svr2PinHasher;)V", "getPinHasher", "()Lorg/whispersystems/signalservice/api/svr/Svr2PinHasher;", "getResponse", "()Lorg/signal/svr2/proto/Response;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "signal-service-java"})
    public static final class Response {
        @NotNull
        private final org.signal.svr2.proto.Response response;
        @NotNull
        private final Svr2PinHasher pinHasher;

        public Response(@NotNull org.signal.svr2.proto.Response response, @NotNull Svr2PinHasher pinHasher) {
            Intrinsics.checkNotNullParameter((Object)((Object)response), (String)"response");
            Intrinsics.checkNotNullParameter((Object)pinHasher, (String)"pinHasher");
            this.response = response;
            this.pinHasher = pinHasher;
        }

        @NotNull
        public final org.signal.svr2.proto.Response getResponse() {
            return this.response;
        }

        @NotNull
        public final Svr2PinHasher getPinHasher() {
            return this.pinHasher;
        }

        @NotNull
        public final org.signal.svr2.proto.Response component1() {
            return this.response;
        }

        @NotNull
        public final Svr2PinHasher component2() {
            return this.pinHasher;
        }

        @NotNull
        public final Response copy(@NotNull org.signal.svr2.proto.Response response, @NotNull Svr2PinHasher pinHasher) {
            Intrinsics.checkNotNullParameter((Object)((Object)response), (String)"response");
            Intrinsics.checkNotNullParameter((Object)pinHasher, (String)"pinHasher");
            return new Response(response, pinHasher);
        }

        public static /* synthetic */ Response copy$default(Response response, org.signal.svr2.proto.Response response2, Svr2PinHasher svr2PinHasher, int n, Object object) {
            if ((n & 1) != 0) {
                response2 = response.response;
            }
            if ((n & 2) != 0) {
                svr2PinHasher = response.pinHasher;
            }
            return response.copy(response2, svr2PinHasher);
        }

        @NotNull
        public String toString() {
            return "Response(response=" + this.response + ", pinHasher=" + this.pinHasher + ")";
        }

        public int hashCode() {
            int result2 = this.response.hashCode();
            result2 = result2 * 31 + this.pinHasher.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Response)) {
                return false;
            }
            Response response = (Response)other;
            if (!Intrinsics.areEqual((Object)((Object)this.response), (Object)((Object)response.response))) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.pinHasher, (Object)response.pinHasher);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/whispersystems/signalservice/api/svr/Svr2Socket$Stage;", "", "(Ljava/lang/String;I)V", "WAITING_TO_INITIALIZE", "WAITING_FOR_CONNECTION", "WAITING_FOR_HANDSHAKE", "WAITING_FOR_RESPONSE", "CLOSED", "FAILED", "signal-service-java"})
    private static final class Stage
    extends Enum<Stage> {
        public static final /* enum */ Stage WAITING_TO_INITIALIZE = new Stage();
        public static final /* enum */ Stage WAITING_FOR_CONNECTION = new Stage();
        public static final /* enum */ Stage WAITING_FOR_HANDSHAKE = new Stage();
        public static final /* enum */ Stage WAITING_FOR_RESPONSE = new Stage();
        public static final /* enum */ Stage CLOSED = new Stage();
        public static final /* enum */ Stage FAILED = new Stage();
        private static final /* synthetic */ Stage[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Stage[] values() {
            return (Stage[])$VALUES.clone();
        }

        public static Stage valueOf(String value) {
            return Enum.valueOf(Stage.class, value);
        }

        @NotNull
        public static EnumEntries<Stage> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stageArray = new Stage[]{Stage.WAITING_TO_INITIALIZE, Stage.WAITING_FOR_CONNECTION, Stage.WAITING_FOR_HANDSHAKE, Stage.WAITING_FOR_RESPONSE, Stage.CLOSED, Stage.FAILED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0013\u001a\u00020\u000eJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J \u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\"\u0010 \u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\b\u0010\r\u001a\u0004\u0018\u00010#H\u0016J\u0018\u0010$\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020#H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/whispersystems/signalservice/api/svr/Svr2Socket$SvrWebSocketListener;", "Lokhttp3/WebSocketListener;", "mrEnclave", "", "clientRequest", "Lorg/signal/svr2/proto/Request;", "(Ljava/lang/String;Lorg/signal/svr2/proto/Request;)V", "client", "Lorg/signal/libsignal/svr2/Svr2Client;", "exception", "Ljava/io/IOException;", "latch", "Ljava/util/concurrent/CountDownLatch;", "response", "Lorg/signal/svr2/proto/Response;", "stage", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/whispersystems/signalservice/api/svr/Svr2Socket$Stage;", "kotlin.jvm.PlatformType", "blockAndWaitForResult", "emitError", "", "e", "emitSuccess", "", "result", "onClosing", "webSocket", "Lokhttp3/WebSocket;", "code", "", "reason", "onFailure", "t", "", "Lokhttp3/Response;", "onMessage", "bytes", "Lokio/ByteString;", "onOpen", "signal-service-java"})
    @SourceDebugExtension(value={"SMAP\nSvr2Socket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Svr2Socket.kt\norg/whispersystems/signalservice/api/svr/Svr2Socket$SvrWebSocketListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,255:1\n1#2:256\n*E\n"})
    private static final class SvrWebSocketListener
    extends WebSocketListener {
        @NotNull
        private final String mrEnclave;
        @NotNull
        private final Request clientRequest;
        @NotNull
        private final AtomicReference<Stage> stage;
        private Svr2Client client;
        @NotNull
        private final CountDownLatch latch;
        @Nullable
        private org.signal.svr2.proto.Response response;
        @Nullable
        private IOException exception;

        public SvrWebSocketListener(@NotNull String mrEnclave, @NotNull Request clientRequest) {
            Intrinsics.checkNotNullParameter((Object)mrEnclave, (String)"mrEnclave");
            Intrinsics.checkNotNullParameter((Object)((Object)clientRequest), (String)"clientRequest");
            this.mrEnclave = mrEnclave;
            this.clientRequest = clientRequest;
            this.stage = new AtomicReference<Stage>(Stage.WAITING_TO_INITIALIZE);
            this.latch = new CountDownLatch(1);
        }

        public void onOpen(@NotNull WebSocket webSocket, @NotNull okhttp3.Response response) {
            Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Log.d((String)TAG, (String)"[onOpen]");
            this.stage.set(Stage.WAITING_FOR_CONNECTION);
        }

        public void onMessage(@NotNull WebSocket webSocket, @NotNull ByteString bytes) {
            Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Log.d((String)TAG, (String)("[onMessage] stage: " + (Object)((Object)this.stage.get())));
            try {
                Stage stage = this.stage.get();
                Intrinsics.checkNotNull((Object)((Object)stage));
                switch (WhenMappings.$EnumSwitchMapping$0[stage.ordinal()]) {
                    case 1: {
                        throw new IOException("Received a message before we were open!");
                    }
                    case 2: {
                        byte[] byArray = Hex.fromStringCondensed(this.mrEnclave);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"fromStringCondensed(...)");
                        byte[] mrEnclave = byArray;
                        this.client = new Svr2Client(mrEnclave, bytes.toByteArray(), Instant.now());
                        Log.d((String)TAG, (String)"[onMessage] Sending initial handshake...");
                        Svr2Client svr2Client = this.client;
                        if (svr2Client == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                            svr2Client = null;
                        }
                        byte[] byArray2 = svr2Client.initialRequest();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"initialRequest(...)");
                        webSocket.send(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray2, (int)0, (int)0, (int)3, null));
                        this.stage.set(Stage.WAITING_FOR_HANDSHAKE);
                        break;
                    }
                    case 3: {
                        Svr2Client svr2Client = this.client;
                        if (svr2Client == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                            svr2Client = null;
                        }
                        svr2Client.completeHandshake(bytes.toByteArray());
                        Log.d((String)TAG, (String)"[onMessage] Handshake read success. Sending request...");
                        Svr2Client svr2Client2 = this.client;
                        if (svr2Client2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                            svr2Client2 = null;
                        }
                        byte[] ciphertextBytes = svr2Client2.establishedSend(this.clientRequest.encode());
                        Intrinsics.checkNotNull((Object)ciphertextBytes);
                        webSocket.send(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])ciphertextBytes, (int)0, (int)0, (int)3, null));
                        Log.d((String)TAG, (String)"[onMessage] Request sent.");
                        this.stage.set(Stage.WAITING_FOR_RESPONSE);
                        break;
                    }
                    case 4: {
                        Log.d((String)TAG, (String)"[onMessage] Received response for our request.");
                        Svr2Client svr2Client = this.client;
                        if (svr2Client == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                            svr2Client = null;
                        }
                        byte[] byArray = svr2Client.establishedRecv(bytes.toByteArray());
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"establishedRecv(...)");
                        this.emitSuccess((org.signal.svr2.proto.Response)((Object)org.signal.svr2.proto.Response.ADAPTER.decode(byArray)));
                        Log.d((String)TAG, (String)"[onMessage] Success! Closing.");
                        webSocket.close(1000, "OK");
                        break;
                    }
                    case 5: {
                        Log.w((String)TAG, (String)"[onMessage] Received a message after the websocket closed! Ignoring.");
                        break;
                    }
                    case 6: {
                        Log.w((String)TAG, (String)"[onMessage] Received a message after we entered the failure state! Ignoring.");
                        webSocket.close(1000, "OK");
                    }
                }
            }
            catch (IOException e) {
                Log.w((String)TAG, (Throwable)e);
                webSocket.close(1000, "OK");
                this.emitError(e);
            }
            catch (AttestationDataException e) {
                Log.w((String)TAG, (Throwable)e);
                webSocket.close(1007, "OK");
                this.emitError(new IOException(e));
            }
            catch (SgxCommunicationFailureException e) {
                Log.w((String)TAG, (Throwable)e);
                webSocket.close(1000, "OK");
                this.emitError(new IOException(e));
            }
        }

        public void onClosing(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
            Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Log.i((String)TAG, (String)("[onClosing] code: " + code + ", reason: " + reason));
            if (code == 1000) {
                this.emitError(new IOException("Websocket was closed with code 1000"));
                this.stage.set(Stage.CLOSED);
            } else {
                Log.w((String)TAG, (String)("Remote side is closing with non-normal code " + code));
                webSocket.close(1000, "Remote closed with code " + code);
                this.stage.set(Stage.FAILED);
                this.emitError(new NonSuccessfulResponseCodeException(code));
            }
        }

        public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable okhttp3.Response response) {
            Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            if (this.emitError(new IOException(t))) {
                Log.w((String)TAG, (String)("[onFailure] response? " + (response != null)), (Throwable)t);
                this.stage.set(Stage.FAILED);
                webSocket.close(1000, "OK");
            }
        }

        @NotNull
        public final org.signal.svr2.proto.Response blockAndWaitForResult() throws IOException {
            this.latch.await();
            IOException iOException = this.exception;
            if (iOException != null) {
                IOException it = iOException;
                boolean bl = false;
                throw it;
            }
            org.signal.svr2.proto.Response response = this.response;
            if (response != null) {
                org.signal.svr2.proto.Response it = response;
                boolean bl = false;
                return it;
            }
            throw new IllegalStateException("Neither the response nor exception were set!");
        }

        private final void emitSuccess(org.signal.svr2.proto.Response result2) {
            this.response = result2;
            this.latch.countDown();
        }

        private final boolean emitError(IOException e) {
            boolean isFirstError;
            boolean bl = isFirstError = this.exception == null;
            if (isFirstError) {
                this.exception = e;
            }
            this.latch.countDown();
            return isFirstError;
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Stage.values().length];
                try {
                    nArray[Stage.WAITING_TO_INITIALIZE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Stage.WAITING_FOR_CONNECTION.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Stage.WAITING_FOR_HANDSHAKE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Stage.WAITING_FOR_RESPONSE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Stage.CLOSED.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Stage.FAILED.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

