/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.contacts.crypto;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Quote {
    private static final long SGX_FLAGS_INITTED = 1L;
    private static final long SGX_FLAGS_DEBUG = 2L;
    private static final long SGX_FLAGS_MODE64BIT = 4L;
    private static final long SGX_FLAGS_PROVISION_KEY = 4L;
    private static final long SGX_FLAGS_EINITTOKEN_KEY = 4L;
    private static final long SGX_FLAGS_RESERVED = -56L;
    private static final long SGX_XFRM_LEGACY = 3L;
    private static final long SGX_XFRM_AVX = 6L;
    private static final long SGX_XFRM_RESERVED = -8L;
    private final int version;
    private final boolean isSigLinkable;
    private final long gid;
    private final int qeSvn;
    private final int pceSvn;
    private final byte[] basename = new byte[32];
    private final byte[] cpuSvn = new byte[16];
    private final long flags;
    private final long xfrm;
    private final byte[] mrenclave = new byte[32];
    private final byte[] mrsigner = new byte[32];
    private final int isvProdId;
    private final int isvSvn;
    private final byte[] reportData = new byte[64];
    private final byte[] signature;
    private final byte[] quoteBytes;

    public Quote(byte[] quoteBytes) throws InvalidQuoteFormatException {
        this.quoteBytes = quoteBytes;
        ByteBuffer quoteBuf = ByteBuffer.wrap(quoteBytes);
        quoteBuf.order(ByteOrder.LITTLE_ENDIAN);
        this.version = quoteBuf.getShort(0) & 0xFFFF;
        if (this.version < 1 || this.version > 2) {
            throw new InvalidQuoteFormatException("unknown_quote_version " + this.version);
        }
        int sign_type = quoteBuf.getShort(2) & 0xFFFF;
        if ((sign_type & 0xFFFFFFFE) != 0) {
            throw new InvalidQuoteFormatException("unknown_quote_sign_type " + sign_type);
        }
        this.isSigLinkable = sign_type == 1;
        this.gid = quoteBuf.getInt(4) & 0xFFFFFFFF;
        this.qeSvn = quoteBuf.getShort(8) & 0xFFFF;
        if (this.version > 1) {
            this.pceSvn = quoteBuf.getShort(10) & 0xFFFF;
        } else {
            this.readZero(quoteBuf, 10, 2);
            this.pceSvn = 0;
        }
        this.readZero(quoteBuf, 12, 4);
        this.read(quoteBuf, 16, this.basename);
        this.read(quoteBuf, 48, this.cpuSvn);
        this.readZero(quoteBuf, 64, 4);
        this.readZero(quoteBuf, 68, 28);
        this.flags = quoteBuf.getLong(96);
        if ((this.flags & 0xFFFFFFFFFFFFFFC8L) != 0L || (this.flags & 1L) == 0L || (this.flags & 4L) == 0L) {
            throw new InvalidQuoteFormatException("bad_quote_flags " + this.flags);
        }
        this.xfrm = quoteBuf.getLong(104);
        if ((this.xfrm & 0xFFFFFFFFFFFFFFF8L) != 0L) {
            throw new InvalidQuoteFormatException("bad_quote_xfrm " + this.xfrm);
        }
        this.read(quoteBuf, 112, this.mrenclave);
        this.readZero(quoteBuf, 144, 32);
        this.read(quoteBuf, 176, this.mrsigner);
        this.readZero(quoteBuf, 208, 96);
        this.isvProdId = quoteBuf.getShort(304) & 0xFFFF;
        this.isvSvn = quoteBuf.getShort(306) & 0xFFFF;
        this.readZero(quoteBuf, 308, 60);
        this.read(quoteBuf, 368, this.reportData);
        int sig_len = quoteBuf.getInt(432) & 0xFFFFFFFF;
        if (sig_len != quoteBytes.length - 436) {
            throw new InvalidQuoteFormatException("bad_quote_sig_len " + sig_len);
        }
        this.signature = new byte[sig_len];
        this.read(quoteBuf, 436, this.signature);
    }

    public byte[] getReportData() {
        return this.reportData;
    }

    private void read(ByteBuffer quoteBuf, int pos, byte[] buf) {
        quoteBuf.position(pos);
        quoteBuf.get(buf);
    }

    private void readZero(ByteBuffer quoteBuf, int pos, int count) {
        byte[] zeroBuf = new byte[count];
        this.read(quoteBuf, pos, zeroBuf);
        for (int zeroBufIdx = 0; zeroBufIdx < count; ++zeroBufIdx) {
            if (zeroBuf[zeroBufIdx] == 0) continue;
            throw new IllegalArgumentException("quote_reserved_mismatch " + pos);
        }
    }

    public byte[] getQuoteBytes() {
        return this.quoteBytes;
    }

    public byte[] getMrenclave() {
        return this.mrenclave;
    }

    public boolean isDebugQuote() {
        return (this.flags & 2L) != 0L;
    }

    public static class InvalidQuoteFormatException
    extends Exception {
        public InvalidQuoteFormatException(String value) {
            super(value);
        }
    }
}

