/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.api;

import java.util.UUID;
import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.api.InvalidNumberException;
import org.asamk.signal.manager.api.RecipientAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.util.PhoneNumberFormatter;
import org.whispersystems.signalservice.api.util.UuidUtil;

public sealed interface RecipientIdentifier {
    public String getIdentifier();

    public record Group(GroupId groupId) implements RecipientIdentifier
    {
        @Override
        public String getIdentifier() {
            return this.groupId.toBase64();
        }
    }

    public record Username(String username) implements Single
    {
        @Override
        public String getIdentifier() {
            return "u:" + this.username;
        }

        @Override
        public RecipientAddress toPartialRecipientAddress() {
            return new RecipientAddress(null, null, null, this.username);
        }
    }

    public record Number(String number) implements Single
    {
        @Override
        public String getIdentifier() {
            return this.number;
        }

        @Override
        public RecipientAddress toPartialRecipientAddress() {
            return new RecipientAddress(this.number);
        }
    }

    public record Pni(String pni) implements Single
    {
        @Override
        public String getIdentifier() {
            return this.pni;
        }

        @Override
        public RecipientAddress toPartialRecipientAddress() {
            return new RecipientAddress(null, this.pni, null, null);
        }
    }

    public record Uuid(UUID uuid) implements Single
    {
        @Override
        public String getIdentifier() {
            return this.uuid.toString();
        }

        @Override
        public RecipientAddress toPartialRecipientAddress() {
            return new RecipientAddress(this.uuid);
        }
    }

    public static sealed interface Single
    extends RecipientIdentifier
    permits Uuid, Pni, Number, Username {
        public static Single fromString(String identifier, String localNumber) throws InvalidNumberException {
            try {
                if (UuidUtil.isUuid((String)identifier)) {
                    return new Uuid(UUID.fromString(identifier));
                }
                if (identifier.startsWith("u:")) {
                    return new Username(identifier.substring(2));
                }
                String normalizedNumber = PhoneNumberFormatter.formatNumber((String)identifier, (String)localNumber);
                if (!normalizedNumber.equals(identifier)) {
                    Logger logger = LoggerFactory.getLogger(RecipientIdentifier.class);
                    logger.debug("Normalized number {} to {}.", (Object)identifier, (Object)normalizedNumber);
                }
                return new Number(normalizedNumber);
            }
            catch (org.whispersystems.signalservice.api.util.InvalidNumberException e) {
                throw new InvalidNumberException(e.getMessage(), e);
            }
        }

        public static Single fromAddress(RecipientAddress address) {
            if (address.number().isPresent()) {
                return new Number(address.number().get());
            }
            if (address.aci().isPresent()) {
                return new Uuid(UUID.fromString(address.aci().get()));
            }
            if (address.pni().isPresent()) {
                return new Pni(address.pni().get());
            }
            if (address.username().isPresent()) {
                return new Username(address.username().get());
            }
            throw new AssertionError((Object)"RecipientAddress without identifier");
        }

        public RecipientAddress toPartialRecipientAddress();
    }

    public record NoteToSelf() implements RecipientIdentifier
    {
        public static final NoteToSelf INSTANCE = new NoteToSelf();

        @Override
        public String getIdentifier() {
            return "Note-To-Self";
        }
    }
}

