/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.helper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okio.ByteString;
import org.asamk.signal.manager.api.GroupIdV2;
import org.asamk.signal.manager.api.GroupLinkState;
import org.asamk.signal.manager.api.GroupPermission;
import org.asamk.signal.manager.api.NotAGroupMemberException;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.groups.GroupLinkPassword;
import org.asamk.signal.manager.groups.GroupUtils;
import org.asamk.signal.manager.helper.Context;
import org.asamk.signal.manager.internal.SignalDependencies;
import org.asamk.signal.manager.storage.groups.GroupInfoV2;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.asamk.signal.manager.util.Utils;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.VerificationFailedException;
import org.signal.libsignal.zkgroup.auth.AuthCredentialWithPniResponse;
import org.signal.libsignal.zkgroup.groups.GroupMasterKey;
import org.signal.libsignal.zkgroup.groups.GroupSecretParams;
import org.signal.libsignal.zkgroup.groups.UuidCiphertext;
import org.signal.libsignal.zkgroup.profiles.ExpiringProfileKeyCredential;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.signal.storageservice.protos.groups.AccessControl;
import org.signal.storageservice.protos.groups.GroupChange;
import org.signal.storageservice.protos.groups.GroupChangeResponse;
import org.signal.storageservice.protos.groups.Member;
import org.signal.storageservice.protos.groups.local.DecryptedGroup;
import org.signal.storageservice.protos.groups.local.DecryptedGroupChange;
import org.signal.storageservice.protos.groups.local.DecryptedGroupJoinInfo;
import org.signal.storageservice.protos.groups.local.DecryptedMember;
import org.signal.storageservice.protos.groups.local.DecryptedPendingMember;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.groupsv2.DecryptedGroupResponse;
import org.whispersystems.signalservice.api.groupsv2.DecryptedGroupUtil;
import org.whispersystems.signalservice.api.groupsv2.GroupCandidate;
import org.whispersystems.signalservice.api.groupsv2.GroupHistoryPage;
import org.whispersystems.signalservice.api.groupsv2.GroupLinkNotActiveException;
import org.whispersystems.signalservice.api.groupsv2.GroupsV2AuthorizationString;
import org.whispersystems.signalservice.api.groupsv2.GroupsV2Operations;
import org.whispersystems.signalservice.api.groupsv2.InvalidGroupStateException;
import org.whispersystems.signalservice.api.groupsv2.NotAbleToApplyGroupV2ChangeException;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;
import org.whispersystems.signalservice.api.util.UuidUtil;

class GroupV2Helper {
    private static final Logger logger = LoggerFactory.getLogger(GroupV2Helper.class);
    private final SignalDependencies dependencies;
    private final Context context;
    private Map<Long, AuthCredentialWithPniResponse> groupApiCredentials;

    GroupV2Helper(Context context) {
        this.dependencies = context.getDependencies();
        this.context = context;
    }

    void clearAuthCredentialCache() {
        this.groupApiCredentials = null;
    }

    DecryptedGroupResponse getDecryptedGroup(GroupSecretParams groupSecretParams) throws NotAGroupMemberException {
        try {
            GroupsV2AuthorizationString groupsV2AuthorizationString = this.getGroupAuthForToday(groupSecretParams);
            return this.dependencies.getGroupsV2Api().getGroup(groupSecretParams, groupsV2AuthorizationString);
        }
        catch (NonSuccessfulResponseCodeException e) {
            if (e.getCode() == 403) {
                throw new NotAGroupMemberException(GroupUtils.getGroupIdV2(groupSecretParams), null);
            }
            logger.warn("Failed to retrieve Group V2 info, ignoring: {}", (Object)e.getMessage());
            return null;
        }
        catch (IOException | InvalidInputException | VerificationFailedException | InvalidGroupStateException e) {
            logger.warn("Failed to retrieve Group V2 info, ignoring: {}", (Object)e.getMessage());
            return null;
        }
    }

    DecryptedGroupJoinInfo getDecryptedGroupJoinInfo(GroupMasterKey groupMasterKey, GroupLinkPassword password) throws IOException, GroupLinkNotActiveException {
        GroupSecretParams groupSecretParams = GroupSecretParams.deriveFromMasterKey((GroupMasterKey)groupMasterKey);
        return this.dependencies.getGroupsV2Api().getGroupJoinInfo(groupSecretParams, Optional.ofNullable(password).map(GroupLinkPassword::serialize), this.getGroupAuthForToday(groupSecretParams));
    }

    GroupHistoryPage getDecryptedGroupHistoryPage(GroupSecretParams groupSecretParams, int fromRevision, long sendEndorsementsExpirationMs) throws NotAGroupMemberException {
        try {
            GroupsV2AuthorizationString groupsV2AuthorizationString = this.getGroupAuthForToday(groupSecretParams);
            return this.dependencies.getGroupsV2Api().getGroupHistoryPage(groupSecretParams, fromRevision, groupsV2AuthorizationString, false, sendEndorsementsExpirationMs);
        }
        catch (NonSuccessfulResponseCodeException e) {
            if (e.getCode() == 403) {
                throw new NotAGroupMemberException(GroupUtils.getGroupIdV2(groupSecretParams), null);
            }
            logger.warn("Failed to retrieve Group V2 history, ignoring: {}", (Object)e.getMessage());
            return null;
        }
        catch (IOException | InvalidInputException | VerificationFailedException | InvalidGroupStateException e) {
            logger.warn("Failed to retrieve Group V2 history, ignoring: {}", (Object)e.getMessage());
            return null;
        }
    }

    int findRevisionWeWereAdded(DecryptedGroup partialDecryptedGroup) {
        ByteString aciBytes = this.getSelfAci().toByteString();
        ByteString pniBytes = this.getSelfPni().toByteString();
        for (DecryptedMember decryptedMember : partialDecryptedGroup.members) {
            if (!decryptedMember.aciBytes.equals((Object)aciBytes) && !decryptedMember.pniBytes.equals((Object)pniBytes)) continue;
            return decryptedMember.joinedAtRevision;
        }
        return partialDecryptedGroup.revision;
    }

    Pair<GroupInfoV2, DecryptedGroupResponse> createGroup(String name, Set<RecipientId> members, byte[] avatarFile) {
        DecryptedGroupResponse response;
        GroupsV2Operations.NewGroup newGroup = this.buildNewGroup(name, members, avatarFile);
        if (newGroup == null) {
            return null;
        }
        GroupSecretParams groupSecretParams = newGroup.getGroupSecretParams();
        try {
            GroupsV2AuthorizationString groupAuthForToday = this.getGroupAuthForToday(groupSecretParams);
            this.dependencies.getGroupsV2Api().putNewGroup(newGroup, groupAuthForToday);
            response = this.dependencies.getGroupsV2Api().getGroup(groupSecretParams, groupAuthForToday);
        }
        catch (IOException | InvalidInputException | VerificationFailedException | InvalidGroupStateException e) {
            logger.warn("Failed to create V2 group: {}", (Object)e.getMessage());
            return null;
        }
        if (response == null) {
            logger.warn("Failed to create V2 group, unknown error!");
            return null;
        }
        GroupIdV2 groupId = GroupUtils.getGroupIdV2(groupSecretParams);
        GroupMasterKey masterKey = groupSecretParams.getMasterKey();
        GroupInfoV2 g = new GroupInfoV2(groupId, masterKey, this.context.getAccount().getRecipientResolver());
        return new Pair<GroupInfoV2, DecryptedGroupResponse>(g, response);
    }

    private GroupsV2Operations.NewGroup buildNewGroup(String name, Set<RecipientId> members, byte[] avatar) {
        ExpiringProfileKeyCredential profileKeyCredential = this.context.getProfileHelper().getExpiringProfileKeyCredential(this.context.getAccount().getSelfRecipientId());
        if (profileKeyCredential == null) {
            logger.warn("Cannot create a V2 group as self does not have a versioned profile");
            return null;
        }
        GroupCandidate self = new GroupCandidate((ServiceId)this.getSelfAci(), Optional.of(profileKeyCredential));
        ArrayList<RecipientId> memberList = new ArrayList<RecipientId>(members);
        Stream credentials = this.context.getProfileHelper().getExpiringProfileKeyCredential(memberList).stream();
        Stream<ServiceId> uuids = memberList.stream().map(member -> this.context.getRecipientHelper().resolveSignalServiceAddress((RecipientId)member).getServiceId());
        Set candidates = Utils.zip(uuids, credentials, (uuid, credential) -> new GroupCandidate(uuid, Optional.ofNullable(credential))).collect(Collectors.toSet());
        GroupSecretParams groupSecretParams = GroupSecretParams.generate();
        return this.dependencies.getGroupsV2Operations().createNewGroup(groupSecretParams, name, Optional.ofNullable(avatar), self, candidates, Member.Role.DEFAULT, 0);
    }

    Pair<DecryptedGroup, GroupChangeResponse> updateGroup(GroupInfoV2 groupInfoV2, String name, String description, byte[] avatarFile) throws IOException {
        GroupChange.Actions.Builder change;
        GroupSecretParams groupSecretParams = GroupSecretParams.deriveFromMasterKey((GroupMasterKey)groupInfoV2.getMasterKey());
        GroupsV2Operations.GroupOperations groupOperations = this.dependencies.getGroupsV2Operations().forGroup(groupSecretParams);
        GroupChange.Actions.Builder builder = change = name != null ? groupOperations.createModifyGroupTitle(name) : new GroupChange.Actions.Builder();
        if (description != null) {
            change.modifyDescription(groupOperations.createModifyGroupDescriptionAction(description).build());
        }
        if (avatarFile != null) {
            String avatarCdnKey = this.dependencies.getGroupsV2Api().uploadAvatar(avatarFile, groupSecretParams, this.getGroupAuthForToday(groupSecretParams));
            change.modifyAvatar(new GroupChange.Actions.ModifyAvatarAction.Builder().avatar(avatarCdnKey).build());
        }
        change.sourceServiceId(this.getSelfAci().toByteString());
        return this.commitChange(groupInfoV2, change);
    }

    Pair<DecryptedGroup, GroupChangeResponse> addMembers(GroupInfoV2 groupInfoV2, Set<RecipientId> newMembers) throws IOException {
        GroupsV2Operations.GroupOperations groupOperations = this.getGroupOperations(groupInfoV2);
        ArrayList<RecipientId> memberList = new ArrayList<RecipientId>(newMembers);
        Stream credentials = this.context.getProfileHelper().getExpiringProfileKeyCredential(memberList).stream();
        Stream<ServiceId> uuids = memberList.stream().map(member -> this.context.getRecipientHelper().resolveSignalServiceAddress((RecipientId)member).getServiceId());
        Set candidates = Utils.zip(uuids, credentials, (uuid, credential) -> new GroupCandidate(uuid, Optional.ofNullable(credential))).collect(Collectors.toSet());
        Set bannedUuids = groupInfoV2.getBannedMembers().stream().map(member -> this.context.getRecipientHelper().resolveSignalServiceAddress((RecipientId)member).getServiceId()).collect(Collectors.toSet());
        ServiceId.ACI aci = this.getSelfAci();
        GroupChange.Actions.Builder change = groupOperations.createModifyGroupMembershipChange(candidates, bannedUuids, aci);
        change.sourceServiceId(this.getSelfAci().toByteString());
        return this.commitChange(groupInfoV2, change);
    }

    Pair<DecryptedGroup, GroupChangeResponse> leaveGroup(GroupInfoV2 groupInfoV2, Set<RecipientId> membersToMakeAdmin) throws IOException {
        List pendingMembersList = groupInfoV2.getGroup().pendingMembers;
        ServiceId.ACI selfAci = this.getSelfAci();
        Optional selfPendingMember = DecryptedGroupUtil.findPendingByServiceId((Collection)pendingMembersList, (ServiceId)selfAci);
        if (selfPendingMember.isPresent()) {
            return this.revokeInvites(groupInfoV2, Set.of((DecryptedPendingMember)selfPendingMember.get()));
        }
        List<UUID> adminUuids = membersToMakeAdmin.stream().map(this.context.getRecipientHelper()::resolveSignalServiceAddress).map(SignalServiceAddress::getServiceId).map(ServiceId::getRawUuid).toList();
        GroupsV2Operations.GroupOperations groupOperations = this.getGroupOperations(groupInfoV2);
        return this.commitChange(groupInfoV2, groupOperations.createLeaveAndPromoteMembersToAdmin(selfAci, adminUuids));
    }

    Pair<DecryptedGroup, GroupChangeResponse> removeMembers(GroupInfoV2 groupInfoV2, Set<RecipientId> members) throws IOException {
        Set<ServiceId.ACI> memberUuids = members.stream().map(this.context.getRecipientHelper()::resolveSignalServiceAddress).map(SignalServiceAddress::getServiceId).filter(m -> m instanceof ServiceId.ACI).map(m -> (ServiceId.ACI)m).collect(Collectors.toSet());
        return this.ejectMembers(groupInfoV2, memberUuids);
    }

    Pair<DecryptedGroup, GroupChangeResponse> approveJoinRequestMembers(GroupInfoV2 groupInfoV2, Set<RecipientId> members) throws IOException {
        Set<UUID> memberUuids = members.stream().map(this.context.getRecipientHelper()::resolveSignalServiceAddress).map(SignalServiceAddress::getServiceId).map(ServiceId::getRawUuid).collect(Collectors.toSet());
        return this.approveJoinRequest(groupInfoV2, memberUuids);
    }

    Pair<DecryptedGroup, GroupChangeResponse> refuseJoinRequestMembers(GroupInfoV2 groupInfoV2, Set<RecipientId> members) throws IOException {
        Set<ServiceId> memberUuids = members.stream().map(this.context.getRecipientHelper()::resolveSignalServiceAddress).map(SignalServiceAddress::getServiceId).collect(Collectors.toSet());
        return this.refuseJoinRequest(groupInfoV2, memberUuids);
    }

    Pair<DecryptedGroup, GroupChangeResponse> revokeInvitedMembers(GroupInfoV2 groupInfoV2, Set<RecipientId> members) throws IOException {
        List pendingMembersList = groupInfoV2.getGroup().pendingMembers;
        Set<DecryptedPendingMember> memberUuids = members.stream().map(this.context.getRecipientHelper()::resolveSignalServiceAddress).map(SignalServiceAddress::getServiceId).map(uuid -> DecryptedGroupUtil.findPendingByServiceId((Collection)pendingMembersList, (ServiceId)uuid)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        return this.revokeInvites(groupInfoV2, memberUuids);
    }

    Pair<DecryptedGroup, GroupChangeResponse> banMembers(GroupInfoV2 groupInfoV2, Set<RecipientId> block) throws IOException {
        GroupsV2Operations.GroupOperations groupOperations = this.getGroupOperations(groupInfoV2);
        Set serviceIds = block.stream().map(member -> this.context.getRecipientHelper().resolveSignalServiceAddress((RecipientId)member).getServiceId()).collect(Collectors.toSet());
        GroupChange.Actions.Builder change = groupOperations.createBanServiceIdsChange(serviceIds, false, groupInfoV2.getGroup().bannedMembers);
        change.sourceServiceId(this.getSelfAci().toByteString());
        return this.commitChange(groupInfoV2, change);
    }

    Pair<DecryptedGroup, GroupChangeResponse> unbanMembers(GroupInfoV2 groupInfoV2, Set<RecipientId> block) throws IOException {
        GroupsV2Operations.GroupOperations groupOperations = this.getGroupOperations(groupInfoV2);
        Set serviceIds = block.stream().map(member -> this.context.getRecipientHelper().resolveSignalServiceAddress((RecipientId)member).getServiceId()).collect(Collectors.toSet());
        GroupChange.Actions.Builder change = groupOperations.createUnbanServiceIdsChange(serviceIds);
        change.sourceServiceId(this.getSelfAci().toByteString());
        return this.commitChange(groupInfoV2, change);
    }

    Pair<DecryptedGroup, GroupChangeResponse> resetGroupLinkPassword(GroupInfoV2 groupInfoV2) throws IOException {
        GroupsV2Operations.GroupOperations groupOperations = this.getGroupOperations(groupInfoV2);
        byte[] newGroupLinkPassword = GroupLinkPassword.createNew().serialize();
        GroupChange.Actions.Builder change = groupOperations.createModifyGroupLinkPasswordChange(newGroupLinkPassword);
        return this.commitChange(groupInfoV2, change);
    }

    Pair<DecryptedGroup, GroupChangeResponse> setGroupLinkState(GroupInfoV2 groupInfoV2, GroupLinkState state) throws IOException {
        GroupsV2Operations.GroupOperations groupOperations = this.getGroupOperations(groupInfoV2);
        AccessControl.AccessRequired accessRequired = this.toAccessControl(state);
        boolean requiresNewPassword = state != GroupLinkState.DISABLED && groupInfoV2.getGroup().inviteLinkPassword.toByteArray().length == 0;
        GroupChange.Actions.Builder change = requiresNewPassword ? groupOperations.createModifyGroupLinkPasswordAndRightsChange(GroupLinkPassword.createNew().serialize(), accessRequired) : groupOperations.createChangeJoinByLinkRights(accessRequired);
        return this.commitChange(groupInfoV2, change);
    }

    Pair<DecryptedGroup, GroupChangeResponse> setEditDetailsPermission(GroupInfoV2 groupInfoV2, GroupPermission permission) throws IOException {
        GroupsV2Operations.GroupOperations groupOperations = this.getGroupOperations(groupInfoV2);
        AccessControl.AccessRequired accessRequired = this.toAccessControl(permission);
        GroupChange.Actions.Builder change = groupOperations.createChangeAttributesRights(accessRequired);
        return this.commitChange(groupInfoV2, change);
    }

    Pair<DecryptedGroup, GroupChangeResponse> setAddMemberPermission(GroupInfoV2 groupInfoV2, GroupPermission permission) throws IOException {
        GroupsV2Operations.GroupOperations groupOperations = this.getGroupOperations(groupInfoV2);
        AccessControl.AccessRequired accessRequired = this.toAccessControl(permission);
        GroupChange.Actions.Builder change = groupOperations.createChangeMembershipRights(accessRequired);
        return this.commitChange(groupInfoV2, change);
    }

    Pair<DecryptedGroup, GroupChangeResponse> updateSelfProfileKey(GroupInfoV2 groupInfoV2) throws IOException {
        Optional selfInGroup;
        Optional optional = selfInGroup = groupInfoV2.getGroup() == null ? Optional.empty() : DecryptedGroupUtil.findMemberByAci((Collection)groupInfoV2.getGroup().members, (ServiceId.ACI)this.getSelfAci());
        if (selfInGroup.isEmpty()) {
            logger.trace("Not updating group, self not in group " + groupInfoV2.getGroupId().toBase64());
            return null;
        }
        ProfileKey profileKey = this.context.getAccount().getProfileKey();
        if (Arrays.equals(profileKey.serialize(), ((DecryptedMember)selfInGroup.get()).profileKey.toByteArray())) {
            logger.trace("Not updating group, own Profile Key is already up to date in group " + groupInfoV2.getGroupId().toBase64());
            return null;
        }
        logger.debug("Updating own profile key in group " + groupInfoV2.getGroupId().toBase64());
        RecipientId selfRecipientId = this.context.getAccount().getSelfRecipientId();
        ExpiringProfileKeyCredential profileKeyCredential = this.context.getProfileHelper().getExpiringProfileKeyCredential(selfRecipientId);
        if (profileKeyCredential == null) {
            logger.trace("Cannot update profile key as self does not have a versioned profile");
            return null;
        }
        GroupsV2Operations.GroupOperations groupOperations = this.getGroupOperations(groupInfoV2);
        GroupChange.Actions.Builder change = groupOperations.createUpdateProfileKeyCredentialChange(profileKeyCredential);
        change.sourceServiceId(this.getSelfAci().toByteString());
        return this.commitChange(groupInfoV2, change);
    }

    GroupChangeResponse joinGroup(GroupMasterKey groupMasterKey, GroupLinkPassword groupLinkPassword, DecryptedGroupJoinInfo decryptedGroupJoinInfo) throws IOException {
        GroupSecretParams groupSecretParams = GroupSecretParams.deriveFromMasterKey((GroupMasterKey)groupMasterKey);
        GroupsV2Operations.GroupOperations groupOperations = this.dependencies.getGroupsV2Operations().forGroup(groupSecretParams);
        RecipientId selfRecipientId = this.context.getAccount().getSelfRecipientId();
        ExpiringProfileKeyCredential profileKeyCredential = this.context.getProfileHelper().getExpiringProfileKeyCredential(selfRecipientId);
        if (profileKeyCredential == null) {
            throw new IOException("Cannot join a V2 group as self does not have a versioned profile");
        }
        boolean requestToJoin = decryptedGroupJoinInfo.addFromInviteLink == AccessControl.AccessRequired.ADMINISTRATOR;
        GroupChange.Actions.Builder change = requestToJoin ? groupOperations.createGroupJoinRequest(profileKeyCredential) : groupOperations.createGroupJoinDirect(profileKeyCredential);
        change.sourceServiceId(this.context.getRecipientHelper().resolveSignalServiceAddress(selfRecipientId).getServiceId().toByteString());
        return this.commitChange(groupSecretParams, decryptedGroupJoinInfo.revision, change, groupLinkPassword);
    }

    Pair<DecryptedGroup, GroupChangeResponse> acceptInvite(GroupInfoV2 groupInfoV2) throws IOException {
        GroupsV2Operations.GroupOperations groupOperations = this.getGroupOperations(groupInfoV2);
        RecipientId selfRecipientId = this.context.getAccount().getSelfRecipientId();
        ExpiringProfileKeyCredential profileKeyCredential = this.context.getProfileHelper().getExpiringProfileKeyCredential(selfRecipientId);
        if (profileKeyCredential == null) {
            throw new IOException("Cannot join a V2 group as self does not have a versioned profile");
        }
        GroupChange.Actions.Builder change = groupOperations.createAcceptInviteChange(profileKeyCredential);
        ServiceId aci = this.context.getRecipientHelper().resolveSignalServiceAddress(selfRecipientId).getServiceId();
        change.sourceServiceId(aci.toByteString());
        return this.commitChange(groupInfoV2, change);
    }

    Pair<DecryptedGroup, GroupChangeResponse> setMemberAdmin(GroupInfoV2 groupInfoV2, RecipientId recipientId, boolean admin) throws IOException {
        GroupsV2Operations.GroupOperations groupOperations = this.getGroupOperations(groupInfoV2);
        SignalServiceAddress address = this.context.getRecipientHelper().resolveSignalServiceAddress(recipientId);
        Member.Role newRole = admin ? Member.Role.ADMINISTRATOR : Member.Role.DEFAULT;
        ServiceId serviceId = address.getServiceId();
        if (serviceId instanceof ServiceId.ACI) {
            ServiceId.ACI aci = (ServiceId.ACI)serviceId;
            GroupChange.Actions.Builder change = groupOperations.createChangeMemberRole(aci, newRole);
            return this.commitChange(groupInfoV2, change);
        }
        throw new IllegalArgumentException("Can't make a PNI a group admin.");
    }

    Pair<DecryptedGroup, GroupChangeResponse> setMessageExpirationTimer(GroupInfoV2 groupInfoV2, int messageExpirationTimer) throws IOException {
        GroupsV2Operations.GroupOperations groupOperations = this.getGroupOperations(groupInfoV2);
        GroupChange.Actions.Builder change = groupOperations.createModifyGroupTimerChange(messageExpirationTimer);
        return this.commitChange(groupInfoV2, change);
    }

    Pair<DecryptedGroup, GroupChangeResponse> setIsAnnouncementGroup(GroupInfoV2 groupInfoV2, boolean isAnnouncementGroup) throws IOException {
        GroupsV2Operations.GroupOperations groupOperations = this.getGroupOperations(groupInfoV2);
        GroupChange.Actions.Builder change = groupOperations.createAnnouncementGroupChange(isAnnouncementGroup);
        return this.commitChange(groupInfoV2, change);
    }

    private AccessControl.AccessRequired toAccessControl(GroupLinkState state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case GroupLinkState.DISABLED -> AccessControl.AccessRequired.UNSATISFIABLE;
            case GroupLinkState.ENABLED -> AccessControl.AccessRequired.ANY;
            case GroupLinkState.ENABLED_WITH_APPROVAL -> AccessControl.AccessRequired.ADMINISTRATOR;
        };
    }

    private AccessControl.AccessRequired toAccessControl(GroupPermission permission) {
        return switch (permission) {
            default -> throw new MatchException(null, null);
            case GroupPermission.EVERY_MEMBER -> AccessControl.AccessRequired.MEMBER;
            case GroupPermission.ONLY_ADMINS -> AccessControl.AccessRequired.ADMINISTRATOR;
        };
    }

    private GroupsV2Operations.GroupOperations getGroupOperations(GroupInfoV2 groupInfoV2) {
        GroupSecretParams groupSecretParams = GroupSecretParams.deriveFromMasterKey((GroupMasterKey)groupInfoV2.getMasterKey());
        return this.dependencies.getGroupsV2Operations().forGroup(groupSecretParams);
    }

    private Pair<DecryptedGroup, GroupChangeResponse> revokeInvites(GroupInfoV2 groupInfoV2, Set<DecryptedPendingMember> pendingMembers) throws IOException {
        GroupsV2Operations.GroupOperations groupOperations = this.getGroupOperations(groupInfoV2);
        Set uuidCipherTexts = pendingMembers.stream().map(member -> {
            try {
                return new UuidCiphertext(member.serviceIdCipherText.toByteArray());
            }
            catch (InvalidInputException e) {
                throw new AssertionError((Object)e);
            }
        }).collect(Collectors.toSet());
        return this.commitChange(groupInfoV2, groupOperations.createRemoveInvitationChange(uuidCipherTexts));
    }

    private Pair<DecryptedGroup, GroupChangeResponse> approveJoinRequest(GroupInfoV2 groupInfoV2, Set<UUID> uuids) throws IOException {
        GroupsV2Operations.GroupOperations groupOperations = this.getGroupOperations(groupInfoV2);
        return this.commitChange(groupInfoV2, groupOperations.createApproveGroupJoinRequest(uuids));
    }

    private Pair<DecryptedGroup, GroupChangeResponse> refuseJoinRequest(GroupInfoV2 groupInfoV2, Set<ServiceId> serviceIds) throws IOException {
        GroupsV2Operations.GroupOperations groupOperations = this.getGroupOperations(groupInfoV2);
        return this.commitChange(groupInfoV2, groupOperations.createRefuseGroupJoinRequest(serviceIds, false, List.of()));
    }

    private Pair<DecryptedGroup, GroupChangeResponse> ejectMembers(GroupInfoV2 groupInfoV2, Set<ServiceId.ACI> members) throws IOException {
        GroupsV2Operations.GroupOperations groupOperations = this.getGroupOperations(groupInfoV2);
        return this.commitChange(groupInfoV2, groupOperations.createRemoveMembersChange(members, false, List.of()));
    }

    private Pair<DecryptedGroup, GroupChangeResponse> commitChange(GroupInfoV2 groupInfoV2, GroupChange.Actions.Builder change) throws IOException {
        DecryptedGroup decryptedGroupState;
        GroupSecretParams groupSecretParams = GroupSecretParams.deriveFromMasterKey((GroupMasterKey)groupInfoV2.getMasterKey());
        GroupsV2Operations.GroupOperations groupOperations = this.dependencies.getGroupsV2Operations().forGroup(groupSecretParams);
        DecryptedGroup previousGroupState = groupInfoV2.getGroup();
        int nextRevision = previousGroupState.revision + 1;
        GroupChange.Actions changeActions = change.revision(nextRevision).build();
        try {
            DecryptedGroupChange decryptedChange = groupOperations.decryptChange(changeActions, (ServiceId)this.getSelfAci());
            decryptedGroupState = DecryptedGroupUtil.apply((DecryptedGroup)previousGroupState, (DecryptedGroupChange)decryptedChange);
        }
        catch (VerificationFailedException | InvalidGroupStateException | NotAbleToApplyGroupV2ChangeException e) {
            throw new IOException(e);
        }
        GroupChangeResponse signedGroupChange = this.dependencies.getGroupsV2Api().patchGroup(changeActions, this.getGroupAuthForToday(groupSecretParams), Optional.empty());
        groupInfoV2.setGroup(decryptedGroupState);
        return new Pair<DecryptedGroup, GroupChangeResponse>(decryptedGroupState, signedGroupChange);
    }

    private GroupChangeResponse commitChange(GroupSecretParams groupSecretParams, int currentRevision, GroupChange.Actions.Builder change, GroupLinkPassword password) throws IOException {
        int nextRevision = currentRevision + 1;
        GroupChange.Actions changeActions = change.revision(nextRevision).build();
        return this.dependencies.getGroupsV2Api().patchGroup(changeActions, this.getGroupAuthForToday(groupSecretParams), Optional.ofNullable(password).map(GroupLinkPassword::serialize));
    }

    Pair<ServiceId, ProfileKey> getAuthoritativeProfileKeyFromChange(DecryptedGroupChange change) {
        ProfileKey profileKey;
        UUID editor = UuidUtil.fromByteStringOrNull((ByteString)change.editorServiceIdBytes);
        Optional<ByteString> editorProfileKeyBytes = Stream.concat(Stream.of(change.newMembers.stream(), change.promotePendingMembers.stream(), change.modifiedProfileKeys.stream()).flatMap(Function.identity()).filter(m -> UuidUtil.fromByteString((ByteString)m.aciBytes).equals(editor)).map(m -> m.profileKey), change.newRequestingMembers.stream().filter(m -> UuidUtil.fromByteString((ByteString)m.aciBytes).equals(editor)).map(m -> m.profileKey)).findFirst();
        if (editorProfileKeyBytes.isEmpty()) {
            return null;
        }
        try {
            profileKey = new ProfileKey(editorProfileKeyBytes.get().toByteArray());
        }
        catch (InvalidInputException e) {
            logger.debug("Bad profile key in group");
            return null;
        }
        return new Pair<ServiceId.ACI, ProfileKey>(ServiceId.ACI.from((UUID)editor), profileKey);
    }

    DecryptedGroup getUpdatedDecryptedGroup(DecryptedGroup group, DecryptedGroupChange decryptedGroupChange) {
        try {
            return DecryptedGroupUtil.apply((DecryptedGroup)group, (DecryptedGroupChange)decryptedGroupChange);
        }
        catch (NotAbleToApplyGroupV2ChangeException e) {
            return null;
        }
    }

    DecryptedGroupChange getDecryptedGroupChange(byte[] signedGroupChange, GroupMasterKey groupMasterKey) {
        if (signedGroupChange != null) {
            GroupsV2Operations.GroupOperations groupOperations = this.dependencies.getGroupsV2Operations().forGroup(GroupSecretParams.deriveFromMasterKey((GroupMasterKey)groupMasterKey));
            try {
                return groupOperations.decryptChange((GroupChange)GroupChange.ADAPTER.decode(signedGroupChange), true).orElse(null);
            }
            catch (IOException | VerificationFailedException | InvalidGroupStateException e) {
                return null;
            }
        }
        return null;
    }

    private static long currentDaySeconds() {
        return TimeUnit.DAYS.toSeconds(TimeUnit.MILLISECONDS.toDays(System.currentTimeMillis()));
    }

    private GroupsV2AuthorizationString getGroupAuthForToday(GroupSecretParams groupSecretParams) throws IOException {
        long todaySeconds = GroupV2Helper.currentDaySeconds();
        if (this.groupApiCredentials == null || !this.groupApiCredentials.containsKey(todaySeconds)) {
            this.groupApiCredentials = this.dependencies.getGroupsV2Api().getCredentials(todaySeconds).getAuthCredentialWithPniResponseHashMap();
        }
        try {
            return this.getAuthorizationString(groupSecretParams, todaySeconds);
        }
        catch (VerificationFailedException e) {
            logger.debug("Group api credentials invalid, renewing and trying again.");
            this.groupApiCredentials.clear();
            this.groupApiCredentials = this.dependencies.getGroupsV2Api().getCredentials(todaySeconds).getAuthCredentialWithPniResponseHashMap();
            try {
                return this.getAuthorizationString(groupSecretParams, todaySeconds);
            }
            catch (VerificationFailedException e2) {
                throw new IOException(e2);
            }
        }
    }

    private GroupsV2AuthorizationString getAuthorizationString(GroupSecretParams groupSecretParams, long todaySeconds) throws VerificationFailedException {
        AuthCredentialWithPniResponse authCredentialResponse = this.groupApiCredentials.get(todaySeconds);
        ServiceId.ACI aci = this.getSelfAci();
        ServiceId.PNI pni = this.getSelfPni();
        return this.dependencies.getGroupsV2Api().getGroupsV2AuthorizationString(aci, pni, todaySeconds, groupSecretParams, authCredentialResponse);
    }

    private ServiceId.ACI getSelfAci() {
        return this.context.getAccount().getAci();
    }

    private ServiceId.PNI getSelfPni() {
        return this.context.getAccount().getPni();
    }
}

