/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.syncStorage;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Optional;
import org.asamk.signal.manager.api.GroupIdV2;
import org.asamk.signal.manager.groups.GroupUtils;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.storage.groups.GroupInfoV2;
import org.asamk.signal.manager.syncStorage.DefaultStorageRecordProcessor;
import org.asamk.signal.manager.syncStorage.StorageRecordUpdate;
import org.asamk.signal.manager.syncStorage.StorageSyncModels;
import org.asamk.signal.manager.util.KeyUtils;
import org.signal.libsignal.zkgroup.groups.GroupMasterKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.storage.SignalGroupV2Record;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.internal.storage.protos.GroupV2Record;

public final class GroupV2RecordProcessor
extends DefaultStorageRecordProcessor<SignalGroupV2Record> {
    private static final Logger logger = LoggerFactory.getLogger(GroupV2RecordProcessor.class);
    private final SignalAccount account;
    private final Connection connection;

    public GroupV2RecordProcessor(SignalAccount account, Connection connection) {
        this.account = account;
        this.connection = connection;
    }

    @Override
    protected boolean isInvalid(SignalGroupV2Record remote) {
        return remote.getMasterKeyBytes().length != 32;
    }

    @Override
    protected Optional<SignalGroupV2Record> getMatching(SignalGroupV2Record remote) throws SQLException {
        GroupIdV2 id = GroupUtils.getGroupIdV2(remote.getMasterKeyOrThrow());
        GroupInfoV2 group = this.account.getGroupStore().getGroup(this.connection, id);
        if (group == null) {
            return Optional.empty();
        }
        StorageId storageId = this.account.getGroupStore().getGroupStorageId(this.connection, id);
        return Optional.of((SignalGroupV2Record)StorageSyncModels.localToRemoteRecord(group, storageId.getRaw()).getGroupV2().get());
    }

    @Override
    protected SignalGroupV2Record merge(SignalGroupV2Record remote, SignalGroupV2Record local) {
        byte[] unknownFields = remote.serializeUnknownFields();
        boolean blocked = remote.isBlocked();
        boolean profileSharing = remote.isProfileSharingEnabled();
        boolean archived = remote.isArchived();
        boolean forcedUnread = remote.isForcedUnread();
        long muteUntil = remote.getMuteUntil();
        boolean notifyForMentionsWhenMuted = remote.notifyForMentionsWhenMuted();
        boolean hideStory = remote.shouldHideStory();
        GroupV2Record.StorySendMode storySendMode = remote.getStorySendMode();
        SignalGroupV2Record.Builder mergedBuilder = new SignalGroupV2Record.Builder(remote.getId().getRaw(), remote.getMasterKeyBytes(), unknownFields).setBlocked(blocked).setProfileSharingEnabled(profileSharing).setArchived(archived).setForcedUnread(forcedUnread).setMuteUntil(muteUntil).setNotifyForMentionsWhenMuted(notifyForMentionsWhenMuted).setHideStory(hideStory).setStorySendMode(storySendMode);
        SignalGroupV2Record merged = mergedBuilder.build();
        boolean matchesRemote = GroupV2RecordProcessor.doProtosMatch(merged, remote);
        if (matchesRemote) {
            return remote;
        }
        boolean matchesLocal = GroupV2RecordProcessor.doProtosMatch(merged, local);
        if (matchesLocal) {
            return local;
        }
        return mergedBuilder.setId(KeyUtils.createRawStorageId()).build();
    }

    @Override
    protected void insertLocal(SignalGroupV2Record record) throws SQLException {
        StorageRecordUpdate<SignalGroupV2Record> update = new StorageRecordUpdate<SignalGroupV2Record>(null, record);
        this.updateLocal(update);
    }

    @Override
    protected void updateLocal(StorageRecordUpdate<SignalGroupV2Record> update) throws SQLException {
        SignalGroupV2Record groupV2Record = update.newRecord();
        GroupMasterKey groupMasterKey = groupV2Record.getMasterKeyOrThrow();
        GroupInfoV2 group = this.account.getGroupStore().getGroupOrPartialMigrate(this.connection, groupMasterKey);
        group.setBlocked(groupV2Record.isBlocked());
        group.setProfileSharingEnabled(groupV2Record.isProfileSharingEnabled());
        this.account.getGroupStore().updateGroup(this.connection, group);
        this.account.getGroupStore().storeStorageRecord(this.connection, group.getGroupId(), groupV2Record.getId(), groupV2Record.toProto().encode());
    }

    @Override
    public int compare(SignalGroupV2Record lhs, SignalGroupV2Record rhs) {
        if (Arrays.equals(lhs.getMasterKeyBytes(), rhs.getMasterKeyBytes())) {
            return 0;
        }
        return 1;
    }

    private static boolean doProtosMatch(SignalGroupV2Record merged, SignalGroupV2Record other) {
        return Arrays.equals(merged.toProto().encode(), other.toProto().encode());
    }
}

