package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SuspendDtsJob invokes the dts.SuspendDtsJob API synchronously
func (client *Client) SuspendDtsJob(request *SuspendDtsJobRequest) (response *SuspendDtsJobResponse, err error) {
	response = CreateSuspendDtsJobResponse()
	err = client.DoAction(request, response)
	return
}

// SuspendDtsJobWithChan invokes the dts.SuspendDtsJob API asynchronously
func (client *Client) SuspendDtsJobWithChan(request *SuspendDtsJobRequest) (<-chan *SuspendDtsJobResponse, <-chan error) {
	responseChan := make(chan *SuspendDtsJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SuspendDtsJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SuspendDtsJobWithCallback invokes the dts.SuspendDtsJob API asynchronously
func (client *Client) SuspendDtsJobWithCallback(request *SuspendDtsJobRequest, callback func(response *SuspendDtsJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SuspendDtsJobResponse
		var err error
		defer close(result)
		response, err = client.SuspendDtsJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SuspendDtsJobRequest is the request struct for api SuspendDtsJob
type SuspendDtsJobRequest struct {
	*requests.RpcRequest
	DtsJobId                 string `position:"Query" name:"DtsJobId"`
	DtsInstanceId            string `position:"Query" name:"DtsInstanceId"`
	SynchronizationDirection string `position:"Query" name:"SynchronizationDirection"`
}

// SuspendDtsJobResponse is the response struct for api SuspendDtsJob
type SuspendDtsJobResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrCode        string `json:"ErrCode" xml:"ErrCode"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrMessage     string `json:"ErrMessage" xml:"ErrMessage"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
}

// CreateSuspendDtsJobRequest creates a request to invoke SuspendDtsJob API
func CreateSuspendDtsJobRequest() (request *SuspendDtsJobRequest) {
	request = &SuspendDtsJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "SuspendDtsJob", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSuspendDtsJobResponse creates a response to parse from SuspendDtsJob response
func CreateSuspendDtsJobResponse() (response *SuspendDtsJobResponse) {
	response = &SuspendDtsJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
