//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfbit?language=objc)
pub type CFBit = u32;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfbitvector?language=objc)
#[repr(C)]
pub struct CFBitVector {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFBitVector {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFBitVector"> for CFBitVector {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfmutablebitvector?language=objc)
#[repr(C)]
pub struct CFMutableBitVector {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFMutableBitVector: CFBitVector {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFBitVector"> for CFMutableBitVector {}
);

unsafe impl ConcreteType for CFBitVector {
    #[doc(alias = "CFBitVectorGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFBitVectorGetTypeID() -> CFTypeID;
        }
        unsafe { CFBitVectorGetTypeID() }
    }
}

impl CFBitVector {
    #[doc(alias = "CFBitVectorCreate")]
    #[inline]
    pub unsafe fn new(
        allocator: Option<&CFAllocator>,
        bytes: *const u8,
        num_bits: CFIndex,
    ) -> Option<CFRetained<CFBitVector>> {
        extern "C-unwind" {
            fn CFBitVectorCreate(
                allocator: Option<&CFAllocator>,
                bytes: *const u8,
                num_bits: CFIndex,
            ) -> Option<NonNull<CFBitVector>>;
        }
        let ret = unsafe { CFBitVectorCreate(allocator, bytes, num_bits) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFBitVectorCreateCopy")]
    #[inline]
    pub unsafe fn new_copy(
        allocator: Option<&CFAllocator>,
        bv: Option<&CFBitVector>,
    ) -> Option<CFRetained<CFBitVector>> {
        extern "C-unwind" {
            fn CFBitVectorCreateCopy(
                allocator: Option<&CFAllocator>,
                bv: Option<&CFBitVector>,
            ) -> Option<NonNull<CFBitVector>>;
        }
        let ret = unsafe { CFBitVectorCreateCopy(allocator, bv) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

impl CFMutableBitVector {
    #[doc(alias = "CFBitVectorCreateMutable")]
    #[inline]
    pub unsafe fn new(
        allocator: Option<&CFAllocator>,
        capacity: CFIndex,
    ) -> Option<CFRetained<CFMutableBitVector>> {
        extern "C-unwind" {
            fn CFBitVectorCreateMutable(
                allocator: Option<&CFAllocator>,
                capacity: CFIndex,
            ) -> Option<NonNull<CFMutableBitVector>>;
        }
        let ret = unsafe { CFBitVectorCreateMutable(allocator, capacity) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFBitVectorCreateMutableCopy")]
    #[inline]
    pub unsafe fn new_copy(
        allocator: Option<&CFAllocator>,
        capacity: CFIndex,
        bv: Option<&CFBitVector>,
    ) -> Option<CFRetained<CFMutableBitVector>> {
        extern "C-unwind" {
            fn CFBitVectorCreateMutableCopy(
                allocator: Option<&CFAllocator>,
                capacity: CFIndex,
                bv: Option<&CFBitVector>,
            ) -> Option<NonNull<CFMutableBitVector>>;
        }
        let ret = unsafe { CFBitVectorCreateMutableCopy(allocator, capacity, bv) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

impl CFBitVector {
    #[doc(alias = "CFBitVectorGetCount")]
    #[inline]
    pub unsafe fn count(self: &CFBitVector) -> CFIndex {
        extern "C-unwind" {
            fn CFBitVectorGetCount(bv: &CFBitVector) -> CFIndex;
        }
        unsafe { CFBitVectorGetCount(self) }
    }

    #[doc(alias = "CFBitVectorGetCountOfBit")]
    #[inline]
    pub unsafe fn count_of_bit(self: &CFBitVector, range: CFRange, value: CFBit) -> CFIndex {
        extern "C-unwind" {
            fn CFBitVectorGetCountOfBit(bv: &CFBitVector, range: CFRange, value: CFBit) -> CFIndex;
        }
        unsafe { CFBitVectorGetCountOfBit(self, range, value) }
    }

    #[doc(alias = "CFBitVectorContainsBit")]
    #[inline]
    pub unsafe fn contains_bit(self: &CFBitVector, range: CFRange, value: CFBit) -> bool {
        extern "C-unwind" {
            fn CFBitVectorContainsBit(bv: &CFBitVector, range: CFRange, value: CFBit) -> Boolean;
        }
        let ret = unsafe { CFBitVectorContainsBit(self, range, value) };
        ret != 0
    }

    #[doc(alias = "CFBitVectorGetBitAtIndex")]
    #[inline]
    pub unsafe fn bit_at_index(self: &CFBitVector, idx: CFIndex) -> CFBit {
        extern "C-unwind" {
            fn CFBitVectorGetBitAtIndex(bv: &CFBitVector, idx: CFIndex) -> CFBit;
        }
        unsafe { CFBitVectorGetBitAtIndex(self, idx) }
    }

    #[doc(alias = "CFBitVectorGetBits")]
    #[inline]
    pub unsafe fn bits(self: &CFBitVector, range: CFRange, bytes: *mut u8) {
        extern "C-unwind" {
            fn CFBitVectorGetBits(bv: &CFBitVector, range: CFRange, bytes: *mut u8);
        }
        unsafe { CFBitVectorGetBits(self, range, bytes) }
    }

    #[doc(alias = "CFBitVectorGetFirstIndexOfBit")]
    #[inline]
    pub unsafe fn first_index_of_bit(self: &CFBitVector, range: CFRange, value: CFBit) -> CFIndex {
        extern "C-unwind" {
            fn CFBitVectorGetFirstIndexOfBit(
                bv: &CFBitVector,
                range: CFRange,
                value: CFBit,
            ) -> CFIndex;
        }
        unsafe { CFBitVectorGetFirstIndexOfBit(self, range, value) }
    }

    #[doc(alias = "CFBitVectorGetLastIndexOfBit")]
    #[inline]
    pub unsafe fn last_index_of_bit(self: &CFBitVector, range: CFRange, value: CFBit) -> CFIndex {
        extern "C-unwind" {
            fn CFBitVectorGetLastIndexOfBit(
                bv: &CFBitVector,
                range: CFRange,
                value: CFBit,
            ) -> CFIndex;
        }
        unsafe { CFBitVectorGetLastIndexOfBit(self, range, value) }
    }
}

impl CFMutableBitVector {
    #[doc(alias = "CFBitVectorSetCount")]
    #[inline]
    pub unsafe fn set_count(bv: Option<&CFMutableBitVector>, count: CFIndex) {
        extern "C-unwind" {
            fn CFBitVectorSetCount(bv: Option<&CFMutableBitVector>, count: CFIndex);
        }
        unsafe { CFBitVectorSetCount(bv, count) }
    }

    #[doc(alias = "CFBitVectorFlipBitAtIndex")]
    #[inline]
    pub unsafe fn flip_bit_at_index(bv: Option<&CFMutableBitVector>, idx: CFIndex) {
        extern "C-unwind" {
            fn CFBitVectorFlipBitAtIndex(bv: Option<&CFMutableBitVector>, idx: CFIndex);
        }
        unsafe { CFBitVectorFlipBitAtIndex(bv, idx) }
    }

    #[doc(alias = "CFBitVectorFlipBits")]
    #[inline]
    pub unsafe fn flip_bits(bv: Option<&CFMutableBitVector>, range: CFRange) {
        extern "C-unwind" {
            fn CFBitVectorFlipBits(bv: Option<&CFMutableBitVector>, range: CFRange);
        }
        unsafe { CFBitVectorFlipBits(bv, range) }
    }

    #[doc(alias = "CFBitVectorSetBitAtIndex")]
    #[inline]
    pub unsafe fn set_bit_at_index(bv: Option<&CFMutableBitVector>, idx: CFIndex, value: CFBit) {
        extern "C-unwind" {
            fn CFBitVectorSetBitAtIndex(
                bv: Option<&CFMutableBitVector>,
                idx: CFIndex,
                value: CFBit,
            );
        }
        unsafe { CFBitVectorSetBitAtIndex(bv, idx, value) }
    }

    #[doc(alias = "CFBitVectorSetBits")]
    #[inline]
    pub unsafe fn set_bits(bv: Option<&CFMutableBitVector>, range: CFRange, value: CFBit) {
        extern "C-unwind" {
            fn CFBitVectorSetBits(bv: Option<&CFMutableBitVector>, range: CFRange, value: CFBit);
        }
        unsafe { CFBitVectorSetBits(bv, range, value) }
    }

    #[doc(alias = "CFBitVectorSetAllBits")]
    #[inline]
    pub unsafe fn set_all_bits(bv: Option<&CFMutableBitVector>, value: CFBit) {
        extern "C-unwind" {
            fn CFBitVectorSetAllBits(bv: Option<&CFMutableBitVector>, value: CFBit);
        }
        unsafe { CFBitVectorSetAllBits(bv, value) }
    }
}

#[deprecated = "renamed to `CFBitVector::new`"]
#[inline]
pub unsafe extern "C-unwind" fn CFBitVectorCreate(
    allocator: Option<&CFAllocator>,
    bytes: *const u8,
    num_bits: CFIndex,
) -> Option<CFRetained<CFBitVector>> {
    extern "C-unwind" {
        fn CFBitVectorCreate(
            allocator: Option<&CFAllocator>,
            bytes: *const u8,
            num_bits: CFIndex,
        ) -> Option<NonNull<CFBitVector>>;
    }
    let ret = unsafe { CFBitVectorCreate(allocator, bytes, num_bits) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFBitVector::new_copy`"]
#[inline]
pub unsafe extern "C-unwind" fn CFBitVectorCreateCopy(
    allocator: Option<&CFAllocator>,
    bv: Option<&CFBitVector>,
) -> Option<CFRetained<CFBitVector>> {
    extern "C-unwind" {
        fn CFBitVectorCreateCopy(
            allocator: Option<&CFAllocator>,
            bv: Option<&CFBitVector>,
        ) -> Option<NonNull<CFBitVector>>;
    }
    let ret = unsafe { CFBitVectorCreateCopy(allocator, bv) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFMutableBitVector::new`"]
#[inline]
pub unsafe extern "C-unwind" fn CFBitVectorCreateMutable(
    allocator: Option<&CFAllocator>,
    capacity: CFIndex,
) -> Option<CFRetained<CFMutableBitVector>> {
    extern "C-unwind" {
        fn CFBitVectorCreateMutable(
            allocator: Option<&CFAllocator>,
            capacity: CFIndex,
        ) -> Option<NonNull<CFMutableBitVector>>;
    }
    let ret = unsafe { CFBitVectorCreateMutable(allocator, capacity) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFMutableBitVector::new_copy`"]
#[inline]
pub unsafe extern "C-unwind" fn CFBitVectorCreateMutableCopy(
    allocator: Option<&CFAllocator>,
    capacity: CFIndex,
    bv: Option<&CFBitVector>,
) -> Option<CFRetained<CFMutableBitVector>> {
    extern "C-unwind" {
        fn CFBitVectorCreateMutableCopy(
            allocator: Option<&CFAllocator>,
            capacity: CFIndex,
            bv: Option<&CFBitVector>,
        ) -> Option<NonNull<CFMutableBitVector>>;
    }
    let ret = unsafe { CFBitVectorCreateMutableCopy(allocator, capacity, bv) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFBitVector::count`"]
    pub fn CFBitVectorGetCount(bv: &CFBitVector) -> CFIndex;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFBitVector::count_of_bit`"]
    pub fn CFBitVectorGetCountOfBit(bv: &CFBitVector, range: CFRange, value: CFBit) -> CFIndex;
}

#[deprecated = "renamed to `CFBitVector::contains_bit`"]
#[inline]
pub unsafe extern "C-unwind" fn CFBitVectorContainsBit(
    bv: &CFBitVector,
    range: CFRange,
    value: CFBit,
) -> bool {
    extern "C-unwind" {
        fn CFBitVectorContainsBit(bv: &CFBitVector, range: CFRange, value: CFBit) -> Boolean;
    }
    let ret = unsafe { CFBitVectorContainsBit(bv, range, value) };
    ret != 0
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFBitVector::bit_at_index`"]
    pub fn CFBitVectorGetBitAtIndex(bv: &CFBitVector, idx: CFIndex) -> CFBit;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFBitVector::bits`"]
    pub fn CFBitVectorGetBits(bv: &CFBitVector, range: CFRange, bytes: *mut u8);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFBitVector::first_index_of_bit`"]
    pub fn CFBitVectorGetFirstIndexOfBit(bv: &CFBitVector, range: CFRange, value: CFBit)
        -> CFIndex;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFBitVector::last_index_of_bit`"]
    pub fn CFBitVectorGetLastIndexOfBit(bv: &CFBitVector, range: CFRange, value: CFBit) -> CFIndex;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFMutableBitVector::set_count`"]
    pub fn CFBitVectorSetCount(bv: Option<&CFMutableBitVector>, count: CFIndex);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFMutableBitVector::flip_bit_at_index`"]
    pub fn CFBitVectorFlipBitAtIndex(bv: Option<&CFMutableBitVector>, idx: CFIndex);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFMutableBitVector::flip_bits`"]
    pub fn CFBitVectorFlipBits(bv: Option<&CFMutableBitVector>, range: CFRange);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFMutableBitVector::set_bit_at_index`"]
    pub fn CFBitVectorSetBitAtIndex(bv: Option<&CFMutableBitVector>, idx: CFIndex, value: CFBit);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFMutableBitVector::set_bits`"]
    pub fn CFBitVectorSetBits(bv: Option<&CFMutableBitVector>, range: CFRange, value: CFBit);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFMutableBitVector::set_all_bits`"]
    pub fn CFBitVectorSetAllBits(bv: Option<&CFMutableBitVector>, value: CFBit);
}
