# Updating the PyOpenGL Extensions from Khronos

Most of PyOpenGL is generated from the Khronos XML definitions published
in the official [registry](https://github.com/KhronosGroup/OpenGL-Registry.git) on github.

To regenerate and update the modules, we do the following:
```
cd src
./xml_generate.py
```
which will clone and/or update the local checkout of the Khronos
registry and then parse the source XML files to decide what to 
generate in the `OpenGL/raw` hierarchy of PyOpenGL.

## Updating Secondary Definitions

Many OpenGL arrays and parameters have defined, but not formally
specified connections between their arguments, so a given flag
may mean that another parameter must have a specific size or
type. PyOpenGL implements these in wrapper functions which are
maintained in the `OpenGL/$API` hierarchies.

These modules generally have an autogenerated prefix, then some
manually maintained/tweaked bits that fill in information that
the autogeneration couldn't catch.