// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: generator/integration_tests/test_request_id.proto

#ifndef GOOGLE_CLOUD_CPP_GENERATOR_INTEGRATION_TESTS_GOLDEN_V1_INTERNAL_REQUEST_ID_TRACING_STUB_H
#define GOOGLE_CLOUD_CPP_GENERATOR_INTEGRATION_TESTS_GOLDEN_V1_INTERNAL_REQUEST_ID_TRACING_STUB_H

#include "generator/integration_tests/golden/v1/internal/request_id_stub.h"
#include "google/cloud/internal/trace_propagator.h"
#include "google/cloud/options.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace golden_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class RequestIdServiceTracingStub : public RequestIdServiceStub {
 public:
  ~RequestIdServiceTracingStub() override = default;

  explicit RequestIdServiceTracingStub(std::shared_ptr<RequestIdServiceStub> child);

  StatusOr<google::test::requestid::v1::Foo> CreateFoo(
      grpc::ClientContext& context,
      Options const& options,
      google::test::requestid::v1::CreateFooRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncRenameFoo(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::test::requestid::v1::RenameFooRequest const& request) override;

  StatusOr<google::longrunning::Operation> RenameFoo(
      grpc::ClientContext& context,
      Options options,
      google::test::requestid::v1::RenameFooRequest const& request) override;

  StatusOr<google::test::requestid::v1::ListFoosResponse> ListFoos(
      grpc::ClientContext& context,
      Options const& options,
      google::test::requestid::v1::ListFoosRequest const& request) override;

  future<StatusOr<google::test::requestid::v1::Foo>> AsyncCreateFoo(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::test::requestid::v1::CreateFooRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::GetOperationRequest const& request) override;

  future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::shared_ptr<RequestIdServiceStub> child_;
  std::shared_ptr<opentelemetry::context::propagation::TextMapPropagator> propagator_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Applies the tracing decorator to the given stub.
 *
 * The stub is only decorated if the library has been compiled with
 * OpenTelemetry.
 */
std::shared_ptr<RequestIdServiceStub> MakeRequestIdServiceTracingStub(
    std::shared_ptr<RequestIdServiceStub> stub);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace golden_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GENERATOR_INTEGRATION_TESTS_GOLDEN_V1_INTERNAL_REQUEST_ID_TRACING_STUB_H
