// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/advisorynotifications/v1/service.proto

#include "google/cloud/advisorynotifications/v1/internal/advisory_notifications_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace advisorynotifications_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

AdvisoryNotificationsServiceTracingConnection::
    AdvisoryNotificationsServiceTracingConnection(
        std::shared_ptr<
            advisorynotifications_v1::AdvisoryNotificationsServiceConnection>
            child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::advisorynotifications::v1::Notification>
AdvisoryNotificationsServiceTracingConnection::ListNotifications(
    google::cloud::advisorynotifications::v1::ListNotificationsRequest
        request) {
  auto span = internal::MakeSpan(
      "advisorynotifications_v1::AdvisoryNotificationsServiceConnection::"
      "ListNotifications");
  internal::OTelScope scope(span);
  auto sr = child_->ListNotifications(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::advisorynotifications::v1::Notification>(std::move(span),
                                                              std::move(sr));
}

StatusOr<google::cloud::advisorynotifications::v1::Notification>
AdvisoryNotificationsServiceTracingConnection::GetNotification(
    google::cloud::advisorynotifications::v1::GetNotificationRequest const&
        request) {
  auto span = internal::MakeSpan(
      "advisorynotifications_v1::AdvisoryNotificationsServiceConnection::"
      "GetNotification");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetNotification(request));
}

StatusOr<google::cloud::advisorynotifications::v1::Settings>
AdvisoryNotificationsServiceTracingConnection::GetSettings(
    google::cloud::advisorynotifications::v1::GetSettingsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "advisorynotifications_v1::AdvisoryNotificationsServiceConnection::"
      "GetSettings");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetSettings(request));
}

StatusOr<google::cloud::advisorynotifications::v1::Settings>
AdvisoryNotificationsServiceTracingConnection::UpdateSettings(
    google::cloud::advisorynotifications::v1::UpdateSettingsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "advisorynotifications_v1::AdvisoryNotificationsServiceConnection::"
      "UpdateSettings");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateSettings(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<
    advisorynotifications_v1::AdvisoryNotificationsServiceConnection>
MakeAdvisoryNotificationsServiceTracingConnection(
    std::shared_ptr<
        advisorynotifications_v1::AdvisoryNotificationsServiceConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<AdvisoryNotificationsServiceTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace advisorynotifications_v1_internal
}  // namespace cloud
}  // namespace google
