// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/appengine/v1/appengine.proto

#include "google/cloud/appengine/v1/domain_mappings_connection.h"
#include "google/cloud/appengine/v1/domain_mappings_options.h"
#include "google/cloud/appengine/v1/internal/domain_mappings_connection_impl.h"
#include "google/cloud/appengine/v1/internal/domain_mappings_option_defaults.h"
#include "google/cloud/appengine/v1/internal/domain_mappings_stub_factory.h"
#include "google/cloud/appengine/v1/internal/domain_mappings_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace appengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DomainMappingsConnection::~DomainMappingsConnection() = default;

StreamRange<google::appengine::v1::DomainMapping>
DomainMappingsConnection::ListDomainMappings(
    google::appengine::v1::
        ListDomainMappingsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::appengine::v1::DomainMapping>>();
}

StatusOr<google::appengine::v1::DomainMapping>
DomainMappingsConnection::GetDomainMapping(
    google::appengine::v1::GetDomainMappingRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::appengine::v1::DomainMapping>>
DomainMappingsConnection::CreateDomainMapping(
    google::appengine::v1::CreateDomainMappingRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::appengine::v1::DomainMapping>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DomainMappingsConnection::CreateDomainMapping(
    NoAwaitTag, google::appengine::v1::CreateDomainMappingRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::appengine::v1::DomainMapping>>
DomainMappingsConnection::CreateDomainMapping(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::appengine::v1::DomainMapping>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::appengine::v1::DomainMapping>>
DomainMappingsConnection::UpdateDomainMapping(
    google::appengine::v1::UpdateDomainMappingRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::appengine::v1::DomainMapping>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DomainMappingsConnection::UpdateDomainMapping(
    NoAwaitTag, google::appengine::v1::UpdateDomainMappingRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::appengine::v1::DomainMapping>>
DomainMappingsConnection::UpdateDomainMapping(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::appengine::v1::DomainMapping>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::appengine::v1::OperationMetadataV1>>
DomainMappingsConnection::DeleteDomainMapping(
    google::appengine::v1::DeleteDomainMappingRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::appengine::v1::OperationMetadataV1>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DomainMappingsConnection::DeleteDomainMapping(
    NoAwaitTag, google::appengine::v1::DeleteDomainMappingRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::appengine::v1::OperationMetadataV1>>
DomainMappingsConnection::DeleteDomainMapping(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::appengine::v1::OperationMetadataV1>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<DomainMappingsConnection> MakeDomainMappingsConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 DomainMappingsPolicyOptionList>(options,
                                                                 __func__);
  options =
      appengine_v1_internal::DomainMappingsDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = appengine_v1_internal::CreateDefaultDomainMappingsStub(
      std::move(auth), options);
  return appengine_v1_internal::MakeDomainMappingsTracingConnection(
      std::make_shared<appengine_v1_internal::DomainMappingsConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace appengine_v1
}  // namespace cloud
}  // namespace google
