// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/datapolicies/v1/datapolicy.proto

#include "google/cloud/bigquery/datapolicies/v1/data_policy_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace bigquery_datapolicies_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DataPolicyServiceClient::DataPolicyServiceClient(
    std::shared_ptr<DataPolicyServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
DataPolicyServiceClient::~DataPolicyServiceClient() = default;

StatusOr<google::cloud::bigquery::datapolicies::v1::DataPolicy>
DataPolicyServiceClient::CreateDataPolicy(
    std::string const& parent,
    google::cloud::bigquery::datapolicies::v1::DataPolicy const& data_policy,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::datapolicies::v1::CreateDataPolicyRequest request;
  request.set_parent(parent);
  *request.mutable_data_policy() = data_policy;
  return connection_->CreateDataPolicy(request);
}

StatusOr<google::cloud::bigquery::datapolicies::v1::DataPolicy>
DataPolicyServiceClient::CreateDataPolicy(
    google::cloud::bigquery::datapolicies::v1::CreateDataPolicyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDataPolicy(request);
}

StatusOr<google::cloud::bigquery::datapolicies::v1::DataPolicy>
DataPolicyServiceClient::UpdateDataPolicy(
    google::cloud::bigquery::datapolicies::v1::DataPolicy const& data_policy,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::datapolicies::v1::UpdateDataPolicyRequest request;
  *request.mutable_data_policy() = data_policy;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateDataPolicy(request);
}

StatusOr<google::cloud::bigquery::datapolicies::v1::DataPolicy>
DataPolicyServiceClient::UpdateDataPolicy(
    google::cloud::bigquery::datapolicies::v1::UpdateDataPolicyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDataPolicy(request);
}

StatusOr<google::cloud::bigquery::datapolicies::v1::DataPolicy>
DataPolicyServiceClient::RenameDataPolicy(std::string const& name,
                                          std::string const& new_data_policy_id,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::datapolicies::v1::RenameDataPolicyRequest request;
  request.set_name(name);
  request.set_new_data_policy_id(new_data_policy_id);
  return connection_->RenameDataPolicy(request);
}

StatusOr<google::cloud::bigquery::datapolicies::v1::DataPolicy>
DataPolicyServiceClient::RenameDataPolicy(
    google::cloud::bigquery::datapolicies::v1::RenameDataPolicyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RenameDataPolicy(request);
}

Status DataPolicyServiceClient::DeleteDataPolicy(std::string const& name,
                                                 Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::datapolicies::v1::DeleteDataPolicyRequest request;
  request.set_name(name);
  return connection_->DeleteDataPolicy(request);
}

Status DataPolicyServiceClient::DeleteDataPolicy(
    google::cloud::bigquery::datapolicies::v1::DeleteDataPolicyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDataPolicy(request);
}

StatusOr<google::cloud::bigquery::datapolicies::v1::DataPolicy>
DataPolicyServiceClient::GetDataPolicy(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::datapolicies::v1::GetDataPolicyRequest request;
  request.set_name(name);
  return connection_->GetDataPolicy(request);
}

StatusOr<google::cloud::bigquery::datapolicies::v1::DataPolicy>
DataPolicyServiceClient::GetDataPolicy(
    google::cloud::bigquery::datapolicies::v1::GetDataPolicyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetDataPolicy(request);
}

StreamRange<google::cloud::bigquery::datapolicies::v1::DataPolicy>
DataPolicyServiceClient::ListDataPolicies(std::string const& parent,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::datapolicies::v1::ListDataPoliciesRequest request;
  request.set_parent(parent);
  return connection_->ListDataPolicies(request);
}

StreamRange<google::cloud::bigquery::datapolicies::v1::DataPolicy>
DataPolicyServiceClient::ListDataPolicies(
    google::cloud::bigquery::datapolicies::v1::ListDataPoliciesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListDataPolicies(std::move(request));
}

StatusOr<google::iam::v1::Policy> DataPolicyServiceClient::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> DataPolicyServiceClient::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
DataPolicyServiceClient::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_datapolicies_v1
}  // namespace cloud
}  // namespace google
