// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/bigtable/admin/v2/bigtable_table_admin.proto

#include "google/cloud/bigtable/admin/bigtable_table_admin_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigtable_admin {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

BigtableTableAdminConnectionIdempotencyPolicy::
    ~BigtableTableAdminConnectionIdempotencyPolicy() = default;

std::unique_ptr<BigtableTableAdminConnectionIdempotencyPolicy>
BigtableTableAdminConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<BigtableTableAdminConnectionIdempotencyPolicy>(*this);
}

Idempotency BigtableTableAdminConnectionIdempotencyPolicy::CreateTable(
    google::bigtable::admin::v2::CreateTableRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BigtableTableAdminConnectionIdempotencyPolicy::ListTables(
    google::bigtable::admin::v2::ListTablesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency BigtableTableAdminConnectionIdempotencyPolicy::GetTable(
    google::bigtable::admin::v2::GetTableRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency BigtableTableAdminConnectionIdempotencyPolicy::UpdateTable(
    google::bigtable::admin::v2::UpdateTableRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BigtableTableAdminConnectionIdempotencyPolicy::DeleteTable(
    google::bigtable::admin::v2::DeleteTableRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BigtableTableAdminConnectionIdempotencyPolicy::UndeleteTable(
    google::bigtable::admin::v2::UndeleteTableRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BigtableTableAdminConnectionIdempotencyPolicy::CreateAuthorizedView(
    google::bigtable::admin::v2::CreateAuthorizedViewRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BigtableTableAdminConnectionIdempotencyPolicy::ListAuthorizedViews(
    google::bigtable::admin::v2::ListAuthorizedViewsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency BigtableTableAdminConnectionIdempotencyPolicy::GetAuthorizedView(
    google::bigtable::admin::v2::GetAuthorizedViewRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency BigtableTableAdminConnectionIdempotencyPolicy::UpdateAuthorizedView(
    google::bigtable::admin::v2::UpdateAuthorizedViewRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BigtableTableAdminConnectionIdempotencyPolicy::DeleteAuthorizedView(
    google::bigtable::admin::v2::DeleteAuthorizedViewRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BigtableTableAdminConnectionIdempotencyPolicy::ModifyColumnFamilies(
    google::bigtable::admin::v2::ModifyColumnFamiliesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BigtableTableAdminConnectionIdempotencyPolicy::DropRowRange(
    google::bigtable::admin::v2::DropRowRangeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
BigtableTableAdminConnectionIdempotencyPolicy::GenerateConsistencyToken(
    google::bigtable::admin::v2::GenerateConsistencyTokenRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BigtableTableAdminConnectionIdempotencyPolicy::CheckConsistency(
    google::bigtable::admin::v2::CheckConsistencyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency BigtableTableAdminConnectionIdempotencyPolicy::CreateBackup(
    google::bigtable::admin::v2::CreateBackupRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BigtableTableAdminConnectionIdempotencyPolicy::GetBackup(
    google::bigtable::admin::v2::GetBackupRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency BigtableTableAdminConnectionIdempotencyPolicy::UpdateBackup(
    google::bigtable::admin::v2::UpdateBackupRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BigtableTableAdminConnectionIdempotencyPolicy::DeleteBackup(
    google::bigtable::admin::v2::DeleteBackupRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BigtableTableAdminConnectionIdempotencyPolicy::ListBackups(
    google::bigtable::admin::v2::ListBackupsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency BigtableTableAdminConnectionIdempotencyPolicy::RestoreTable(
    google::bigtable::admin::v2::RestoreTableRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BigtableTableAdminConnectionIdempotencyPolicy::CopyBackup(
    google::bigtable::admin::v2::CopyBackupRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BigtableTableAdminConnectionIdempotencyPolicy::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency BigtableTableAdminConnectionIdempotencyPolicy::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return request.policy().etag().empty() ? Idempotency::kNonIdempotent
                                         : Idempotency::kIdempotent;
}

Idempotency BigtableTableAdminConnectionIdempotencyPolicy::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Idempotency::kIdempotent;
}

std::unique_ptr<BigtableTableAdminConnectionIdempotencyPolicy>
MakeDefaultBigtableTableAdminConnectionIdempotencyPolicy() {
  return std::make_unique<BigtableTableAdminConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigtable_admin
}  // namespace cloud
}  // namespace google
