// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/region_operations/v1/region_operations.proto

#include "google/cloud/compute/region_operations/v1/internal/region_operations_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_region_operations_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

RegionOperationsTracingConnection::RegionOperationsTracingConnection(
    std::shared_ptr<compute_region_operations_v1::RegionOperationsConnection>
        child)
    : child_(std::move(child)) {}

Status RegionOperationsTracingConnection::DeleteOperation(
    google::cloud::cpp::compute::region_operations::v1::
        DeleteOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_operations_v1::RegionOperationsConnection::"
      "DeleteOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteOperation(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionOperationsTracingConnection::GetOperation(
    google::cloud::cpp::compute::region_operations::v1::
        GetOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_operations_v1::RegionOperationsConnection::GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetOperation(request));
}

StreamRange<google::cloud::cpp::compute::v1::Operation>
RegionOperationsTracingConnection::ListRegionOperations(
    google::cloud::cpp::compute::region_operations::v1::
        ListRegionOperationsRequest request) {
  auto span = internal::MakeSpan(
      "compute_region_operations_v1::RegionOperationsConnection::"
      "ListRegionOperations");
  internal::OTelScope scope(span);
  auto sr = child_->ListRegionOperations(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::Operation>(std::move(span),
                                                  std::move(sr));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionOperationsTracingConnection::Wait(
    google::cloud::cpp::compute::region_operations::v1::WaitRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_region_operations_v1::RegionOperationsConnection::Wait");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->Wait(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<compute_region_operations_v1::RegionOperationsConnection>
MakeRegionOperationsTracingConnection(
    std::shared_ptr<compute_region_operations_v1::RegionOperationsConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<RegionOperationsTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_region_operations_v1_internal
}  // namespace cloud
}  // namespace google
