// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/zone_operations/v1/zone_operations.proto

#include "google/cloud/compute/zone_operations/v1/zone_operations_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_zone_operations_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ZoneOperationsClient::ZoneOperationsClient(
    std::shared_ptr<ZoneOperationsConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
ZoneOperationsClient::~ZoneOperationsClient() = default;

Status ZoneOperationsClient::DeleteOperation(std::string const& project,
                                             std::string const& zone,
                                             std::string const& operation,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::zone_operations::v1::DeleteOperationRequest
      request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_operation(operation);
  return connection_->DeleteOperation(request);
}

Status ZoneOperationsClient::DeleteOperation(
    google::cloud::cpp::compute::zone_operations::v1::
        DeleteOperationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteOperation(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
ZoneOperationsClient::GetOperation(std::string const& project,
                                   std::string const& zone,
                                   std::string const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::zone_operations::v1::GetOperationRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_operation(operation);
  return connection_->GetOperation(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
ZoneOperationsClient::GetOperation(
    google::cloud::cpp::compute::zone_operations::v1::GetOperationRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

StreamRange<google::cloud::cpp::compute::v1::Operation>
ZoneOperationsClient::ListZoneOperations(std::string const& project,
                                         std::string const& zone,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::zone_operations::v1::ListZoneOperationsRequest
      request;
  request.set_project(project);
  request.set_zone(zone);
  return connection_->ListZoneOperations(request);
}

StreamRange<google::cloud::cpp::compute::v1::Operation>
ZoneOperationsClient::ListZoneOperations(
    google::cloud::cpp::compute::zone_operations::v1::ListZoneOperationsRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListZoneOperations(std::move(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation> ZoneOperationsClient::Wait(
    std::string const& project, std::string const& zone,
    std::string const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::zone_operations::v1::WaitRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_operation(operation);
  return connection_->Wait(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation> ZoneOperationsClient::Wait(
    google::cloud::cpp::compute::zone_operations::v1::WaitRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->Wait(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_zone_operations_v1
}  // namespace cloud
}  // namespace google
