// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/contentwarehouse/v1/document_schema_service.proto

#include "google/cloud/contentwarehouse/v1/internal/document_schema_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/contentwarehouse/v1/document_schema_service.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace contentwarehouse_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DocumentSchemaServiceStub::~DocumentSchemaServiceStub() = default;

StatusOr<google::cloud::contentwarehouse::v1::DocumentSchema>
DefaultDocumentSchemaServiceStub::CreateDocumentSchema(
    grpc::ClientContext& context, Options const&,
    google::cloud::contentwarehouse::v1::CreateDocumentSchemaRequest const&
        request) {
  google::cloud::contentwarehouse::v1::DocumentSchema response;
  auto status = grpc_stub_->CreateDocumentSchema(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::contentwarehouse::v1::DocumentSchema>
DefaultDocumentSchemaServiceStub::UpdateDocumentSchema(
    grpc::ClientContext& context, Options const&,
    google::cloud::contentwarehouse::v1::UpdateDocumentSchemaRequest const&
        request) {
  google::cloud::contentwarehouse::v1::DocumentSchema response;
  auto status = grpc_stub_->UpdateDocumentSchema(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::contentwarehouse::v1::DocumentSchema>
DefaultDocumentSchemaServiceStub::GetDocumentSchema(
    grpc::ClientContext& context, Options const&,
    google::cloud::contentwarehouse::v1::GetDocumentSchemaRequest const&
        request) {
  google::cloud::contentwarehouse::v1::DocumentSchema response;
  auto status = grpc_stub_->GetDocumentSchema(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultDocumentSchemaServiceStub::DeleteDocumentSchema(
    grpc::ClientContext& context, Options const&,
    google::cloud::contentwarehouse::v1::DeleteDocumentSchemaRequest const&
        request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DeleteDocumentSchema(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::cloud::contentwarehouse::v1::ListDocumentSchemasResponse>
DefaultDocumentSchemaServiceStub::ListDocumentSchemas(
    grpc::ClientContext& context, Options const&,
    google::cloud::contentwarehouse::v1::ListDocumentSchemasRequest const&
        request) {
  google::cloud::contentwarehouse::v1::ListDocumentSchemasResponse response;
  auto status = grpc_stub_->ListDocumentSchemas(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace contentwarehouse_v1_internal
}  // namespace cloud
}  // namespace google
