// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/engine_service.proto

#include "google/cloud/discoveryengine/v1/internal/engine_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace discoveryengine_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

EngineServiceTracingConnection::EngineServiceTracingConnection(
    std::shared_ptr<discoveryengine_v1::EngineServiceConnection> child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::discoveryengine::v1::Engine>>
EngineServiceTracingConnection::CreateEngine(
    google::cloud::discoveryengine::v1::CreateEngineRequest const& request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::EngineServiceConnection::CreateEngine");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateEngine(request));
}

StatusOr<google::longrunning::Operation>
EngineServiceTracingConnection::CreateEngine(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::CreateEngineRequest const& request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::EngineServiceConnection::CreateEngine");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CreateEngine(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::discoveryengine::v1::Engine>>
EngineServiceTracingConnection::CreateEngine(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::EngineServiceConnection::CreateEngine");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateEngine(operation));
}

future<StatusOr<google::cloud::discoveryengine::v1::DeleteEngineMetadata>>
EngineServiceTracingConnection::DeleteEngine(
    google::cloud::discoveryengine::v1::DeleteEngineRequest const& request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::EngineServiceConnection::DeleteEngine");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteEngine(request));
}

StatusOr<google::longrunning::Operation>
EngineServiceTracingConnection::DeleteEngine(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::DeleteEngineRequest const& request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::EngineServiceConnection::DeleteEngine");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteEngine(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::discoveryengine::v1::DeleteEngineMetadata>>
EngineServiceTracingConnection::DeleteEngine(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::EngineServiceConnection::DeleteEngine");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteEngine(operation));
}

StatusOr<google::cloud::discoveryengine::v1::Engine>
EngineServiceTracingConnection::UpdateEngine(
    google::cloud::discoveryengine::v1::UpdateEngineRequest const& request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::EngineServiceConnection::UpdateEngine");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateEngine(request));
}

StatusOr<google::cloud::discoveryengine::v1::Engine>
EngineServiceTracingConnection::GetEngine(
    google::cloud::discoveryengine::v1::GetEngineRequest const& request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::EngineServiceConnection::GetEngine");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetEngine(request));
}

StreamRange<google::cloud::discoveryengine::v1::Engine>
EngineServiceTracingConnection::ListEngines(
    google::cloud::discoveryengine::v1::ListEnginesRequest request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::EngineServiceConnection::ListEngines");
  internal::OTelScope scope(span);
  auto sr = child_->ListEngines(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::discoveryengine::v1::Engine>(std::move(span),
                                                  std::move(sr));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<discoveryengine_v1::EngineServiceConnection>
MakeEngineServiceTracingConnection(
    std::shared_ptr<discoveryengine_v1::EngineServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<EngineServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1_internal
}  // namespace cloud
}  // namespace google
