// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/edgecontainer/v1/service.proto

#include "google/cloud/edgecontainer/v1/edge_container_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace edgecontainer_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

EdgeContainerClient::EdgeContainerClient(
    std::shared_ptr<EdgeContainerConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
EdgeContainerClient::~EdgeContainerClient() = default;

StreamRange<google::cloud::edgecontainer::v1::Cluster>
EdgeContainerClient::ListClusters(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::ListClustersRequest request;
  request.set_parent(parent);
  return connection_->ListClusters(request);
}

StreamRange<google::cloud::edgecontainer::v1::Cluster>
EdgeContainerClient::ListClusters(
    google::cloud::edgecontainer::v1::ListClustersRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListClusters(std::move(request));
}

StatusOr<google::cloud::edgecontainer::v1::Cluster>
EdgeContainerClient::GetCluster(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::GetClusterRequest request;
  request.set_name(name);
  return connection_->GetCluster(request);
}

StatusOr<google::cloud::edgecontainer::v1::Cluster>
EdgeContainerClient::GetCluster(
    google::cloud::edgecontainer::v1::GetClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetCluster(request);
}

future<StatusOr<google::cloud::edgecontainer::v1::Cluster>>
EdgeContainerClient::CreateCluster(
    std::string const& parent,
    google::cloud::edgecontainer::v1::Cluster const& cluster,
    std::string const& cluster_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::CreateClusterRequest request;
  request.set_parent(parent);
  *request.mutable_cluster() = cluster;
  request.set_cluster_id(cluster_id);
  return connection_->CreateCluster(request);
}

StatusOr<google::longrunning::Operation> EdgeContainerClient::CreateCluster(
    NoAwaitTag, std::string const& parent,
    google::cloud::edgecontainer::v1::Cluster const& cluster,
    std::string const& cluster_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::CreateClusterRequest request;
  request.set_parent(parent);
  *request.mutable_cluster() = cluster;
  request.set_cluster_id(cluster_id);
  return connection_->CreateCluster(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::edgecontainer::v1::Cluster>>
EdgeContainerClient::CreateCluster(
    google::cloud::edgecontainer::v1::CreateClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCluster(request);
}

StatusOr<google::longrunning::Operation> EdgeContainerClient::CreateCluster(
    NoAwaitTag,
    google::cloud::edgecontainer::v1::CreateClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCluster(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::edgecontainer::v1::Cluster>>
EdgeContainerClient::CreateCluster(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCluster(operation);
}

future<StatusOr<google::cloud::edgecontainer::v1::Cluster>>
EdgeContainerClient::UpdateCluster(
    google::cloud::edgecontainer::v1::Cluster const& cluster,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::UpdateClusterRequest request;
  *request.mutable_cluster() = cluster;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateCluster(request);
}

StatusOr<google::longrunning::Operation> EdgeContainerClient::UpdateCluster(
    NoAwaitTag, google::cloud::edgecontainer::v1::Cluster const& cluster,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::UpdateClusterRequest request;
  *request.mutable_cluster() = cluster;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateCluster(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::edgecontainer::v1::Cluster>>
EdgeContainerClient::UpdateCluster(
    google::cloud::edgecontainer::v1::UpdateClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCluster(request);
}

StatusOr<google::longrunning::Operation> EdgeContainerClient::UpdateCluster(
    NoAwaitTag,
    google::cloud::edgecontainer::v1::UpdateClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCluster(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::edgecontainer::v1::Cluster>>
EdgeContainerClient::UpdateCluster(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCluster(operation);
}

future<StatusOr<google::cloud::edgecontainer::v1::Cluster>>
EdgeContainerClient::UpgradeCluster(
    std::string const& name, std::string const& target_version,
    google::cloud::edgecontainer::v1::UpgradeClusterRequest::Schedule schedule,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::UpgradeClusterRequest request;
  request.set_name(name);
  request.set_target_version(target_version);
  request.set_schedule(schedule);
  return connection_->UpgradeCluster(request);
}

StatusOr<google::longrunning::Operation> EdgeContainerClient::UpgradeCluster(
    NoAwaitTag, std::string const& name, std::string const& target_version,
    google::cloud::edgecontainer::v1::UpgradeClusterRequest::Schedule schedule,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::UpgradeClusterRequest request;
  request.set_name(name);
  request.set_target_version(target_version);
  request.set_schedule(schedule);
  return connection_->UpgradeCluster(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::edgecontainer::v1::Cluster>>
EdgeContainerClient::UpgradeCluster(
    google::cloud::edgecontainer::v1::UpgradeClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpgradeCluster(request);
}

StatusOr<google::longrunning::Operation> EdgeContainerClient::UpgradeCluster(
    NoAwaitTag,
    google::cloud::edgecontainer::v1::UpgradeClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpgradeCluster(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::edgecontainer::v1::Cluster>>
EdgeContainerClient::UpgradeCluster(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpgradeCluster(operation);
}

future<StatusOr<google::cloud::edgecontainer::v1::OperationMetadata>>
EdgeContainerClient::DeleteCluster(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::DeleteClusterRequest request;
  request.set_name(name);
  return connection_->DeleteCluster(request);
}

StatusOr<google::longrunning::Operation> EdgeContainerClient::DeleteCluster(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::DeleteClusterRequest request;
  request.set_name(name);
  return connection_->DeleteCluster(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::edgecontainer::v1::OperationMetadata>>
EdgeContainerClient::DeleteCluster(
    google::cloud::edgecontainer::v1::DeleteClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCluster(request);
}

StatusOr<google::longrunning::Operation> EdgeContainerClient::DeleteCluster(
    NoAwaitTag,
    google::cloud::edgecontainer::v1::DeleteClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCluster(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::edgecontainer::v1::OperationMetadata>>
EdgeContainerClient::DeleteCluster(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCluster(operation);
}

StatusOr<google::cloud::edgecontainer::v1::GenerateAccessTokenResponse>
EdgeContainerClient::GenerateAccessToken(std::string const& cluster,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::GenerateAccessTokenRequest request;
  request.set_cluster(cluster);
  return connection_->GenerateAccessToken(request);
}

StatusOr<google::cloud::edgecontainer::v1::GenerateAccessTokenResponse>
EdgeContainerClient::GenerateAccessToken(
    google::cloud::edgecontainer::v1::GenerateAccessTokenRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GenerateAccessToken(request);
}

StatusOr<google::cloud::edgecontainer::v1::GenerateOfflineCredentialResponse>
EdgeContainerClient::GenerateOfflineCredential(std::string const& cluster,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::GenerateOfflineCredentialRequest request;
  request.set_cluster(cluster);
  return connection_->GenerateOfflineCredential(request);
}

StatusOr<google::cloud::edgecontainer::v1::GenerateOfflineCredentialResponse>
EdgeContainerClient::GenerateOfflineCredential(
    google::cloud::edgecontainer::v1::GenerateOfflineCredentialRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GenerateOfflineCredential(request);
}

StreamRange<google::cloud::edgecontainer::v1::NodePool>
EdgeContainerClient::ListNodePools(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::ListNodePoolsRequest request;
  request.set_parent(parent);
  return connection_->ListNodePools(request);
}

StreamRange<google::cloud::edgecontainer::v1::NodePool>
EdgeContainerClient::ListNodePools(
    google::cloud::edgecontainer::v1::ListNodePoolsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListNodePools(std::move(request));
}

StatusOr<google::cloud::edgecontainer::v1::NodePool>
EdgeContainerClient::GetNodePool(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::GetNodePoolRequest request;
  request.set_name(name);
  return connection_->GetNodePool(request);
}

StatusOr<google::cloud::edgecontainer::v1::NodePool>
EdgeContainerClient::GetNodePool(
    google::cloud::edgecontainer::v1::GetNodePoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetNodePool(request);
}

future<StatusOr<google::cloud::edgecontainer::v1::NodePool>>
EdgeContainerClient::CreateNodePool(
    std::string const& parent,
    google::cloud::edgecontainer::v1::NodePool const& node_pool,
    std::string const& node_pool_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::CreateNodePoolRequest request;
  request.set_parent(parent);
  *request.mutable_node_pool() = node_pool;
  request.set_node_pool_id(node_pool_id);
  return connection_->CreateNodePool(request);
}

StatusOr<google::longrunning::Operation> EdgeContainerClient::CreateNodePool(
    NoAwaitTag, std::string const& parent,
    google::cloud::edgecontainer::v1::NodePool const& node_pool,
    std::string const& node_pool_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::CreateNodePoolRequest request;
  request.set_parent(parent);
  *request.mutable_node_pool() = node_pool;
  request.set_node_pool_id(node_pool_id);
  return connection_->CreateNodePool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::edgecontainer::v1::NodePool>>
EdgeContainerClient::CreateNodePool(
    google::cloud::edgecontainer::v1::CreateNodePoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateNodePool(request);
}

StatusOr<google::longrunning::Operation> EdgeContainerClient::CreateNodePool(
    NoAwaitTag,
    google::cloud::edgecontainer::v1::CreateNodePoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateNodePool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::edgecontainer::v1::NodePool>>
EdgeContainerClient::CreateNodePool(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateNodePool(operation);
}

future<StatusOr<google::cloud::edgecontainer::v1::NodePool>>
EdgeContainerClient::UpdateNodePool(
    google::cloud::edgecontainer::v1::NodePool const& node_pool,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::UpdateNodePoolRequest request;
  *request.mutable_node_pool() = node_pool;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateNodePool(request);
}

StatusOr<google::longrunning::Operation> EdgeContainerClient::UpdateNodePool(
    NoAwaitTag, google::cloud::edgecontainer::v1::NodePool const& node_pool,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::UpdateNodePoolRequest request;
  *request.mutable_node_pool() = node_pool;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateNodePool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::edgecontainer::v1::NodePool>>
EdgeContainerClient::UpdateNodePool(
    google::cloud::edgecontainer::v1::UpdateNodePoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateNodePool(request);
}

StatusOr<google::longrunning::Operation> EdgeContainerClient::UpdateNodePool(
    NoAwaitTag,
    google::cloud::edgecontainer::v1::UpdateNodePoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateNodePool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::edgecontainer::v1::NodePool>>
EdgeContainerClient::UpdateNodePool(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateNodePool(operation);
}

future<StatusOr<google::cloud::edgecontainer::v1::OperationMetadata>>
EdgeContainerClient::DeleteNodePool(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::DeleteNodePoolRequest request;
  request.set_name(name);
  return connection_->DeleteNodePool(request);
}

StatusOr<google::longrunning::Operation> EdgeContainerClient::DeleteNodePool(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::DeleteNodePoolRequest request;
  request.set_name(name);
  return connection_->DeleteNodePool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::edgecontainer::v1::OperationMetadata>>
EdgeContainerClient::DeleteNodePool(
    google::cloud::edgecontainer::v1::DeleteNodePoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNodePool(request);
}

StatusOr<google::longrunning::Operation> EdgeContainerClient::DeleteNodePool(
    NoAwaitTag,
    google::cloud::edgecontainer::v1::DeleteNodePoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNodePool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::edgecontainer::v1::OperationMetadata>>
EdgeContainerClient::DeleteNodePool(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNodePool(operation);
}

StreamRange<google::cloud::edgecontainer::v1::Machine>
EdgeContainerClient::ListMachines(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::ListMachinesRequest request;
  request.set_parent(parent);
  return connection_->ListMachines(request);
}

StreamRange<google::cloud::edgecontainer::v1::Machine>
EdgeContainerClient::ListMachines(
    google::cloud::edgecontainer::v1::ListMachinesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListMachines(std::move(request));
}

StatusOr<google::cloud::edgecontainer::v1::Machine>
EdgeContainerClient::GetMachine(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::GetMachineRequest request;
  request.set_name(name);
  return connection_->GetMachine(request);
}

StatusOr<google::cloud::edgecontainer::v1::Machine>
EdgeContainerClient::GetMachine(
    google::cloud::edgecontainer::v1::GetMachineRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetMachine(request);
}

StreamRange<google::cloud::edgecontainer::v1::VpnConnection>
EdgeContainerClient::ListVpnConnections(std::string const& parent,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::ListVpnConnectionsRequest request;
  request.set_parent(parent);
  return connection_->ListVpnConnections(request);
}

StreamRange<google::cloud::edgecontainer::v1::VpnConnection>
EdgeContainerClient::ListVpnConnections(
    google::cloud::edgecontainer::v1::ListVpnConnectionsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListVpnConnections(std::move(request));
}

StatusOr<google::cloud::edgecontainer::v1::VpnConnection>
EdgeContainerClient::GetVpnConnection(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::GetVpnConnectionRequest request;
  request.set_name(name);
  return connection_->GetVpnConnection(request);
}

StatusOr<google::cloud::edgecontainer::v1::VpnConnection>
EdgeContainerClient::GetVpnConnection(
    google::cloud::edgecontainer::v1::GetVpnConnectionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetVpnConnection(request);
}

future<StatusOr<google::cloud::edgecontainer::v1::VpnConnection>>
EdgeContainerClient::CreateVpnConnection(
    std::string const& parent,
    google::cloud::edgecontainer::v1::VpnConnection const& vpn_connection,
    std::string const& vpn_connection_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::CreateVpnConnectionRequest request;
  request.set_parent(parent);
  *request.mutable_vpn_connection() = vpn_connection;
  request.set_vpn_connection_id(vpn_connection_id);
  return connection_->CreateVpnConnection(request);
}

StatusOr<google::longrunning::Operation>
EdgeContainerClient::CreateVpnConnection(
    NoAwaitTag, std::string const& parent,
    google::cloud::edgecontainer::v1::VpnConnection const& vpn_connection,
    std::string const& vpn_connection_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::CreateVpnConnectionRequest request;
  request.set_parent(parent);
  *request.mutable_vpn_connection() = vpn_connection;
  request.set_vpn_connection_id(vpn_connection_id);
  return connection_->CreateVpnConnection(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::edgecontainer::v1::VpnConnection>>
EdgeContainerClient::CreateVpnConnection(
    google::cloud::edgecontainer::v1::CreateVpnConnectionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateVpnConnection(request);
}

StatusOr<google::longrunning::Operation>
EdgeContainerClient::CreateVpnConnection(
    NoAwaitTag,
    google::cloud::edgecontainer::v1::CreateVpnConnectionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateVpnConnection(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::edgecontainer::v1::VpnConnection>>
EdgeContainerClient::CreateVpnConnection(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateVpnConnection(operation);
}

future<StatusOr<google::cloud::edgecontainer::v1::OperationMetadata>>
EdgeContainerClient::DeleteVpnConnection(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::DeleteVpnConnectionRequest request;
  request.set_name(name);
  return connection_->DeleteVpnConnection(request);
}

StatusOr<google::longrunning::Operation>
EdgeContainerClient::DeleteVpnConnection(NoAwaitTag, std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::DeleteVpnConnectionRequest request;
  request.set_name(name);
  return connection_->DeleteVpnConnection(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::edgecontainer::v1::OperationMetadata>>
EdgeContainerClient::DeleteVpnConnection(
    google::cloud::edgecontainer::v1::DeleteVpnConnectionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteVpnConnection(request);
}

StatusOr<google::longrunning::Operation>
EdgeContainerClient::DeleteVpnConnection(
    NoAwaitTag,
    google::cloud::edgecontainer::v1::DeleteVpnConnectionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteVpnConnection(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::edgecontainer::v1::OperationMetadata>>
EdgeContainerClient::DeleteVpnConnection(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteVpnConnection(operation);
}

StatusOr<google::cloud::edgecontainer::v1::ServerConfig>
EdgeContainerClient::GetServerConfig(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::edgecontainer::v1::GetServerConfigRequest request;
  request.set_name(name);
  return connection_->GetServerConfig(request);
}

StatusOr<google::cloud::edgecontainer::v1::ServerConfig>
EdgeContainerClient::GetServerConfig(
    google::cloud::edgecontainer::v1::GetServerConfigRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetServerConfig(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace edgecontainer_v1
}  // namespace cloud
}  // namespace google
