// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcemanager/v3/tag_bindings.proto

#include "google/cloud/resourcemanager/v3/internal/tag_bindings_option_defaults.h"
#include "google/cloud/resourcemanager/v3/tag_bindings_connection.h"
#include "google/cloud/resourcemanager/v3/tag_bindings_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace resourcemanager_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options TagBindingsDefaultOptions(Options options) {
  options = internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_TAG_BINDINGS_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_TAG_BINDINGS_AUTHORITY",
      "cloudresourcemanager.googleapis.com");
  options = internal::PopulateGrpcOptions(std::move(options));
  if (!options.has<resourcemanager_v3::TagBindingsRetryPolicyOption>()) {
    options.set<resourcemanager_v3::TagBindingsRetryPolicyOption>(
        resourcemanager_v3::TagBindingsLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<resourcemanager_v3::TagBindingsBackoffPolicyOption>()) {
    options.set<resourcemanager_v3::TagBindingsBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<resourcemanager_v3::TagBindingsPollingPolicyOption>()) {
    options.set<resourcemanager_v3::TagBindingsPollingPolicyOption>(
        GenericPollingPolicy<
            resourcemanager_v3::TagBindingsRetryPolicyOption::Type,
            resourcemanager_v3::TagBindingsBackoffPolicyOption::Type>(
            options.get<resourcemanager_v3::TagBindingsRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options.has<
          resourcemanager_v3::TagBindingsConnectionIdempotencyPolicyOption>()) {
    options
        .set<resourcemanager_v3::TagBindingsConnectionIdempotencyPolicyOption>(
            resourcemanager_v3::
                MakeDefaultTagBindingsConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager_v3_internal
}  // namespace cloud
}  // namespace google
