// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/retail/v2/model_service.proto

#include "google/cloud/retail/v2/model_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace retail_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ModelServiceClient::ModelServiceClient(
    std::shared_ptr<ModelServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
ModelServiceClient::~ModelServiceClient() = default;

future<StatusOr<google::cloud::retail::v2::Model>>
ModelServiceClient::CreateModel(std::string const& parent,
                                google::cloud::retail::v2::Model const& model,
                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::retail::v2::CreateModelRequest request;
  request.set_parent(parent);
  *request.mutable_model() = model;
  return connection_->CreateModel(request);
}

StatusOr<google::longrunning::Operation> ModelServiceClient::CreateModel(
    NoAwaitTag, std::string const& parent,
    google::cloud::retail::v2::Model const& model, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::retail::v2::CreateModelRequest request;
  request.set_parent(parent);
  *request.mutable_model() = model;
  return connection_->CreateModel(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::retail::v2::Model>>
ModelServiceClient::CreateModel(
    google::cloud::retail::v2::CreateModelRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateModel(request);
}

StatusOr<google::longrunning::Operation> ModelServiceClient::CreateModel(
    NoAwaitTag, google::cloud::retail::v2::CreateModelRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateModel(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::retail::v2::Model>>
ModelServiceClient::CreateModel(google::longrunning::Operation const& operation,
                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateModel(operation);
}

StatusOr<google::cloud::retail::v2::Model> ModelServiceClient::GetModel(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::retail::v2::GetModelRequest request;
  request.set_name(name);
  return connection_->GetModel(request);
}

StatusOr<google::cloud::retail::v2::Model> ModelServiceClient::GetModel(
    google::cloud::retail::v2::GetModelRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetModel(request);
}

StatusOr<google::cloud::retail::v2::Model> ModelServiceClient::PauseModel(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::retail::v2::PauseModelRequest request;
  request.set_name(name);
  return connection_->PauseModel(request);
}

StatusOr<google::cloud::retail::v2::Model> ModelServiceClient::PauseModel(
    google::cloud::retail::v2::PauseModelRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PauseModel(request);
}

StatusOr<google::cloud::retail::v2::Model> ModelServiceClient::ResumeModel(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::retail::v2::ResumeModelRequest request;
  request.set_name(name);
  return connection_->ResumeModel(request);
}

StatusOr<google::cloud::retail::v2::Model> ModelServiceClient::ResumeModel(
    google::cloud::retail::v2::ResumeModelRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ResumeModel(request);
}

Status ModelServiceClient::DeleteModel(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::retail::v2::DeleteModelRequest request;
  request.set_name(name);
  return connection_->DeleteModel(request);
}

Status ModelServiceClient::DeleteModel(
    google::cloud::retail::v2::DeleteModelRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteModel(request);
}

StreamRange<google::cloud::retail::v2::Model> ModelServiceClient::ListModels(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::retail::v2::ListModelsRequest request;
  request.set_parent(parent);
  return connection_->ListModels(request);
}

StreamRange<google::cloud::retail::v2::Model> ModelServiceClient::ListModels(
    google::cloud::retail::v2::ListModelsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListModels(std::move(request));
}

StatusOr<google::cloud::retail::v2::Model> ModelServiceClient::UpdateModel(
    google::cloud::retail::v2::Model const& model,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::retail::v2::UpdateModelRequest request;
  *request.mutable_model() = model;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateModel(request);
}

StatusOr<google::cloud::retail::v2::Model> ModelServiceClient::UpdateModel(
    google::cloud::retail::v2::UpdateModelRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateModel(request);
}

future<StatusOr<google::cloud::retail::v2::TuneModelResponse>>
ModelServiceClient::TuneModel(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::retail::v2::TuneModelRequest request;
  request.set_name(name);
  return connection_->TuneModel(request);
}

StatusOr<google::longrunning::Operation> ModelServiceClient::TuneModel(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::retail::v2::TuneModelRequest request;
  request.set_name(name);
  return connection_->TuneModel(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::retail::v2::TuneModelResponse>>
ModelServiceClient::TuneModel(
    google::cloud::retail::v2::TuneModelRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TuneModel(request);
}

StatusOr<google::longrunning::Operation> ModelServiceClient::TuneModel(
    NoAwaitTag, google::cloud::retail::v2::TuneModelRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TuneModel(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::retail::v2::TuneModelResponse>>
ModelServiceClient::TuneModel(google::longrunning::Operation const& operation,
                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TuneModel(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail_v2
}  // namespace cloud
}  // namespace google
