// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/telcoautomation/v1/telcoautomation.proto

#include "google/cloud/telcoautomation/v1/telco_automation_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace telcoautomation_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

TelcoAutomationConnectionIdempotencyPolicy::
    ~TelcoAutomationConnectionIdempotencyPolicy() = default;

std::unique_ptr<TelcoAutomationConnectionIdempotencyPolicy>
TelcoAutomationConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<TelcoAutomationConnectionIdempotencyPolicy>(*this);
}

Idempotency
TelcoAutomationConnectionIdempotencyPolicy::ListOrchestrationClusters(
    google::cloud::telcoautomation::v1::
        ListOrchestrationClustersRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::GetOrchestrationCluster(
    google::cloud::telcoautomation::v1::GetOrchestrationClusterRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
TelcoAutomationConnectionIdempotencyPolicy::CreateOrchestrationCluster(
    google::cloud::telcoautomation::v1::
        CreateOrchestrationClusterRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
TelcoAutomationConnectionIdempotencyPolicy::DeleteOrchestrationCluster(
    google::cloud::telcoautomation::v1::
        DeleteOrchestrationClusterRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::ListEdgeSlms(
    google::cloud::telcoautomation::v1::ListEdgeSlmsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::GetEdgeSlm(
    google::cloud::telcoautomation::v1::GetEdgeSlmRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::CreateEdgeSlm(
    google::cloud::telcoautomation::v1::CreateEdgeSlmRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::DeleteEdgeSlm(
    google::cloud::telcoautomation::v1::DeleteEdgeSlmRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::CreateBlueprint(
    google::cloud::telcoautomation::v1::CreateBlueprintRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::UpdateBlueprint(
    google::cloud::telcoautomation::v1::UpdateBlueprintRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::GetBlueprint(
    google::cloud::telcoautomation::v1::GetBlueprintRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::DeleteBlueprint(
    google::cloud::telcoautomation::v1::DeleteBlueprintRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::ListBlueprints(
    google::cloud::telcoautomation::v1::ListBlueprintsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::ApproveBlueprint(
    google::cloud::telcoautomation::v1::ApproveBlueprintRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::ProposeBlueprint(
    google::cloud::telcoautomation::v1::ProposeBlueprintRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::RejectBlueprint(
    google::cloud::telcoautomation::v1::RejectBlueprintRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::ListBlueprintRevisions(
    google::cloud::telcoautomation::v1::
        ListBlueprintRevisionsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency
TelcoAutomationConnectionIdempotencyPolicy::SearchBlueprintRevisions(
    google::cloud::telcoautomation::v1::
        SearchBlueprintRevisionsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency
TelcoAutomationConnectionIdempotencyPolicy::SearchDeploymentRevisions(
    google::cloud::telcoautomation::v1::
        SearchDeploymentRevisionsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::DiscardBlueprintChanges(
    google::cloud::telcoautomation::v1::DiscardBlueprintChangesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::ListPublicBlueprints(
    google::cloud::telcoautomation::v1::
        ListPublicBlueprintsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::GetPublicBlueprint(
    google::cloud::telcoautomation::v1::GetPublicBlueprintRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::CreateDeployment(
    google::cloud::telcoautomation::v1::CreateDeploymentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::UpdateDeployment(
    google::cloud::telcoautomation::v1::UpdateDeploymentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::GetDeployment(
    google::cloud::telcoautomation::v1::GetDeploymentRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::RemoveDeployment(
    google::cloud::telcoautomation::v1::RemoveDeploymentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::ListDeployments(
    google::cloud::telcoautomation::v1::ListDeploymentsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::ListDeploymentRevisions(
    google::cloud::telcoautomation::v1::
        ListDeploymentRevisionsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency
TelcoAutomationConnectionIdempotencyPolicy::DiscardDeploymentChanges(
    google::cloud::telcoautomation::v1::
        DiscardDeploymentChangesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::ApplyDeployment(
    google::cloud::telcoautomation::v1::ApplyDeploymentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::ComputeDeploymentStatus(
    google::cloud::telcoautomation::v1::ComputeDeploymentStatusRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::RollbackDeployment(
    google::cloud::telcoautomation::v1::RollbackDeploymentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::GetHydratedDeployment(
    google::cloud::telcoautomation::v1::GetHydratedDeploymentRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::ListHydratedDeployments(
    google::cloud::telcoautomation::v1::
        ListHydratedDeploymentsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency
TelcoAutomationConnectionIdempotencyPolicy::UpdateHydratedDeployment(
    google::cloud::telcoautomation::v1::
        UpdateHydratedDeploymentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TelcoAutomationConnectionIdempotencyPolicy::ApplyHydratedDeployment(
    google::cloud::telcoautomation::v1::ApplyHydratedDeploymentRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<TelcoAutomationConnectionIdempotencyPolicy>
MakeDefaultTelcoAutomationConnectionIdempotencyPolicy() {
  return std::make_unique<TelcoAutomationConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace telcoautomation_v1
}  // namespace cloud
}  // namespace google
