//! DO NOT EDIT! This file is generated by `xtask`.
//! Contains tests for the `info!` macro.
#![deny(warnings)]
#![no_implicit_prelude]

extern crate tracing;

// We call all macros in this module with `no_implicit_prelude` to ensure they do not depend on the standard prelude.
#[cfg(target_arch = "wasm32")]
extern crate wasm_bindgen_test;

struct Disp {
    val: u64,
}

impl ::std::fmt::Display for Disp {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::std::write!(f, "Disp.val={val}", val = self.val)
    }
}

struct Deb {
    val: u64,
}

/// Manual implementation because otherwise `val` is unused.
impl ::std::fmt::Debug for Deb {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        f.debug_struct("Deb").field("val", &self.val).finish()
    }
}

struct Sub {
    field: u64,
}
#[cfg_attr(target_arch = "wasm32", wasm_bindgen_test::wasm_bindgen_test)]
#[test]
fn info() {
    const CONST_VAR: &str = "const-field";

    let var = true;
    let sub = Sub { field: 4, };
    let disp = Disp { val: 61, };
    let deb = Deb { val: 102, };

    tracing::info!(ident = 3); // DEBUG:info,-,-,-,-,"ident","3"
    tracing::info!(foo = true, ident = 3); // DEBUG:info,-,-,p,-,"ident","3"
    tracing::info!(ident = 3, qux = 3); // DEBUG:info,-,-,f,-,"ident","3"
    tracing::info!(foo = true, ident = 3, qux = 3); // DEBUG:info,-,-,pf,-,"ident","3"
    tracing::info!(ident = 3, "msg without args"); // DEBUG:info,-,-,-,m,"ident","3"
    tracing::info!(foo = true, ident = 3, "msg without args"); // DEBUG:info,-,-,p,m,"ident","3"
    tracing::info!(ident = 3, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"ident","3"
    tracing::info!(foo = true, ident = 3, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"ident","3"
    tracing::info!({ ident = 3 }, "msg without args"); // DEBUG:info,-,{},-,m,"ident","3"
    tracing::info!({ foo = true, ident = 3 }, "msg without args"); // DEBUG:info,-,{},p,m,"ident","3"
    tracing::info!({ ident = 3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"ident","3"
    tracing::info!({ foo = true, ident = 3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"ident","3"
    tracing::info!(ident = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"ident","3"
    tracing::info!(foo = true, ident = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"ident","3"
    tracing::info!(ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"ident","3"
    tracing::info!(foo = true, ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"ident","3"
    tracing::info!({ ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"ident","3"
    tracing::info!({ foo = true, ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"ident","3"
    tracing::info!({ ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"ident","3"
    tracing::info!({ foo = true, ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"ident","3"
    tracing::info!(ident = false); // DEBUG:info,-,-,-,-,"ident","false"
    tracing::info!(foo = true, ident = false); // DEBUG:info,-,-,p,-,"ident","false"
    tracing::info!(ident = false, qux = 3); // DEBUG:info,-,-,f,-,"ident","false"
    tracing::info!(foo = true, ident = false, qux = 3); // DEBUG:info,-,-,pf,-,"ident","false"
    tracing::info!(ident = false, "msg without args"); // DEBUG:info,-,-,-,m,"ident","false"
    tracing::info!(foo = true, ident = false, "msg without args"); // DEBUG:info,-,-,p,m,"ident","false"
    tracing::info!(ident = false, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"ident","false"
    tracing::info!(foo = true, ident = false, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"ident","false"
    tracing::info!({ ident = false }, "msg without args"); // DEBUG:info,-,{},-,m,"ident","false"
    tracing::info!({ foo = true, ident = false }, "msg without args"); // DEBUG:info,-,{},p,m,"ident","false"
    tracing::info!({ ident = false, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"ident","false"
    tracing::info!({ foo = true, ident = false, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"ident","false"
    tracing::info!(ident = false, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"ident","false"
    tracing::info!(foo = true, ident = false, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"ident","false"
    tracing::info!(ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"ident","false"
    tracing::info!(foo = true, ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"ident","false"
    tracing::info!({ ident = false }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"ident","false"
    tracing::info!({ foo = true, ident = false }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"ident","false"
    tracing::info!({ ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"ident","false"
    tracing::info!({ foo = true, ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"ident","false"
    tracing::info!(ident = ?3); // DEBUG:info,-,-,-,-,"ident","?3"
    tracing::info!(foo = true, ident = ?3); // DEBUG:info,-,-,p,-,"ident","?3"
    tracing::info!(ident = ?3, qux = 3); // DEBUG:info,-,-,f,-,"ident","?3"
    tracing::info!(foo = true, ident = ?3, qux = 3); // DEBUG:info,-,-,pf,-,"ident","?3"
    tracing::info!(ident = ?3, "msg without args"); // DEBUG:info,-,-,-,m,"ident","?3"
    tracing::info!(foo = true, ident = ?3, "msg without args"); // DEBUG:info,-,-,p,m,"ident","?3"
    tracing::info!(ident = ?3, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"ident","?3"
    tracing::info!(foo = true, ident = ?3, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"ident","?3"
    tracing::info!({ ident = ?3 }, "msg without args"); // DEBUG:info,-,{},-,m,"ident","?3"
    tracing::info!({ foo = true, ident = ?3 }, "msg without args"); // DEBUG:info,-,{},p,m,"ident","?3"
    tracing::info!({ ident = ?3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"ident","?3"
    tracing::info!({ foo = true, ident = ?3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"ident","?3"
    tracing::info!(ident = ?3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"ident","?3"
    tracing::info!(foo = true, ident = ?3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"ident","?3"
    tracing::info!(ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"ident","?3"
    tracing::info!(foo = true, ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"ident","?3"
    tracing::info!({ ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"ident","?3"
    tracing::info!({ foo = true, ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"ident","?3"
    tracing::info!({ ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"ident","?3"
    tracing::info!({ foo = true, ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"ident","?3"
    tracing::info!(ident = %3); // DEBUG:info,-,-,-,-,"ident","%3"
    tracing::info!(foo = true, ident = %3); // DEBUG:info,-,-,p,-,"ident","%3"
    tracing::info!(ident = %3, qux = 3); // DEBUG:info,-,-,f,-,"ident","%3"
    tracing::info!(foo = true, ident = %3, qux = 3); // DEBUG:info,-,-,pf,-,"ident","%3"
    tracing::info!(ident = %3, "msg without args"); // DEBUG:info,-,-,-,m,"ident","%3"
    tracing::info!(foo = true, ident = %3, "msg without args"); // DEBUG:info,-,-,p,m,"ident","%3"
    tracing::info!(ident = %3, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"ident","%3"
    tracing::info!(foo = true, ident = %3, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"ident","%3"
    tracing::info!({ ident = %3 }, "msg without args"); // DEBUG:info,-,{},-,m,"ident","%3"
    tracing::info!({ foo = true, ident = %3 }, "msg without args"); // DEBUG:info,-,{},p,m,"ident","%3"
    tracing::info!({ ident = %3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"ident","%3"
    tracing::info!({ foo = true, ident = %3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"ident","%3"
    tracing::info!(ident = %3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"ident","%3"
    tracing::info!(foo = true, ident = %3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"ident","%3"
    tracing::info!(ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"ident","%3"
    tracing::info!(foo = true, ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"ident","%3"
    tracing::info!({ ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"ident","%3"
    tracing::info!({ foo = true, ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"ident","%3"
    tracing::info!({ ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"ident","%3"
    tracing::info!({ foo = true, ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"ident","%3"
    tracing::info!(ident = ?deb); // DEBUG:info,-,-,-,-,"ident","?deb"
    tracing::info!(foo = true, ident = ?deb); // DEBUG:info,-,-,p,-,"ident","?deb"
    tracing::info!(ident = ?deb, qux = 3); // DEBUG:info,-,-,f,-,"ident","?deb"
    tracing::info!(foo = true, ident = ?deb, qux = 3); // DEBUG:info,-,-,pf,-,"ident","?deb"
    tracing::info!(ident = ?deb, "msg without args"); // DEBUG:info,-,-,-,m,"ident","?deb"
    tracing::info!(foo = true, ident = ?deb, "msg without args"); // DEBUG:info,-,-,p,m,"ident","?deb"
    tracing::info!(ident = ?deb, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"ident","?deb"
    tracing::info!(foo = true, ident = ?deb, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"ident","?deb"
    tracing::info!({ ident = ?deb }, "msg without args"); // DEBUG:info,-,{},-,m,"ident","?deb"
    tracing::info!({ foo = true, ident = ?deb }, "msg without args"); // DEBUG:info,-,{},p,m,"ident","?deb"
    tracing::info!({ ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"ident","?deb"
    tracing::info!({ foo = true, ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"ident","?deb"
    tracing::info!(ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"ident","?deb"
    tracing::info!(foo = true, ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"ident","?deb"
    tracing::info!(ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"ident","?deb"
    tracing::info!(foo = true, ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"ident","?deb"
    tracing::info!({ ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"ident","?deb"
    tracing::info!({ foo = true, ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"ident","?deb"
    tracing::info!({ ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"ident","?deb"
    tracing::info!({ foo = true, ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"ident","?deb"
    tracing::info!(ident = %disp); // DEBUG:info,-,-,-,-,"ident","%disp"
    tracing::info!(foo = true, ident = %disp); // DEBUG:info,-,-,p,-,"ident","%disp"
    tracing::info!(ident = %disp, qux = 3); // DEBUG:info,-,-,f,-,"ident","%disp"
    tracing::info!(foo = true, ident = %disp, qux = 3); // DEBUG:info,-,-,pf,-,"ident","%disp"
    tracing::info!(ident = %disp, "msg without args"); // DEBUG:info,-,-,-,m,"ident","%disp"
    tracing::info!(foo = true, ident = %disp, "msg without args"); // DEBUG:info,-,-,p,m,"ident","%disp"
    tracing::info!(ident = %disp, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"ident","%disp"
    tracing::info!(foo = true, ident = %disp, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"ident","%disp"
    tracing::info!({ ident = %disp }, "msg without args"); // DEBUG:info,-,{},-,m,"ident","%disp"
    tracing::info!({ foo = true, ident = %disp }, "msg without args"); // DEBUG:info,-,{},p,m,"ident","%disp"
    tracing::info!({ ident = %disp, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"ident","%disp"
    tracing::info!({ foo = true, ident = %disp, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"ident","%disp"
    tracing::info!(ident = %disp, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"ident","%disp"
    tracing::info!(foo = true, ident = %disp, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"ident","%disp"
    tracing::info!(ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"ident","%disp"
    tracing::info!(foo = true, ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"ident","%disp"
    tracing::info!({ ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"ident","%disp"
    tracing::info!({ foo = true, ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"ident","%disp"
    tracing::info!({ ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"ident","%disp"
    tracing::info!({ foo = true, ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"ident","%disp"
    tracing::info!(ident = ?sub.field); // DEBUG:info,-,-,-,-,"ident","?sub.field"
    tracing::info!(foo = true, ident = ?sub.field); // DEBUG:info,-,-,p,-,"ident","?sub.field"
    tracing::info!(ident = ?sub.field, qux = 3); // DEBUG:info,-,-,f,-,"ident","?sub.field"
    tracing::info!(foo = true, ident = ?sub.field, qux = 3); // DEBUG:info,-,-,pf,-,"ident","?sub.field"
    tracing::info!(ident = ?sub.field, "msg without args"); // DEBUG:info,-,-,-,m,"ident","?sub.field"
    tracing::info!(foo = true, ident = ?sub.field, "msg without args"); // DEBUG:info,-,-,p,m,"ident","?sub.field"
    tracing::info!(ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"ident","?sub.field"
    tracing::info!(foo = true, ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"ident","?sub.field"
    tracing::info!({ ident = ?sub.field }, "msg without args"); // DEBUG:info,-,{},-,m,"ident","?sub.field"
    tracing::info!({ foo = true, ident = ?sub.field }, "msg without args"); // DEBUG:info,-,{},p,m,"ident","?sub.field"
    tracing::info!({ ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"ident","?sub.field"
    tracing::info!({ foo = true, ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"ident","?sub.field"
    tracing::info!(ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"ident","?sub.field"
    tracing::info!(foo = true, ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"ident","?sub.field"
    tracing::info!(ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"ident","?sub.field"
    tracing::info!(foo = true, ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"ident","?sub.field"
    tracing::info!({ ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"ident","?sub.field"
    tracing::info!({ foo = true, ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"ident","?sub.field"
    tracing::info!({ ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"ident","?sub.field"
    tracing::info!({ foo = true, ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"ident","?sub.field"
    tracing::info!(ident = %sub.field); // DEBUG:info,-,-,-,-,"ident","%sub.field"
    tracing::info!(foo = true, ident = %sub.field); // DEBUG:info,-,-,p,-,"ident","%sub.field"
    tracing::info!(ident = %sub.field, qux = 3); // DEBUG:info,-,-,f,-,"ident","%sub.field"
    tracing::info!(foo = true, ident = %sub.field, qux = 3); // DEBUG:info,-,-,pf,-,"ident","%sub.field"
    tracing::info!(ident = %sub.field, "msg without args"); // DEBUG:info,-,-,-,m,"ident","%sub.field"
    tracing::info!(foo = true, ident = %sub.field, "msg without args"); // DEBUG:info,-,-,p,m,"ident","%sub.field"
    tracing::info!(ident = %sub.field, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"ident","%sub.field"
    tracing::info!(foo = true, ident = %sub.field, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"ident","%sub.field"
    tracing::info!({ ident = %sub.field }, "msg without args"); // DEBUG:info,-,{},-,m,"ident","%sub.field"
    tracing::info!({ foo = true, ident = %sub.field }, "msg without args"); // DEBUG:info,-,{},p,m,"ident","%sub.field"
    tracing::info!({ ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"ident","%sub.field"
    tracing::info!({ foo = true, ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"ident","%sub.field"
    tracing::info!(ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"ident","%sub.field"
    tracing::info!(foo = true, ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"ident","%sub.field"
    tracing::info!(ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"ident","%sub.field"
    tracing::info!(foo = true, ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"ident","%sub.field"
    tracing::info!({ ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"ident","%sub.field"
    tracing::info!({ foo = true, ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"ident","%sub.field"
    tracing::info!({ ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"ident","%sub.field"
    tracing::info!({ foo = true, ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"ident","%sub.field"
    tracing::info!(ident = debug(&deb)); // DEBUG:info,-,-,-,-,"ident","debug(&deb)"
    tracing::info!(foo = true, ident = debug(&deb)); // DEBUG:info,-,-,p,-,"ident","debug(&deb)"
    tracing::info!(ident = debug(&deb), qux = 3); // DEBUG:info,-,-,f,-,"ident","debug(&deb)"
    tracing::info!(foo = true, ident = debug(&deb), qux = 3); // DEBUG:info,-,-,pf,-,"ident","debug(&deb)"
    tracing::info!(ident = debug(&deb), "msg without args"); // DEBUG:info,-,-,-,m,"ident","debug(&deb)"
    tracing::info!(foo = true, ident = debug(&deb), "msg without args"); // DEBUG:info,-,-,p,m,"ident","debug(&deb)"
    tracing::info!(ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"ident","debug(&deb)"
    tracing::info!(foo = true, ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"ident","debug(&deb)"
    tracing::info!({ ident = debug(&deb) }, "msg without args"); // DEBUG:info,-,{},-,m,"ident","debug(&deb)"
    tracing::info!({ foo = true, ident = debug(&deb) }, "msg without args"); // DEBUG:info,-,{},p,m,"ident","debug(&deb)"
    tracing::info!({ ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"ident","debug(&deb)"
    tracing::info!({ foo = true, ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"ident","debug(&deb)"
    tracing::info!(ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"ident","debug(&deb)"
    tracing::info!(foo = true, ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"ident","debug(&deb)"
    tracing::info!(ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"ident","debug(&deb)"
    tracing::info!(foo = true, ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"ident","debug(&deb)"
    tracing::info!({ ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"ident","debug(&deb)"
    tracing::info!({ foo = true, ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"ident","debug(&deb)"
    tracing::info!({ ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"ident","debug(&deb)"
    tracing::info!({ foo = true, ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"ident","debug(&deb)"
    tracing::info!(ident = display(&disp)); // DEBUG:info,-,-,-,-,"ident","display(&disp)"
    tracing::info!(foo = true, ident = display(&disp)); // DEBUG:info,-,-,p,-,"ident","display(&disp)"
    tracing::info!(ident = display(&disp), qux = 3); // DEBUG:info,-,-,f,-,"ident","display(&disp)"
    tracing::info!(foo = true, ident = display(&disp), qux = 3); // DEBUG:info,-,-,pf,-,"ident","display(&disp)"
    tracing::info!(ident = display(&disp), "msg without args"); // DEBUG:info,-,-,-,m,"ident","display(&disp)"
    tracing::info!(foo = true, ident = display(&disp), "msg without args"); // DEBUG:info,-,-,p,m,"ident","display(&disp)"
    tracing::info!(ident = display(&disp), qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"ident","display(&disp)"
    tracing::info!(foo = true, ident = display(&disp), qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"ident","display(&disp)"
    tracing::info!({ ident = display(&disp) }, "msg without args"); // DEBUG:info,-,{},-,m,"ident","display(&disp)"
    tracing::info!({ foo = true, ident = display(&disp) }, "msg without args"); // DEBUG:info,-,{},p,m,"ident","display(&disp)"
    tracing::info!({ ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"ident","display(&disp)"
    tracing::info!({ foo = true, ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"ident","display(&disp)"
    tracing::info!(ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"ident","display(&disp)"
    tracing::info!(foo = true, ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"ident","display(&disp)"
    tracing::info!(ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"ident","display(&disp)"
    tracing::info!(foo = true, ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"ident","display(&disp)"
    tracing::info!({ ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"ident","display(&disp)"
    tracing::info!({ foo = true, ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"ident","display(&disp)"
    tracing::info!({ ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"ident","display(&disp)"
    tracing::info!({ foo = true, ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"ident","display(&disp)"
    tracing::info!(ident = tracing::field::Empty); // DEBUG:info,-,-,-,-,"ident","tracing::field::Empty"
    tracing::info!(foo = true, ident = tracing::field::Empty); // DEBUG:info,-,-,p,-,"ident","tracing::field::Empty"
    tracing::info!(ident = tracing::field::Empty, qux = 3); // DEBUG:info,-,-,f,-,"ident","tracing::field::Empty"
    tracing::info!(foo = true, ident = tracing::field::Empty, qux = 3); // DEBUG:info,-,-,pf,-,"ident","tracing::field::Empty"
    tracing::info!(ident = tracing::field::Empty, "msg without args"); // DEBUG:info,-,-,-,m,"ident","tracing::field::Empty"
    tracing::info!(foo = true, ident = tracing::field::Empty, "msg without args"); // DEBUG:info,-,-,p,m,"ident","tracing::field::Empty"
    tracing::info!(ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"ident","tracing::field::Empty"
    tracing::info!(foo = true, ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"ident","tracing::field::Empty"
    tracing::info!({ ident = tracing::field::Empty }, "msg without args"); // DEBUG:info,-,{},-,m,"ident","tracing::field::Empty"
    tracing::info!({ foo = true, ident = tracing::field::Empty }, "msg without args"); // DEBUG:info,-,{},p,m,"ident","tracing::field::Empty"
    tracing::info!({ ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"ident","tracing::field::Empty"
    tracing::info!({ foo = true, ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"ident","tracing::field::Empty"
    tracing::info!(ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"ident","tracing::field::Empty"
    tracing::info!(foo = true, ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"ident","tracing::field::Empty"
    tracing::info!(ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"ident","tracing::field::Empty"
    tracing::info!(foo = true, ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"ident","tracing::field::Empty"
    tracing::info!({ ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"ident","tracing::field::Empty"
    tracing::info!({ foo = true, ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"ident","tracing::field::Empty"
    tracing::info!({ ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"ident","tracing::field::Empty"
    tracing::info!({ foo = true, ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"ident","tracing::field::Empty"
    tracing::info!(dotted.ident = 3); // DEBUG:info,-,-,-,-,"dotted.ident","3"
    tracing::info!(foo = true, dotted.ident = 3); // DEBUG:info,-,-,p,-,"dotted.ident","3"
    tracing::info!(dotted.ident = 3, qux = 3); // DEBUG:info,-,-,f,-,"dotted.ident","3"
    tracing::info!(foo = true, dotted.ident = 3, qux = 3); // DEBUG:info,-,-,pf,-,"dotted.ident","3"
    tracing::info!(dotted.ident = 3, "msg without args"); // DEBUG:info,-,-,-,m,"dotted.ident","3"
    tracing::info!(foo = true, dotted.ident = 3, "msg without args"); // DEBUG:info,-,-,p,m,"dotted.ident","3"
    tracing::info!(dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"dotted.ident","3"
    tracing::info!(foo = true, dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"dotted.ident","3"
    tracing::info!({ dotted.ident = 3 }, "msg without args"); // DEBUG:info,-,{},-,m,"dotted.ident","3"
    tracing::info!({ foo = true, dotted.ident = 3 }, "msg without args"); // DEBUG:info,-,{},p,m,"dotted.ident","3"
    tracing::info!({ dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"dotted.ident","3"
    tracing::info!({ foo = true, dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"dotted.ident","3"
    tracing::info!(dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"dotted.ident","3"
    tracing::info!(foo = true, dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"dotted.ident","3"
    tracing::info!(dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"dotted.ident","3"
    tracing::info!(foo = true, dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"dotted.ident","3"
    tracing::info!({ dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"dotted.ident","3"
    tracing::info!({ foo = true, dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"dotted.ident","3"
    tracing::info!({ dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"dotted.ident","3"
    tracing::info!({ foo = true, dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"dotted.ident","3"
    tracing::info!(dotted.ident = false); // DEBUG:info,-,-,-,-,"dotted.ident","false"
    tracing::info!(foo = true, dotted.ident = false); // DEBUG:info,-,-,p,-,"dotted.ident","false"
    tracing::info!(dotted.ident = false, qux = 3); // DEBUG:info,-,-,f,-,"dotted.ident","false"
    tracing::info!(foo = true, dotted.ident = false, qux = 3); // DEBUG:info,-,-,pf,-,"dotted.ident","false"
    tracing::info!(dotted.ident = false, "msg without args"); // DEBUG:info,-,-,-,m,"dotted.ident","false"
    tracing::info!(foo = true, dotted.ident = false, "msg without args"); // DEBUG:info,-,-,p,m,"dotted.ident","false"
    tracing::info!(dotted.ident = false, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"dotted.ident","false"
    tracing::info!(foo = true, dotted.ident = false, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"dotted.ident","false"
    tracing::info!({ dotted.ident = false }, "msg without args"); // DEBUG:info,-,{},-,m,"dotted.ident","false"
    tracing::info!({ foo = true, dotted.ident = false }, "msg without args"); // DEBUG:info,-,{},p,m,"dotted.ident","false"
    tracing::info!({ dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"dotted.ident","false"
    tracing::info!({ foo = true, dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"dotted.ident","false"
    tracing::info!(dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"dotted.ident","false"
    tracing::info!(foo = true, dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"dotted.ident","false"
    tracing::info!(dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"dotted.ident","false"
    tracing::info!(foo = true, dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"dotted.ident","false"
    tracing::info!({ dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"dotted.ident","false"
    tracing::info!({ foo = true, dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"dotted.ident","false"
    tracing::info!({ dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"dotted.ident","false"
    tracing::info!({ foo = true, dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"dotted.ident","false"
    tracing::info!(dotted.ident = ?3); // DEBUG:info,-,-,-,-,"dotted.ident","?3"
    tracing::info!(foo = true, dotted.ident = ?3); // DEBUG:info,-,-,p,-,"dotted.ident","?3"
    tracing::info!(dotted.ident = ?3, qux = 3); // DEBUG:info,-,-,f,-,"dotted.ident","?3"
    tracing::info!(foo = true, dotted.ident = ?3, qux = 3); // DEBUG:info,-,-,pf,-,"dotted.ident","?3"
    tracing::info!(dotted.ident = ?3, "msg without args"); // DEBUG:info,-,-,-,m,"dotted.ident","?3"
    tracing::info!(foo = true, dotted.ident = ?3, "msg without args"); // DEBUG:info,-,-,p,m,"dotted.ident","?3"
    tracing::info!(dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"dotted.ident","?3"
    tracing::info!(foo = true, dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"dotted.ident","?3"
    tracing::info!({ dotted.ident = ?3 }, "msg without args"); // DEBUG:info,-,{},-,m,"dotted.ident","?3"
    tracing::info!({ foo = true, dotted.ident = ?3 }, "msg without args"); // DEBUG:info,-,{},p,m,"dotted.ident","?3"
    tracing::info!({ dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"dotted.ident","?3"
    tracing::info!({ foo = true, dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"dotted.ident","?3"
    tracing::info!(dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"dotted.ident","?3"
    tracing::info!(foo = true, dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"dotted.ident","?3"
    tracing::info!(dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"dotted.ident","?3"
    tracing::info!(foo = true, dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"dotted.ident","?3"
    tracing::info!({ dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"dotted.ident","?3"
    tracing::info!({ foo = true, dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"dotted.ident","?3"
    tracing::info!({ dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"dotted.ident","?3"
    tracing::info!({ foo = true, dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"dotted.ident","?3"
    tracing::info!(dotted.ident = %3); // DEBUG:info,-,-,-,-,"dotted.ident","%3"
    tracing::info!(foo = true, dotted.ident = %3); // DEBUG:info,-,-,p,-,"dotted.ident","%3"
    tracing::info!(dotted.ident = %3, qux = 3); // DEBUG:info,-,-,f,-,"dotted.ident","%3"
    tracing::info!(foo = true, dotted.ident = %3, qux = 3); // DEBUG:info,-,-,pf,-,"dotted.ident","%3"
    tracing::info!(dotted.ident = %3, "msg without args"); // DEBUG:info,-,-,-,m,"dotted.ident","%3"
    tracing::info!(foo = true, dotted.ident = %3, "msg without args"); // DEBUG:info,-,-,p,m,"dotted.ident","%3"
    tracing::info!(dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"dotted.ident","%3"
    tracing::info!(foo = true, dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"dotted.ident","%3"
    tracing::info!({ dotted.ident = %3 }, "msg without args"); // DEBUG:info,-,{},-,m,"dotted.ident","%3"
    tracing::info!({ foo = true, dotted.ident = %3 }, "msg without args"); // DEBUG:info,-,{},p,m,"dotted.ident","%3"
    tracing::info!({ dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"dotted.ident","%3"
    tracing::info!({ foo = true, dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"dotted.ident","%3"
    tracing::info!(dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"dotted.ident","%3"
    tracing::info!(foo = true, dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"dotted.ident","%3"
    tracing::info!(dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"dotted.ident","%3"
    tracing::info!(foo = true, dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"dotted.ident","%3"
    tracing::info!({ dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"dotted.ident","%3"
    tracing::info!({ foo = true, dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"dotted.ident","%3"
    tracing::info!({ dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"dotted.ident","%3"
    tracing::info!({ foo = true, dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"dotted.ident","%3"
    tracing::info!(dotted.ident = ?deb); // DEBUG:info,-,-,-,-,"dotted.ident","?deb"
    tracing::info!(foo = true, dotted.ident = ?deb); // DEBUG:info,-,-,p,-,"dotted.ident","?deb"
    tracing::info!(dotted.ident = ?deb, qux = 3); // DEBUG:info,-,-,f,-,"dotted.ident","?deb"
    tracing::info!(foo = true, dotted.ident = ?deb, qux = 3); // DEBUG:info,-,-,pf,-,"dotted.ident","?deb"
    tracing::info!(dotted.ident = ?deb, "msg without args"); // DEBUG:info,-,-,-,m,"dotted.ident","?deb"
    tracing::info!(foo = true, dotted.ident = ?deb, "msg without args"); // DEBUG:info,-,-,p,m,"dotted.ident","?deb"
    tracing::info!(dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"dotted.ident","?deb"
    tracing::info!(foo = true, dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"dotted.ident","?deb"
    tracing::info!({ dotted.ident = ?deb }, "msg without args"); // DEBUG:info,-,{},-,m,"dotted.ident","?deb"
    tracing::info!({ foo = true, dotted.ident = ?deb }, "msg without args"); // DEBUG:info,-,{},p,m,"dotted.ident","?deb"
    tracing::info!({ dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"dotted.ident","?deb"
    tracing::info!({ foo = true, dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"dotted.ident","?deb"
    tracing::info!(dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"dotted.ident","?deb"
    tracing::info!(foo = true, dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"dotted.ident","?deb"
    tracing::info!(dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"dotted.ident","?deb"
    tracing::info!(foo = true, dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"dotted.ident","?deb"
    tracing::info!({ dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"dotted.ident","?deb"
    tracing::info!({ foo = true, dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"dotted.ident","?deb"
    tracing::info!({ dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"dotted.ident","?deb"
    tracing::info!({ foo = true, dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"dotted.ident","?deb"
    tracing::info!(dotted.ident = %disp); // DEBUG:info,-,-,-,-,"dotted.ident","%disp"
    tracing::info!(foo = true, dotted.ident = %disp); // DEBUG:info,-,-,p,-,"dotted.ident","%disp"
    tracing::info!(dotted.ident = %disp, qux = 3); // DEBUG:info,-,-,f,-,"dotted.ident","%disp"
    tracing::info!(foo = true, dotted.ident = %disp, qux = 3); // DEBUG:info,-,-,pf,-,"dotted.ident","%disp"
    tracing::info!(dotted.ident = %disp, "msg without args"); // DEBUG:info,-,-,-,m,"dotted.ident","%disp"
    tracing::info!(foo = true, dotted.ident = %disp, "msg without args"); // DEBUG:info,-,-,p,m,"dotted.ident","%disp"
    tracing::info!(dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"dotted.ident","%disp"
    tracing::info!(foo = true, dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"dotted.ident","%disp"
    tracing::info!({ dotted.ident = %disp }, "msg without args"); // DEBUG:info,-,{},-,m,"dotted.ident","%disp"
    tracing::info!({ foo = true, dotted.ident = %disp }, "msg without args"); // DEBUG:info,-,{},p,m,"dotted.ident","%disp"
    tracing::info!({ dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"dotted.ident","%disp"
    tracing::info!({ foo = true, dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"dotted.ident","%disp"
    tracing::info!(dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"dotted.ident","%disp"
    tracing::info!(foo = true, dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"dotted.ident","%disp"
    tracing::info!(dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"dotted.ident","%disp"
    tracing::info!(foo = true, dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"dotted.ident","%disp"
    tracing::info!({ dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"dotted.ident","%disp"
    tracing::info!({ foo = true, dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"dotted.ident","%disp"
    tracing::info!({ dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"dotted.ident","%disp"
    tracing::info!({ foo = true, dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"dotted.ident","%disp"
    tracing::info!(dotted.ident = ?sub.field); // DEBUG:info,-,-,-,-,"dotted.ident","?sub.field"
    tracing::info!(foo = true, dotted.ident = ?sub.field); // DEBUG:info,-,-,p,-,"dotted.ident","?sub.field"
    tracing::info!(dotted.ident = ?sub.field, qux = 3); // DEBUG:info,-,-,f,-,"dotted.ident","?sub.field"
    tracing::info!(foo = true, dotted.ident = ?sub.field, qux = 3); // DEBUG:info,-,-,pf,-,"dotted.ident","?sub.field"
    tracing::info!(dotted.ident = ?sub.field, "msg without args"); // DEBUG:info,-,-,-,m,"dotted.ident","?sub.field"
    tracing::info!(foo = true, dotted.ident = ?sub.field, "msg without args"); // DEBUG:info,-,-,p,m,"dotted.ident","?sub.field"
    tracing::info!(dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"dotted.ident","?sub.field"
    tracing::info!(foo = true, dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"dotted.ident","?sub.field"
    tracing::info!({ dotted.ident = ?sub.field }, "msg without args"); // DEBUG:info,-,{},-,m,"dotted.ident","?sub.field"
    tracing::info!({ foo = true, dotted.ident = ?sub.field }, "msg without args"); // DEBUG:info,-,{},p,m,"dotted.ident","?sub.field"
    tracing::info!({ dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"dotted.ident","?sub.field"
    tracing::info!({ foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"dotted.ident","?sub.field"
    tracing::info!(dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"dotted.ident","?sub.field"
    tracing::info!(foo = true, dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"dotted.ident","?sub.field"
    tracing::info!(dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"dotted.ident","?sub.field"
    tracing::info!(foo = true, dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"dotted.ident","?sub.field"
    tracing::info!({ dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"dotted.ident","?sub.field"
    tracing::info!({ foo = true, dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"dotted.ident","?sub.field"
    tracing::info!({ dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"dotted.ident","?sub.field"
    tracing::info!({ foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"dotted.ident","?sub.field"
    tracing::info!(dotted.ident = %sub.field); // DEBUG:info,-,-,-,-,"dotted.ident","%sub.field"
    tracing::info!(foo = true, dotted.ident = %sub.field); // DEBUG:info,-,-,p,-,"dotted.ident","%sub.field"
    tracing::info!(dotted.ident = %sub.field, qux = 3); // DEBUG:info,-,-,f,-,"dotted.ident","%sub.field"
    tracing::info!(foo = true, dotted.ident = %sub.field, qux = 3); // DEBUG:info,-,-,pf,-,"dotted.ident","%sub.field"
    tracing::info!(dotted.ident = %sub.field, "msg without args"); // DEBUG:info,-,-,-,m,"dotted.ident","%sub.field"
    tracing::info!(foo = true, dotted.ident = %sub.field, "msg without args"); // DEBUG:info,-,-,p,m,"dotted.ident","%sub.field"
    tracing::info!(dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"dotted.ident","%sub.field"
    tracing::info!(foo = true, dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"dotted.ident","%sub.field"
    tracing::info!({ dotted.ident = %sub.field }, "msg without args"); // DEBUG:info,-,{},-,m,"dotted.ident","%sub.field"
    tracing::info!({ foo = true, dotted.ident = %sub.field }, "msg without args"); // DEBUG:info,-,{},p,m,"dotted.ident","%sub.field"
    tracing::info!({ dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"dotted.ident","%sub.field"
    tracing::info!({ foo = true, dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"dotted.ident","%sub.field"
    tracing::info!(dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"dotted.ident","%sub.field"
    tracing::info!(foo = true, dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"dotted.ident","%sub.field"
    tracing::info!(dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"dotted.ident","%sub.field"
    tracing::info!(foo = true, dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"dotted.ident","%sub.field"
    tracing::info!({ dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"dotted.ident","%sub.field"
    tracing::info!({ foo = true, dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"dotted.ident","%sub.field"
    tracing::info!({ dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"dotted.ident","%sub.field"
    tracing::info!({ foo = true, dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"dotted.ident","%sub.field"
    tracing::info!(dotted.ident = debug(&deb)); // DEBUG:info,-,-,-,-,"dotted.ident","debug(&deb)"
    tracing::info!(foo = true, dotted.ident = debug(&deb)); // DEBUG:info,-,-,p,-,"dotted.ident","debug(&deb)"
    tracing::info!(dotted.ident = debug(&deb), qux = 3); // DEBUG:info,-,-,f,-,"dotted.ident","debug(&deb)"
    tracing::info!(foo = true, dotted.ident = debug(&deb), qux = 3); // DEBUG:info,-,-,pf,-,"dotted.ident","debug(&deb)"
    tracing::info!(dotted.ident = debug(&deb), "msg without args"); // DEBUG:info,-,-,-,m,"dotted.ident","debug(&deb)"
    tracing::info!(foo = true, dotted.ident = debug(&deb), "msg without args"); // DEBUG:info,-,-,p,m,"dotted.ident","debug(&deb)"
    tracing::info!(dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"dotted.ident","debug(&deb)"
    tracing::info!(foo = true, dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"dotted.ident","debug(&deb)"
    tracing::info!({ dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:info,-,{},-,m,"dotted.ident","debug(&deb)"
    tracing::info!({ foo = true, dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:info,-,{},p,m,"dotted.ident","debug(&deb)"
    tracing::info!({ dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"dotted.ident","debug(&deb)"
    tracing::info!({ foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"dotted.ident","debug(&deb)"
    tracing::info!(dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"dotted.ident","debug(&deb)"
    tracing::info!(foo = true, dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"dotted.ident","debug(&deb)"
    tracing::info!(dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"dotted.ident","debug(&deb)"
    tracing::info!(foo = true, dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"dotted.ident","debug(&deb)"
    tracing::info!({ dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"dotted.ident","debug(&deb)"
    tracing::info!({ foo = true, dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"dotted.ident","debug(&deb)"
    tracing::info!({ dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"dotted.ident","debug(&deb)"
    tracing::info!({ foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"dotted.ident","debug(&deb)"
    tracing::info!(dotted.ident = display(&disp)); // DEBUG:info,-,-,-,-,"dotted.ident","display(&disp)"
    tracing::info!(foo = true, dotted.ident = display(&disp)); // DEBUG:info,-,-,p,-,"dotted.ident","display(&disp)"
    tracing::info!(dotted.ident = display(&disp), qux = 3); // DEBUG:info,-,-,f,-,"dotted.ident","display(&disp)"
    tracing::info!(foo = true, dotted.ident = display(&disp), qux = 3); // DEBUG:info,-,-,pf,-,"dotted.ident","display(&disp)"
    tracing::info!(dotted.ident = display(&disp), "msg without args"); // DEBUG:info,-,-,-,m,"dotted.ident","display(&disp)"
    tracing::info!(foo = true, dotted.ident = display(&disp), "msg without args"); // DEBUG:info,-,-,p,m,"dotted.ident","display(&disp)"
    tracing::info!(dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"dotted.ident","display(&disp)"
    tracing::info!(foo = true, dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"dotted.ident","display(&disp)"
    tracing::info!({ dotted.ident = display(&disp) }, "msg without args"); // DEBUG:info,-,{},-,m,"dotted.ident","display(&disp)"
    tracing::info!({ foo = true, dotted.ident = display(&disp) }, "msg without args"); // DEBUG:info,-,{},p,m,"dotted.ident","display(&disp)"
    tracing::info!({ dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"dotted.ident","display(&disp)"
    tracing::info!({ foo = true, dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"dotted.ident","display(&disp)"
    tracing::info!(dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"dotted.ident","display(&disp)"
    tracing::info!(foo = true, dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"dotted.ident","display(&disp)"
    tracing::info!(dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"dotted.ident","display(&disp)"
    tracing::info!(foo = true, dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"dotted.ident","display(&disp)"
    tracing::info!({ dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"dotted.ident","display(&disp)"
    tracing::info!({ foo = true, dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"dotted.ident","display(&disp)"
    tracing::info!({ dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"dotted.ident","display(&disp)"
    tracing::info!({ foo = true, dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"dotted.ident","display(&disp)"
    tracing::info!(dotted.ident = tracing::field::Empty); // DEBUG:info,-,-,-,-,"dotted.ident","tracing::field::Empty"
    tracing::info!(foo = true, dotted.ident = tracing::field::Empty); // DEBUG:info,-,-,p,-,"dotted.ident","tracing::field::Empty"
    tracing::info!(dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:info,-,-,f,-,"dotted.ident","tracing::field::Empty"
    tracing::info!(foo = true, dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:info,-,-,pf,-,"dotted.ident","tracing::field::Empty"
    tracing::info!(dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:info,-,-,-,m,"dotted.ident","tracing::field::Empty"
    tracing::info!(foo = true, dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:info,-,-,p,m,"dotted.ident","tracing::field::Empty"
    tracing::info!(dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"dotted.ident","tracing::field::Empty"
    tracing::info!(foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"dotted.ident","tracing::field::Empty"
    tracing::info!({ dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:info,-,{},-,m,"dotted.ident","tracing::field::Empty"
    tracing::info!({ foo = true, dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:info,-,{},p,m,"dotted.ident","tracing::field::Empty"
    tracing::info!({ dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"dotted.ident","tracing::field::Empty"
    tracing::info!({ foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"dotted.ident","tracing::field::Empty"
    tracing::info!(dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"dotted.ident","tracing::field::Empty"
    tracing::info!(foo = true, dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"dotted.ident","tracing::field::Empty"
    tracing::info!(dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"dotted.ident","tracing::field::Empty"
    tracing::info!(foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::info!({ dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"dotted.ident","tracing::field::Empty"
    tracing::info!({ foo = true, dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"dotted.ident","tracing::field::Empty"
    tracing::info!({ dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"dotted.ident","tracing::field::Empty"
    tracing::info!({ foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::info!("literal" = 3); // DEBUG:info,-,-,-,-,"\"literal\"","3"
    tracing::info!(foo = true, "literal" = 3); // DEBUG:info,-,-,p,-,"\"literal\"","3"
    tracing::info!("literal" = 3, qux = 3); // DEBUG:info,-,-,f,-,"\"literal\"","3"
    tracing::info!(foo = true, "literal" = 3, qux = 3); // DEBUG:info,-,-,pf,-,"\"literal\"","3"
    tracing::info!("literal" = 3, "msg without args"); // DEBUG:info,-,-,-,m,"\"literal\"","3"
    tracing::info!(foo = true, "literal" = 3, "msg without args"); // DEBUG:info,-,-,p,m,"\"literal\"","3"
    tracing::info!("literal" = 3, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"\"literal\"","3"
    tracing::info!(foo = true, "literal" = 3, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"\"literal\"","3"
    tracing::info!({ "literal" = 3 }, "msg without args"); // DEBUG:info,-,{},-,m,"\"literal\"","3"
    tracing::info!({ foo = true, "literal" = 3 }, "msg without args"); // DEBUG:info,-,{},p,m,"\"literal\"","3"
    tracing::info!({ "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"\"literal\"","3"
    tracing::info!({ foo = true, "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"\"literal\"","3"
    tracing::info!("literal" = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"\"literal\"","3"
    tracing::info!(foo = true, "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"\"literal\"","3"
    tracing::info!("literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"\"literal\"","3"
    tracing::info!(foo = true, "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"\"literal\"","3"
    tracing::info!({ "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"\"literal\"","3"
    tracing::info!({ foo = true, "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"\"literal\"","3"
    tracing::info!({ "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"\"literal\"","3"
    tracing::info!({ foo = true, "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"\"literal\"","3"
    tracing::info!("literal" = false); // DEBUG:info,-,-,-,-,"\"literal\"","false"
    tracing::info!(foo = true, "literal" = false); // DEBUG:info,-,-,p,-,"\"literal\"","false"
    tracing::info!("literal" = false, qux = 3); // DEBUG:info,-,-,f,-,"\"literal\"","false"
    tracing::info!(foo = true, "literal" = false, qux = 3); // DEBUG:info,-,-,pf,-,"\"literal\"","false"
    tracing::info!("literal" = false, "msg without args"); // DEBUG:info,-,-,-,m,"\"literal\"","false"
    tracing::info!(foo = true, "literal" = false, "msg without args"); // DEBUG:info,-,-,p,m,"\"literal\"","false"
    tracing::info!("literal" = false, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"\"literal\"","false"
    tracing::info!(foo = true, "literal" = false, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"\"literal\"","false"
    tracing::info!({ "literal" = false }, "msg without args"); // DEBUG:info,-,{},-,m,"\"literal\"","false"
    tracing::info!({ foo = true, "literal" = false }, "msg without args"); // DEBUG:info,-,{},p,m,"\"literal\"","false"
    tracing::info!({ "literal" = false, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"\"literal\"","false"
    tracing::info!({ foo = true, "literal" = false, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"\"literal\"","false"
    tracing::info!("literal" = false, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"\"literal\"","false"
    tracing::info!(foo = true, "literal" = false, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"\"literal\"","false"
    tracing::info!("literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"\"literal\"","false"
    tracing::info!(foo = true, "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"\"literal\"","false"
    tracing::info!({ "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"\"literal\"","false"
    tracing::info!({ foo = true, "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"\"literal\"","false"
    tracing::info!({ "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"\"literal\"","false"
    tracing::info!({ foo = true, "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"\"literal\"","false"
    tracing::info!("literal" = ?3); // DEBUG:info,-,-,-,-,"\"literal\"","?3"
    tracing::info!(foo = true, "literal" = ?3); // DEBUG:info,-,-,p,-,"\"literal\"","?3"
    tracing::info!("literal" = ?3, qux = 3); // DEBUG:info,-,-,f,-,"\"literal\"","?3"
    tracing::info!(foo = true, "literal" = ?3, qux = 3); // DEBUG:info,-,-,pf,-,"\"literal\"","?3"
    tracing::info!("literal" = ?3, "msg without args"); // DEBUG:info,-,-,-,m,"\"literal\"","?3"
    tracing::info!(foo = true, "literal" = ?3, "msg without args"); // DEBUG:info,-,-,p,m,"\"literal\"","?3"
    tracing::info!("literal" = ?3, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"\"literal\"","?3"
    tracing::info!(foo = true, "literal" = ?3, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"\"literal\"","?3"
    tracing::info!({ "literal" = ?3 }, "msg without args"); // DEBUG:info,-,{},-,m,"\"literal\"","?3"
    tracing::info!({ foo = true, "literal" = ?3 }, "msg without args"); // DEBUG:info,-,{},p,m,"\"literal\"","?3"
    tracing::info!({ "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"\"literal\"","?3"
    tracing::info!({ foo = true, "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"\"literal\"","?3"
    tracing::info!("literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"\"literal\"","?3"
    tracing::info!(foo = true, "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"\"literal\"","?3"
    tracing::info!("literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"\"literal\"","?3"
    tracing::info!(foo = true, "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"\"literal\"","?3"
    tracing::info!({ "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"\"literal\"","?3"
    tracing::info!({ foo = true, "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"\"literal\"","?3"
    tracing::info!({ "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"\"literal\"","?3"
    tracing::info!({ foo = true, "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"\"literal\"","?3"
    tracing::info!("literal" = %3); // DEBUG:info,-,-,-,-,"\"literal\"","%3"
    tracing::info!(foo = true, "literal" = %3); // DEBUG:info,-,-,p,-,"\"literal\"","%3"
    tracing::info!("literal" = %3, qux = 3); // DEBUG:info,-,-,f,-,"\"literal\"","%3"
    tracing::info!(foo = true, "literal" = %3, qux = 3); // DEBUG:info,-,-,pf,-,"\"literal\"","%3"
    tracing::info!("literal" = %3, "msg without args"); // DEBUG:info,-,-,-,m,"\"literal\"","%3"
    tracing::info!(foo = true, "literal" = %3, "msg without args"); // DEBUG:info,-,-,p,m,"\"literal\"","%3"
    tracing::info!("literal" = %3, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"\"literal\"","%3"
    tracing::info!(foo = true, "literal" = %3, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"\"literal\"","%3"
    tracing::info!({ "literal" = %3 }, "msg without args"); // DEBUG:info,-,{},-,m,"\"literal\"","%3"
    tracing::info!({ foo = true, "literal" = %3 }, "msg without args"); // DEBUG:info,-,{},p,m,"\"literal\"","%3"
    tracing::info!({ "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"\"literal\"","%3"
    tracing::info!({ foo = true, "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"\"literal\"","%3"
    tracing::info!("literal" = %3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"\"literal\"","%3"
    tracing::info!(foo = true, "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"\"literal\"","%3"
    tracing::info!("literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"\"literal\"","%3"
    tracing::info!(foo = true, "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"\"literal\"","%3"
    tracing::info!({ "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"\"literal\"","%3"
    tracing::info!({ foo = true, "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"\"literal\"","%3"
    tracing::info!({ "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"\"literal\"","%3"
    tracing::info!({ foo = true, "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"\"literal\"","%3"
    tracing::info!("literal" = ?deb); // DEBUG:info,-,-,-,-,"\"literal\"","?deb"
    tracing::info!(foo = true, "literal" = ?deb); // DEBUG:info,-,-,p,-,"\"literal\"","?deb"
    tracing::info!("literal" = ?deb, qux = 3); // DEBUG:info,-,-,f,-,"\"literal\"","?deb"
    tracing::info!(foo = true, "literal" = ?deb, qux = 3); // DEBUG:info,-,-,pf,-,"\"literal\"","?deb"
    tracing::info!("literal" = ?deb, "msg without args"); // DEBUG:info,-,-,-,m,"\"literal\"","?deb"
    tracing::info!(foo = true, "literal" = ?deb, "msg without args"); // DEBUG:info,-,-,p,m,"\"literal\"","?deb"
    tracing::info!("literal" = ?deb, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"\"literal\"","?deb"
    tracing::info!(foo = true, "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"\"literal\"","?deb"
    tracing::info!({ "literal" = ?deb }, "msg without args"); // DEBUG:info,-,{},-,m,"\"literal\"","?deb"
    tracing::info!({ foo = true, "literal" = ?deb }, "msg without args"); // DEBUG:info,-,{},p,m,"\"literal\"","?deb"
    tracing::info!({ "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"\"literal\"","?deb"
    tracing::info!({ foo = true, "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"\"literal\"","?deb"
    tracing::info!("literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"\"literal\"","?deb"
    tracing::info!(foo = true, "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"\"literal\"","?deb"
    tracing::info!("literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"\"literal\"","?deb"
    tracing::info!(foo = true, "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"\"literal\"","?deb"
    tracing::info!({ "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"\"literal\"","?deb"
    tracing::info!({ foo = true, "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"\"literal\"","?deb"
    tracing::info!({ "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"\"literal\"","?deb"
    tracing::info!({ foo = true, "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"\"literal\"","?deb"
    tracing::info!("literal" = %disp); // DEBUG:info,-,-,-,-,"\"literal\"","%disp"
    tracing::info!(foo = true, "literal" = %disp); // DEBUG:info,-,-,p,-,"\"literal\"","%disp"
    tracing::info!("literal" = %disp, qux = 3); // DEBUG:info,-,-,f,-,"\"literal\"","%disp"
    tracing::info!(foo = true, "literal" = %disp, qux = 3); // DEBUG:info,-,-,pf,-,"\"literal\"","%disp"
    tracing::info!("literal" = %disp, "msg without args"); // DEBUG:info,-,-,-,m,"\"literal\"","%disp"
    tracing::info!(foo = true, "literal" = %disp, "msg without args"); // DEBUG:info,-,-,p,m,"\"literal\"","%disp"
    tracing::info!("literal" = %disp, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"\"literal\"","%disp"
    tracing::info!(foo = true, "literal" = %disp, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"\"literal\"","%disp"
    tracing::info!({ "literal" = %disp }, "msg without args"); // DEBUG:info,-,{},-,m,"\"literal\"","%disp"
    tracing::info!({ foo = true, "literal" = %disp }, "msg without args"); // DEBUG:info,-,{},p,m,"\"literal\"","%disp"
    tracing::info!({ "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"\"literal\"","%disp"
    tracing::info!({ foo = true, "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"\"literal\"","%disp"
    tracing::info!("literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"\"literal\"","%disp"
    tracing::info!(foo = true, "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"\"literal\"","%disp"
    tracing::info!("literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"\"literal\"","%disp"
    tracing::info!(foo = true, "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"\"literal\"","%disp"
    tracing::info!({ "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"\"literal\"","%disp"
    tracing::info!({ foo = true, "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"\"literal\"","%disp"
    tracing::info!({ "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"\"literal\"","%disp"
    tracing::info!({ foo = true, "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"\"literal\"","%disp"
    tracing::info!("literal" = ?sub.field); // DEBUG:info,-,-,-,-,"\"literal\"","?sub.field"
    tracing::info!(foo = true, "literal" = ?sub.field); // DEBUG:info,-,-,p,-,"\"literal\"","?sub.field"
    tracing::info!("literal" = ?sub.field, qux = 3); // DEBUG:info,-,-,f,-,"\"literal\"","?sub.field"
    tracing::info!(foo = true, "literal" = ?sub.field, qux = 3); // DEBUG:info,-,-,pf,-,"\"literal\"","?sub.field"
    tracing::info!("literal" = ?sub.field, "msg without args"); // DEBUG:info,-,-,-,m,"\"literal\"","?sub.field"
    tracing::info!(foo = true, "literal" = ?sub.field, "msg without args"); // DEBUG:info,-,-,p,m,"\"literal\"","?sub.field"
    tracing::info!("literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"\"literal\"","?sub.field"
    tracing::info!(foo = true, "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"\"literal\"","?sub.field"
    tracing::info!({ "literal" = ?sub.field }, "msg without args"); // DEBUG:info,-,{},-,m,"\"literal\"","?sub.field"
    tracing::info!({ foo = true, "literal" = ?sub.field }, "msg without args"); // DEBUG:info,-,{},p,m,"\"literal\"","?sub.field"
    tracing::info!({ "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"\"literal\"","?sub.field"
    tracing::info!({ foo = true, "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"\"literal\"","?sub.field"
    tracing::info!("literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"\"literal\"","?sub.field"
    tracing::info!(foo = true, "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"\"literal\"","?sub.field"
    tracing::info!("literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"\"literal\"","?sub.field"
    tracing::info!(foo = true, "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"\"literal\"","?sub.field"
    tracing::info!({ "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"\"literal\"","?sub.field"
    tracing::info!({ foo = true, "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"\"literal\"","?sub.field"
    tracing::info!({ "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"\"literal\"","?sub.field"
    tracing::info!({ foo = true, "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"\"literal\"","?sub.field"
    tracing::info!("literal" = %sub.field); // DEBUG:info,-,-,-,-,"\"literal\"","%sub.field"
    tracing::info!(foo = true, "literal" = %sub.field); // DEBUG:info,-,-,p,-,"\"literal\"","%sub.field"
    tracing::info!("literal" = %sub.field, qux = 3); // DEBUG:info,-,-,f,-,"\"literal\"","%sub.field"
    tracing::info!(foo = true, "literal" = %sub.field, qux = 3); // DEBUG:info,-,-,pf,-,"\"literal\"","%sub.field"
    tracing::info!("literal" = %sub.field, "msg without args"); // DEBUG:info,-,-,-,m,"\"literal\"","%sub.field"
    tracing::info!(foo = true, "literal" = %sub.field, "msg without args"); // DEBUG:info,-,-,p,m,"\"literal\"","%sub.field"
    tracing::info!("literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"\"literal\"","%sub.field"
    tracing::info!(foo = true, "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"\"literal\"","%sub.field"
    tracing::info!({ "literal" = %sub.field }, "msg without args"); // DEBUG:info,-,{},-,m,"\"literal\"","%sub.field"
    tracing::info!({ foo = true, "literal" = %sub.field }, "msg without args"); // DEBUG:info,-,{},p,m,"\"literal\"","%sub.field"
    tracing::info!({ "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"\"literal\"","%sub.field"
    tracing::info!({ foo = true, "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"\"literal\"","%sub.field"
    tracing::info!("literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"\"literal\"","%sub.field"
    tracing::info!(foo = true, "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"\"literal\"","%sub.field"
    tracing::info!("literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"\"literal\"","%sub.field"
    tracing::info!(foo = true, "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"\"literal\"","%sub.field"
    tracing::info!({ "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"\"literal\"","%sub.field"
    tracing::info!({ foo = true, "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"\"literal\"","%sub.field"
    tracing::info!({ "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"\"literal\"","%sub.field"
    tracing::info!({ foo = true, "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"\"literal\"","%sub.field"
    tracing::info!("literal" = debug(&deb)); // DEBUG:info,-,-,-,-,"\"literal\"","debug(&deb)"
    tracing::info!(foo = true, "literal" = debug(&deb)); // DEBUG:info,-,-,p,-,"\"literal\"","debug(&deb)"
    tracing::info!("literal" = debug(&deb), qux = 3); // DEBUG:info,-,-,f,-,"\"literal\"","debug(&deb)"
    tracing::info!(foo = true, "literal" = debug(&deb), qux = 3); // DEBUG:info,-,-,pf,-,"\"literal\"","debug(&deb)"
    tracing::info!("literal" = debug(&deb), "msg without args"); // DEBUG:info,-,-,-,m,"\"literal\"","debug(&deb)"
    tracing::info!(foo = true, "literal" = debug(&deb), "msg without args"); // DEBUG:info,-,-,p,m,"\"literal\"","debug(&deb)"
    tracing::info!("literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"\"literal\"","debug(&deb)"
    tracing::info!(foo = true, "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"\"literal\"","debug(&deb)"
    tracing::info!({ "literal" = debug(&deb) }, "msg without args"); // DEBUG:info,-,{},-,m,"\"literal\"","debug(&deb)"
    tracing::info!({ foo = true, "literal" = debug(&deb) }, "msg without args"); // DEBUG:info,-,{},p,m,"\"literal\"","debug(&deb)"
    tracing::info!({ "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"\"literal\"","debug(&deb)"
    tracing::info!({ foo = true, "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"\"literal\"","debug(&deb)"
    tracing::info!("literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"\"literal\"","debug(&deb)"
    tracing::info!(foo = true, "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"\"literal\"","debug(&deb)"
    tracing::info!("literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"\"literal\"","debug(&deb)"
    tracing::info!(foo = true, "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"\"literal\"","debug(&deb)"
    tracing::info!({ "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"\"literal\"","debug(&deb)"
    tracing::info!({ foo = true, "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"\"literal\"","debug(&deb)"
    tracing::info!({ "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"\"literal\"","debug(&deb)"
    tracing::info!({ foo = true, "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"\"literal\"","debug(&deb)"
    tracing::info!("literal" = display(&disp)); // DEBUG:info,-,-,-,-,"\"literal\"","display(&disp)"
    tracing::info!(foo = true, "literal" = display(&disp)); // DEBUG:info,-,-,p,-,"\"literal\"","display(&disp)"
    tracing::info!("literal" = display(&disp), qux = 3); // DEBUG:info,-,-,f,-,"\"literal\"","display(&disp)"
    tracing::info!(foo = true, "literal" = display(&disp), qux = 3); // DEBUG:info,-,-,pf,-,"\"literal\"","display(&disp)"
    tracing::info!("literal" = display(&disp), "msg without args"); // DEBUG:info,-,-,-,m,"\"literal\"","display(&disp)"
    tracing::info!(foo = true, "literal" = display(&disp), "msg without args"); // DEBUG:info,-,-,p,m,"\"literal\"","display(&disp)"
    tracing::info!("literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"\"literal\"","display(&disp)"
    tracing::info!(foo = true, "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"\"literal\"","display(&disp)"
    tracing::info!({ "literal" = display(&disp) }, "msg without args"); // DEBUG:info,-,{},-,m,"\"literal\"","display(&disp)"
    tracing::info!({ foo = true, "literal" = display(&disp) }, "msg without args"); // DEBUG:info,-,{},p,m,"\"literal\"","display(&disp)"
    tracing::info!({ "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"\"literal\"","display(&disp)"
    tracing::info!({ foo = true, "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"\"literal\"","display(&disp)"
    tracing::info!("literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"\"literal\"","display(&disp)"
    tracing::info!(foo = true, "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"\"literal\"","display(&disp)"
    tracing::info!("literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"\"literal\"","display(&disp)"
    tracing::info!(foo = true, "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"\"literal\"","display(&disp)"
    tracing::info!({ "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"\"literal\"","display(&disp)"
    tracing::info!({ foo = true, "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"\"literal\"","display(&disp)"
    tracing::info!({ "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"\"literal\"","display(&disp)"
    tracing::info!({ foo = true, "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"\"literal\"","display(&disp)"
    tracing::info!("literal" = tracing::field::Empty); // DEBUG:info,-,-,-,-,"\"literal\"","tracing::field::Empty"
    tracing::info!(foo = true, "literal" = tracing::field::Empty); // DEBUG:info,-,-,p,-,"\"literal\"","tracing::field::Empty"
    tracing::info!("literal" = tracing::field::Empty, qux = 3); // DEBUG:info,-,-,f,-,"\"literal\"","tracing::field::Empty"
    tracing::info!(foo = true, "literal" = tracing::field::Empty, qux = 3); // DEBUG:info,-,-,pf,-,"\"literal\"","tracing::field::Empty"
    tracing::info!("literal" = tracing::field::Empty, "msg without args"); // DEBUG:info,-,-,-,m,"\"literal\"","tracing::field::Empty"
    tracing::info!(foo = true, "literal" = tracing::field::Empty, "msg without args"); // DEBUG:info,-,-,p,m,"\"literal\"","tracing::field::Empty"
    tracing::info!("literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"\"literal\"","tracing::field::Empty"
    tracing::info!(foo = true, "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"\"literal\"","tracing::field::Empty"
    tracing::info!({ "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:info,-,{},-,m,"\"literal\"","tracing::field::Empty"
    tracing::info!({ foo = true, "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:info,-,{},p,m,"\"literal\"","tracing::field::Empty"
    tracing::info!({ "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"\"literal\"","tracing::field::Empty"
    tracing::info!({ foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"\"literal\"","tracing::field::Empty"
    tracing::info!("literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"\"literal\"","tracing::field::Empty"
    tracing::info!(foo = true, "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"\"literal\"","tracing::field::Empty"
    tracing::info!("literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"\"literal\"","tracing::field::Empty"
    tracing::info!(foo = true, "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::info!({ "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"\"literal\"","tracing::field::Empty"
    tracing::info!({ foo = true, "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"\"literal\"","tracing::field::Empty"
    tracing::info!({ "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"\"literal\"","tracing::field::Empty"
    tracing::info!({ foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::info!({ CONST_VAR } = 3); // DEBUG:info,-,-,-,-,"{ CONST_VAR }","3"
    tracing::info!(foo = true, { CONST_VAR } = 3); // DEBUG:info,-,-,p,-,"{ CONST_VAR }","3"
    tracing::info!({ CONST_VAR } = 3, qux = 3); // DEBUG:info,-,-,f,-,"{ CONST_VAR }","3"
    tracing::info!(foo = true, { CONST_VAR } = 3, qux = 3); // DEBUG:info,-,-,pf,-,"{ CONST_VAR }","3"
    tracing::info!({ CONST_VAR } = 3, "msg without args"); // DEBUG:info,-,-,-,m,"{ CONST_VAR }","3"
    tracing::info!(foo = true, { CONST_VAR } = 3, "msg without args"); // DEBUG:info,-,-,p,m,"{ CONST_VAR }","3"
    tracing::info!({ CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"{ CONST_VAR }","3"
    tracing::info!(foo = true, { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"{ CONST_VAR }","3"
    tracing::info!({ { CONST_VAR } = 3 }, "msg without args"); // DEBUG:info,-,{},-,m,"{ CONST_VAR }","3"
    tracing::info!({ foo = true, { CONST_VAR } = 3 }, "msg without args"); // DEBUG:info,-,{},p,m,"{ CONST_VAR }","3"
    tracing::info!({ { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"{ CONST_VAR }","3"
    tracing::info!({ foo = true, { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"{ CONST_VAR }","3"
    tracing::info!({ CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"{ CONST_VAR }","3"
    tracing::info!(foo = true, { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"{ CONST_VAR }","3"
    tracing::info!({ CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"{ CONST_VAR }","3"
    tracing::info!(foo = true, { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"{ CONST_VAR }","3"
    tracing::info!({ { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"{ CONST_VAR }","3"
    tracing::info!({ foo = true, { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"{ CONST_VAR }","3"
    tracing::info!({ { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"{ CONST_VAR }","3"
    tracing::info!({ foo = true, { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"{ CONST_VAR }","3"
    tracing::info!({ CONST_VAR } = false); // DEBUG:info,-,-,-,-,"{ CONST_VAR }","false"
    tracing::info!(foo = true, { CONST_VAR } = false); // DEBUG:info,-,-,p,-,"{ CONST_VAR }","false"
    tracing::info!({ CONST_VAR } = false, qux = 3); // DEBUG:info,-,-,f,-,"{ CONST_VAR }","false"
    tracing::info!(foo = true, { CONST_VAR } = false, qux = 3); // DEBUG:info,-,-,pf,-,"{ CONST_VAR }","false"
    tracing::info!({ CONST_VAR } = false, "msg without args"); // DEBUG:info,-,-,-,m,"{ CONST_VAR }","false"
    tracing::info!(foo = true, { CONST_VAR } = false, "msg without args"); // DEBUG:info,-,-,p,m,"{ CONST_VAR }","false"
    tracing::info!({ CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"{ CONST_VAR }","false"
    tracing::info!(foo = true, { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"{ CONST_VAR }","false"
    tracing::info!({ { CONST_VAR } = false }, "msg without args"); // DEBUG:info,-,{},-,m,"{ CONST_VAR }","false"
    tracing::info!({ foo = true, { CONST_VAR } = false }, "msg without args"); // DEBUG:info,-,{},p,m,"{ CONST_VAR }","false"
    tracing::info!({ { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"{ CONST_VAR }","false"
    tracing::info!({ foo = true, { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"{ CONST_VAR }","false"
    tracing::info!({ CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"{ CONST_VAR }","false"
    tracing::info!(foo = true, { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"{ CONST_VAR }","false"
    tracing::info!({ CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"{ CONST_VAR }","false"
    tracing::info!(foo = true, { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"{ CONST_VAR }","false"
    tracing::info!({ { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"{ CONST_VAR }","false"
    tracing::info!({ foo = true, { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"{ CONST_VAR }","false"
    tracing::info!({ { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"{ CONST_VAR }","false"
    tracing::info!({ foo = true, { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"{ CONST_VAR }","false"
    tracing::info!({ CONST_VAR } = ?3); // DEBUG:info,-,-,-,-,"{ CONST_VAR }","?3"
    tracing::info!(foo = true, { CONST_VAR } = ?3); // DEBUG:info,-,-,p,-,"{ CONST_VAR }","?3"
    tracing::info!({ CONST_VAR } = ?3, qux = 3); // DEBUG:info,-,-,f,-,"{ CONST_VAR }","?3"
    tracing::info!(foo = true, { CONST_VAR } = ?3, qux = 3); // DEBUG:info,-,-,pf,-,"{ CONST_VAR }","?3"
    tracing::info!({ CONST_VAR } = ?3, "msg without args"); // DEBUG:info,-,-,-,m,"{ CONST_VAR }","?3"
    tracing::info!(foo = true, { CONST_VAR } = ?3, "msg without args"); // DEBUG:info,-,-,p,m,"{ CONST_VAR }","?3"
    tracing::info!({ CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"{ CONST_VAR }","?3"
    tracing::info!(foo = true, { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"{ CONST_VAR }","?3"
    tracing::info!({ { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:info,-,{},-,m,"{ CONST_VAR }","?3"
    tracing::info!({ foo = true, { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:info,-,{},p,m,"{ CONST_VAR }","?3"
    tracing::info!({ { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"{ CONST_VAR }","?3"
    tracing::info!({ foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"{ CONST_VAR }","?3"
    tracing::info!({ CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"{ CONST_VAR }","?3"
    tracing::info!(foo = true, { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"{ CONST_VAR }","?3"
    tracing::info!({ CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"{ CONST_VAR }","?3"
    tracing::info!(foo = true, { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"{ CONST_VAR }","?3"
    tracing::info!({ { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"{ CONST_VAR }","?3"
    tracing::info!({ foo = true, { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"{ CONST_VAR }","?3"
    tracing::info!({ { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"{ CONST_VAR }","?3"
    tracing::info!({ foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"{ CONST_VAR }","?3"
    tracing::info!({ CONST_VAR } = %3); // DEBUG:info,-,-,-,-,"{ CONST_VAR }","%3"
    tracing::info!(foo = true, { CONST_VAR } = %3); // DEBUG:info,-,-,p,-,"{ CONST_VAR }","%3"
    tracing::info!({ CONST_VAR } = %3, qux = 3); // DEBUG:info,-,-,f,-,"{ CONST_VAR }","%3"
    tracing::info!(foo = true, { CONST_VAR } = %3, qux = 3); // DEBUG:info,-,-,pf,-,"{ CONST_VAR }","%3"
    tracing::info!({ CONST_VAR } = %3, "msg without args"); // DEBUG:info,-,-,-,m,"{ CONST_VAR }","%3"
    tracing::info!(foo = true, { CONST_VAR } = %3, "msg without args"); // DEBUG:info,-,-,p,m,"{ CONST_VAR }","%3"
    tracing::info!({ CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"{ CONST_VAR }","%3"
    tracing::info!(foo = true, { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"{ CONST_VAR }","%3"
    tracing::info!({ { CONST_VAR } = %3 }, "msg without args"); // DEBUG:info,-,{},-,m,"{ CONST_VAR }","%3"
    tracing::info!({ foo = true, { CONST_VAR } = %3 }, "msg without args"); // DEBUG:info,-,{},p,m,"{ CONST_VAR }","%3"
    tracing::info!({ { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"{ CONST_VAR }","%3"
    tracing::info!({ foo = true, { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"{ CONST_VAR }","%3"
    tracing::info!({ CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"{ CONST_VAR }","%3"
    tracing::info!(foo = true, { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"{ CONST_VAR }","%3"
    tracing::info!({ CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"{ CONST_VAR }","%3"
    tracing::info!(foo = true, { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"{ CONST_VAR }","%3"
    tracing::info!({ { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"{ CONST_VAR }","%3"
    tracing::info!({ foo = true, { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"{ CONST_VAR }","%3"
    tracing::info!({ { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"{ CONST_VAR }","%3"
    tracing::info!({ foo = true, { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"{ CONST_VAR }","%3"
    tracing::info!({ CONST_VAR } = ?deb); // DEBUG:info,-,-,-,-,"{ CONST_VAR }","?deb"
    tracing::info!(foo = true, { CONST_VAR } = ?deb); // DEBUG:info,-,-,p,-,"{ CONST_VAR }","?deb"
    tracing::info!({ CONST_VAR } = ?deb, qux = 3); // DEBUG:info,-,-,f,-,"{ CONST_VAR }","?deb"
    tracing::info!(foo = true, { CONST_VAR } = ?deb, qux = 3); // DEBUG:info,-,-,pf,-,"{ CONST_VAR }","?deb"
    tracing::info!({ CONST_VAR } = ?deb, "msg without args"); // DEBUG:info,-,-,-,m,"{ CONST_VAR }","?deb"
    tracing::info!(foo = true, { CONST_VAR } = ?deb, "msg without args"); // DEBUG:info,-,-,p,m,"{ CONST_VAR }","?deb"
    tracing::info!({ CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"{ CONST_VAR }","?deb"
    tracing::info!(foo = true, { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"{ CONST_VAR }","?deb"
    tracing::info!({ { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:info,-,{},-,m,"{ CONST_VAR }","?deb"
    tracing::info!({ foo = true, { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:info,-,{},p,m,"{ CONST_VAR }","?deb"
    tracing::info!({ { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"{ CONST_VAR }","?deb"
    tracing::info!({ foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"{ CONST_VAR }","?deb"
    tracing::info!({ CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"{ CONST_VAR }","?deb"
    tracing::info!(foo = true, { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"{ CONST_VAR }","?deb"
    tracing::info!({ CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"{ CONST_VAR }","?deb"
    tracing::info!(foo = true, { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"{ CONST_VAR }","?deb"
    tracing::info!({ { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"{ CONST_VAR }","?deb"
    tracing::info!({ foo = true, { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"{ CONST_VAR }","?deb"
    tracing::info!({ { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"{ CONST_VAR }","?deb"
    tracing::info!({ foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"{ CONST_VAR }","?deb"
    tracing::info!({ CONST_VAR } = %disp); // DEBUG:info,-,-,-,-,"{ CONST_VAR }","%disp"
    tracing::info!(foo = true, { CONST_VAR } = %disp); // DEBUG:info,-,-,p,-,"{ CONST_VAR }","%disp"
    tracing::info!({ CONST_VAR } = %disp, qux = 3); // DEBUG:info,-,-,f,-,"{ CONST_VAR }","%disp"
    tracing::info!(foo = true, { CONST_VAR } = %disp, qux = 3); // DEBUG:info,-,-,pf,-,"{ CONST_VAR }","%disp"
    tracing::info!({ CONST_VAR } = %disp, "msg without args"); // DEBUG:info,-,-,-,m,"{ CONST_VAR }","%disp"
    tracing::info!(foo = true, { CONST_VAR } = %disp, "msg without args"); // DEBUG:info,-,-,p,m,"{ CONST_VAR }","%disp"
    tracing::info!({ CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"{ CONST_VAR }","%disp"
    tracing::info!(foo = true, { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"{ CONST_VAR }","%disp"
    tracing::info!({ { CONST_VAR } = %disp }, "msg without args"); // DEBUG:info,-,{},-,m,"{ CONST_VAR }","%disp"
    tracing::info!({ foo = true, { CONST_VAR } = %disp }, "msg without args"); // DEBUG:info,-,{},p,m,"{ CONST_VAR }","%disp"
    tracing::info!({ { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"{ CONST_VAR }","%disp"
    tracing::info!({ foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"{ CONST_VAR }","%disp"
    tracing::info!({ CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"{ CONST_VAR }","%disp"
    tracing::info!(foo = true, { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"{ CONST_VAR }","%disp"
    tracing::info!({ CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"{ CONST_VAR }","%disp"
    tracing::info!(foo = true, { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"{ CONST_VAR }","%disp"
    tracing::info!({ { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"{ CONST_VAR }","%disp"
    tracing::info!({ foo = true, { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"{ CONST_VAR }","%disp"
    tracing::info!({ { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"{ CONST_VAR }","%disp"
    tracing::info!({ foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"{ CONST_VAR }","%disp"
    tracing::info!({ CONST_VAR } = ?sub.field); // DEBUG:info,-,-,-,-,"{ CONST_VAR }","?sub.field"
    tracing::info!(foo = true, { CONST_VAR } = ?sub.field); // DEBUG:info,-,-,p,-,"{ CONST_VAR }","?sub.field"
    tracing::info!({ CONST_VAR } = ?sub.field, qux = 3); // DEBUG:info,-,-,f,-,"{ CONST_VAR }","?sub.field"
    tracing::info!(foo = true, { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:info,-,-,pf,-,"{ CONST_VAR }","?sub.field"
    tracing::info!({ CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:info,-,-,-,m,"{ CONST_VAR }","?sub.field"
    tracing::info!(foo = true, { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:info,-,-,p,m,"{ CONST_VAR }","?sub.field"
    tracing::info!({ CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"{ CONST_VAR }","?sub.field"
    tracing::info!(foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"{ CONST_VAR }","?sub.field"
    tracing::info!({ { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:info,-,{},-,m,"{ CONST_VAR }","?sub.field"
    tracing::info!({ foo = true, { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:info,-,{},p,m,"{ CONST_VAR }","?sub.field"
    tracing::info!({ { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"{ CONST_VAR }","?sub.field"
    tracing::info!({ foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"{ CONST_VAR }","?sub.field"
    tracing::info!({ CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"{ CONST_VAR }","?sub.field"
    tracing::info!(foo = true, { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"{ CONST_VAR }","?sub.field"
    tracing::info!({ CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"{ CONST_VAR }","?sub.field"
    tracing::info!(foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::info!({ { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"{ CONST_VAR }","?sub.field"
    tracing::info!({ foo = true, { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"{ CONST_VAR }","?sub.field"
    tracing::info!({ { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"{ CONST_VAR }","?sub.field"
    tracing::info!({ foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::info!({ CONST_VAR } = %sub.field); // DEBUG:info,-,-,-,-,"{ CONST_VAR }","%sub.field"
    tracing::info!(foo = true, { CONST_VAR } = %sub.field); // DEBUG:info,-,-,p,-,"{ CONST_VAR }","%sub.field"
    tracing::info!({ CONST_VAR } = %sub.field, qux = 3); // DEBUG:info,-,-,f,-,"{ CONST_VAR }","%sub.field"
    tracing::info!(foo = true, { CONST_VAR } = %sub.field, qux = 3); // DEBUG:info,-,-,pf,-,"{ CONST_VAR }","%sub.field"
    tracing::info!({ CONST_VAR } = %sub.field, "msg without args"); // DEBUG:info,-,-,-,m,"{ CONST_VAR }","%sub.field"
    tracing::info!(foo = true, { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:info,-,-,p,m,"{ CONST_VAR }","%sub.field"
    tracing::info!({ CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"{ CONST_VAR }","%sub.field"
    tracing::info!(foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"{ CONST_VAR }","%sub.field"
    tracing::info!({ { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:info,-,{},-,m,"{ CONST_VAR }","%sub.field"
    tracing::info!({ foo = true, { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:info,-,{},p,m,"{ CONST_VAR }","%sub.field"
    tracing::info!({ { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"{ CONST_VAR }","%sub.field"
    tracing::info!({ foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"{ CONST_VAR }","%sub.field"
    tracing::info!({ CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"{ CONST_VAR }","%sub.field"
    tracing::info!(foo = true, { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"{ CONST_VAR }","%sub.field"
    tracing::info!({ CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"{ CONST_VAR }","%sub.field"
    tracing::info!(foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::info!({ { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"{ CONST_VAR }","%sub.field"
    tracing::info!({ foo = true, { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"{ CONST_VAR }","%sub.field"
    tracing::info!({ { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"{ CONST_VAR }","%sub.field"
    tracing::info!({ foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::info!({ CONST_VAR } = debug(&deb)); // DEBUG:info,-,-,-,-,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(foo = true, { CONST_VAR } = debug(&deb)); // DEBUG:info,-,-,p,-,"{ CONST_VAR }","debug(&deb)"
    tracing::info!({ CONST_VAR } = debug(&deb), qux = 3); // DEBUG:info,-,-,f,-,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(foo = true, { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:info,-,-,pf,-,"{ CONST_VAR }","debug(&deb)"
    tracing::info!({ CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:info,-,-,-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(foo = true, { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:info,-,-,p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::info!({ CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::info!({ { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:info,-,{},-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::info!({ foo = true, { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:info,-,{},p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::info!({ { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::info!({ foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::info!({ CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(foo = true, { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::info!({ CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::info!({ { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::info!({ foo = true, { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::info!({ { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::info!({ foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::info!({ CONST_VAR } = display(&disp)); // DEBUG:info,-,-,-,-,"{ CONST_VAR }","display(&disp)"
    tracing::info!(foo = true, { CONST_VAR } = display(&disp)); // DEBUG:info,-,-,p,-,"{ CONST_VAR }","display(&disp)"
    tracing::info!({ CONST_VAR } = display(&disp), qux = 3); // DEBUG:info,-,-,f,-,"{ CONST_VAR }","display(&disp)"
    tracing::info!(foo = true, { CONST_VAR } = display(&disp), qux = 3); // DEBUG:info,-,-,pf,-,"{ CONST_VAR }","display(&disp)"
    tracing::info!({ CONST_VAR } = display(&disp), "msg without args"); // DEBUG:info,-,-,-,m,"{ CONST_VAR }","display(&disp)"
    tracing::info!(foo = true, { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:info,-,-,p,m,"{ CONST_VAR }","display(&disp)"
    tracing::info!({ CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"{ CONST_VAR }","display(&disp)"
    tracing::info!(foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::info!({ { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:info,-,{},-,m,"{ CONST_VAR }","display(&disp)"
    tracing::info!({ foo = true, { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:info,-,{},p,m,"{ CONST_VAR }","display(&disp)"
    tracing::info!({ { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"{ CONST_VAR }","display(&disp)"
    tracing::info!({ foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::info!({ CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::info!(foo = true, { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::info!({ CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::info!(foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::info!({ { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::info!({ foo = true, { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::info!({ { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::info!({ foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::info!({ CONST_VAR } = tracing::field::Empty); // DEBUG:info,-,-,-,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(foo = true, { CONST_VAR } = tracing::field::Empty); // DEBUG:info,-,-,p,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!({ CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:info,-,-,f,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:info,-,-,pf,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!({ CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:info,-,-,-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(foo = true, { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:info,-,-,p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!({ CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!({ { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:info,-,{},-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!({ foo = true, { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:info,-,{},p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!({ { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!({ foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!({ CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(foo = true, { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!({ CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!({ { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!({ foo = true, { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!({ { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!({ foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(r#type = 3); // DEBUG:info,-,-,-,-,"r#type","3"
    tracing::info!(foo = true, r#type = 3); // DEBUG:info,-,-,p,-,"r#type","3"
    tracing::info!(r#type = 3, qux = 3); // DEBUG:info,-,-,f,-,"r#type","3"
    tracing::info!(foo = true, r#type = 3, qux = 3); // DEBUG:info,-,-,pf,-,"r#type","3"
    tracing::info!(r#type = 3, "msg without args"); // DEBUG:info,-,-,-,m,"r#type","3"
    tracing::info!(foo = true, r#type = 3, "msg without args"); // DEBUG:info,-,-,p,m,"r#type","3"
    tracing::info!(r#type = 3, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"r#type","3"
    tracing::info!(foo = true, r#type = 3, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"r#type","3"
    tracing::info!({ r#type = 3 }, "msg without args"); // DEBUG:info,-,{},-,m,"r#type","3"
    tracing::info!({ foo = true, r#type = 3 }, "msg without args"); // DEBUG:info,-,{},p,m,"r#type","3"
    tracing::info!({ r#type = 3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"r#type","3"
    tracing::info!({ foo = true, r#type = 3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"r#type","3"
    tracing::info!(r#type = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"r#type","3"
    tracing::info!(foo = true, r#type = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"r#type","3"
    tracing::info!(r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"r#type","3"
    tracing::info!(foo = true, r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"r#type","3"
    tracing::info!({ r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"r#type","3"
    tracing::info!({ foo = true, r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"r#type","3"
    tracing::info!({ r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"r#type","3"
    tracing::info!({ foo = true, r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"r#type","3"
    tracing::info!(r#type = false); // DEBUG:info,-,-,-,-,"r#type","false"
    tracing::info!(foo = true, r#type = false); // DEBUG:info,-,-,p,-,"r#type","false"
    tracing::info!(r#type = false, qux = 3); // DEBUG:info,-,-,f,-,"r#type","false"
    tracing::info!(foo = true, r#type = false, qux = 3); // DEBUG:info,-,-,pf,-,"r#type","false"
    tracing::info!(r#type = false, "msg without args"); // DEBUG:info,-,-,-,m,"r#type","false"
    tracing::info!(foo = true, r#type = false, "msg without args"); // DEBUG:info,-,-,p,m,"r#type","false"
    tracing::info!(r#type = false, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"r#type","false"
    tracing::info!(foo = true, r#type = false, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"r#type","false"
    tracing::info!({ r#type = false }, "msg without args"); // DEBUG:info,-,{},-,m,"r#type","false"
    tracing::info!({ foo = true, r#type = false }, "msg without args"); // DEBUG:info,-,{},p,m,"r#type","false"
    tracing::info!({ r#type = false, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"r#type","false"
    tracing::info!({ foo = true, r#type = false, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"r#type","false"
    tracing::info!(r#type = false, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"r#type","false"
    tracing::info!(foo = true, r#type = false, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"r#type","false"
    tracing::info!(r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"r#type","false"
    tracing::info!(foo = true, r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"r#type","false"
    tracing::info!({ r#type = false }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"r#type","false"
    tracing::info!({ foo = true, r#type = false }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"r#type","false"
    tracing::info!({ r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"r#type","false"
    tracing::info!({ foo = true, r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"r#type","false"
    tracing::info!(r#type = ?3); // DEBUG:info,-,-,-,-,"r#type","?3"
    tracing::info!(foo = true, r#type = ?3); // DEBUG:info,-,-,p,-,"r#type","?3"
    tracing::info!(r#type = ?3, qux = 3); // DEBUG:info,-,-,f,-,"r#type","?3"
    tracing::info!(foo = true, r#type = ?3, qux = 3); // DEBUG:info,-,-,pf,-,"r#type","?3"
    tracing::info!(r#type = ?3, "msg without args"); // DEBUG:info,-,-,-,m,"r#type","?3"
    tracing::info!(foo = true, r#type = ?3, "msg without args"); // DEBUG:info,-,-,p,m,"r#type","?3"
    tracing::info!(r#type = ?3, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"r#type","?3"
    tracing::info!(foo = true, r#type = ?3, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"r#type","?3"
    tracing::info!({ r#type = ?3 }, "msg without args"); // DEBUG:info,-,{},-,m,"r#type","?3"
    tracing::info!({ foo = true, r#type = ?3 }, "msg without args"); // DEBUG:info,-,{},p,m,"r#type","?3"
    tracing::info!({ r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"r#type","?3"
    tracing::info!({ foo = true, r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"r#type","?3"
    tracing::info!(r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"r#type","?3"
    tracing::info!(foo = true, r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"r#type","?3"
    tracing::info!(r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"r#type","?3"
    tracing::info!(foo = true, r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"r#type","?3"
    tracing::info!({ r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"r#type","?3"
    tracing::info!({ foo = true, r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"r#type","?3"
    tracing::info!({ r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"r#type","?3"
    tracing::info!({ foo = true, r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"r#type","?3"
    tracing::info!(r#type = %3); // DEBUG:info,-,-,-,-,"r#type","%3"
    tracing::info!(foo = true, r#type = %3); // DEBUG:info,-,-,p,-,"r#type","%3"
    tracing::info!(r#type = %3, qux = 3); // DEBUG:info,-,-,f,-,"r#type","%3"
    tracing::info!(foo = true, r#type = %3, qux = 3); // DEBUG:info,-,-,pf,-,"r#type","%3"
    tracing::info!(r#type = %3, "msg without args"); // DEBUG:info,-,-,-,m,"r#type","%3"
    tracing::info!(foo = true, r#type = %3, "msg without args"); // DEBUG:info,-,-,p,m,"r#type","%3"
    tracing::info!(r#type = %3, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"r#type","%3"
    tracing::info!(foo = true, r#type = %3, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"r#type","%3"
    tracing::info!({ r#type = %3 }, "msg without args"); // DEBUG:info,-,{},-,m,"r#type","%3"
    tracing::info!({ foo = true, r#type = %3 }, "msg without args"); // DEBUG:info,-,{},p,m,"r#type","%3"
    tracing::info!({ r#type = %3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"r#type","%3"
    tracing::info!({ foo = true, r#type = %3, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"r#type","%3"
    tracing::info!(r#type = %3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"r#type","%3"
    tracing::info!(foo = true, r#type = %3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"r#type","%3"
    tracing::info!(r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"r#type","%3"
    tracing::info!(foo = true, r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"r#type","%3"
    tracing::info!({ r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"r#type","%3"
    tracing::info!({ foo = true, r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"r#type","%3"
    tracing::info!({ r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"r#type","%3"
    tracing::info!({ foo = true, r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"r#type","%3"
    tracing::info!(r#type = ?deb); // DEBUG:info,-,-,-,-,"r#type","?deb"
    tracing::info!(foo = true, r#type = ?deb); // DEBUG:info,-,-,p,-,"r#type","?deb"
    tracing::info!(r#type = ?deb, qux = 3); // DEBUG:info,-,-,f,-,"r#type","?deb"
    tracing::info!(foo = true, r#type = ?deb, qux = 3); // DEBUG:info,-,-,pf,-,"r#type","?deb"
    tracing::info!(r#type = ?deb, "msg without args"); // DEBUG:info,-,-,-,m,"r#type","?deb"
    tracing::info!(foo = true, r#type = ?deb, "msg without args"); // DEBUG:info,-,-,p,m,"r#type","?deb"
    tracing::info!(r#type = ?deb, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"r#type","?deb"
    tracing::info!(foo = true, r#type = ?deb, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"r#type","?deb"
    tracing::info!({ r#type = ?deb }, "msg without args"); // DEBUG:info,-,{},-,m,"r#type","?deb"
    tracing::info!({ foo = true, r#type = ?deb }, "msg without args"); // DEBUG:info,-,{},p,m,"r#type","?deb"
    tracing::info!({ r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"r#type","?deb"
    tracing::info!({ foo = true, r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"r#type","?deb"
    tracing::info!(r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"r#type","?deb"
    tracing::info!(foo = true, r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"r#type","?deb"
    tracing::info!(r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"r#type","?deb"
    tracing::info!(foo = true, r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"r#type","?deb"
    tracing::info!({ r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"r#type","?deb"
    tracing::info!({ foo = true, r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"r#type","?deb"
    tracing::info!({ r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"r#type","?deb"
    tracing::info!({ foo = true, r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"r#type","?deb"
    tracing::info!(r#type = %disp); // DEBUG:info,-,-,-,-,"r#type","%disp"
    tracing::info!(foo = true, r#type = %disp); // DEBUG:info,-,-,p,-,"r#type","%disp"
    tracing::info!(r#type = %disp, qux = 3); // DEBUG:info,-,-,f,-,"r#type","%disp"
    tracing::info!(foo = true, r#type = %disp, qux = 3); // DEBUG:info,-,-,pf,-,"r#type","%disp"
    tracing::info!(r#type = %disp, "msg without args"); // DEBUG:info,-,-,-,m,"r#type","%disp"
    tracing::info!(foo = true, r#type = %disp, "msg without args"); // DEBUG:info,-,-,p,m,"r#type","%disp"
    tracing::info!(r#type = %disp, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"r#type","%disp"
    tracing::info!(foo = true, r#type = %disp, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"r#type","%disp"
    tracing::info!({ r#type = %disp }, "msg without args"); // DEBUG:info,-,{},-,m,"r#type","%disp"
    tracing::info!({ foo = true, r#type = %disp }, "msg without args"); // DEBUG:info,-,{},p,m,"r#type","%disp"
    tracing::info!({ r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"r#type","%disp"
    tracing::info!({ foo = true, r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"r#type","%disp"
    tracing::info!(r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"r#type","%disp"
    tracing::info!(foo = true, r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"r#type","%disp"
    tracing::info!(r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"r#type","%disp"
    tracing::info!(foo = true, r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"r#type","%disp"
    tracing::info!({ r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"r#type","%disp"
    tracing::info!({ foo = true, r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"r#type","%disp"
    tracing::info!({ r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"r#type","%disp"
    tracing::info!({ foo = true, r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"r#type","%disp"
    tracing::info!(r#type = ?sub.field); // DEBUG:info,-,-,-,-,"r#type","?sub.field"
    tracing::info!(foo = true, r#type = ?sub.field); // DEBUG:info,-,-,p,-,"r#type","?sub.field"
    tracing::info!(r#type = ?sub.field, qux = 3); // DEBUG:info,-,-,f,-,"r#type","?sub.field"
    tracing::info!(foo = true, r#type = ?sub.field, qux = 3); // DEBUG:info,-,-,pf,-,"r#type","?sub.field"
    tracing::info!(r#type = ?sub.field, "msg without args"); // DEBUG:info,-,-,-,m,"r#type","?sub.field"
    tracing::info!(foo = true, r#type = ?sub.field, "msg without args"); // DEBUG:info,-,-,p,m,"r#type","?sub.field"
    tracing::info!(r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"r#type","?sub.field"
    tracing::info!(foo = true, r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"r#type","?sub.field"
    tracing::info!({ r#type = ?sub.field }, "msg without args"); // DEBUG:info,-,{},-,m,"r#type","?sub.field"
    tracing::info!({ foo = true, r#type = ?sub.field }, "msg without args"); // DEBUG:info,-,{},p,m,"r#type","?sub.field"
    tracing::info!({ r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"r#type","?sub.field"
    tracing::info!({ foo = true, r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"r#type","?sub.field"
    tracing::info!(r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"r#type","?sub.field"
    tracing::info!(foo = true, r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"r#type","?sub.field"
    tracing::info!(r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"r#type","?sub.field"
    tracing::info!(foo = true, r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"r#type","?sub.field"
    tracing::info!({ r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"r#type","?sub.field"
    tracing::info!({ foo = true, r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"r#type","?sub.field"
    tracing::info!({ r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"r#type","?sub.field"
    tracing::info!({ foo = true, r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"r#type","?sub.field"
    tracing::info!(r#type = %sub.field); // DEBUG:info,-,-,-,-,"r#type","%sub.field"
    tracing::info!(foo = true, r#type = %sub.field); // DEBUG:info,-,-,p,-,"r#type","%sub.field"
    tracing::info!(r#type = %sub.field, qux = 3); // DEBUG:info,-,-,f,-,"r#type","%sub.field"
    tracing::info!(foo = true, r#type = %sub.field, qux = 3); // DEBUG:info,-,-,pf,-,"r#type","%sub.field"
    tracing::info!(r#type = %sub.field, "msg without args"); // DEBUG:info,-,-,-,m,"r#type","%sub.field"
    tracing::info!(foo = true, r#type = %sub.field, "msg without args"); // DEBUG:info,-,-,p,m,"r#type","%sub.field"
    tracing::info!(r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"r#type","%sub.field"
    tracing::info!(foo = true, r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"r#type","%sub.field"
    tracing::info!({ r#type = %sub.field }, "msg without args"); // DEBUG:info,-,{},-,m,"r#type","%sub.field"
    tracing::info!({ foo = true, r#type = %sub.field }, "msg without args"); // DEBUG:info,-,{},p,m,"r#type","%sub.field"
    tracing::info!({ r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"r#type","%sub.field"
    tracing::info!({ foo = true, r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"r#type","%sub.field"
    tracing::info!(r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"r#type","%sub.field"
    tracing::info!(foo = true, r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"r#type","%sub.field"
    tracing::info!(r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"r#type","%sub.field"
    tracing::info!(foo = true, r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"r#type","%sub.field"
    tracing::info!({ r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"r#type","%sub.field"
    tracing::info!({ foo = true, r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"r#type","%sub.field"
    tracing::info!({ r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"r#type","%sub.field"
    tracing::info!({ foo = true, r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"r#type","%sub.field"
    tracing::info!(r#type = debug(&deb)); // DEBUG:info,-,-,-,-,"r#type","debug(&deb)"
    tracing::info!(foo = true, r#type = debug(&deb)); // DEBUG:info,-,-,p,-,"r#type","debug(&deb)"
    tracing::info!(r#type = debug(&deb), qux = 3); // DEBUG:info,-,-,f,-,"r#type","debug(&deb)"
    tracing::info!(foo = true, r#type = debug(&deb), qux = 3); // DEBUG:info,-,-,pf,-,"r#type","debug(&deb)"
    tracing::info!(r#type = debug(&deb), "msg without args"); // DEBUG:info,-,-,-,m,"r#type","debug(&deb)"
    tracing::info!(foo = true, r#type = debug(&deb), "msg without args"); // DEBUG:info,-,-,p,m,"r#type","debug(&deb)"
    tracing::info!(r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"r#type","debug(&deb)"
    tracing::info!(foo = true, r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"r#type","debug(&deb)"
    tracing::info!({ r#type = debug(&deb) }, "msg without args"); // DEBUG:info,-,{},-,m,"r#type","debug(&deb)"
    tracing::info!({ foo = true, r#type = debug(&deb) }, "msg without args"); // DEBUG:info,-,{},p,m,"r#type","debug(&deb)"
    tracing::info!({ r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"r#type","debug(&deb)"
    tracing::info!({ foo = true, r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"r#type","debug(&deb)"
    tracing::info!(r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"r#type","debug(&deb)"
    tracing::info!(foo = true, r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"r#type","debug(&deb)"
    tracing::info!(r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"r#type","debug(&deb)"
    tracing::info!(foo = true, r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"r#type","debug(&deb)"
    tracing::info!({ r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"r#type","debug(&deb)"
    tracing::info!({ foo = true, r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"r#type","debug(&deb)"
    tracing::info!({ r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"r#type","debug(&deb)"
    tracing::info!({ foo = true, r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"r#type","debug(&deb)"
    tracing::info!(r#type = display(&disp)); // DEBUG:info,-,-,-,-,"r#type","display(&disp)"
    tracing::info!(foo = true, r#type = display(&disp)); // DEBUG:info,-,-,p,-,"r#type","display(&disp)"
    tracing::info!(r#type = display(&disp), qux = 3); // DEBUG:info,-,-,f,-,"r#type","display(&disp)"
    tracing::info!(foo = true, r#type = display(&disp), qux = 3); // DEBUG:info,-,-,pf,-,"r#type","display(&disp)"
    tracing::info!(r#type = display(&disp), "msg without args"); // DEBUG:info,-,-,-,m,"r#type","display(&disp)"
    tracing::info!(foo = true, r#type = display(&disp), "msg without args"); // DEBUG:info,-,-,p,m,"r#type","display(&disp)"
    tracing::info!(r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"r#type","display(&disp)"
    tracing::info!(foo = true, r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"r#type","display(&disp)"
    tracing::info!({ r#type = display(&disp) }, "msg without args"); // DEBUG:info,-,{},-,m,"r#type","display(&disp)"
    tracing::info!({ foo = true, r#type = display(&disp) }, "msg without args"); // DEBUG:info,-,{},p,m,"r#type","display(&disp)"
    tracing::info!({ r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"r#type","display(&disp)"
    tracing::info!({ foo = true, r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"r#type","display(&disp)"
    tracing::info!(r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"r#type","display(&disp)"
    tracing::info!(foo = true, r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"r#type","display(&disp)"
    tracing::info!(r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"r#type","display(&disp)"
    tracing::info!(foo = true, r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"r#type","display(&disp)"
    tracing::info!({ r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"r#type","display(&disp)"
    tracing::info!({ foo = true, r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"r#type","display(&disp)"
    tracing::info!({ r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"r#type","display(&disp)"
    tracing::info!({ foo = true, r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"r#type","display(&disp)"
    tracing::info!(r#type = tracing::field::Empty); // DEBUG:info,-,-,-,-,"r#type","tracing::field::Empty"
    tracing::info!(foo = true, r#type = tracing::field::Empty); // DEBUG:info,-,-,p,-,"r#type","tracing::field::Empty"
    tracing::info!(r#type = tracing::field::Empty, qux = 3); // DEBUG:info,-,-,f,-,"r#type","tracing::field::Empty"
    tracing::info!(foo = true, r#type = tracing::field::Empty, qux = 3); // DEBUG:info,-,-,pf,-,"r#type","tracing::field::Empty"
    tracing::info!(r#type = tracing::field::Empty, "msg without args"); // DEBUG:info,-,-,-,m,"r#type","tracing::field::Empty"
    tracing::info!(foo = true, r#type = tracing::field::Empty, "msg without args"); // DEBUG:info,-,-,p,m,"r#type","tracing::field::Empty"
    tracing::info!(r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,"r#type","tracing::field::Empty"
    tracing::info!(foo = true, r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,"r#type","tracing::field::Empty"
    tracing::info!({ r#type = tracing::field::Empty }, "msg without args"); // DEBUG:info,-,{},-,m,"r#type","tracing::field::Empty"
    tracing::info!({ foo = true, r#type = tracing::field::Empty }, "msg without args"); // DEBUG:info,-,{},p,m,"r#type","tracing::field::Empty"
    tracing::info!({ r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,"r#type","tracing::field::Empty"
    tracing::info!({ foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,"r#type","tracing::field::Empty"
    tracing::info!(r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,"r#type","tracing::field::Empty"
    tracing::info!(foo = true, r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,"r#type","tracing::field::Empty"
    tracing::info!(r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,"r#type","tracing::field::Empty"
    tracing::info!(foo = true, r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,"r#type","tracing::field::Empty"
    tracing::info!({ r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,"r#type","tracing::field::Empty"
    tracing::info!({ foo = true, r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,"r#type","tracing::field::Empty"
    tracing::info!({ r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,"r#type","tracing::field::Empty"
    tracing::info!({ foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,"r#type","tracing::field::Empty"
    tracing::info!(var); // DEBUG:info,-,-,-,-,-,"var"
    tracing::info!(foo = true, var); // DEBUG:info,-,-,p,-,-,"var"
    tracing::info!(var, qux = 3); // DEBUG:info,-,-,f,-,-,"var"
    tracing::info!(foo = true, var, qux = 3); // DEBUG:info,-,-,pf,-,-,"var"
    tracing::info!(var, "msg without args"); // DEBUG:info,-,-,-,m,-,"var"
    tracing::info!(foo = true, var, "msg without args"); // DEBUG:info,-,-,p,m,-,"var"
    tracing::info!(var, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,-,"var"
    tracing::info!(foo = true, var, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,-,"var"
    tracing::info!({ var }, "msg without args"); // DEBUG:info,-,{},-,m,-,"var"
    tracing::info!({ foo = true, var }, "msg without args"); // DEBUG:info,-,{},p,m,-,"var"
    tracing::info!({ var, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,-,"var"
    tracing::info!({ foo = true, var, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,-,"var"
    tracing::info!(var, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,-,"var"
    tracing::info!(foo = true, var, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,-,"var"
    tracing::info!(var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,-,"var"
    tracing::info!(foo = true, var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,-,"var"
    tracing::info!({ var }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,-,"var"
    tracing::info!({ foo = true, var }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,-,"var"
    tracing::info!({ var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,-,"var"
    tracing::info!({ foo = true, var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,-,"var"
    tracing::info!(sub.field); // DEBUG:info,-,-,-,-,-,"sub.field"
    tracing::info!(foo = true, sub.field); // DEBUG:info,-,-,p,-,-,"sub.field"
    tracing::info!(sub.field, qux = 3); // DEBUG:info,-,-,f,-,-,"sub.field"
    tracing::info!(foo = true, sub.field, qux = 3); // DEBUG:info,-,-,pf,-,-,"sub.field"
    tracing::info!(sub.field, "msg without args"); // DEBUG:info,-,-,-,m,-,"sub.field"
    tracing::info!(foo = true, sub.field, "msg without args"); // DEBUG:info,-,-,p,m,-,"sub.field"
    tracing::info!(sub.field, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,-,"sub.field"
    tracing::info!(foo = true, sub.field, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,-,"sub.field"
    tracing::info!({ sub.field }, "msg without args"); // DEBUG:info,-,{},-,m,-,"sub.field"
    tracing::info!({ foo = true, sub.field }, "msg without args"); // DEBUG:info,-,{},p,m,-,"sub.field"
    tracing::info!({ sub.field, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,-,"sub.field"
    tracing::info!({ foo = true, sub.field, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,-,"sub.field"
    tracing::info!(sub.field, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,-,"sub.field"
    tracing::info!(foo = true, sub.field, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,-,"sub.field"
    tracing::info!(sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,-,"sub.field"
    tracing::info!(foo = true, sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,-,"sub.field"
    tracing::info!({ sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,-,"sub.field"
    tracing::info!({ foo = true, sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,-,"sub.field"
    tracing::info!({ sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,-,"sub.field"
    tracing::info!({ foo = true, sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,-,"sub.field"
    tracing::info!(%disp); // DEBUG:info,-,-,-,-,-,"%disp"
    tracing::info!(foo = true, %disp); // DEBUG:info,-,-,p,-,-,"%disp"
    tracing::info!(%disp, qux = 3); // DEBUG:info,-,-,f,-,-,"%disp"
    tracing::info!(foo = true, %disp, qux = 3); // DEBUG:info,-,-,pf,-,-,"%disp"
    tracing::info!(%disp, "msg without args"); // DEBUG:info,-,-,-,m,-,"%disp"
    tracing::info!(foo = true, %disp, "msg without args"); // DEBUG:info,-,-,p,m,-,"%disp"
    tracing::info!(%disp, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,-,"%disp"
    tracing::info!(foo = true, %disp, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,-,"%disp"
    tracing::info!({ %disp }, "msg without args"); // DEBUG:info,-,{},-,m,-,"%disp"
    tracing::info!({ foo = true, %disp }, "msg without args"); // DEBUG:info,-,{},p,m,-,"%disp"
    tracing::info!({ %disp, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,-,"%disp"
    tracing::info!({ foo = true, %disp, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,-,"%disp"
    tracing::info!(%disp, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,-,"%disp"
    tracing::info!(foo = true, %disp, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,-,"%disp"
    tracing::info!(%disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,-,"%disp"
    tracing::info!(foo = true, %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,-,"%disp"
    tracing::info!({ %disp }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,-,"%disp"
    tracing::info!({ foo = true, %disp }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,-,"%disp"
    tracing::info!({ %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,-,"%disp"
    tracing::info!({ foo = true, %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,-,"%disp"
    tracing::info!(?deb); // DEBUG:info,-,-,-,-,-,"?deb"
    tracing::info!(foo = true, ?deb); // DEBUG:info,-,-,p,-,-,"?deb"
    tracing::info!(?deb, qux = 3); // DEBUG:info,-,-,f,-,-,"?deb"
    tracing::info!(foo = true, ?deb, qux = 3); // DEBUG:info,-,-,pf,-,-,"?deb"
    tracing::info!(?deb, "msg without args"); // DEBUG:info,-,-,-,m,-,"?deb"
    tracing::info!(foo = true, ?deb, "msg without args"); // DEBUG:info,-,-,p,m,-,"?deb"
    tracing::info!(?deb, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,-,"?deb"
    tracing::info!(foo = true, ?deb, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,-,"?deb"
    tracing::info!({ ?deb }, "msg without args"); // DEBUG:info,-,{},-,m,-,"?deb"
    tracing::info!({ foo = true, ?deb }, "msg without args"); // DEBUG:info,-,{},p,m,-,"?deb"
    tracing::info!({ ?deb, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,-,"?deb"
    tracing::info!({ foo = true, ?deb, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,-,"?deb"
    tracing::info!(?deb, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,-,"?deb"
    tracing::info!(foo = true, ?deb, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,-,"?deb"
    tracing::info!(?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,-,"?deb"
    tracing::info!(foo = true, ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,-,"?deb"
    tracing::info!({ ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,-,"?deb"
    tracing::info!({ foo = true, ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,-,"?deb"
    tracing::info!({ ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,-,"?deb"
    tracing::info!({ foo = true, ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,-,"?deb"
    tracing::info!(%sub.field); // DEBUG:info,-,-,-,-,-,"%sub.field"
    tracing::info!(foo = true, %sub.field); // DEBUG:info,-,-,p,-,-,"%sub.field"
    tracing::info!(%sub.field, qux = 3); // DEBUG:info,-,-,f,-,-,"%sub.field"
    tracing::info!(foo = true, %sub.field, qux = 3); // DEBUG:info,-,-,pf,-,-,"%sub.field"
    tracing::info!(%sub.field, "msg without args"); // DEBUG:info,-,-,-,m,-,"%sub.field"
    tracing::info!(foo = true, %sub.field, "msg without args"); // DEBUG:info,-,-,p,m,-,"%sub.field"
    tracing::info!(%sub.field, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,-,"%sub.field"
    tracing::info!(foo = true, %sub.field, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,-,"%sub.field"
    tracing::info!({ %sub.field }, "msg without args"); // DEBUG:info,-,{},-,m,-,"%sub.field"
    tracing::info!({ foo = true, %sub.field }, "msg without args"); // DEBUG:info,-,{},p,m,-,"%sub.field"
    tracing::info!({ %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,-,"%sub.field"
    tracing::info!({ foo = true, %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,-,"%sub.field"
    tracing::info!(%sub.field, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,-,"%sub.field"
    tracing::info!(foo = true, %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,-,"%sub.field"
    tracing::info!(%sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,-,"%sub.field"
    tracing::info!(foo = true, %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,-,"%sub.field"
    tracing::info!({ %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,-,"%sub.field"
    tracing::info!({ foo = true, %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,-,"%sub.field"
    tracing::info!({ %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,-,"%sub.field"
    tracing::info!({ foo = true, %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,-,"%sub.field"
    tracing::info!(?sub.field); // DEBUG:info,-,-,-,-,-,"?sub.field"
    tracing::info!(foo = true, ?sub.field); // DEBUG:info,-,-,p,-,-,"?sub.field"
    tracing::info!(?sub.field, qux = 3); // DEBUG:info,-,-,f,-,-,"?sub.field"
    tracing::info!(foo = true, ?sub.field, qux = 3); // DEBUG:info,-,-,pf,-,-,"?sub.field"
    tracing::info!(?sub.field, "msg without args"); // DEBUG:info,-,-,-,m,-,"?sub.field"
    tracing::info!(foo = true, ?sub.field, "msg without args"); // DEBUG:info,-,-,p,m,-,"?sub.field"
    tracing::info!(?sub.field, qux = 3, "msg without args"); // DEBUG:info,-,-,f,m,-,"?sub.field"
    tracing::info!(foo = true, ?sub.field, qux = 3, "msg without args"); // DEBUG:info,-,-,pf,m,-,"?sub.field"
    tracing::info!({ ?sub.field }, "msg without args"); // DEBUG:info,-,{},-,m,-,"?sub.field"
    tracing::info!({ foo = true, ?sub.field }, "msg without args"); // DEBUG:info,-,{},p,m,-,"?sub.field"
    tracing::info!({ ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,-,{},f,m,-,"?sub.field"
    tracing::info!({ foo = true, ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,-,{},pf,m,-,"?sub.field"
    tracing::info!(?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,-,-,-,ma,-,"?sub.field"
    tracing::info!(foo = true, ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,-,-,p,ma,-,"?sub.field"
    tracing::info!(?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,f,ma,-,"?sub.field"
    tracing::info!(foo = true, ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,-,-,pf,ma,-,"?sub.field"
    tracing::info!({ ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},-,ma,-,"?sub.field"
    tracing::info!({ foo = true, ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},p,ma,-,"?sub.field"
    tracing::info!({ ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},f,ma,-,"?sub.field"
    tracing::info!({ foo = true, ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,-,{},pf,ma,-,"?sub.field"
}
