# genqlient documentation

<img width="100%" alt="generated graphql client ⇒ genqlient" src="images/genqlient.svg">

Welcome to the genqlient documentation! This documentation is made possible by viewers like you; if you see something unclear, file an [issue] or make a [pull request] to improve it!

[issue]: https://github.com/Khan/genqlient/issues/new/choose
[pull request]: https://github.com/Khan/genqlient/compare

## Usage/recipes

- [Getting started guide](introduction.md)
- [Runnable usage example](../example)
- [Handling your GraphQL schema](schema.md)
- [Client configuration and usage](client_config.md)
- [Writing your GraphQL operations](operations.md)

# Reference

- [Go package reference](https://pkg.go.dev/github.com/Khan/genqlient)
- [`genqlient.yaml` configuration reference](genqlient.yaml)
- [`@genqlient` directive reference](genqlient_directive.graphql)
- [changelog](CHANGELOG.md)

## Background

- [Why genqlient](../README.md#why-another-graphql-client)
- [Notes on the design of genqlient](design.md)
- Blog posts on the [usage][blog1] and [design][blog2] of genqlient
- [Contributing to genqlient](CONTRIBUTING.md)
- [Security policy](SECURITY.md)

[blog1]: https://blog.khanacademy.org/genqlient-a-truly-type-safe-go-graphql-client/
[blog2]: https://blog.khanacademy.org/where-go-and-graphql-collide-behind-the-curtain-with-genqlient/
