/// Generates the root file output of the macro MacroName

#include "TString.h"
#include "TCanvas.h"
#include "TSystem.h"
#include "TROOT.h"
#include "TBufferJSON.h"
#include <fstream>

void MakeTCanvasJS(const char *MacroName, const char *IN, const char *OutDir, bool cp, bool py, bool aclic)
{

   // Execute the macro as a C++ one or a Python one.
   if (py)
      gROOT->ProcessLine(TString::Format("TPython::ExecScript(\"%s\");",MacroName));
   else if (aclic)
      gROOT->ProcessLine(TString::Format(".x %s+",MacroName));
   else
      gROOT->ProcessLine(TString::Format(".x %s",MacroName));

   // If needed, copy the macro in the documentation directory.
   if (cp) {
      TString MN = MacroName;
      Int_t i = MN.Index("(");
      Int_t l = MN.Length();
      if (i>0) MN.Remove(i, l);
      gSystem->Exec(TString::Format("cp %s %s/macros", MN.Data(), OutDir));
   }

   // Build the html file inlining the JS pictures

   TIter next(gROOT->GetListOfCanvases());
   std::vector<TString> json_codes;
   TCanvas* canvas = nullptr;
   int ImageNum = 0;

   // Iterate over all the pads generated by the macro and produce the corresponding pictures.

   FILE *fh = fopen(TString::Format("%s/macros/%s.html",OutDir,IN), "w");
   fprintf(fh,"<center>\n");
   while ((canvas = (TCanvas*) next()) != nullptr) {
      ImageNum++;
      json_codes.push_back(TWebCanvas::CreateCanvasJSON(canvas, TBufferJSON::kNoSpaces + TBufferJSON::kSameSuppression, kTRUE));
      fprintf(fh,"   <div id=\"draw_pict%d_%s\" style=\"position: relative; width: %dpx; height: %dpx;\"></div>\n",
                  ImageNum,IN,canvas->GetWindowWidth(),canvas->GetWindowHeight());
   }
   fprintf(fh,"</center>\n");

   fprintf(fh,"<script type=\"module\">\n");
   fprintf(fh,"   import { settings, parse, draw } from './js/modules/main.mjs';\n");
   fprintf(fh,"   settings.HandleKeys = false;\n");
   for (int i=1; i<=ImageNum; i++) {
      fprintf(fh,"   let obj%d = parse(%s);\n", i, json_codes[i-1].Data());
      fprintf(fh,"   draw('draw_pict%d_%s', obj%d, \"\");\n", i,IN,i);
   }
   fprintf(fh,"</script>\n");

   fclose(fh);
}
