// mathtext - A TeX/LaTeX compatible rendering library. Copyright (C)
// 2008-2012 Yue Shi Lai <ylai@users.sourceforge.net>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public License
// as published by the Free Software Foundation; either version 2.1 of
// the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
// 02110-1301 USA

static const unsigned long nglyph = 545;
static const char *glyph_control_sequence[nglyph] = {
    "\\\"",
    "\\'",
    "\\.",
    "\\=",
    "\\Box",
    "\\Bumpeq",
    "\\Cap",
    "\\Cup",
    "\\Delta",
    "\\Diamond",
    "\\Digamma",
    "\\Doteq",
    "\\Downarrow",
    "\\Finv",
    "\\Game",
    "\\Gamma",
    "\\Im",
    "\\Koppa",
    "\\Lambda",
    "\\Leftarrow",
    "\\Leftrightarrow",
    "\\Lleftarrow",
    "\\Longleftarrow",
    "\\Longleftrightarrow",
    "\\Longrightarrow",
    "\\Lsh",
    "\\Omega",
    "\\P",
    "\\Phi",
    "\\Pi",
    "\\Psi",
    "\\Re",
    "\\Rightarrow",
    "\\Rrightarrow",
    "\\Rsh",
    "\\S",
    "\\Sampi",
    "\\San",
    "\\Sho",
    "\\Sigma",
    "\\Stigma",
    "\\Subset",
    "\\Supset",
    "\\Theta",
    "\\Uparrow",
    "\\Updownarrow",
    "\\Upsilon",
    "\\VarKoppa",
    "\\Vdash",
    "\\Vert",
    "\\Vvdash",
    "\\Xi",
    "\\^",
    "\\`",
    "\\aa",
    "\\aleph",
    "\\alpha",
    "\\angle",
    "\\approx",
    "\\approxeq",
    "\\asymp",
    "\\backepsilon",
    "\\backprime",
    "\\backsim",
    "\\backsimeq",
    "\\backslash",
    "\\barwedge",
    "\\because",
    "\\beta",
    "\\beth",
    "\\between",
    "\\bigcirc",
    "\\bigstar",
    "\\bigtriangledown",
    "\\bigtriangleup",
    "\\blacklozenge",
    "\\blacksquare",
    "\\blacktriangle",
    "\\blacktriangledown",
    "\\blacktriangleleft",
    "\\blacktriangleright",
    "\\bowtie",
    "\\boxdot",
    "\\boxminus",
    "\\boxplus",
    "\\boxtimes",
    "\\bullet",
    "\\bulletdashcirc",
    "\\bumpeq",
    "\\cap",
    "\\cdot",
    "\\cdots",
    "\\centerdot",
    "\\checkmark",
    "\\chi",
    "\\circ",
    "\\circdashbullet",
    "\\circeq",
    "\\circlearrowleft",
    "\\circlearrowright",
    "\\circledR",
    "\\circledS",
    "\\circledast",
    "\\circledcirc",
    "\\circleddash",
    "\\clubsuit",
    "\\coloneq",
    "\\comp",
    "\\complement",
    "\\cong",
    "\\coprod",
    "\\cup",
    "\\curlyeqprec",
    "\\curlyeqsucc",
    "\\curlyvee",
    "\\curlywedge",
    "\\curvearrowleft",
    "\\dagger",
    "\\daleth",
    "\\dasharrow",
    "\\dashdownarrow",
    "\\dashleftarrow",
    "\\dashrightarrow",
    "\\dashuparrow",
    "\\dashv",
    "\\dbar",
    "\\ddagger",
    "\\ddddot",
    "\\dddot",
    "\\ddots",
    "\\defineeq",
    "\\defineequal",
    "\\delta",
    "\\diagdown",
    "\\diagup",
    "\\diamond",
    "\\diamondsuit",
    "\\digamma",
    "\\digamma",
    "\\div",
    "\\divideontimes",
    "\\doteq",
    "\\doteqdot",
    "\\dotplus",
    "\\doublebarwedge",
    "\\doublecap",
    "\\doublecup",
    "\\downarrow",
    "\\downdownarrows",
    "\\downdownharpoons",
    "\\downharpoonleft",
    "\\downharpoonright",
    "\\downuparrows",
    "\\downupharpoons",
    "\\ell",
    "\\emptyset",
    "\\epsilon",
    "\\eqcirc",
    "\\eqcolon",
    "\\eqsim",
    "\\eqslantgtr",
    "\\eqslantless",
    "\\equiv",
    "\\eta",
    "\\eth",
    "\\exists",
    "\\fallingdotseq",
    "\\flat",
    "\\forall",
    "\\frown",
    "\\gamma",
    "\\ge",
    "\\geq",
    "\\geqq",
    "\\geqslant",
    "\\gets",
    "\\gg",
    "\\ggg",
    "\\gggtr",
    "\\gimel",
    "\\gnapprox",
    "\\gneq",
    "\\gneqq",
    "\\gnsim",
    "\\gtrapprox",
    "\\gtrdot",
    "\\gtreqless",
    "\\gtreqqless",
    "\\gtrless",
    "\\gtrsim",
    "\\hateq",
    "\\hbar",
    "\\heartsuit",
    "\\hookleftarrow",
    "\\hookrightarrow",
    "\\hslash",
    "\\imath",
    "\\in",
    "\\infty",
    "\\intercal",
    "\\iota",
    "\\jmath",
    "\\kappa",
    "\\koppa",
    "\\lambda",
    "\\land",
    "\\langle",
    "\\lceil",
    "\\ldbrack",
    "\\ldots",
    "\\le",
    "\\leadsfrom",
    "\\leadsto",
    "\\leftarrow",
    "\\leftarrowtail",
    "\\leftharpoondown",
    "\\leftharpoonup",
    "\\leftleftarrows",
    "\\leftrightarrow",
    "\\leftrightarrows",
    "\\leftrightharpoons",
    "\\leftsquigarrow",
    "\\leftthreetimes",
    "\\leq",
    "\\leqq",
    "\\leqslant",
    "\\lessapprox",
    "\\lessdot",
    "\\lesseqgtr",
    "\\lesseqqgtr",
    "\\lessgtr",
    "\\lesssim",
    "\\lfloor",
    "\\lightning",
    "\\ll",
    "\\llcorner",
    "\\lll",
    "\\llless",
    "\\lnapprox",
    "\\lneq",
    "\\lneqq",
    "\\lnot",
    "\\lnsim",
    "\\longleftarrow",
    "\\longleftrightarrow",
    "\\longmapsto",
    "\\longrightarrow",
    "\\lor",
    "\\lozenge",
    "\\lrcorner",
    "\\ltimes",
    "\\maltese",
    "\\mapsto",
    "\\measuredangle",
    "\\mho",
    "\\mp",
    "\\mu",
    "\\multimap",
    "\\nLeftarrow",
    "\\nLeftrightarrow",
    "\\nRightarrow",
    "\\nVDash",
    "\\nVdash",
    "\\nabla",
    "\\napprox",
    "\\nasymp",
    "\\natural",
    "\\ncong",
    "\\ne",
    "\\nearrow",
    "\\neg",
    "\\neq",
    "\\nequiv",
    "\\nexists",
    "\\ngeq",
    "\\ngeqq",
    "\\ngeqslant",
    "\\ngtr",
    "\\ni",
    "\\nleftarrow",
    "\\nleftrightarrow",
    "\\nleq",
    "\\nleqq",
    "\\nleqslant",
    "\\nless",
    "\\nmid",
    "\\not",
    "\\notapprox",
    "\\notasymp",
    "\\notcong",
    "\\notcong",
    "\\notequiv",
    "\\notgeq",
    "\\notgeq",
    "\\notgr",
    "\\notgr",
    "\\notin",
    "\\notleq",
    "\\notleq",
    "\\notless",
    "\\notless",
    "\\notni",
    "\\notprec",
    "\\notprec",
    "\\notsimeq",
    "\\notsubset",
    "\\notsubseteq",
    "\\notsubseteq",
    "\\notsucc",
    "\\notsucc",
    "\\notsupset",
    "\\notsupseteq",
    "\\notsupseteq",
    "\\nparallel",
    "\\nprec",
    "\\nrightarrow",
    "\\nsim",
    "\\nsim",
    "\\nsimeq",
    "\\nsubset",
    "\\nsubseteq",
    "\\nsubseteqq",
    "\\nsucc",
    "\\nsupset",
    "\\nsupseteq",
    "\\nsupseteqq",
    "\\ntriangleleft",
    "\\ntrianglelefteq",
    "\\ntriangleright",
    "\\ntrianglerighteq",
    "\\nu",
    "\\nvDash",
    "\\nvdash",
    "\\nwarrow",
    "\\odot",
    "\\omega",
    "\\ominus",
    "\\openclubsuit",
    "\\openspadesuit",
    "\\oplus",
    "\\oslash",
    "\\otimes",
    "\\owns",
    "\\parallel",
    "\\partial",
    "\\perp",
    "\\phi",
    "\\pi",
    "\\pitchfork",
    "\\pm",
    "\\prec",
    "\\precapprox",
    "\\preccurlyeq",
    "\\preceq",
    "\\precnapprox",
    "\\precneqq",
    "\\precnsim",
    "\\precsim",
    "\\prime",
    "\\propto",
    "\\psi",
    "\\rangle",
    "\\rceil",
    "\\rdbrack",
    "\\restriction",
    "\\rfloor",
    "\\rho",
    "\\rightarrow",
    "\\rightarrowtail",
    "\\rightharpoondown",
    "\\rightharpoonup",
    "\\rightleftarrows",
    "\\rightleftharpoons",
    "\\rightrightarrows",
    "\\rightsquigarrow",
    "\\rightthreetimes",
    "\\risingdotseq",
    "\\rtimes",
    "\\sampi",
    "\\san",
    "\\searrow",
    "\\setdif",
    "\\sharp",
    "\\sho",
    "\\sigma",
    "\\sim",
    "\\simarrow",
    "\\simeq",
    "\\smallfrown",
    "\\smallint",
    "\\smallsetminus",
    "\\smallsmile",
    "\\smile",
    "\\spadesuit",
    "\\sphericalangle",
    "\\sqcap",
    "\\sqcup",
    "\\sqsubset",
    "\\sqsubseteq",
    "\\sqsupset",
    "\\sqsupseteq",
    "\\square",
    "\\star",
    "\\stigma",
    "\\subset",
    "\\subseteq",
    "\\subseteqq",
    "\\subsetneq",
    "\\subsetneqq",
    "\\succ",
    "\\succapprox",
    "\\succcurlyeq",
    "\\succeq",
    "\\succnapprox",
    "\\succneqq",
    "\\succnsim",
    "\\succsim",
    "\\supset",
    "\\supseteq",
    "\\supseteqq",
    "\\supsetneq",
    "\\supsetneqq",
    "\\surd",
    "\\swarrow",
    "\\t",
    "\\tau",
    "\\therefore",
    "\\theta",
    "\\times",
    "\\to",
    "\\top",
    "\\triangledown",
    "\\triangleleft",
    "\\triangleleft",
    "\\trianglelefteq",
    "\\triangleq",
    "\\triangleright",
    "\\trianglerighteq",
    "\\twoheadleftarrow",
    "\\twoheadrightarrow",
    "\\u",
    "\\ulcorner",
    "\\undercurvearrowright",
    "\\upDelta",
    "\\upDigamma",
    "\\upGamma",
    "\\upKoppa",
    "\\upLambda",
    "\\upOmega",
    "\\upPhi",
    "\\upPi",
    "\\upPsi",
    "\\upSampi",
    "\\upSan",
    "\\upSho",
    "\\upSigma",
    "\\upStigma",
    "\\upTheta",
    "\\upUpsilon",
    "\\upVarKoppa",
    "\\upXi",
    "\\upalpha",
    "\\uparrow",
    "\\upbeta",
    "\\upchi",
    "\\updbar",
    "\\updelta",
    "\\updigamma",
    "\\updownarrow",
    "\\updownarrows",
    "\\updownharpoons",
    "\\upepsilon",
    "\\upeta",
    "\\upgamma",
    "\\upharpoonleft",
    "\\upharpoonright",
    "\\upiota",
    "\\upkappa",
    "\\upkoppa",
    "\\uplambda",
    "\\uplus",
    "\\upmu",
    "\\upnu",
    "\\upomega",
    "\\upphi",
    "\\uppi",
    "\\uppsi",
    "\\uprho",
    "\\upsampi",
    "\\upsan",
    "\\upsho",
    "\\upsigma",
    "\\upsilon",
    "\\upstigma",
    "\\uptau",
    "\\uptheta",
    "\\upuparrows",
    "\\upupharpoons",
    "\\upupsilon",
    "\\upvarbeta",
    "\\upvarepsilon",
    "\\upvarkappa",
    "\\upvarkoppa",
    "\\upvarphi",
    "\\upvarpi",
    "\\upvarrho",
    "\\upvarsigma",
    "\\upvartheta",
    "\\upxi",
    "\\upzeta",
    "\\urcorner",
    "\\v",
    "\\vDash",
    "\\vDash",
    "\\varbeta",
    "\\varepsilon",
    "\\varkappa",
    "\\varkoppa",
    "\\varnothing",
    "\\varphi",
    "\\varpi",
    "\\varpropto",
    "\\varrho",
    "\\varsigma",
    "\\vartheta",
    "\\vartriangle",
    "\\vartriangleleft",
    "\\vartriangleright",
    "\\vdash",
    "\\vdots",
    "\\vec",
    "\\vee",
    "\\veebar",
    "\\vert",
    "\\wedge",
    "\\wp",
    "\\wr",
    "\\wwbar",
    "\\xi",
    "\\yen",
    "\\zeta",
    "\\{",
    "\\|",
    "\\}",
    "\\~",
};

static const unsigned int glyph_type[nglyph] = {
    atom_t::TYPE_ACC,
    atom_t::TYPE_ACC,
    atom_t::TYPE_ACC,
    atom_t::TYPE_ACC,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_BIN,
    atom_t::TYPE_BIN,
    atom_t::TYPE_ORD,
    atom_t::TYPE_BIN,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_BIN,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ACC,
    atom_t::TYPE_ACC,
    atom_t::TYPE_ACC,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_BIN,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_BIN,
    atom_t::TYPE_ORD,
    atom_t::TYPE_BIN,
    atom_t::TYPE_BIN,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_BIN,
    atom_t::TYPE_BIN,
    atom_t::TYPE_BIN,
    atom_t::TYPE_BIN,
    atom_t::TYPE_BIN,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_BIN,
    atom_t::TYPE_BIN,
    atom_t::TYPE_ORD,
    atom_t::TYPE_BIN,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_BIN,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_BIN,
    atom_t::TYPE_BIN,
    atom_t::TYPE_BIN,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_BIN,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_OP,
    atom_t::TYPE_BIN,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_BIN,
    atom_t::TYPE_BIN,
    atom_t::TYPE_REL,
    atom_t::TYPE_BIN,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_BIN,
    atom_t::TYPE_ACC,
    atom_t::TYPE_ACC,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_BIN,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_BIN,
    atom_t::TYPE_BIN,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_BIN,
    atom_t::TYPE_BIN,
    atom_t::TYPE_BIN,
    atom_t::TYPE_BIN,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_BIN,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_BIN,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_BIN,
    atom_t::TYPE_OPEN,
    atom_t::TYPE_OPEN,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_BIN,
    atom_t::TYPE_BIN,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_BIN,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_BIN,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_OPEN,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_OPEN,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_BIN,
    atom_t::TYPE_ORD,
    atom_t::TYPE_CLOSE,
    atom_t::TYPE_BIN,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_BIN,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_BIN,
    atom_t::TYPE_ORD,
    atom_t::TYPE_BIN,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_BIN,
    atom_t::TYPE_BIN,
    atom_t::TYPE_BIN,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_BIN,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_CLOSE,
    atom_t::TYPE_CLOSE,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_CLOSE,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_BIN,
    atom_t::TYPE_REL,
    atom_t::TYPE_BIN,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_BIN,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_OP,
    atom_t::TYPE_BIN,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_BIN,
    atom_t::TYPE_BIN,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_BIN,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_OP,
    atom_t::TYPE_REL,
    atom_t::TYPE_ACC,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_BIN,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_BIN,
    atom_t::TYPE_BIN,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_BIN,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ACC,
    atom_t::TYPE_OPEN,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_BIN,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_CLOSE,
    atom_t::TYPE_ACC,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_REL,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ACC,
    atom_t::TYPE_BIN,
    atom_t::TYPE_BIN,
    atom_t::TYPE_BIN,
    atom_t::TYPE_BIN,
    atom_t::TYPE_ORD,
    atom_t::TYPE_BIN,
    atom_t::TYPE_ACC,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_ORD,
    atom_t::TYPE_OPEN,
    atom_t::TYPE_BIN,
    atom_t::TYPE_CLOSE,
    atom_t::TYPE_ACC,
};

static const bool glyph_upright[nglyph] = {
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    false,
    true,
    false,
    true,
    true,
    true,
    true,
    false,
    true,
    false,
    false,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    false,
    true,
    false,
    false,
    false,
    true,
    true,
    true,
    true,
    true,
    false,
    false,
    false,
    false,
    false,
    true,
    true,
    false,
    true,
    true,
    false,
    false,
    true,
    true,
    true,
    false,
    true,
    true,
    true,
    true,
    false,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    false,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    false,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    false,
    true,
    true,
    true,
    true,
    true,
    true,
    false,
    true,
    true,
    true,
    true,
    false,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    false,
    true,
    false,
    true,
    true,
    true,
    true,
    true,
    true,
    false,
    true,
    true,
    true,
    true,
    true,
    true,
    false,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    false,
    true,
    true,
    true,
    false,
    false,
    false,
    false,
    false,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    false,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    false,
    true,
    true,
    true,
    true,
    false,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    false,
    false,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    false,
    true,
    true,
    true,
    true,
    true,
    false,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    false,
    false,
    true,
    true,
    true,
    false,
    false,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    false,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    false,
    true,
    false,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    false,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    false,
    false,
    false,
    false,
    true,
    false,
    false,
    true,
    false,
    false,
    false,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    true,
    false,
    true,
    false,
    true,
    true,
    true,
    true,
};

static const wchar_t glyph_code_point[nglyph] = {
    L'\u00a8',
    L'\u00b4',
    L'\u02d9',
    L'\u00af',
    L'\u25a1',
    L'\u224e',
    L'\u22d2',
    L'\u22d3',
    L'\u0394',
    L'\u25c7',
    L'\u03dc',
    L'\u2251',
    L'\u21d3',
    L'\u2132',
    L'\u2141',
    L'\u0393',
    L'\u2111',
    L'\u03de',
    L'\u039b',
    L'\u21d0',
    L'\u21d4',
    L'\u21da',
    L'\u27f8',
    L'\u27fa',
    L'\u27f9',
    L'\u21b0',
    L'\u03a9',
    L'\u00b6',
    L'\u03a6',
    L'\u03a0',
    L'\u03a8',
    L'\u211c',
    L'\u21d2',
    L'\u21db',
    L'\u21b1',
    L'\u00a7',
    L'\u03e0',
    L'\u03fa',
    L'\u03f7',
    L'\u03a3',
    L'\u03da',
    L'\u22d0',
    L'\u22d1',
    L'\u0398',
    L'\u21d1',
    L'\u21d5',
    L'\u03a5',
    L'\u03d8',
    L'\u22a9',
    L'\u2016',
    L'\u22aa',
    L'\u039e',
    L'\u02c6',
    L'\140',
    L'\u02da',
    L'\u2135',
    L'\u03b1',
    L'\u2220',
    L'\u2248',
    L'\u224a',
    L'\u224d',
    L'\u220b',
    L'\u2035',
    L'\u223d',
    L'\u22cd',
    L'\134',
    L'\u22bc',
    L'\u2235',
    L'\u03b2',
    L'\u2136',
    L'\u226c',
    L'\u20dd',
    L'\u2605',
    L'\u25bd',
    L'\u25b3',
    L'\u29eb',
    L'\u25a0',
    L'\u25b4',
    L'\u25be',
    L'\u25c4',
    L'\u25ba',
    L'\u22c8',
    L'\u22a1',
    L'\u229f',
    L'\u229e',
    L'\u22a0',
    L'\u2022',
    L'\u22b7',
    L'\u224f',
    L'\u2229',
    L'\u00b7',
    L'\u22ef',
    L'\u2b1d',
    L'\u2713',
    L'\u03c7',
    L'\u25e6',
    L'\u22b6',
    L'\u2257',
    L'\u21ba',
    L'\u21bb',
    L'\u00ae',
    L'\u24c8',
    L'\u229b',
    L'\u229a',
    L'\u229d',
    L'\u2663',
    L'\u2254',
    L'\u2218',
    L'\u2201',
    L'\u2245',
    L'\u2a3f',
    L'\u222a',
    L'\u22de',
    L'\u22df',
    L'\u22ce',
    L'\u22cf',
    L'\u293a',
    L'\u2020',
    L'\u2138',
    L'\u21e2',
    L'\u21e3',
    L'\u21e0',
    L'\u21e2',
    L'\u21e1',
    L'\u22a3',
    L'\u0111',
    L'\u2021',
    L'\u20dc',
    L'\u20db',
    L'\u22f1',
    L'\u225d',
    L'\u225d',
    L'\u03b4',
    L'\u2572',
    L'\u2571',
    L'\u22c4',
    L'\u2666',
    L'\u03dd',
    L'\u03dc',
    L'\u00f7',
    L'\u22c7',
    L'\u2250',
    L'\u2251',
    L'\u2214',
    L'\u2a5e',
    L'\u22d2',
    L'\u22d3',
    L'\u2193',
    L'\u21ca',
    L'\u2965',
    L'\u21c3',
    L'\u21c2',
    L'\u21f5',
    L'\u296f',
    L'\u2113',
    L'\u2205',
    L'\u03f5',
    L'\u2256',
    L'\u2255',
    L'\u2242',
    L'\u2a96',
    L'\u2a95',
    L'\u2261',
    L'\u03b7',
    L'\u00f0',
    L'\u2203',
    L'\u2252',
    L'\u266d',
    L'\u2200',
    L'\u2322',
    L'\u03b3',
    L'\u2265',
    L'\u2265',
    L'\u2267',
    L'\u2a7e',
    L'\u2190',
    L'\u226b',
    L'\u226b',
    L'\u226b',
    L'\u05d2',
    L'\u2a8a',
    L'\u2a88',
    L'\u2269',
    L'\u22e7',
    L'\u2a86',
    L'\u22d7',
    L'\u22db',
    L'\u2a8c',
    L'\u2277',
    L'\u2273',
    L'\u2259',
    L'\u0127',
    L'\u2665',
    L'\u21a9',
    L'\u21aa',
    L'\u210f',
    L'\u0131',
    L'\u2208',
    L'\u221e',
    L'\u22ba',
    L'\u03b9',
    L'\u0237',
    L'\u03ba',
    L'\u03df',
    L'\u03bb',
    L'\u2227',
    L'\u27e8',
    L'\u2308',
    L'\u27e6',
    L'\u2026',
    L'\u2264',
    L'\u219c',
    L'\u219d',
    L'\u2190',
    L'\u21a2',
    L'\u21bd',
    L'\u21bc',
    L'\u21d4',
    L'\u2194',
    L'\u21c6',
    L'\u21cb',
    L'\u21dc',
    L'\u22cb',
    L'\u2264',
    L'\u2266',
    L'\u2a7d',
    L'\u2a85',
    L'\u22d6',
    L'\u22da',
    L'\u2a8b',
    L'\u2276',
    L'\u2272',
    L'\u230a',
    L'\u21af',
    L'\u226a',
    L'\u230e',
    L'\u226a',
    L'\u226a',
    L'\u2a89',
    L'\u2a87',
    L'\u2268',
    L'\u00ac',
    L'\u22e6',
    L'\u27f5',
    L'\u27f7',
    L'\u27fc',
    L'\u27f6',
    L'\u2228',
    L'\u25ca',
    L'\u230f',
    L'\u22c9',
    L'\u2720',
    L'\u21a6',
    L'\u2221',
    L'\u2127',
    L'\u2213',
    L'\u03bc',
    L'\u22b8',
    L'\u21cd',
    L'\u21ce',
    L'\u21cf',
    L'\u22af',
    L'\u22ae',
    L'\u2207',
    L'\u2249',
    L'\u226d',
    L'\u266e',
    L'\u2247',
    L'\u2260',
    L'\u2197',
    L'\u00ac',
    L'\u2260',
    L'\u2262',
    L'\u2204',
    L'\u2271',
    L'\ue08a',
    L'\ue0b1',
    L'\u226f',
    L'\u220b',
    L'\u219a',
    L'\u21ae',
    L'\u2270',
    L'\ue088',
    L'\ue0af',
    L'\u226e',
    L'\u2224',
    L'\u0338',
    L'\u2249',
    L'\u226d',
    L'\u2247',
    L'\u2247',
    L'\u2262',
    L'\u2271',
    L'\u2271',
    L'\u226f',
    L'\u226f',
    L'\u2209',
    L'\u2270',
    L'\u2270',
    L'\u226e',
    L'\u226e',
    L'\u220c',
    L'\u2280',
    L'\u2280',
    L'\u2244',
    L'\u2284',
    L'\u2288',
    L'\u2288',
    L'\u2281',
    L'\u2281',
    L'\u2285',
    L'\u2289',
    L'\u2289',
    L'\u2226',
    L'\u2280',
    L'\u219b',
    L'\u2241',
    L'\u2241',
    L'\u2244',
    L'\u2284',
    L'\u2288',
    L'\ue0bd',
    L'\u2281',
    L'\u2285',
    L'\u2289',
    L'\ue0bf',
    L'\u22ea',
    L'\u22ec',
    L'\u22eb',
    L'\u22ed',
    L'\u03bd',
    L'\u22ad',
    L'\u22ac',
    L'\u2196',
    L'\u2299',
    L'\u03c9',
    L'\u2296',
    L'\u2667',
    L'\u2664',
    L'\u2295',
    L'\u2298',
    L'\u2297',
    L'\u220b',
    L'\u2225',
    L'\u2202',
    L'\u22a5',
    L'\u03d5',
    L'\u03c0',
    L'\u22d4',
    L'\u00b1',
    L'\u227a',
    L'\u2ab7',
    L'\u227c',
    L'\u2aaf',
    L'\u2ab9',
    L'\u2ab5',
    L'\u22e8',
    L'\u227e',
    L'\u2032',
    L'\u221d',
    L'\u03c8',
    L'\u27e9',
    L'\u2309',
    L'\u27e7',
    L'\u21be',
    L'\u230b',
    L'\u03c1',
    L'\u2192',
    L'\u21a3',
    L'\u21c1',
    L'\u21c0',
    L'\u21c4',
    L'\u21cc',
    L'\u21d2',
    L'\u21dd',
    L'\u22cc',
    L'\u2253',
    L'\u22ca',
    L'\u03e1',
    L'\u03fb',
    L'\u2198',
    L'\u2216',
    L'\u266f',
    L'\u03f8',
    L'\u03c3',
    L'\u223c',
    L'\u2b47',
    L'\u2243',
    L'\u2322',
    L'\u222b',
    L'\u2216',
    L'\u2323',
    L'\u2323',
    L'\u2660',
    L'\u2222',
    L'\u2293',
    L'\u2294',
    L'\u228f',
    L'\u2291',
    L'\u2290',
    L'\u2292',
    L'\u25a1',
    L'\u22c6',
    L'\u03db',
    L'\u2282',
    L'\u2286',
    L'\u2ac5',
    L'\u228a',
    L'\u2acb',
    L'\u227b',
    L'\u2ab8',
    L'\u227d',
    L'\u2ab0',
    L'\u2aba',
    L'\u2ab6',
    L'\u22e9',
    L'\u227f',
    L'\u2283',
    L'\u2287',
    L'\u2ac6',
    L'\u228b',
    L'\u2acc',
    L'\u221a',
    L'\u2199',
    L'\u2040',
    L'\u03c4',
    L'\u2234',
    L'\u03b8',
    L'\u00d7',
    L'\u2192',
    L'\u22a4',
    L'\u25bf',
    L'\u25b9',
    L'\ue0c8',
    L'\u22b4',
    L'\u225c',
    L'\u25c3',
    L'\u22b5',
    L'\u219e',
    L'\u21a0',
    L'\u02d8',
    L'\u230c',
    L'\u293b',
    L'\u0394',
    L'\u03dc',
    L'\u0393',
    L'\u03de',
    L'\u039b',
    L'\u03a9',
    L'\u03a6',
    L'\u03a0',
    L'\u03a8',
    L'\u03e0',
    L'\u03fa',
    L'\u03f7',
    L'\u03a3',
    L'\u03da',
    L'\u0398',
    L'\u03a5',
    L'\u03d8',
    L'\u039e',
    L'\u03b1',
    L'\u2191',
    L'\u03b2',
    L'\u03c7',
    L'\u0111',
    L'\u03b4',
    L'\u03dd',
    L'\u2195',
    L'\u21c5',
    L'\u296e',
    L'\u03f5',
    L'\u03b7',
    L'\u03b3',
    L'\u21bf',
    L'\u21be',
    L'\u03b9',
    L'\u03ba',
    L'\u03df',
    L'\u03bb',
    L'\u228e',
    L'\u03bc',
    L'\u03bd',
    L'\u03c9',
    L'\u03d5',
    L'\u03c0',
    L'\u03c8',
    L'\u03c1',
    L'\u03e1',
    L'\u03fb',
    L'\u03f8',
    L'\u03c3',
    L'\u03c5',
    L'\u03db',
    L'\u03c4',
    L'\u03b8',
    L'\u21c8',
    L'\u2963',
    L'\u03c5',
    L'\u03d0',
    L'\u03b5',
    L'\u03f0',
    L'\u03d9',
    L'\u03c6',
    L'\u03d6',
    L'\u03f1',
    L'\u03c2',
    L'\u03d1',
    L'\u03be',
    L'\u03b6',
    L'\u230d',
    L'\u02c7',
    L'\u22a8',
    L'\u22a8',
    L'\u03d0',
    L'\u03b5',
    L'\u03f0',
    L'\u03d9',
    L'\u2205',
    L'\u03c6',
    L'\u03d6',
    L'\u221d',
    L'\u03f1',
    L'\u03c2',
    L'\u03d1',
    L'\u25b5',
    L'\u25c5',
    L'\u25bb',
    L'\u22a2',
    L'\u22ee',
    L'\u20d7',
    L'\u2228',
    L'\u22bb',
    L'\174',
    L'\u2227',
    L'\u2118',
    L'\u2240',
    L'\u0305',
    L'\u03be',
    L'\u00a5',
    L'\u03b6',
    L'\173',
    L'\u2016',
    L'\175',
    L'\u02dc',
};
