// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: cilium/api/npds.proto

package cilium

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"

	v3 "github.com/cilium/proxy/go/envoy/config/core/v3"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort

	_ = v3.SocketAddress_Protocol(0)
)

// Validate checks the field values on NetworkPolicy with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *NetworkPolicy) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on NetworkPolicy with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in NetworkPolicyMultiError, or
// nil if none found.
func (m *NetworkPolicy) ValidateAll() error {
	return m.validate(true)
}

func (m *NetworkPolicy) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if l := len(m.GetEndpointIps()); l < 1 || l > 2 {
		err := NetworkPolicyValidationError{
			field:  "EndpointIps",
			reason: "value must contain between 1 and 2 items, inclusive",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetEndpointIps() {
		_, _ = idx, item

		if utf8.RuneCountInString(item) < 1 {
			err := NetworkPolicyValidationError{
				field:  fmt.Sprintf("EndpointIps[%v]", idx),
				reason: "value length must be at least 1 runes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	// no validation rules for EndpointId

	for idx, item := range m.GetIngressPerPortPolicies() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, NetworkPolicyValidationError{
						field:  fmt.Sprintf("IngressPerPortPolicies[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, NetworkPolicyValidationError{
						field:  fmt.Sprintf("IngressPerPortPolicies[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return NetworkPolicyValidationError{
					field:  fmt.Sprintf("IngressPerPortPolicies[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetEgressPerPortPolicies() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, NetworkPolicyValidationError{
						field:  fmt.Sprintf("EgressPerPortPolicies[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, NetworkPolicyValidationError{
						field:  fmt.Sprintf("EgressPerPortPolicies[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return NetworkPolicyValidationError{
					field:  fmt.Sprintf("EgressPerPortPolicies[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	// no validation rules for ConntrackMapName

	if len(errors) > 0 {
		return NetworkPolicyMultiError(errors)
	}

	return nil
}

// NetworkPolicyMultiError is an error wrapping multiple validation errors
// returned by NetworkPolicy.ValidateAll() if the designated constraints
// aren't met.
type NetworkPolicyMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m NetworkPolicyMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m NetworkPolicyMultiError) AllErrors() []error { return m }

// NetworkPolicyValidationError is the validation error returned by
// NetworkPolicy.Validate if the designated constraints aren't met.
type NetworkPolicyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e NetworkPolicyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e NetworkPolicyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e NetworkPolicyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e NetworkPolicyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e NetworkPolicyValidationError) ErrorName() string { return "NetworkPolicyValidationError" }

// Error satisfies the builtin error interface
func (e NetworkPolicyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sNetworkPolicy.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = NetworkPolicyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = NetworkPolicyValidationError{}

// Validate checks the field values on PortNetworkPolicy with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *PortNetworkPolicy) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on PortNetworkPolicy with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// PortNetworkPolicyMultiError, or nil if none found.
func (m *PortNetworkPolicy) ValidateAll() error {
	return m.validate(true)
}

func (m *PortNetworkPolicy) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetPort() > 65535 {
		err := PortNetworkPolicyValidationError{
			field:  "Port",
			reason: "value must be less than or equal to 65535",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetEndPort() > 65535 {
		err := PortNetworkPolicyValidationError{
			field:  "EndPort",
			reason: "value must be less than or equal to 65535",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for Protocol

	for idx, item := range m.GetRules() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, PortNetworkPolicyValidationError{
						field:  fmt.Sprintf("Rules[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, PortNetworkPolicyValidationError{
						field:  fmt.Sprintf("Rules[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return PortNetworkPolicyValidationError{
					field:  fmt.Sprintf("Rules[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return PortNetworkPolicyMultiError(errors)
	}

	return nil
}

// PortNetworkPolicyMultiError is an error wrapping multiple validation errors
// returned by PortNetworkPolicy.ValidateAll() if the designated constraints
// aren't met.
type PortNetworkPolicyMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PortNetworkPolicyMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PortNetworkPolicyMultiError) AllErrors() []error { return m }

// PortNetworkPolicyValidationError is the validation error returned by
// PortNetworkPolicy.Validate if the designated constraints aren't met.
type PortNetworkPolicyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PortNetworkPolicyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PortNetworkPolicyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PortNetworkPolicyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PortNetworkPolicyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PortNetworkPolicyValidationError) ErrorName() string {
	return "PortNetworkPolicyValidationError"
}

// Error satisfies the builtin error interface
func (e PortNetworkPolicyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPortNetworkPolicy.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PortNetworkPolicyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PortNetworkPolicyValidationError{}

// Validate checks the field values on TLSContext with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *TLSContext) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TLSContext with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in TLSContextMultiError, or
// nil if none found.
func (m *TLSContext) ValidateAll() error {
	return m.validate(true)
}

func (m *TLSContext) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for TrustedCa

	// no validation rules for CertificateChain

	// no validation rules for PrivateKey

	// no validation rules for ValidationContextSdsSecret

	// no validation rules for TlsSdsSecret

	if len(errors) > 0 {
		return TLSContextMultiError(errors)
	}

	return nil
}

// TLSContextMultiError is an error wrapping multiple validation errors
// returned by TLSContext.ValidateAll() if the designated constraints aren't met.
type TLSContextMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TLSContextMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TLSContextMultiError) AllErrors() []error { return m }

// TLSContextValidationError is the validation error returned by
// TLSContext.Validate if the designated constraints aren't met.
type TLSContextValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TLSContextValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TLSContextValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TLSContextValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TLSContextValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TLSContextValidationError) ErrorName() string { return "TLSContextValidationError" }

// Error satisfies the builtin error interface
func (e TLSContextValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTLSContext.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TLSContextValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TLSContextValidationError{}

// Validate checks the field values on PortNetworkPolicyRule with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *PortNetworkPolicyRule) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on PortNetworkPolicyRule with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// PortNetworkPolicyRuleMultiError, or nil if none found.
func (m *PortNetworkPolicyRule) ValidateAll() error {
	return m.validate(true)
}

func (m *PortNetworkPolicyRule) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Deny

	// no validation rules for Name

	if all {
		switch v := interface{}(m.GetDownstreamTlsContext()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PortNetworkPolicyRuleValidationError{
					field:  "DownstreamTlsContext",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PortNetworkPolicyRuleValidationError{
					field:  "DownstreamTlsContext",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDownstreamTlsContext()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PortNetworkPolicyRuleValidationError{
				field:  "DownstreamTlsContext",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetUpstreamTlsContext()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PortNetworkPolicyRuleValidationError{
					field:  "UpstreamTlsContext",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PortNetworkPolicyRuleValidationError{
					field:  "UpstreamTlsContext",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetUpstreamTlsContext()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PortNetworkPolicyRuleValidationError{
				field:  "UpstreamTlsContext",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for L7Proto

	switch v := m.L7.(type) {
	case *PortNetworkPolicyRule_HttpRules:
		if v == nil {
			err := PortNetworkPolicyRuleValidationError{
				field:  "L7",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetHttpRules()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, PortNetworkPolicyRuleValidationError{
						field:  "HttpRules",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, PortNetworkPolicyRuleValidationError{
						field:  "HttpRules",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetHttpRules()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return PortNetworkPolicyRuleValidationError{
					field:  "HttpRules",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *PortNetworkPolicyRule_KafkaRules:
		if v == nil {
			err := PortNetworkPolicyRuleValidationError{
				field:  "L7",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetKafkaRules()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, PortNetworkPolicyRuleValidationError{
						field:  "KafkaRules",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, PortNetworkPolicyRuleValidationError{
						field:  "KafkaRules",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetKafkaRules()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return PortNetworkPolicyRuleValidationError{
					field:  "KafkaRules",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *PortNetworkPolicyRule_L7Rules:
		if v == nil {
			err := PortNetworkPolicyRuleValidationError{
				field:  "L7",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetL7Rules()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, PortNetworkPolicyRuleValidationError{
						field:  "L7Rules",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, PortNetworkPolicyRuleValidationError{
						field:  "L7Rules",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetL7Rules()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return PortNetworkPolicyRuleValidationError{
					field:  "L7Rules",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return PortNetworkPolicyRuleMultiError(errors)
	}

	return nil
}

// PortNetworkPolicyRuleMultiError is an error wrapping multiple validation
// errors returned by PortNetworkPolicyRule.ValidateAll() if the designated
// constraints aren't met.
type PortNetworkPolicyRuleMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PortNetworkPolicyRuleMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PortNetworkPolicyRuleMultiError) AllErrors() []error { return m }

// PortNetworkPolicyRuleValidationError is the validation error returned by
// PortNetworkPolicyRule.Validate if the designated constraints aren't met.
type PortNetworkPolicyRuleValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PortNetworkPolicyRuleValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PortNetworkPolicyRuleValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PortNetworkPolicyRuleValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PortNetworkPolicyRuleValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PortNetworkPolicyRuleValidationError) ErrorName() string {
	return "PortNetworkPolicyRuleValidationError"
}

// Error satisfies the builtin error interface
func (e PortNetworkPolicyRuleValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPortNetworkPolicyRule.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PortNetworkPolicyRuleValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PortNetworkPolicyRuleValidationError{}

// Validate checks the field values on HttpNetworkPolicyRules with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *HttpNetworkPolicyRules) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on HttpNetworkPolicyRules with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// HttpNetworkPolicyRulesMultiError, or nil if none found.
func (m *HttpNetworkPolicyRules) ValidateAll() error {
	return m.validate(true)
}

func (m *HttpNetworkPolicyRules) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetHttpRules()) < 1 {
		err := HttpNetworkPolicyRulesValidationError{
			field:  "HttpRules",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetHttpRules() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, HttpNetworkPolicyRulesValidationError{
						field:  fmt.Sprintf("HttpRules[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, HttpNetworkPolicyRulesValidationError{
						field:  fmt.Sprintf("HttpRules[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HttpNetworkPolicyRulesValidationError{
					field:  fmt.Sprintf("HttpRules[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return HttpNetworkPolicyRulesMultiError(errors)
	}

	return nil
}

// HttpNetworkPolicyRulesMultiError is an error wrapping multiple validation
// errors returned by HttpNetworkPolicyRules.ValidateAll() if the designated
// constraints aren't met.
type HttpNetworkPolicyRulesMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HttpNetworkPolicyRulesMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HttpNetworkPolicyRulesMultiError) AllErrors() []error { return m }

// HttpNetworkPolicyRulesValidationError is the validation error returned by
// HttpNetworkPolicyRules.Validate if the designated constraints aren't met.
type HttpNetworkPolicyRulesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HttpNetworkPolicyRulesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HttpNetworkPolicyRulesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HttpNetworkPolicyRulesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HttpNetworkPolicyRulesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HttpNetworkPolicyRulesValidationError) ErrorName() string {
	return "HttpNetworkPolicyRulesValidationError"
}

// Error satisfies the builtin error interface
func (e HttpNetworkPolicyRulesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHttpNetworkPolicyRules.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HttpNetworkPolicyRulesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HttpNetworkPolicyRulesValidationError{}

// Validate checks the field values on HeaderMatch with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *HeaderMatch) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on HeaderMatch with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in HeaderMatchMultiError, or
// nil if none found.
func (m *HeaderMatch) ValidateAll() error {
	return m.validate(true)
}

func (m *HeaderMatch) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := HeaderMatchValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for Value

	// no validation rules for MatchAction

	// no validation rules for MismatchAction

	// no validation rules for ValueSdsSecret

	if len(errors) > 0 {
		return HeaderMatchMultiError(errors)
	}

	return nil
}

// HeaderMatchMultiError is an error wrapping multiple validation errors
// returned by HeaderMatch.ValidateAll() if the designated constraints aren't met.
type HeaderMatchMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HeaderMatchMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HeaderMatchMultiError) AllErrors() []error { return m }

// HeaderMatchValidationError is the validation error returned by
// HeaderMatch.Validate if the designated constraints aren't met.
type HeaderMatchValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HeaderMatchValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HeaderMatchValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HeaderMatchValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HeaderMatchValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HeaderMatchValidationError) ErrorName() string { return "HeaderMatchValidationError" }

// Error satisfies the builtin error interface
func (e HeaderMatchValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHeaderMatch.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HeaderMatchValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HeaderMatchValidationError{}

// Validate checks the field values on HttpNetworkPolicyRule with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *HttpNetworkPolicyRule) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on HttpNetworkPolicyRule with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// HttpNetworkPolicyRuleMultiError, or nil if none found.
func (m *HttpNetworkPolicyRule) ValidateAll() error {
	return m.validate(true)
}

func (m *HttpNetworkPolicyRule) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetHeaders() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, HttpNetworkPolicyRuleValidationError{
						field:  fmt.Sprintf("Headers[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, HttpNetworkPolicyRuleValidationError{
						field:  fmt.Sprintf("Headers[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HttpNetworkPolicyRuleValidationError{
					field:  fmt.Sprintf("Headers[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetHeaderMatches() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, HttpNetworkPolicyRuleValidationError{
						field:  fmt.Sprintf("HeaderMatches[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, HttpNetworkPolicyRuleValidationError{
						field:  fmt.Sprintf("HeaderMatches[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HttpNetworkPolicyRuleValidationError{
					field:  fmt.Sprintf("HeaderMatches[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return HttpNetworkPolicyRuleMultiError(errors)
	}

	return nil
}

// HttpNetworkPolicyRuleMultiError is an error wrapping multiple validation
// errors returned by HttpNetworkPolicyRule.ValidateAll() if the designated
// constraints aren't met.
type HttpNetworkPolicyRuleMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HttpNetworkPolicyRuleMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HttpNetworkPolicyRuleMultiError) AllErrors() []error { return m }

// HttpNetworkPolicyRuleValidationError is the validation error returned by
// HttpNetworkPolicyRule.Validate if the designated constraints aren't met.
type HttpNetworkPolicyRuleValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HttpNetworkPolicyRuleValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HttpNetworkPolicyRuleValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HttpNetworkPolicyRuleValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HttpNetworkPolicyRuleValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HttpNetworkPolicyRuleValidationError) ErrorName() string {
	return "HttpNetworkPolicyRuleValidationError"
}

// Error satisfies the builtin error interface
func (e HttpNetworkPolicyRuleValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHttpNetworkPolicyRule.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HttpNetworkPolicyRuleValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HttpNetworkPolicyRuleValidationError{}

// Validate checks the field values on KafkaNetworkPolicyRules with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *KafkaNetworkPolicyRules) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on KafkaNetworkPolicyRules with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// KafkaNetworkPolicyRulesMultiError, or nil if none found.
func (m *KafkaNetworkPolicyRules) ValidateAll() error {
	return m.validate(true)
}

func (m *KafkaNetworkPolicyRules) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetKafkaRules()) < 1 {
		err := KafkaNetworkPolicyRulesValidationError{
			field:  "KafkaRules",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetKafkaRules() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, KafkaNetworkPolicyRulesValidationError{
						field:  fmt.Sprintf("KafkaRules[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, KafkaNetworkPolicyRulesValidationError{
						field:  fmt.Sprintf("KafkaRules[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return KafkaNetworkPolicyRulesValidationError{
					field:  fmt.Sprintf("KafkaRules[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return KafkaNetworkPolicyRulesMultiError(errors)
	}

	return nil
}

// KafkaNetworkPolicyRulesMultiError is an error wrapping multiple validation
// errors returned by KafkaNetworkPolicyRules.ValidateAll() if the designated
// constraints aren't met.
type KafkaNetworkPolicyRulesMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m KafkaNetworkPolicyRulesMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m KafkaNetworkPolicyRulesMultiError) AllErrors() []error { return m }

// KafkaNetworkPolicyRulesValidationError is the validation error returned by
// KafkaNetworkPolicyRules.Validate if the designated constraints aren't met.
type KafkaNetworkPolicyRulesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e KafkaNetworkPolicyRulesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e KafkaNetworkPolicyRulesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e KafkaNetworkPolicyRulesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e KafkaNetworkPolicyRulesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e KafkaNetworkPolicyRulesValidationError) ErrorName() string {
	return "KafkaNetworkPolicyRulesValidationError"
}

// Error satisfies the builtin error interface
func (e KafkaNetworkPolicyRulesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sKafkaNetworkPolicyRules.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = KafkaNetworkPolicyRulesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = KafkaNetworkPolicyRulesValidationError{}

// Validate checks the field values on KafkaNetworkPolicyRule with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *KafkaNetworkPolicyRule) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on KafkaNetworkPolicyRule with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// KafkaNetworkPolicyRuleMultiError, or nil if none found.
func (m *KafkaNetworkPolicyRule) ValidateAll() error {
	return m.validate(true)
}

func (m *KafkaNetworkPolicyRule) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for ApiVersion

	if !_KafkaNetworkPolicyRule_ClientId_Pattern.MatchString(m.GetClientId()) {
		err := KafkaNetworkPolicyRuleValidationError{
			field:  "ClientId",
			reason: "value does not match regex pattern \"^[a-zA-Z0-9._-]*$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if utf8.RuneCountInString(m.GetTopic()) > 255 {
		err := KafkaNetworkPolicyRuleValidationError{
			field:  "Topic",
			reason: "value length must be at most 255 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_KafkaNetworkPolicyRule_Topic_Pattern.MatchString(m.GetTopic()) {
		err := KafkaNetworkPolicyRuleValidationError{
			field:  "Topic",
			reason: "value does not match regex pattern \"^[a-zA-Z0-9._-]*$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return KafkaNetworkPolicyRuleMultiError(errors)
	}

	return nil
}

// KafkaNetworkPolicyRuleMultiError is an error wrapping multiple validation
// errors returned by KafkaNetworkPolicyRule.ValidateAll() if the designated
// constraints aren't met.
type KafkaNetworkPolicyRuleMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m KafkaNetworkPolicyRuleMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m KafkaNetworkPolicyRuleMultiError) AllErrors() []error { return m }

// KafkaNetworkPolicyRuleValidationError is the validation error returned by
// KafkaNetworkPolicyRule.Validate if the designated constraints aren't met.
type KafkaNetworkPolicyRuleValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e KafkaNetworkPolicyRuleValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e KafkaNetworkPolicyRuleValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e KafkaNetworkPolicyRuleValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e KafkaNetworkPolicyRuleValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e KafkaNetworkPolicyRuleValidationError) ErrorName() string {
	return "KafkaNetworkPolicyRuleValidationError"
}

// Error satisfies the builtin error interface
func (e KafkaNetworkPolicyRuleValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sKafkaNetworkPolicyRule.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = KafkaNetworkPolicyRuleValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = KafkaNetworkPolicyRuleValidationError{}

var _KafkaNetworkPolicyRule_ClientId_Pattern = regexp.MustCompile("^[a-zA-Z0-9._-]*$")

var _KafkaNetworkPolicyRule_Topic_Pattern = regexp.MustCompile("^[a-zA-Z0-9._-]*$")

// Validate checks the field values on L7NetworkPolicyRules with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *L7NetworkPolicyRules) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on L7NetworkPolicyRules with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// L7NetworkPolicyRulesMultiError, or nil if none found.
func (m *L7NetworkPolicyRules) ValidateAll() error {
	return m.validate(true)
}

func (m *L7NetworkPolicyRules) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetL7AllowRules() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, L7NetworkPolicyRulesValidationError{
						field:  fmt.Sprintf("L7AllowRules[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, L7NetworkPolicyRulesValidationError{
						field:  fmt.Sprintf("L7AllowRules[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return L7NetworkPolicyRulesValidationError{
					field:  fmt.Sprintf("L7AllowRules[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetL7DenyRules() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, L7NetworkPolicyRulesValidationError{
						field:  fmt.Sprintf("L7DenyRules[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, L7NetworkPolicyRulesValidationError{
						field:  fmt.Sprintf("L7DenyRules[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return L7NetworkPolicyRulesValidationError{
					field:  fmt.Sprintf("L7DenyRules[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return L7NetworkPolicyRulesMultiError(errors)
	}

	return nil
}

// L7NetworkPolicyRulesMultiError is an error wrapping multiple validation
// errors returned by L7NetworkPolicyRules.ValidateAll() if the designated
// constraints aren't met.
type L7NetworkPolicyRulesMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m L7NetworkPolicyRulesMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m L7NetworkPolicyRulesMultiError) AllErrors() []error { return m }

// L7NetworkPolicyRulesValidationError is the validation error returned by
// L7NetworkPolicyRules.Validate if the designated constraints aren't met.
type L7NetworkPolicyRulesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e L7NetworkPolicyRulesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e L7NetworkPolicyRulesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e L7NetworkPolicyRulesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e L7NetworkPolicyRulesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e L7NetworkPolicyRulesValidationError) ErrorName() string {
	return "L7NetworkPolicyRulesValidationError"
}

// Error satisfies the builtin error interface
func (e L7NetworkPolicyRulesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sL7NetworkPolicyRules.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = L7NetworkPolicyRulesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = L7NetworkPolicyRulesValidationError{}

// Validate checks the field values on L7NetworkPolicyRule with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *L7NetworkPolicyRule) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on L7NetworkPolicyRule with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// L7NetworkPolicyRuleMultiError, or nil if none found.
func (m *L7NetworkPolicyRule) ValidateAll() error {
	return m.validate(true)
}

func (m *L7NetworkPolicyRule) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Name

	// no validation rules for Rule

	for idx, item := range m.GetMetadataRule() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, L7NetworkPolicyRuleValidationError{
						field:  fmt.Sprintf("MetadataRule[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, L7NetworkPolicyRuleValidationError{
						field:  fmt.Sprintf("MetadataRule[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return L7NetworkPolicyRuleValidationError{
					field:  fmt.Sprintf("MetadataRule[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return L7NetworkPolicyRuleMultiError(errors)
	}

	return nil
}

// L7NetworkPolicyRuleMultiError is an error wrapping multiple validation
// errors returned by L7NetworkPolicyRule.ValidateAll() if the designated
// constraints aren't met.
type L7NetworkPolicyRuleMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m L7NetworkPolicyRuleMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m L7NetworkPolicyRuleMultiError) AllErrors() []error { return m }

// L7NetworkPolicyRuleValidationError is the validation error returned by
// L7NetworkPolicyRule.Validate if the designated constraints aren't met.
type L7NetworkPolicyRuleValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e L7NetworkPolicyRuleValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e L7NetworkPolicyRuleValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e L7NetworkPolicyRuleValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e L7NetworkPolicyRuleValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e L7NetworkPolicyRuleValidationError) ErrorName() string {
	return "L7NetworkPolicyRuleValidationError"
}

// Error satisfies the builtin error interface
func (e L7NetworkPolicyRuleValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sL7NetworkPolicyRule.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = L7NetworkPolicyRuleValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = L7NetworkPolicyRuleValidationError{}

// Validate checks the field values on NetworkPoliciesConfigDump with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *NetworkPoliciesConfigDump) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on NetworkPoliciesConfigDump with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// NetworkPoliciesConfigDumpMultiError, or nil if none found.
func (m *NetworkPoliciesConfigDump) ValidateAll() error {
	return m.validate(true)
}

func (m *NetworkPoliciesConfigDump) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetNetworkpolicies() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, NetworkPoliciesConfigDumpValidationError{
						field:  fmt.Sprintf("Networkpolicies[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, NetworkPoliciesConfigDumpValidationError{
						field:  fmt.Sprintf("Networkpolicies[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return NetworkPoliciesConfigDumpValidationError{
					field:  fmt.Sprintf("Networkpolicies[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return NetworkPoliciesConfigDumpMultiError(errors)
	}

	return nil
}

// NetworkPoliciesConfigDumpMultiError is an error wrapping multiple validation
// errors returned by NetworkPoliciesConfigDump.ValidateAll() if the
// designated constraints aren't met.
type NetworkPoliciesConfigDumpMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m NetworkPoliciesConfigDumpMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m NetworkPoliciesConfigDumpMultiError) AllErrors() []error { return m }

// NetworkPoliciesConfigDumpValidationError is the validation error returned by
// NetworkPoliciesConfigDump.Validate if the designated constraints aren't met.
type NetworkPoliciesConfigDumpValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e NetworkPoliciesConfigDumpValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e NetworkPoliciesConfigDumpValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e NetworkPoliciesConfigDumpValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e NetworkPoliciesConfigDumpValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e NetworkPoliciesConfigDumpValidationError) ErrorName() string {
	return "NetworkPoliciesConfigDumpValidationError"
}

// Error satisfies the builtin error interface
func (e NetworkPoliciesConfigDumpValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sNetworkPoliciesConfigDump.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = NetworkPoliciesConfigDumpValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = NetworkPoliciesConfigDumpValidationError{}
