// Copyright 2023-2024 Gentoo Authors
// Distributed under the terms of the GNU General Public License v2

namespace Gdmt.Sync.Runners

module Eix =
    open SimpleLog.SimpleLog

    open Gdmt.Shared

    let RunEixUpdate () : unit =
        let eixArgs = [ "eix-update"; "--quiet" ]

        LogMessage Debug "Updating eix database"
        ExecProcess(eixArgs).Run().Check()
        LogMessage Success "Database update succeeded"

    let RunEixShowUpdates () : unit =
        let eixArgs = [ "eix"; "--upgrade"; "--only-names" ]

        ExecProcess(eixArgs, [ ("EIX_LIMIT", "0") ]).Run().Check()
