/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.IndexDebugProperties;
import org.jetbrains.kotlin.com.intellij.util.io.FileChannelInterruptsRetryer;
import org.jetbrains.kotlin.com.intellij.util.io.FilePageCache;
import org.jetbrains.kotlin.com.intellij.util.io.FilePageCacheLockFree;
import org.jetbrains.kotlin.com.intellij.util.io.OpenChannelsCache;
import org.jetbrains.kotlin.com.intellij.util.io.PageCacheUtils;
import org.jetbrains.kotlin.com.intellij.util.io.pagecache.impl.PageContentLockingStrategy;

@ApiStatus.Internal
public final class StorageLockContext {
    private static final FilePageCache DEFAULT_FILE_PAGE_CACHE = new FilePageCache(PageCacheUtils.FILE_PAGE_CACHE_OLD_CAPACITY_BYTES);
    @Nullable
    private static final FilePageCacheLockFree DEFAULT_FILE_PAGE_CACHE_NEW = PageCacheUtils.LOCK_FREE_PAGE_CACHE_ENABLED ? new FilePageCacheLockFree(PageCacheUtils.FILE_PAGE_CACHE_NEW_CAPACITY_BYTES, (long)((float)PageCacheUtils.FILE_PAGE_CACHE_NEW_CAPACITY_BYTES * PageCacheUtils.HEAP_CAPACITY_FRACTION)) : null;
    static final StorageLockContext DEFAULT_CONTEXT = new StorageLockContext(false);
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final FilePageCache legacyFilePageCache;
    @Nullable
    private final FilePageCacheLockFree newFilePageCache;
    private final PageContentLockingStrategy defaultPageContentLockingStrategy;
    private final boolean useReadWriteLock;
    private final boolean cacheChannels;
    private final boolean disableAssertions;

    @VisibleForTesting
    StorageLockContext(@NotNull FilePageCache legacyFilePageCache, @Nullable FilePageCacheLockFree newFilePageCacheLockFree, boolean useReadWriteLock, boolean cacheChannels, boolean disableAssertions) {
        if (legacyFilePageCache == null) {
            StorageLockContext.$$$reportNull$$$0(0);
        }
        this.lock = new ReentrantReadWriteLock();
        this.defaultPageContentLockingStrategy = new PageContentLockingStrategy.SharedLockLockingStrategy(this.lock);
        this.useReadWriteLock = useReadWriteLock;
        this.cacheChannels = cacheChannels;
        this.disableAssertions = disableAssertions;
        this.legacyFilePageCache = legacyFilePageCache;
        this.newFilePageCache = newFilePageCacheLockFree;
    }

    public StorageLockContext(boolean useReadWriteLock, boolean cacheChannels, boolean disableAssertions) {
        this(DEFAULT_FILE_PAGE_CACHE, DEFAULT_FILE_PAGE_CACHE_NEW, useReadWriteLock, cacheChannels, disableAssertions);
    }

    public StorageLockContext(boolean useReadWriteLock, boolean cacheChannels) {
        this(useReadWriteLock, cacheChannels, false);
    }

    public StorageLockContext(boolean useReadWriteLock) {
        this(useReadWriteLock, false, false);
    }

    public StorageLockContext() {
        this(false, false, false);
    }

    boolean useChannelCache() {
        return this.cacheChannels;
    }

    public <R> R executeOp(Path file2, @NotNull OpenChannelsCache.FileChannelOperation<R> operation, boolean readOnly) throws IOException {
        if (operation == null) {
            StorageLockContext.$$$reportNull$$$0(1);
        }
        if (this.useChannelCache()) {
            return PageCacheUtils.CHANNELS_CACHE.executeOp(file2, operation, readOnly);
        }
        this.getBufferCache().incrementUncachedFileAccess();
        try (OpenChannelsCache.ChannelDescriptor desc = new OpenChannelsCache.ChannelDescriptor(file2, readOnly);){
            R r = operation.execute(desc.channel());
            return r;
        }
    }

    public <R> R executeIdempotentOp(Path file2, @NotNull FileChannelInterruptsRetryer.FileChannelIdempotentOperation<R> operation, boolean readOnly) throws IOException {
        if (operation == null) {
            StorageLockContext.$$$reportNull$$$0(2);
        }
        if (this.useChannelCache()) {
            return PageCacheUtils.CHANNELS_CACHE.executeIdempotentOp(file2, operation, readOnly);
        }
        this.getBufferCache().incrementUncachedFileAccess();
        try (OpenChannelsCache.ChannelDescriptor desc = new OpenChannelsCache.ChannelDescriptor(file2, readOnly);){
            R r = desc.channel().executeOperation(operation);
            return r;
        }
    }

    public Lock writeLock() {
        return this.lock.writeLock();
    }

    public void lockRead() {
        if (this.useReadWriteLock) {
            this.lock.readLock().lock();
        } else {
            this.lock.writeLock().lock();
        }
    }

    public void unlockRead() {
        if (this.useReadWriteLock) {
            this.lock.readLock().unlock();
        } else {
            this.lock.writeLock().unlock();
        }
    }

    public void lockWrite() {
        this.lock.writeLock().lock();
    }

    public void unlockWrite() {
        this.lock.writeLock().unlock();
    }

    @ApiStatus.Internal
    @NotNull
    FilePageCache getBufferCache() {
        FilePageCache filePageCache = this.legacyFilePageCache;
        if (filePageCache == null) {
            StorageLockContext.$$$reportNull$$$0(3);
        }
        return filePageCache;
    }

    @ApiStatus.Internal
    public void checkWriteAccess() {
        if (!this.disableAssertions && IndexDebugProperties.DEBUG) {
            if (this.lock.writeLock().isHeldByCurrentThread()) {
                return;
            }
            throw new IllegalStateException("Must hold StorageLock write lock to access PagedFileStorage");
        }
    }

    @ApiStatus.Internal
    public void checkReadAccess() {
        if (!this.disableAssertions && IndexDebugProperties.DEBUG) {
            if (this.lock.getReadHoldCount() > 0 || this.lock.writeLock().isHeldByCurrentThread()) {
                return;
            }
            throw new IllegalStateException("Must hold StorageLock read lock to access PagedFileStorage");
        }
    }

    void assertUnderSegmentAllocationLock() {
        if (IndexDebugProperties.DEBUG) {
            this.legacyFilePageCache.assertUnderSegmentAllocationLock();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "legacyFilePageCache";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/StorageLockContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/StorageLockContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferCache";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "pageCache";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "lockingStrategyWithGlobalLock";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatistics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "executeOp";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "executeIdempotentOp";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

