/*
 * CalcMySky - a simulator of light scattering in planetary atmospheres
 * Copyright © 2025 Ruslan Kabatsayev
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Suite 500, Boston, MA  02110-1335, USA.
 */

#include "DockScrollArea.hpp"
#include <QScrollBar>

DockScrollArea::DockScrollArea(QWidget* parent)
    : QScrollArea(parent)
{
}

QSize DockScrollArea::sizeHint() const
{
    // Avoid scrollbars when we can simply adjust the size a bit to get rid of them
    auto size = QScrollArea::sizeHint();
    if(verticalScrollBarPolicy() == Qt::ScrollBarAsNeeded)
        size.setWidth(size.width() + verticalScrollBar()->sizeHint().width());
    if(horizontalScrollBarPolicy() == Qt::ScrollBarAsNeeded)
        size.setHeight(size.height() + horizontalScrollBar()->sizeHint().height());
    return size;
}
